"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _default = async (bp, editorByBot) => {
  const router = bp.http.createRouterForBot('code-editor');
  router.get('/files', async (req, res) => {
    try {
      res.send((await editorByBot[req.params.botId].fetchFiles()));
    } catch (err) {
      bp.logger.attachError(err).error('Error fetching files');
      res.sendStatus(500);
    }
  });
  router.post('/save', async (req, res) => {
    try {
      await editorByBot[req.params.botId].saveFile(req.body);
      res.sendStatus(200);
    } catch (err) {
      bp.logger.attachError(err).error('Could not save file');
      res.sendStatus(500);
    }
  });
  router.get('/typings', async (req, res) => {
    try {
      res.send((await editorByBot[req.params.botId].loadTypings()));
    } catch (err) {
      bp.logger.attachError(err).error('Could not load typings. Code completion will not be available');
      res.sendStatus(500);
    }
  });
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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