"use strict";

const ActionButton = require('./action_button');

const Carousel = require('./carousel');

module.exports = {
  id: 'builtin_card',
  group: 'Built-in Messages',
  title: 'Card',
  jsonSchema: {
    description: 'A card message with a title with optional subtitle, image and action buttons.',
    type: 'object',
    required: ['title'],
    properties: {
      title: {
        type: 'string',
        title: 'Title'
      },
      subtitle: {
        type: 'string',
        title: 'Subtitle'
      },
      image: {
        type: 'string',
        $subtype: 'media',
        $filter: '.jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*',
        title: 'Image'
      },
      actions: {
        type: 'array',
        title: 'Action Buttons',
        items: ActionButton.jsonSchema
      }
    }
  },
  uiSchema: {
    title: {
      'ui:widget': 'textarea'
    },
    subtitle: {
      'ui:widget': 'textarea'
    }
  },
  computePreviewText: formData => formData.title && `Card: ${formData.title}`,
  renderElement: (data, channel) => Carousel.renderElement({
    items: [data],
    ...data
  }, channel)
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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