"use strict";

const base = require('./_base');

function renderElement(data, channel) {
  // We don't render action button
  return [];
}

module.exports = {
  id: 'builtin_action-button',
  group: 'Built-in Messages',
  title: 'Action Button',
  jsonSchema: {
    description: 'A button that triggers an action, often used in cards',
    type: 'object',
    required: ['action', 'title'],
    properties: {
      title: {
        type: 'string',
        description: 'Title of the button'
      },
      action: {
        type: 'string',
        enum: ['Say something', 'Open URL', 'Postback'],
        default: 'Say something'
      }
    },
    dependencies: {
      action: {
        oneOf: [{
          properties: {
            action: {
              enum: ['Say something']
            },
            text: {
              type: 'string',
              title: 'Enter text or the ID of a content element (ex: #!builtin_text-myid)'
            }
          }
        }, {
          properties: {
            action: {
              enum: ['Open URL']
            },
            url: {
              type: 'string',
              title: 'Enter a valid URL'
            }
          },
          required: ['url']
        }, {
          properties: {
            action: {
              enum: ['Postback']
            },
            payload: {
              type: 'string'
            }
          },
          required: ['payload']
        }]
      }
    }
  },
  uiSchema: {},
  computePreviewText: formData => `Action: ${formData.action}`,
  renderElement: renderElement,
  hidden: true
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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