"use strict";

/**
 * Store data to desired storage based on the time to live expectation. Read the
 * documentation for more details
 *
 * @title Set Variable
 * @category Storage
 * @author Botpress, Inc.
 * @param {string} type - Pick between: user, session, temp, bot
 * @param {string} name - The name of the variable
 * @param {any} value - Set the value of the variable. Type 'null' or leave empty to erase it.
 */
const setVariable = async (type, name, value) => {
  if (type === 'bot') {
    const original = await bp.kvs.get(event.botId, 'global');
    await bp.kvs.set(event.botId, 'global', { ...original,
      [name]: value
    });
  } else if (value === 'null' || value === '' || typeof value === 'undefined') {
    delete event.state[type][name];
  } else {
    event.state[type][name] = value;
  }
};

return setVariable(args.type, args.name, args.value);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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