"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

var _db = _interopRequireDefault(require("./db"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = async (bp, interactionsToTrack) => {
  const db = new _db.default(bp);
  await db.initializeDb(); // Dev: uncomment to generate users/interactions
  // seed.run(bp.database)

  bp.events.registerMiddleware({
    name: 'analytics.incoming',
    direction: 'incoming',
    handler: incomingMiddleware,
    order: 5,
    description: 'Tracks incoming messages for Analytics purposes'
  });
  bp.events.registerMiddleware({
    name: 'analytics.outgoing',
    direction: 'outgoing',
    handler: outgoingMiddleware,
    order: 5,
    description: 'Tracks outgoing messages for Analytics purposes'
  });

  function incomingMiddleware(event, next) {
    if (!_lodash.default.includes(interactionsToTrack, event.type)) {
      return next();
    } // Asynchronously save the interaction (non-blocking)


    db.saveIncoming(event).then().catch(() => {
      bp.logger.debug('Could not save incoming interaction for ' + event.channel);
    });
    next();
  }

  function outgoingMiddleware(event, next) {
    if (!_lodash.default.includes(interactionsToTrack, event.type)) {
      return next();
    } // Asynchronously save the interaction (non-blocking)


    db.saveOutgoing(event).then().catch(() => {
      bp.logger.debug('Could not save outgoing interaction for ' + event.channel);
    });
    next();
  }
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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