"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class AnalyticsDb {
  constructor(bp) {
    _defineProperty(this, "knex", void 0);

    _defineProperty(this, "initializeDb", () => {
      if (!this.knex) {
        throw new Error('you must initialize the database before');
      }

      return this.knex.createTableIfNotExists('analytics_interactions', table => {
        table.increments('id').primary();
        table.timestamp('ts');
        table.string('type');
        table.string('text');
        table.string('channel');
        table.string('user_id');
        table.enu('direction', ['in', 'out']);
      }).then(() => {
        return this.knex.createTableIfNotExists('analytics_runs', table => {
          table.increments('id').primary();
          table.timestamp('ts');
        });
      }).then(() => {
        return this.knex.createTableIfNotExists('analytics_custom', table => {
          table.string('botId');
          table.string('date');
          table.string('name');
          table.integer('count');
          table.unique(['date', 'name']);
        });
      }).then(() => this.knex);
    });

    _defineProperty(this, "saveIncoming", event => {
      const interactionRow = {
        ts: this.knex.date.now(),
        type: event.type,
        text: event.payload.text,
        channel: event.channel,
        user_id: event.target,
        direction: 'in'
      };
      return this.knex('analytics_interactions').insert(interactionRow);
    });

    _defineProperty(this, "saveOutgoing", event => {
      const interactionRow = {
        ts: this.knex.date.now(),
        type: event.type,
        text: event.payload.text,
        channel: event.channel,
        user_id: event.target,
        direction: 'out'
      };
      return this.knex('analytics_interactions').insert(interactionRow);
    });

    this.knex = bp.database;
  }

}

exports.default = AnalyticsDb;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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