"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _default = async (bp, testByBot) => {
  const router = bp.http.createRouterForBot('testing');
  router.get('/scenarios', async (req, res) => {
    const scenarios = await testByBot[req.params.botId].getScenarios();
    const status = await testByBot[req.params.botId].getStatus();
    res.send({
      scenarios,
      status
    });
  });
  router.post('/runAll', async (req, res) => {
    await testByBot[req.params.botId].executeAll();
    res.sendStatus(200);
  });
  router.post('/run', async (req, res) => {
    await testByBot[req.params.botId].executeSingle(req.body.scenario);
    res.sendStatus(200);
  });
  router.get('/startRecording/:userId?', async (req, res) => {
    await testByBot[req.params.botId].startRecording(req.params.userId || '');
    res.sendStatus(200);
  });
  router.get('/stopRecording', async (req, res) => {
    res.send((await testByBot[req.params.botId].endRecording()));
  });
  router.post('/saveScenario', async (req, res) => {
    const {
      name,
      steps
    } = req.body;

    if (!name || !steps || !name.length) {
      return res.sendStatus(400);
    }

    await testByBot[req.params.botId].saveScenario(name, steps);
    res.sendStatus(200);
  });
  router.post('/incomingEvent', (req, res) => {
    const event = req.body;
    res.send(testByBot[req.params.botId].processIncomingEvent(event));
  });
  router.post('/processedEvent', (req, res) => {
    const event = req.body;
    res.send(testByBot[req.params.botId].processCompletedEvent(event));
  });
  router.post('/fetchPreviews', async (req, res) => {
    const {
      elementIds
    } = req.body;

    if (!elementIds || !_lodash.default.isArray(elementIds)) {
      return res.sendStatus(400);
    }

    const elements = await bp.cms.getContentElements(req.params.botId, elementIds.map(x => x.replace('#!', '')));
    const rendered = elements.map(element => {
      return {
        id: `#!${element.id}`,
        preview: element.previews.en
      };
    });
    res.send(rendered);
  });
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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