"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const debug = DEBUG('hitl');
const debugSwallow = debug.sub('swallow');

var _default = async (bp, db) => {
  bp.events.registerMiddleware({
    name: 'hitl.captureInMessages',
    direction: 'incoming',
    order: 2,
    handler: incomingHandler,
    description: 'Captures incoming messages and if the session if paused, swallow the event.'
  });
  bp.events.registerMiddleware({
    name: 'hitl.captureOutMessages',
    direction: 'outgoing',
    order: 50,
    handler: outgoingHandler,
    description: 'Captures outgoing messages to show inside HITL.'
  });

  async function incomingHandler(event, next) {
    if (!db) {
      return next();
    }

    if (_lodash.default.includes(['delivery', 'read'], event.type)) {
      return next();
    }

    const session = await db.getOrCreateUserSession(event);

    if (!session) {
      return next();
    }

    if (session.is_new_session) {
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session', session));
    }

    await db.appendMessageToSession(event, session.id, 'in');
    bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session', session));
    const config = await bp.config.getModuleConfigForBot('hitl', event.botId);

    if ((!!session.paused || config.paused) && _lodash.default.includes(['text', 'message'], event.type)) {
      debugSwallow('message swallowed / session paused', {
        target: event.target,
        channel: event.channel,
        preview: event.preview,
        type: event.type
      }); // the session or bot is paused, swallow the message
      // @ts-ignore

      Object.assign(event, {
        isPause: true
      });
      return;
    }

    next();
  }

  async function outgoingHandler(event, next) {
    if (!db) {
      return next();
    }

    const session = await db.getOrCreateUserSession(event);

    if (!session) {
      return next();
    }

    if (session.is_new_session) {
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session', session));
    }

    await db.appendMessageToSession(event, session.id, 'out');
    bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session', session));
    next();
  }
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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