"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareExport = exports.importQuestions = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

var parsers = _interopRequireWildcard(require("./parsers.js"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const ANSWERS_SPLIT_CHAR = '†';

const importQuestions = async (questions, params) => {
  const {
    storage,
    config,
    format = 'json',
    statusCallback,
    uploadStatusId
  } = params;
  statusCallback(uploadStatusId, 'Calculating diff with existing questions');
  const existingQuestions = (await storage.fetchAllQuestions()).map(item => JSON.stringify(_lodash.default.omit(item.data, 'enabled')));
  const hasCategory = storage.hasCategories();
  const parsedQuestions = typeof questions === 'string' ? parsers[`${format}Parse`](questions, {
    hasCategory
  }) : questions;
  const questionsToSave = parsedQuestions.filter(item => !existingQuestions.includes(JSON.stringify(item)));

  if (config.qnaMakerApiKey) {
    return storage.insert(questionsToSave.map(question => ({ ...question,
      enabled: true
    })));
  }

  let questionsSavedCount = 0;
  return Promise.each(questionsToSave, async question => {
    const answers = question['answer'].split(ANSWERS_SPLIT_CHAR);
    await storage.insert({ ...question,
      answers,
      enabled: true
    });
    questionsSavedCount += 1;
    statusCallback(uploadStatusId, `Saved ${questionsSavedCount}/${questionsToSave.length} questions`);
  });
};

exports.importQuestions = importQuestions;

const prepareExport = async (storage, {
  flat = false
} = {}) => {
  const qnas = await storage.fetchAllQuestions();
  return _lodash.default.flatMap(qnas, question => {
    const {
      data
    } = question;
    const {
      questions,
      action,
      redirectNode,
      redirectFlow,
      category,
      answers,
      answer: textAnswer
    } = data; // FIXME: Remove v11.2 answer support

    let answer = answers.join(ANSWERS_SPLIT_CHAR) || textAnswer; // textAnswer allow to support v11.2 answer format

    let answer2 = undefined; // FIXME: Refactor these answer, answer2 fieds for something more meaningful like a 'redirect' field.
    // redirect dont need text so answer is overriden with the redirect flow

    if (action === 'redirect') {
      answer = redirectFlow;

      if (redirectNode) {
        answer += '#' + redirectNode;
      } // text_redirect will display a text before redirecting to the desired flow

    } else if (action === 'text_redirect') {
      answer2 = redirectFlow;

      if (redirectNode) {
        answer2 += '#' + redirectNode;
      }
    }

    const categoryWrapper = storage.getCategories() ? {
      category
    } : {};

    if (!flat) {
      return {
        questions,
        action,
        answer,
        answer2,
        ...categoryWrapper
      };
    }

    return questions.map(question => ({
      question,
      action,
      answer,
      answer2,
      ...categoryWrapper
    }));
  });
};

exports.prepareExport = prepareExport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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