"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractPattern = exports.escapeRegex = void 0;
const ESCAPED_CHARS = /[.+?^${}()|[\]\\]/g;
const WILDCARD = /\*/g;

const escapeRegex = pattern => {
  return pattern.replace(ESCAPED_CHARS, '\\$&').replace(WILDCARD, '.+?');
}; // Padding is necessary due to the recursive nature of this function.
// Every found pattern is removed from the candidate, therefor the length of the extracted value (padding) is needed to compute sourceIndex of future extractions


exports.escapeRegex = escapeRegex;

const extractPattern = (candidate, pattern, extracted = [], padding = 0) => {
  const res = pattern.exec(candidate);
  if (!res) return extracted;
  const value = res[0];
  const nextPadding = padding + value.length;
  const nextCandidate = candidate.slice(0, res.index) + candidate.slice(res.index + value.length);
  extracted.push({
    value,
    sourceIndex: res.index + padding
  });
  return extractPattern(nextCandidate, pattern, extracted, nextPadding);
};

exports.extractPattern = extractPattern;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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