"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _fs = _interopRequireDefault(require("fs"));

var _lodash = _interopRequireDefault(require("lodash"));

var _path = _interopRequireDefault(require("path"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const debug = DEBUG('nlu').sub('pretrained');

var _default = async bp => {
  const models = await bp.ghost.forGlobal().directoryListing('./models', '*.vec');

  const pretrainedPath = _path.default.join(__dirname, 'pretrained');

  const files = _fs.default.readdirSync(pretrainedPath).filter(x => x.toLowerCase().endsWith('.vec'));

  const globalGhost = bp.ghost.forGlobal();

  const missing = _lodash.default.without(files, ...models);

  debug('start copying missing pretrained models', missing);

  for (const model of missing) {
    const data = _fs.default.readFileSync(_path.default.join(pretrainedPath, model));

    await globalGhost.upsertFile('./models', model, data, false);
  }

  debug('end copy missing pretrained models');
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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