"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var sdk = _interopRequireWildcard(require("botpress/sdk"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

const generateFlow = async (data, metadata) => {
  return {
    transitions: createTransitions(),
    flow: {
      startNode: 'check-if-extracted',
      nodes: createNodes(data),
      catchAll: {
        next: []
      }
    }
  };
};

const createTransitions = () => {
  return [{
    caption: 'On extracted',
    condition: 'temp.extracted == "true"',
    node: ''
  }, {
    caption: 'On not found',
    condition: 'temp.notExtracted == "true"',
    node: ''
  }, {
    caption: 'On already extracted',
    condition: 'temp.alreadyExtracted == "true"',
    node: ''
  }];
};

const createNodes = data => {
  const slotExtractOnReceive = [{
    type: sdk.NodeActionType.RunAction,
    name: `basic-skills/slot_fill {"slotName":"${data.slotName}","entities":"${data.entities}"}`
  }];

  if (data.validationAction) {
    slotExtractOnReceive.push({
      type: sdk.NodeActionType.RunAction,
      name: `${data.validationAction} {}`
    });
  }

  return [{
    name: 'slot-extract',
    onEnter: [{
      type: sdk.NodeActionType.RenderElement,
      name: `#!${data.contentElement}`
    }],
    onReceive: slotExtractOnReceive,
    next: [{
      condition: `session.extractedSlots.${data.slotName} && (temp.valid === undefined || temp.valid == "true")`,
      node: 'extracted'
    }, {
      condition: 'true',
      node: 'not-extracted'
    }]
  }, {
    name: 'extracted',
    onEnter: [{
      type: sdk.NodeActionType.RunAction,
      name: 'builtin/setVariable {"type":"temp","name":"extracted","value":"true"}'
    }],
    onReceive: undefined,
    next: [{
      condition: 'true',
      node: '#'
    }]
  }, {
    name: 'not-extracted',
    onEnter: [{
      type: sdk.NodeActionType.RunAction,
      name: `basic-skills/slot_not_found {"retryAttempts":"${data.retryAttempts}"}`
    }, {
      type: sdk.NodeActionType.RenderElement,
      name: `#!${data.notFoundElement}`
    }],
    onReceive: slotExtractOnReceive,
    next: [{
      condition: `session.extractedSlots.${data.slotName} && (temp.valid === undefined || temp.valid == "true")`,
      node: 'extracted'
    }, {
      condition: `temp.notExtracted == "true"`,
      node: '#'
    }, {
      condition: 'session.extractedSlots.notFound > 0',
      node: 'not-extracted'
    }, {
      condition: 'true',
      node: '#'
    }]
  }, {
    name: 'check-if-extracted',
    onEnter: [{
      type: sdk.NodeActionType.RunAction,
      name: `basic-skills/slot_update_contexts {"intentName":"${data.intent}"}`
    }],
    onReceive: undefined,
    next: [{
      condition: `session.extractedSlots.${data.slotName} !== undefined`,
      node: 'already-extracted'
    }, {
      condition: 'true',
      node: 'slot-extract'
    }]
  }, {
    name: 'already-extracted',
    onEnter: [{
      type: sdk.NodeActionType.RunAction,
      name: 'builtin/setVariable {"type":"temp","name":"alreadyExtracted","value":"true"}'
    }],
    onReceive: undefined,
    next: [{
      condition: 'true',
      node: '#'
    }]
  }];
};

var _default = {
  generateFlow
};
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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