#!/bin/sh

# Copyright (C) 2011 Help/Systems LLC, All Rights Reserved
# Fires off a sapinterceptedjobhistoryreport to be processed by the Server.

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}
cd ../

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText() {
  echo ""
  echo "Help for: $0"
  echo ""
  echo "sapinterceptedjobhistoryreport - Add a sapinterceptedjobhistoryreport to the report queue."
  echo ""
  echo "The -h or --help option will show command help."
  echo ""
  echo "Usage: $0 ReportParameters"
  echo ""
  echo "** At least one of the date parameters is required. **"
  echo ""
  echo ""
  echo " ReportParameters:"
  echo ""
  echo "  -sapPlannedStartDateRange  (Report on a duration between two timestamps)"
  echo ""                         
  echo "   [start_date/yyyymmdd]  [start_time/hhmm]  [end_date/yyyymmdd] [end_time/hhmm]"
  echo "     Example 1: Report on the duration between Sept 1 18:00 and Sept 2 06:00" 
  echo "     Command: $0 -sapPlannedStartDateRange 20110901 1800 20110902 0600" 
  echo ""
  echo "   [start_date/yyyymmdd]  [start_time/hhmm]"
  echo "     Example 2: Report on the duration between Sept 1 18:00" 
  echo "     Command: $0 -sapPlannedStartDateRange 20110901 1800" 
  echo ""
  echo "  -sapPlannedEndDateDuration (Report on a duration relative to an end timestamp)"
  echo ""                        
  echo "   [days/number]  [hours/number]  [end_date/yyyymmdd]  [end_time/hhmm]"
  echo "     Example 3: Report on the duration 2 days 12 hours prior to Sept 2 06:00" 
  echo "     Command: $0 -sapPlannedEndDateDuration 2 12 20110902 0600" 
  echo ""                         
  echo "   [days/number]  [hours/number]"
  echo "     Example 4: Report on the duration 5 days 6 hours prior to run time" 
  echo "     Command: $0 -sapPlannedEndDateDuration 5 6" 
  echo "" 
  echo "   [days/number]"    
  echo "     Example 5: Report on the duration 7 days prior to run time"
  echo "     Command: $0 -sapPlannedEndDateDuration 7" 
  echo ""
  echo "  -sapPlannedStartDateDuration  (Report on a duration relative to an start timestamp)"
  echo ""
  echo "   [days/number]  [hours/number]  [start_date/yyyymmdd]  [start_time/hhmm]"
  echo "     Example 6: Report on the duration 4 days 8 hours after Sept 2 06:00" 
  echo "     Command: $0 -sapPlannedStartDateDuration 4 8 20110902 0600"
  echo ""
  echo "  -scheduledReleaseStartDateRange  (Report on a duration between two timestamps)"
  echo ""                         
  echo "   [start_date/yyyymmdd]  [start_time/hhmm]  [end_date/yyyymmdd] [end_time/hhmm]"
  echo "     Example 7: Report on the duration between Sept 1 18:00 and Sept 2 06:00" 
  echo "        and sap planned duration 7 days."
  echo "     Command: $0 -scheduledReleaseStartDateRange 20110901 1800 20110902 0600" 
  echo "          -sapPlannedEndDateDuration 7"
  echo ""
  echo "   [start_date/yyyymmdd]  [start_time/hhmm]"
  echo "     Example 8: Report on the duration between Sept 1 18:00 and run time"
  echo "        and sap planned duration 7 days."
  echo "     Command: $0 -scheduledReleaseStartDateRange 20110901 1800" 
  echo "          -sapPlannedEndDateDuration 7"
  echo ""
  echo "  -scheduledReleaseEndDateDuration (Report on a duration relative to an end timestamp)"
  echo ""                         
  echo "   [days/number]  [hours/number]  [end_date/yyyymmdd]  [end_time/hhmm]"
  echo "     Example 9: Report on the duration 2 days 12 hours prior to Sept 2 06:00"
  echo "        and sap planned duration 7 days."
  echo "     Command: $0 -scheduledReleaseEndDateDuration 2 12 20110902 0600"
  echo "          -sapPlannedEndDateDuration 7"
  echo ""                         
  echo "   [days/number]  [hours/number]"
  echo "     Example 10: Report on the duration 5 days 6 hours prior to run time"
  echo "        and sap planned duration 7 days."
  echo "     Command: $0 -scheduledReleaseEndDateDuration 5 6"
  echo "          -sapPlannedEndDateDuration 7"
  echo "" 
  echo "   [days/number]"    
  echo "     Example 11: Report on the duration 7 days prior to run time"
  echo "        and sap planned duration 7 days."
  echo "     Command: $0 -scheduledReleaseEndDateDuration 7"
  echo "          -sapPlannedEndDateDuration 7"
  echo ""
  echo "  -scheduledReleaseStartDateDuration  (Report on a duration relative to an start timestamp)"
  echo ""
  echo "   [days/number]  [hours/number]  [start_date/yyyymmdd]  [start_time/hhmm]"
  echo "     Example 12: Report on the duration 4 days 8 hours after Sept 2 06:00" 
  echo "        and sap planned duration 7 days."
  echo "     Command: $0 -scheduledReleaseStartDateDuration 4 8 20110902 0600" 
  echo "          -sapPlannedEndDateDuration 7"
  echo ""
  echo "  -sapSystemDefinitions (Specify SAP System Definition name to include in the report)"
  echo ""   
  echo "   [sapSystemDefinitions/list]"
  echo "     Example 13: Report on SAP System Definition named ssd1 and ssd2 for"
  echo "     the sap planned duration 7 days and scheduled release duration 3 days"
  echo "                prior to run time."    
  echo "     Command: $0 -sapSystemDefinitions ssd1 ssd2" 
  echo "      -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo ""
  echo "  -jobNames (Specify Automate Schedule job name to include in the report)"
  echo ""   
  echo "   [jobNames/list]"
  echo "     Example 14: Report on Automate Schedule job named job1 and job2 for"
  echo "     the sap planned duration 7 days and scheduled release duration 3 days"
  echo "                prior to run time."    
  echo "     Command: $0 -jobNames job1 job2 -sapPlannedEndDateDuration 7"
  echo "      -scheduledReleaseEndDateDuration 3"
  echo ""
  echo "  -agents (Specify Automate Schedule Agent name to include in the report)"
  echo ""   
  echo "   [agents/list]"
  echo "     Example 15: Report on Automate Schedule Agent Definition named agent1 and"
  echo "     agent2 for the sap planned duration 7 days and scheduled release duration"
  echo "                3 days prior to run time."    
  echo "     Command: $0 -agents agent1 agent2 -sapPlannedEndDateDuration 7"
  echo "      -scheduledReleaseEndDateDuration 3"
  echo ""
  echo "  -sapJobNames (Specify SAP Job name to include in the report)"
  echo ""   
  echo "   [sapJobNames/list]"
  echo "     Example 16: Report on SAP Job named sj1 and sj2 for"
  echo "     the sap planned duration 7 days and scheduled release duration 3 days"
  echo "                prior to run time."    
  echo "     Command: $0 -sapJobNames sj1 sj2"
  echo "      -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo ""
  echo "  -sapJobOwners (Specify SAP Job Owner name to include in the report)"
  echo ""   
  echo "   [sapJobOwners/list]"
  echo "     Example 17: Report on SAP Job Owner named sjo1 and sjo2 for "
  echo "     the sap planned duration 7 days and scheduled release duration 3 days"
  echo "                prior to run time."
  echo "     Command: $0 -sapJobOwners sjo1 sjo2"
  echo "      -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo ""
  echo "  -sapClients (Specify SAP Client name to include in the report)"
  echo ""   
  echo "   [sapClients/list]"
  echo "     Example 18: Report on SAP Client named sc1 and sc2 for"
  echo "     the sap planned duration 7 days and scheduled release duration 3 days"
  echo "                prior to run time."    
  echo "     Command: $0 -sapClients sc1 sc2"
  echo "      -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo ""
  echo "  -userName (Specify the user name who will generate the report)"
  echo "" 
  echo "  [userName] - If no -userName option is given the report will" 
  echo "               be generated by administrator user." 
  echo "     Example 19: Specify the user name who generates the report for"
  echo "     the sap planned duration 7 days and scheduled release duration 3 days"
  echo ""                 
  echo "     Command: $0 -userName username"
  echo "      -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo ""
  echo ""
  echo "  -f  (Specify an agent configuration file to be used to start the report)"
  echo ""
  echo "   [filename] - If no -f option is given the agent configuration file defaults "
  echo "                to agent.xml."
  echo "     Example 20: Specify agent other than default, report on "
  echo "     the sap planned duration 7 days and scheduled release duration 3 days"
  echo "     Command: $0 -f myconfig.xml"
  echo "     -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo ""
  echo "  -emailToAddress  (Specify email addresses to send the report)"
  echo "  [emailToAddress/list]"
  echo ""
  echo "    Example 21:  Send a report to admin@mycompany.com, company@mycompany.com email addresses "
  echo "    Command: $0 -emailToAddress admin@mycompany.com company@mycompany.com "
  echo "    -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo "     If no -emailToAddress option is given the report will not be sent "
  echo ""
  echo "  -emailToNotificationList  (Specify notification lists to send the report)"
  echo "  [emailToNotificationList/list]"
  echo ""
  echo "    Example 22:  Send a report an email to notification lists "
  echo "    Command: $0 -emailToNotificationList notificationList1 notificationList2 "
  echo "    -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo "     If no -emailToNotificationList option is given the report will not be sent "
  echo ""
  echo "  -emailToCurrentUser  (Specify current user email address to send the report)"
  echo "  [emailToCurrentUser]"
  echo ""
  echo "    Example 23:  Send a report to current user email address "
  echo "    Command: $0 -userName automateuser -emailToCurrentUser yes "
  echo "    -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo "     If no -emailToCurrentUser option is given the report will not be sent "
  echo ""
  echo "  -reportFilePath  (Specify file path to copy the report)"
  echo "  [reportFilePath]"
  echo "  This parameter is for the file system that the Automate Schedule server is running "
  echo "  on, not the agent itself."
  echo ""
  echo "    Example 24A:  Copy the report when the Automate Schedule server is running on a Windows system "
  echo "    Command: $0 -reportFilePath C:\\\\automateschedule -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3 "
  echo ""
  echo "    Example 24B:  Copy the report when the Automate Schedule server is running on a Unix system. "
  echo "    Command: $0 -reportFilePath /home/a_user -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3 "
  echo "     If -reportFilePath is not specified the report will not be copied "
  echo ""
  echo "  -reportFileName  (Specify file name to copy the report)"
  echo "  [reportFileName]"
  echo ""
  echo "    Example 25A:  Copy report to this file when the Automate Schedule server is running on a Windows system."
  echo "    Command: $0 -reportFilePath C:\\\\automateschedule -reportFileName report.pdf "
  echo "    Example 25B:  Copy report to this file when the Automate Schedule server is running on a Unix system."
  echo "    Command: $0 -reportFilePath /home/a_user -reportFileName report.pdf "
  echo "      -sapPlannedEndDateDuration 7 -scheduledReleaseEndDateDuration 3"
  echo "     If -reportFileName is not specified generated name will be used "
  echo ""
  echo ""
  echo "Copyright (C) 2011 Help/Systems LLC, All Rights Reserved."
}

noConfigFile() {
  echo "Error: A configuration file must follow the -f parameter"
}

COMMAND=REPORT
CONFIG_FILE=agent.xml
# For other reports, change the "0" to the report id, ie "100", "1002", etc
REPORT_NUM=1012
OUTPUT_TYPE=0
MAINCLASS=com.helpsystems.enterprise.peer.AgentControl

allArgs=$@

for i in ${@}
do
	if [ "$i" = "-h" -o "$i" = "--help" ]; then
		showHelpText
		exit 1
	fi
done

if [ "$1" = "-f" ]; then
	if [ "$2" = "" ]; then
		noConfigFile
		exit 1
	fi
	CONFIG_FILE=$2
fi 

if [ ! -f ${CONFIG_FILE} ]; then
    echo "The config file ${CONFIG_FILE} is missing. Command unsuccessful."
    exit 1
fi

if [ ! -r ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is not readable by the current user."
    exit 1
fi

echo "Generating report with agent configuration file $CONFIG_FILE ..."
# ./runjava.sh ${MAINCLASS} ${CONFIG_FILE} ${COMMAND} "${REPORT_NUM}" "${OUTPUT_TYPE}" ${FROM_DATE} ${TO_DATE}
./runjava.sh ${MAINCLASS} ${CONFIG_FILE} ${COMMAND} "${REPORT_NUM}" "${OUTPUT_TYPE}" "$@"
