#!/bin/sh

#
# Copyright (C) 2011 Help/Systems LLC, All Rights Reserved
# Starts up a JobConditionsPeer, which provide access to system object running
# as the Job User, not the Agent User.
#

# This script (and runjava.sh) need to be "world executable" in order for
#   users to have their job's Agent conditions checked.

PATH="$PATH:/bin:/usr/bin"
export PATH

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}

# initialize empty parm flags
parm_u=
parm_q=
parm_i=
parm_j=
parm_s=
parm_t=
parm_d=
parm_n=
parm_m=
parm_c=
parm_o=
parm_y=


while getopts :i:j:s:t:u:q:d:n:m:c:o:y: opt
  do
    case $opt in
    u)   parm_u=$OPTARG
         ;;
    q)   parm_q=$OPTARG
         ;;
    i)   parm_i=$OPTARG
         ;;
    j)   parm_j=$OPTARG
         ;;
    s)   parm_s=$OPTARG
         ;;
    t)   parm_t=$OPTARG
         ;;
    d)   parm_d=$OPTARG
         ;;
    n)  parm_n=$OPTARG
         ;;
    m)  parm_m=$OPTARG
         ;;
    c)   parm_c=$OPTARG
         ;;
    o)   parm_o=$OPTARG
         ;;
    y)   parm_y=$OPTARG
         ;;    
 
    esac
  done
./runjava.sh com.helpsystems.enterprise.peer.JobConditionsPeer -u"${parm_u}" -q"${parm_q}" -i"${parm_i}" -j"${parm_j}" -s"${parm_s}" -t"${parm_t}" -d"${parm_d}" -n"${parm_n}" -m"${parm_m}" -c"${parm_c}" -o"${parm_o}" -y"${parm_y}"
