#!/bin/sh

# ============================================================================
#  Copyright (C) 2017 HelpSystems, LLC, All Rights Reserved
#  ============================================================================

STARTING_DIR=`pwd`
WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}

JAVA_HOME=XXX

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText(){
echo  " 

       ----------------------- The Cloud Server Parameters -------------------------------
      -userEmail:<userEmail>                                 The user id - Required
      -password:<password>                                   The server password - Required 
      -passwordSalt:<password salt>                          If passed encrypted password password salt must be past as well
      -baseURL:<base url>                                    The base url - Required
      -verbose:<verbose logging>                             The verbose logging [yes:no]
      -findJobInterval:<initial polling interval>            The initial polling intervals
      -findJobMaxTries:<initial polling attempts>            The initial polling attempts
      -statusInterval:<status polling intervals>             The status polling intervals
      -serverOID:<server oid>                                The OID of the server definition (connection cache)
      -runNumber:<job history run number>                    The job history number (connection cache)
      -agentPort:<agent port number>                         The port number for agent (connection cache)
       ----------------------- End Cloud Server Parameters ---------------------------------
       ----------------------- The Cloud Command Parameters -----------------------------------
      -taskName:<Task Name>                                  The informatica cloud task name
      -taskID:<Task ID>                                      The informatica cloud task id
      -taskType:<Task Type>                                  The informatica cloud task type
      -continueImmediately:<Continue Immediately>            Continue Immediately [yes:no]
       ----------------------- END Cloud Command Parameters ------------------------------------
     
     -h, /h, -? or /?   Show help information
     This function can only be run on the executed Agent.
     Example: $0 -userEmail:"someEmail@test.com" -password:"automate2017" -baseURL:"http://someurl.com" -verbose:"yes" -findJobInterval:"1000" -findJobMaxTries:"1000" -statusInterval:"1000" -taskName:"automate_task"  -taskID:"000FF12000" -jobNumber:"7654321" -taskType:"DLS" -continueImmediately:"yes" "name" "value" "scope"  
      -h, /h, -? or /?   Show help information"
  
}
for i in "${@}"
do
	if [ "$i" = "-h" -o "$i" = "--help" ]; then
		showHelpText
		exit 1
	fi
done
echo "Using JAVA_HOME: ${JAVA_HOME}"

PS1=`hostname`:
export PS1
TERM=dumb
export TERM
# Import any custom environment settings the customer would like to use
if [ -r myenv.sh ]; then
    . ./myenv.sh "$@" 
fi

JAVA_EXEC=${JAVA_HOME}/bin/java
if [ ! -f ${JAVA_EXEC} ]; then
    echo "The java executable does not exist: ${JAVA_EXEC}"
    exit 1
fi

if [ ! -x ${JAVA_EXEC} ]; then
    echo "Unable to run java: ${JAVA_EXEC}"
    exit 1
fi




# ============================================================================
# Define the Java Class and Classpath
# ============================================================================
MAINCLASS="com.helpsystems.enterprise.module.infocloud.ICJobRunner"
SKYLIBPATH="${WORKING_DIR}/lib"
CLASSPATH=.
CLASSPATH=${CLASSPATH}:${SKYLIBPATH}"/gson-2.2.4.jar"
CLASSPATH=${CLASSPATH}:${SKYLIBPATH}"/commons-logging-1.1.jar"
CLASSPATH=${CLASSPATH}:${SKYLIBPATH}"/httpclient-4.3.6.jar"
CLASSPATH=${CLASSPATH}:${SKYLIBPATH}"/httpcore-4.3.3.jar"

SKYMODLIBPATH=${SKYLIBPATH}
CLASSPATH=${CLASSPATH}:${SKYMODLIBPATH}"/schent-mp-module.jar"
CLASSPATH=${CLASSPATH}:${SKYMODLIBPATH}"/schent-mp-peer.jar"

COMMONLIBPATH=${SKYLIBPATH}
CLASSPATH=${CLASSPATH}:${COMMONLIBPATH}"/common-core.jar"
CLASSPATH=${CLASSPATH}:${COMMONLIBPATH}"/common-tl.jar"
CLASSPATH=${CLASSPATH}:${COMMONLIBPATH}"/transport-module.jar"
CLASSPATH=${CLASSPATH}:${COMMONLIBPATH}"/common-server.jar"
CLASSPATH=${CLASSPATH}:${COMMONLIBPATH}"/log4j-1.3.0_hs.jar"

SKYLIBPATH=
SKYMODLIBPATH=
COMMONLIBPATH=

if [ -z "${COMPUTERNAME}" ]; then
    # Cheap hack to make UNIX systems use the same env var as Windows.
    COMPUTERNAME=`hostname`
fi
export COMPUTERNAME

JAVA_FLAGS=""

. $WORKING_DIR/sysinfo.sh
if [ "${OP_SYS}" = "HP-UX" ]; then
    JAVA_FLAGS="-d64"
fi

if [ "${OP_SYS}" = "SunOS" -a "${BIT_WIDTH}" = "64" ]; then
    JAVA_FLAGS="-d${BIT_WIDTH}"
fi

exec ${JAVA_EXEC} ${JAVA_FLAGS} "-Djava.library.path=${WORKING_DIR}/bin/${OP_SYS}/${PROCESSOR}" "-Dhelpsystems.module.dir=lib" -cp ${CLASSPATH} ${MAINCLASS} "$@" 
EXIT_CODE=$?

cd ${STARTING_DIR}
STARTING_DIR=

# use java's exit code as our own.
exit $EXIT_CODE 
