#!/bin/sh

# Copyright (C) 2010 Help/Systems LLC, All Rights Reserved
# Instructs an Agent to dump all diagnostic information to a file.

PATH=$PATH:/usr/ucb

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}
COMMAND=diag
CONFIG_FILE=agent.xml

# Initialize a verbose parameter
# "verbose=" to turn off verbose mode
# "verbose=-v" to turn on verbose mode
verbose=

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText() {
  echo ""
  echo "Help for: $0"
  echo ""
  echo "DIAG - Instructs an Agent to dump all diagnostic information to a file."
  echo ""
  echo "Usage: $0 [-v] [-f config_file]"
  echo "If no config file is provided, then the file agent.xml is used."
  echo ""
  echo "  The -h or --help option will show command help."
  echo "  Use -v to specify verbose mode."
  echo "  Use -f to specify an Agent configuration file."
  echo ""
  echo " Example: $0 -f myagent.xml"
  echo ""
  echo ""
}

while [ $# -ne 0 ]; do
    # is it the command, or the file?
    if [ "$1" = "-h" -o "$1" = "--help" ]; then
        showHelpText
        exit
    elif [ "$1" = "-f" ]; then
        if [ -n "$2" ]; then
           CONFIG_FILE=$2
	else
	   echo "Error: A configuration file must follow the -f parameter"
           exit 1
	fi
    elif [ "-v" = $1 ] ; then
        verbose=-v
    fi
    shift
done

if [ ! -f ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is missing. Command unsuccessful."
    exit 1
fi

if [ ! -r ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is not readable by the current user."
    exit 1
fi

echo "About to dump diagnostics for Agent with configuration file $CONFIG_FILE ..."
./runjava.sh com.helpsystems.enterprise.peer.AgentControl ${verbose} $CONFIG_FILE $COMMAND



