/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.AutoJobRunner;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.ConnectionManager;
import java.util.ArrayList;

public class DefaultTimeoutChecker
implements AutoJobRunner.AutoJob {
    private static final long minCheckPeriode = 120000L;
    private static final long maxCheckPeriode = 600000L;
    private ArrayList<ClientFactory> clientFactories = new ArrayList();
    private ArrayList<ClientFactory> toAdd = new ArrayList();
    private long checkPeriode = 600000L;
    private long lastExecution = 0L;
    private ConnectionManager conManager = ConnectionManager.getConnectionManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addPool(ClientFactory pool) {
        ArrayList<ClientFactory> arrayList = this.toAdd;
        synchronized (arrayList) {
            this.toAdd.add(pool);
            if (pool.getExpirationCheckPeriod() < this.checkPeriode) {
                this.checkPeriode = pool.getExpirationCheckPeriod();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() {
        this.lastExecution = System.currentTimeMillis();
        boolean isTimedOut = false;
        boolean recomputeCheckPeriode = false;
        ArrayList<ClientFactory> arrayList = this.clientFactories;
        synchronized (arrayList) {
            ClientFactory cF;
            ArrayList<ClientFactory> arrayList2 = this.toAdd;
            synchronized (arrayList2) {
                int toAddSize = this.toAdd.size();
                if (toAddSize > 0) {
                    int i = toAddSize;
                    while (--i >= 0) {
                        cF = this.toAdd.remove(i);
                        if (this.clientFactories.contains(cF) || cF.getExpirationCheckPeriod() <= 0L) continue;
                        this.clientFactories.add(cF);
                    }
                    recomputeCheckPeriode = true;
                }
            }
            int j = this.clientFactories.size();
            while (--j >= 0) {
                cF = this.clientFactories.get(j);
                isTimedOut = cF.isTimedOut(this.lastExecution);
                if (!isTimedOut) continue;
                this.conManager.removeFactory(cF);
                this.clientFactories.remove(j);
                recomputeCheckPeriode = true;
            }
            if (recomputeCheckPeriode) {
                int size = this.clientFactories.size();
                this.checkPeriode = 600000L;
                for (int i = 0; i < size; ++i) {
                    long cFCheckPeriode = this.clientFactories.get(i).getExpirationCheckPeriod();
                    if (cFCheckPeriode < 120000L) {
                        this.checkPeriode = 120000L;
                        break;
                    }
                    if (cFCheckPeriode >= this.checkPeriode) continue;
                    this.checkPeriode = cFCheckPeriode;
                }
            }
        }
    }

    public long getExecutePeriode() {
        return this.checkPeriode;
    }

    public long getLastExecutionTime() {
        return this.lastExecution;
    }
}

