/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.JCoSessionReference;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Context
extends JCoContext {
    private Object monitor = new Object();
    private String currentThreadName;
    private long currentThreadId;
    private boolean stateBusy = false;
    protected Map<String, DestinationEntry> connToDest = new HashMap<String, DestinationEntry>();
    protected int allDestionationsStatefulMode = 0;
    protected List<ClientConnection> usedClients = Collections.synchronizedList(new ArrayList(3));
    protected JCoSessionReference sessionRef;
    protected String scopeType;
    String sessionID;
    long firstAccess = this.lastAccess = System.currentTimeMillis();
    long lastAccess;
    private ServerConnection serverConnection;

    protected Context() {
    }

    void setSessionReference(JCoSessionReference sessionRef, String scopeType) {
        if (this.sessionRef != null && !this.sessionRef.getID().equals(sessionRef.getID()) && Trace.isOn(4, true)) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("[JCoAPI] JCoContext: Switching session from session id [").append(this.sessionRef.getID()).append("] scopeType [").append(this.scopeType).append("] to session id [").append(sessionRef.getID()).append("] scopeType [").append(scopeType).append("]");
            Trace.fireTrace(4, sb.toString());
        }
        this.sessionRef = sessionRef;
        this.sessionID = sessionRef.getID();
        this.scopeType = scopeType;
    }

    JCoSessionReference getSessionReference() {
        return this.sessionRef;
    }

    String getSessionID() {
        return this.sessionID;
    }

    void removeSessionReference() {
        this.sessionRef = null;
    }

    void setLastAccess(long timestamp) {
        this.lastAccess = timestamp;
    }

    ContextState getDefaultState() {
        return ContextState.STATELESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnection getConnection(InternalDestination destination, boolean forChangePassword) throws JCoException {
        Object generalState;
        ContextState state = ContextState.STATEFUL;
        DestinationEntry destEntry = this.connToDest.get(destination.getDestinationID());
        ClientConnection client = null;
        if (this.allDestionationsStatefulMode <= 0 && (state = this.getDefaultState()) == ContextState.STATELESS && destEntry != null) {
            state = ContextState.STATEFUL;
        }
        if (Trace.isOn(64)) {
            ContextState destState = null;
            generalState = null;
            if (destEntry != null) {
                destState = ContextState.STATEFUL;
            } else if (this.allDestionationsStatefulMode > 0) {
                generalState = ContextState.STATEFUL;
            }
            Trace.fireTrace(64, "[JCoAPI] Context.getConnection on destination " + destination.getDestinationName() + " (state: destination = " + (destState == null ? "null" : destState.toString()) + ", general = " + (generalState == null ? "null" : ((Enum)generalState).toString()) + ", default = " + this.getDefaultState().toString() + ")");
        }
        if (state == ContextState.STATEFUL) {
            boolean exceptionThrown = true;
            generalState = this.monitor;
            synchronized (generalState) {
                this.checkBusy(true, true);
            }
            try {
                StringBuilder sb;
                if (destEntry == null) {
                    destEntry = new DestinationEntry();
                    this.connToDest.put(destination.getDestinationID(), destEntry);
                }
                if (destEntry.conn == null) {
                    client = ConnectionManager.getConnectionManager().getClient(destination, false, forChangePassword);
                    client.sessionId = this.sessionRef != null ? this.sessionRef.getID() : "Invalid session ID [no session reference provider]";
                    destEntry.conn = client;
                    client.setStateful(true);
                    if (Trace.isOn(64)) {
                        sb = new StringBuilder(100);
                        sb.append("[JCoAPI] Context.getConnection on destination ").append(destination.getDestinationName());
                        sb.append(" nothing found in the context - got client from ConnectionManager [").append(client.getConnectionHandle());
                        if (client.attributes != null) {
                            sb.append("|").append(client.getConversationID());
                        }
                        sb.append("]");
                        Trace.fireTrace(64, sb.toString());
                    }
                } else {
                    client = destEntry.conn;
                    if (Trace.isOn(64)) {
                        sb = new StringBuilder(100);
                        sb.append("[JCoAPI] Context.getConnection on destination ").append(destination.getDestinationName());
                        sb.append(" found client in the context connections [").append(client.getConnectionHandle());
                        if (client.attributes != null) {
                            sb.append("|").append(client.getConversationID());
                        }
                        sb.append("]");
                        Trace.fireTrace(64, sb.toString());
                    }
                }
                exceptionThrown = false;
            }
            finally {
                if (exceptionThrown) {
                    Object object = this.monitor;
                    synchronized (object) {
                        this.stateBusy = false;
                    }
                }
            }
        }
        client = ConnectionManager.getConnectionManager().getClient(destination, false, forChangePassword);
        client.throughput = destination.getThroughput();
        this.usedClients.add(client);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseConnection(InternalDestination destination, ClientConnection client) throws JCoException {
        boolean isExtern;
        Object sb;
        ContextState state = null;
        if (Trace.isOn(64)) {
            sb = new StringBuilder(100);
            ((StringBuilder)sb).append("[JCoAPI] Context.releaseConnection on destination ").append(destination == null ? "null" : destination.getDestinationName()).append(" [");
            if (client != null) {
                ((StringBuilder)sb).append(client.getConnectionHandle());
                if (client.attributes != null) {
                    ((StringBuilder)sb).append("|").append(client.getConversationID());
                }
            } else {
                ((StringBuilder)sb).append("not allocated");
            }
            ((StringBuilder)sb).append("]");
            Trace.fireTrace(64, ((StringBuilder)sb).toString());
        }
        sb = this.monitor;
        synchronized (sb) {
            this.stateBusy = false;
        }
        if (client == null) {
            return;
        }
        if (!this.usedClients.remove(client)) {
            return;
        }
        client.throughput = null;
        if (destination == null) {
            ConnectionManager.getConnectionManager().releaseClient(client);
            return;
        }
        DestinationEntry destEntry = this.connToDest.get(destination.getDestinationID());
        state = destEntry != null ? ContextState.STATEFUL : (this.allDestionationsStatefulMode > 0 ? ContextState.STATEFUL : this.getDefaultState());
        char partnerType = destination.getAttributes().getPartnerType();
        boolean bl = isExtern = partnerType == 'E' || partnerType == 'R';
        if (isExtern || !client.isAlive()) {
            if (destEntry != null) {
                destEntry.conn = null;
            }
            ConnectionManager.getConnectionManager().releaseClient(client);
            return;
        }
        if (state == ContextState.STATELESS) {
            ConnectionManager.getConnectionManager().releaseClient(client);
        }
    }

    protected void closeConnections() throws JCoException {
        if (Trace.isOn(64)) {
            if (Trace.isOn(32)) {
                Trace.fireTrace(32, "[JCoCallStack] reset context -> close connections/remove destination states", true);
            } else {
                Trace.fireTrace(64, "[JCoAPI] reset context -> close connections/remove destination states");
            }
        }
        JCoException exception = null;
        ConnectionManager connManager = ConnectionManager.getConnectionManager();
        String destKey2 = null;
        DestinationEntry destEntry = null;
        for (String destKey2 : this.connToDest.keySet()) {
            try {
                destEntry = this.connToDest.get(destKey2);
                if (destEntry.conn == null) continue;
                destEntry.conn.setStateful(false);
                if (this.usedClients.remove(destEntry.conn)) {
                    connManager.releaseWithCancel(destEntry.conn);
                } else {
                    connManager.releaseClient(destEntry.conn);
                }
                destEntry.conn = null;
            }
            catch (JCoException ex) {
                Trace.fireTraceCritical("Exception while releasing connections for destination " + destKey2, ex);
                if (exception != null) {
                    exception = new JCoException(ex.getGroup(), ex.getKey(), exception.getMessage() + JCoRuntime.CRLF + ex.getMessage());
                    continue;
                }
                exception = ex;
            }
        }
        this.connToDest.clear();
        if (!this.usedClients.isEmpty()) {
            for (int i = 0; i < this.usedClients.size(); ++i) {
                ClientConnection c = this.usedClients.get(i);
                try {
                    connManager.releaseWithCancel(c);
                }
                catch (JCoException ex) {
                    Trace.fireTraceCritical("Exception while releasing connection " + c.getConnectionHandle(), ex);
                    exception = exception != null ? new JCoException(ex.getGroup(), ex.getKey(), exception.getMessage() + JCoRuntime.CRLF + ex.getMessage()) : ex;
                }
                this.usedClients.clear();
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        Object object = this.monitor;
        synchronized (object) {
            this.stateBusy = false;
            this.allDestionationsStatefulMode = 0;
            if (!this.usedClients.isEmpty() && Trace.isOn(4, true)) {
                int traceLevel = 4;
                String msg = "[JCoAPI] [JCoAPI] reset context -> context [session ID=" + this.sessionID + "] is being released, however " + this.usedClients.size() + " connections are still used and will be canceled";
                if (Trace.isOn(32)) {
                    StringBuilder buf = new StringBuilder(msg);
                    traceLevel = 32;
                    for (int i = 0; i < this.usedClients.size(); ++i) {
                        ClientConnection c = this.usedClients.get(i);
                        buf.append(JCoRuntime.CRLF).append("   ").append(i + 1).append(" connection with handle ");
                        buf.append(c.getConnectionHandle()).append(" [conv id ").append(c.getConversationID()).append("] ");
                        buf.append(c.getHashKey(true));
                    }
                    msg = buf.toString();
                }
                Trace.fireTrace(traceLevel, msg);
            }
            if (this.connToDest.isEmpty() && this.usedClients.isEmpty()) {
                return;
            }
            try {
                this.closeConnections();
            }
            catch (Exception ex) {
                Trace.fireTraceCritical(ex.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginSequence(InternalDestination destination) {
        DestinationEntry destEntry = null;
        Object object = this.monitor;
        synchronized (object) {
            if (!this.isInTx() && this.sessionRef != null) {
                try {
                    if (Trace.isOn(64)) {
                        Trace.fireTrace(64, "[JCoAPI] Started context for session " + this.sessionRef.getID());
                    }
                    this.sessionRef.contextStarted();
                }
                catch (RuntimeException re) {
                    Trace.fireTrace(2, "Exception in contextStarted()", re);
                    throw re;
                }
                catch (Error e) {
                    Trace.fireTrace(2, "Error in contextStarted()", e);
                    throw e;
                }
            }
            if (destination == null) {
                ++this.allDestionationsStatefulMode;
            } else {
                destEntry = this.connToDest.get(destination.getDestinationID());
                if (destEntry == null) {
                    destEntry = new DestinationEntry();
                    this.connToDest.put(destination.getDestinationID(), destEntry);
                } else {
                    ++destEntry.stateCounter;
                }
            }
            if (Trace.isOn(64)) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("[JCoAPI] JCoContext.begin/beginSequence on ");
                if (destination == null) {
                    sb.append("all destinations");
                } else {
                    sb.append(destination.getDestinationName()).append(" (").append(destination.getDestinationID()).append(")  destination");
                }
                if (this.sessionRef != null) {
                    sb.append(" on the context with id ").append(this.sessionRef.getID());
                } else {
                    sb.append(" on context without id");
                }
                sb.append(" current state counter ");
                if (destination == null) {
                    sb.append(this.allDestionationsStatefulMode);
                } else if (destEntry != null) {
                    sb.append(destEntry.stateCounter);
                } else {
                    sb.append(" error (destination entry was not found)");
                }
                Trace.fireTrace(64, sb.toString());
            }
            this.checkBusy(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endSequence(InternalDestination destination) throws JCoException {
        DestinationEntry destEntry = null;
        boolean wasInTx = this.isInTx();
        Object object = this.monitor;
        synchronized (object) {
            if (destination == null) {
                --this.allDestionationsStatefulMode;
                if (this.allDestionationsStatefulMode <= 0) {
                    this.closeConnections();
                    this.allDestionationsStatefulMode = 0;
                }
            } else {
                destEntry = this.connToDest.get(destination.getDestinationID());
                if (destEntry != null) {
                    --destEntry.stateCounter;
                    if (destEntry.stateCounter <= 0) {
                        if (destEntry.conn != null) {
                            destEntry.conn.setStateful(false);
                            ConnectionManager.getConnectionManager().releaseClient(destEntry.conn);
                        }
                        this.connToDest.remove(destination.getDestinationID());
                    }
                }
            }
            if (wasInTx && !this.isInTx() && this.sessionRef != null) {
                if (Trace.isOn(64)) {
                    Trace.fireTrace(64, "[JCoAPI] Finished context for session " + this.sessionRef.getID());
                }
                this.sessionRef.contextFinished();
            }
            if (Trace.isOn(64)) {
                StringBuilder sb = new StringBuilder(200);
                sb.append("[JCoAPI] JCoContext.end/endSequence on ");
                if (destination == null) {
                    sb.append("all destinations");
                } else {
                    sb.append(destination.getDestinationName()).append(" (").append(destination.getDestinationID());
                }
                sb.append(") destination");
                if (this.sessionRef != null) {
                    sb.append(" on the context with id ").append(this.sessionRef.getID());
                } else {
                    sb.append(" on context without id");
                }
                sb.append(" current state counter ");
                if (destination == null) {
                    sb.append(this.allDestionationsStatefulMode);
                } else if (destEntry != null) {
                    sb.append(destEntry.stateCounter);
                } else {
                    sb.append("error - destination wasn't stateful");
                }
                Trace.fireTrace(64, sb.toString());
            }
            this.checkBusy(false, false);
        }
    }

    boolean isInTx() {
        boolean inTx;
        boolean bl = inTx = !this.connToDest.isEmpty() || this.allDestionationsStatefulMode > 0;
        if (Trace.isOn(32)) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("[JCoAPI] Context.isInTx() returns ").append(inTx).append(" conn map is");
            if (!this.connToDest.isEmpty()) {
                sb.append(" not");
            }
            sb.append(" empty and general state counter is ").append(this.allDestionationsStatefulMode);
            Trace.fireTrace(32, sb.toString());
        }
        return inTx;
    }

    boolean isInTx(InternalDestination destination) {
        boolean inTx = this.connToDest.containsKey(destination.getDestinationID());
        return inTx;
    }

    private void checkBusy(boolean setBusy, boolean throwException) throws JCoRuntimeException {
        if (this.stateBusy && this.currentThreadId != Thread.currentThread().getId()) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The context ");
            if (this.sessionRef == null) {
                sb.append("[thread-local without session id]");
            } else {
                sb.append("with the session id [").append(this.sessionRef.getID()).append("] scope type [").append(this.scopeType);
            }
            sb.append("] is currently used in thread ").append(this.currentThreadName);
            sb.append(" [0x").append(Long.toHexString(this.currentThreadId)).append("].");
            Thread thread = Thread.currentThread();
            sb.append("Current thread is ").append(thread.getName());
            sb.append(" [0x").append(Long.toHexString(thread.getId())).append("].");
            if (Trace.isOn(2, true)) {
                Trace.fireTrace(2, "[JCoAPI] " + sb.toString(), true);
            }
            if (throwException) {
                throw new JCoRuntimeException(132, "JCO_ERROR_CONCURRENT_CALL", sb.toString());
            }
        } else if (setBusy) {
            this.stateBusy = true;
            this.currentThreadName = Thread.currentThread().getName();
            this.currentThreadId = Thread.currentThread().getId();
        }
    }

    void setServerConnection(ServerConnection serverConnection) {
        this.serverConnection = serverConnection;
    }

    void clearServerConnection() {
        if (this.serverConnection != null) {
            try {
                this.serverConnection.disconnect();
                this.serverConnection = null;
            }
            catch (Exception ex) {
                Trace.fireTraceCritical(ex.toString());
            }
        }
    }

    static class DestinationEntry {
        ClientConnection conn;
        int stateCounter;

        DestinationEntry() {
            this.stateCounter = 1;
        }

        DestinationEntry(ClientConnection conn) {
            this.conn = conn;
            this.stateCounter = 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ContextState {
        STATEFUL,
        STATELESS;

    }
}

