/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.remoteserver.RBTNotification;
import com.helpsystems.enterprise.core.remoteserver.RegisteredServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification_TL;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import com.helpsystems.enterprise.core.remoteserver.RemoteObject;
import com.helpsystems.enterprise.core.remoteserver.RemoteScheduleServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServer;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerNotConfiguredException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerUnreachableException;
import com.helpsystems.enterprise.core.remoteserver.RemoteServersDM;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import com.helpsystems.enterprise.remoteserver.RemoteScheduleServerNotifier;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteServerDMScheduleImpl
extends AbstractManager
implements RemoteServerDM {
    private static final Logger logger = Logger.getLogger(RemoteServerDMScheduleImpl.class);
    private long remoteServerID;
    private String jdbcDriver = "com.ibm.as400.access.AS400JDBCDriver";
    private String jdbcUrlProperties = ";sort=hex;translate binary=true;prompt=false";
    private static final String JOB_TABLE = "RBTROB";
    private static final String SKYBOT_TABLE = "RBTSKYBOT";
    private static final String DEPENDENCY_TABLE = "RBTSDEP";
    private static final String NOTIFICATION_TABLE = "RBTNOTIF";
    private String jobTable = "{library}.RBTROB";
    private String skybotTable = "{library}.RBTSKYBOT";
    private String dependencyTable = "{library}.RBTSDEP";
    private String notificationTable = "{library}.RBTNOTIF";
    private RemoteServersDM remoteServersDM;

    public RemoteServerDMScheduleImpl(long l, String string) throws RemoteServerException {
        this.setName("ENTERPRISE.RemoteServerDM", string);
        this.remoteServerID = l;
        this.remoteServersDM = (RemoteServersDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.RemoteServersDM");
    }

    public boolean areYouThere() {
        return true;
    }

    public int[] getNotifiableEventTypes() {
        int n = RemoteEventType.JOB_STATUS_CHANGE.persistanceCode();
        int n2 = RemoteEventType.GROUP_JOB_STATUS_CHANGE.persistanceCode();
        return new int[]{n, n2};
    }

    public String[] getNotifiableEventStatuses(RemoteEventType remoteEventType) {
        this.validateRemoteEventType(remoteEventType);
        String string = PrereqStatusType.SUBMITTED.persistanceCode();
        String string2 = PrereqStatusType.RUNNING.persistanceCode();
        String string3 = PrereqStatusType.COMPLETED.persistanceCode();
        String string4 = PrereqStatusType.FAILED.persistanceCode();
        String string5 = PrereqStatusType.SKIPPED.persistanceCode();
        String string6 = PrereqStatusType.ENDED.persistanceCode();
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                return new String[]{string3, string4, string6, string2, string, string5};
            }
            case GROUP_JOB_STATUS_CHANGE: {
                return new String[]{string3, string4, string6, string2};
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    public RemoteObject[] getEvents(RemoteEventType remoteEventType) throws RemoteServerNotConfiguredException, ResourceUnavailableException, RemoteServerUnreachableException {
        this.validateRemoteEventType(remoteEventType);
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                return this.getJobs();
            }
            case GROUP_JOB_STATUS_CHANGE: {
                return this.getGroupJobs();
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    public RemoteObject[] getEvents(RemoteEventType remoteEventType, String string, int n, int n2) throws RemoteServerNotConfiguredException, ResourceUnavailableException, RemoteServerUnreachableException {
        this.validateRemoteEventType(remoteEventType);
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                return this.getJobs(string, n, n2);
            }
            case GROUP_JOB_STATUS_CHANGE: {
                return this.getGroupJobs(string, n, n2);
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    public RemoteObject[] getSuiteMembers(long l) throws ResourceUnavailableException {
        logger.warn((Object)"The getSuiteMembers method is not supported for a SCHEDULE type remote server.");
        return new RemoteObject[0];
    }

    public RemoteObject[] getSuiteMembers(long l, String string, int n, int n2) throws ResourceUnavailableException {
        logger.warn((Object)"The getSuiteMembers method is not supported for a SCHEDULE type remote server.");
        return new RemoteObject[0];
    }

    public boolean isObjectExists(RemoteEventType remoteEventType, long l) throws RemoteServerNotConfiguredException, ResourceUnavailableException, RemoteServerUnreachableException {
        this.validateRemoteEventType(remoteEventType);
        return this.isInDatabase(remoteEventType, l);
    }

    public boolean isObjectExists(int n, long l, long l2) throws RemoteServerException {
        throw new IllegalStateException("Program error: This version of the isObjectExists method should not be called on a Schedule type remote server.");
    }

    public void notifyOfDependency(RemoteEventType remoteEventType, long l) throws RemoteServerNotConfiguredException, ResourceUnavailableException, RemoteServerUnreachableException {
        this.validateRemoteEventType(remoteEventType);
        this.validateObject(remoteEventType, l);
        long l2 = this.remoteServersDM.getInstalledDateTime(this.remoteServerID);
        if (!this.isDependencyAlreadyExists(l, remoteEventType, l2)) {
            String string = "INSERT INTO " + this.dependencyTable + " (" + "prereq_object_id, prereq_object_type, server_id) VALUES(?,?,?)";
            PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
            try {
                preparedStatement.setLong(1, l);
                preparedStatement.setInt(2, remoteEventType.persistanceCode());
                preparedStatement.setLong(3, l2);
                int n = preparedStatement.executeUpdate();
                if (n < 1) {
                    logger.info((Object)MessageUtil.formatMsg((String)"Remote server {0} is already notifying us when the {1} event occurs, for the object with id = {2}.", (Object[])new Object[]{this.getRemoteServerName(), remoteEventType, l}));
                }
            }
            catch (SQLException sQLException) {
                String string2 = MessageUtil.formatMsg((String)"SQL error while inserting the notification request entry on remote server {0}, for when the {1} event occurs, for the object with id = {2}.", (Object[])new Object[]{this.getRemoteServerName(), remoteEventType, l});
                throw new ResourceUnavailableException(string2, (Throwable)sQLException);
            }
            finally {
                this.closeConnection(preparedStatement);
            }
        }
    }

    public void notifyOfDependency(int n, long l, long l2) throws RemoteServerException {
        throw new IllegalStateException("Program error: This version of the notifyOfDependency method should not be called on a Schedule type remote server.");
    }

    public long notifyOfEvent(RemoteDependencyNotification remoteDependencyNotification) throws RemoteServerNotConfiguredException, RemoteServerUnreachableException, RemoteServerException, ResourceUnavailableException {
        this.verifyInstall();
        RemoteScheduleServer remoteScheduleServer = this.getRemoteServerInfo();
        return RemoteScheduleServerNotifier.notifyOfEvent(remoteDependencyNotification, remoteScheduleServer);
    }

    public long notifyOfEvent(RemoteDependencyNotification_TL remoteDependencyNotification_TL, long l) throws RemoteServerException {
        throw new IllegalStateException("Program error: This version of the notifyOfEvent method should not be called on a Schedule type remote server.");
    }

    long createSkybotTableEntry(String string) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        string = string.toUpperCase();
        long l = System.currentTimeMillis();
        RemoteScheduleServer remoteScheduleServer = this.getRemoteServerInfo();
        String string2 = this.skybotTable.replaceAll("\\{library\\}", remoteScheduleServer.getLibrary());
        String string3 = "INSERT INTO " + string2 + " (skybot_server_name, installed_utc," + " notification_queue_name, request_queue_name, response_queue_name) " + "VALUES(?,?,?,?,?)";
        Connection connection = this.establishNonVerifiedJDBCConnection(remoteScheduleServer);
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(string3);
        }
        catch (SQLException sQLException) {
            AbstractDatabaseManager.closeEm((Connection)connection, (Statement)preparedStatement, null);
            throw new ResourceUnavailableException("Error retrieving the Prepared Statement from the Connection.", (Throwable)sQLException);
        }
        try {
            String string4 = this.getServerName();
            preparedStatement.setString(1, string4);
            preparedStatement.setLong(2, l);
            preparedStatement.setString(3, string);
            preparedStatement.setString(4, "");
            preparedStatement.setString(5, "");
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string5 = MessageUtil.formatMsg((String)"SQL error while trying to insert the Automate Schedule server name and installed date/time into the {0} table on remote server {1}.", (Object[])new Object[]{string2, this.getRemoteServerName()});
            throw new ResourceUnavailableException(string5, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return l;
    }

    private String getServerName() {
        String string = null;
        try {
            string = System.getenv("COMPUTERNAME");
            if (string == null || string.trim().length() == 0) {
                try {
                    InetAddress inetAddress = null;
                    inetAddress = InetAddress.getLocalHost();
                    string = inetAddress.getHostName();
                }
                catch (UnknownHostException unknownHostException) {}
            }
        }
        catch (Exception exception) {
            logger.warn((Object)"Error retrieving system name.", (Throwable)exception);
        }
        if (string == null || string.trim().length() == 0) {
            string = "UNKNOWN SERVER";
        }
        int n = 25;
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    void deleteSkybotTableEntry(RemoteScheduleServer remoteScheduleServer) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        ValidationHelper.checkForNull((String)"Remote Schedule Server", (Object)remoteScheduleServer);
        String string = "DELETE FROM " + this.skybotTable + " WHERE installed_utc =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, remoteScheduleServer.getInstalledDateTime());
            int n = preparedStatement.executeUpdate();
            if (n == 0) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Unable to find the entry for this server, with installed timestamp {0}, for delete from remote server {1}.", (Object[])new Object[]{remoteScheduleServer.getInstalledDateTime(), remoteScheduleServer.getName()}));
            }
            if (n > 1) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"More than 1 entry for this server, with installed timestamp {0}, was deleted from remote server {1}. Count = {2}.", (Object[])new Object[]{remoteScheduleServer.getInstalledDateTime(), remoteScheduleServer.getName(), n}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while trying to delete the entry for this server, with installed timestamp {0}, from remote server {1}.", (Object[])new Object[]{remoteScheduleServer.getInstalledDateTime(), remoteScheduleServer.getName()});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    void verifyInstall() throws RemoteServerUnreachableException, RemoteServerNotConfiguredException, ResourceUnavailableException {
        Connection connection = null;
        try {
            RemoteScheduleServer remoteScheduleServer = this.getRemoteServerInfo();
            connection = this.establishVerifiedJDBCConnection(remoteScheduleServer);
        }
        catch (Throwable throwable) {
            AbstractDatabaseManager.closeEm(connection, null, null);
            throw throwable;
        }
        AbstractDatabaseManager.closeEm((Connection)connection, null, null);
    }

    private void closeConnection(Statement statement) {
        if (statement == null) {
            throw new NullPointerException("Statement cannot be null.");
        }
        Connection connection = null;
        try {
            connection = statement.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ResultSet resultSet = null;
        try {
            resultSet = statement.getResultSet();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.swapBack(connection);
        }
        catch (Exception exception) {
            logger.info((Object)"Unable to swap back.");
        }
        AbstractDatabaseManager.closeEm((Connection)connection, (Statement)statement, (ResultSet)resultSet);
    }

    private Connection establishVerifiedJDBCConnection(RemoteScheduleServer remoteScheduleServer) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        Connection connection = this.establishNonVerifiedJDBCConnection(remoteScheduleServer);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            String string = remoteScheduleServer.getName();
            long l = remoteScheduleServer.getInstalledDateTime();
            if (l == 0L) {
                String string2 = MessageUtil.formatMsg((String)"Remote server {0} has not been registered.", (Object[])new Object[]{string});
                throw new RemoteServerNotConfiguredException(string2);
            }
            String string3 = remoteScheduleServer.getLibrary() + "." + SKYBOT_TABLE;
            String string4 = "SELECT installed_utc FROM " + string3 + " where installed_utc=?";
            try {
                preparedStatement = connection.prepareStatement(string4);
            }
            catch (SQLException sQLException) {
                AbstractDatabaseManager.closeEm((Connection)connection, (Statement)preparedStatement, null);
                throw new ResourceUnavailableException("Error retrieving the Prepared Statement from the Connection.", (Throwable)sQLException);
            }
            Long l2 = null;
            try {
                preparedStatement.setLong(1, l);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    long l3 = resultSet.getLong("installed_utc");
                    if (!resultSet.wasNull()) {
                        l2 = new Long(l3);
                    }
                }
                AbstractDatabaseManager.closeEm(null, (Statement)preparedStatement, (ResultSet)resultSet);
                preparedStatement = null;
                resultSet = null;
            }
            catch (Exception exception) {
                String string5 = MessageUtil.formatMsg((String)"Either unable to locate or unable to read the {0} table in library {1} on remote server {2}.", (Object[])new Object[]{SKYBOT_TABLE, remoteScheduleServer.getLibrary(), string});
                throw new RemoteServerNotConfiguredException(string5);
            }
            if (l2 == null) {
                String string6 = MessageUtil.formatMsg((String)"The registered date/time in the {0} table on remote server {1} does not match the expected value {2}. The actual value is null.", (Object[])new Object[]{string3, string, remoteScheduleServer.getInstalledDateTime()});
                throw new RemoteServerNotConfiguredException(string6);
            }
            if (l2 != l) {
                String string7 = MessageUtil.formatMsg((String)"The registered date/time in the {0} table on remote server {1} does not match the expected value. {2} vs {3}.", (Object[])new Object[]{string3, string, (long)l2, remoteScheduleServer.getInstalledDateTime()});
                throw new RemoteServerNotConfiguredException(string7);
            }
        }
        catch (Exception exception) {
            AbstractDatabaseManager.closeEm((Connection)connection, preparedStatement, resultSet);
            if (exception instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)((Object)exception);
            }
            if (exception instanceof RemoteServerUnreachableException) {
                throw (RemoteServerUnreachableException)exception;
            }
            if (exception instanceof RemoteServerNotConfiguredException) {
                throw (RemoteServerNotConfiguredException)exception;
            }
            throw new RuntimeException(exception);
        }
        return connection;
    }

    private Connection establishNonVerifiedJDBCConnection(RemoteScheduleServer remoteScheduleServer) throws ResourceUnavailableException, RemoteServerUnreachableException {
        try {
            Class.forName(this.jdbcDriver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"JDBC driver {0} not found.", (Object[])new Object[]{this.jdbcDriver}));
        }
        String string = MessageUtil.formatMsg((String)"jdbc:as400://{0}{1}", (Object[])new Object[]{remoteScheduleServer.getSystemName(), this.jdbcUrlProperties});
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(string, remoteScheduleServer.getUser(), remoteScheduleServer.getPwd());
        }
        catch (SQLException sQLException) {
            throw new RemoteServerUnreachableException(MessageUtil.formatMsg((String)"Unable to establish a connection to remote server {0}.", (Object[])new Object[]{remoteScheduleServer.getSystemName()}), (Throwable)sQLException);
        }
        if (connection == null) {
            throw new RemoteServerUnreachableException("Unable to get a JDBC Connection.");
        }
        try {
            this.swapToRBTUSER(connection);
        }
        catch (Exception exception) {
            AbstractDatabaseManager.closeEm((Connection)connection, null, null);
            throw new RemoteServerUnreachableException(MessageUtil.formatMsg((String)"Unable to swap the user on the connection to remote server {0}.", (Object[])new Object[]{remoteScheduleServer.getSystemName()}), (Throwable)exception);
        }
        return connection;
    }

    private PreparedStatement getDefaultPreparedStmt(String string) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        RemoteScheduleServer remoteScheduleServer = this.getRemoteServerInfo();
        string = string.replaceAll("\\{library\\}", remoteScheduleServer.getLibrary());
        Connection connection = this.establishVerifiedJDBCConnection(remoteScheduleServer);
        Object var4_4 = null;
        try {
            return connection.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            AbstractDatabaseManager.closeEm((Connection)connection, var4_4, null);
            connection = null;
            var4_4 = null;
            throw new ResourceUnavailableException("Error retrieving the Prepared Statement from the Connection.", (Throwable)sQLException);
        }
    }

    private RemoteObject[] getJobs() throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        return this.getJobs(null, 0, 0);
    }

    private RemoteObject[] getJobs(String string, int n, int n2) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        return this.getJobs(false, string, n, n2);
    }

    private RemoteObject[] getJobs(boolean bl, String string, int n, int n2) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        String string2;
        ArrayList<RemoteObject> arrayList = new ArrayList<RemoteObject>();
        if (n == 0) {
            string2 = "SELECT robot_job_number, robot_job_name, robot_job_desc FROM " + this.jobTable + " WHERE";
            string2 = bl ? string2 + " robot_job_type=?" : string2 + " robot_job_type<>? AND robot_job_type<>? AND robot_job_type<>? AND robot_job_type<>?";
            if (string != null && string.trim().length() > 0) {
                string2 = string2 + " AND robot_job_name LIKE '" + string.trim().toUpperCase() + "%'";
            }
            string2 = string2 + " ORDER BY robot_job_name";
        } else {
            string2 = "SELECT row_id, robot_job_name, robot_job_number, robot_job_desc from (select ROW_NUMBER() OVER (order by robot_job_name, robot_job_number) AS row_id, robot_job_name, robot_job_number, robot_job_desc from " + this.jobTable;
            string2 = string2 + " where";
            if (string != null && string.trim().length() > 0) {
                string2 = string2 + " JOBNAM like '" + string.trim().toUpperCase() + "%' AND";
            }
            string2 = bl ? string2 + " robot_job_type=?" : string2 + " robot_job_type<>? AND robot_job_type<>? AND robot_job_type<>? AND robot_job_type<>?";
            string2 = string2 + ")";
            string2 = string2 + " AS ROB WHERE ROB.row_id>=" + (n2 + 1) + " AND ROB.row_id<=" + (n2 + n);
        }
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            if (bl) {
                preparedStatement.setString(1, "G");
            } else {
                preparedStatement.setString(1, "G");
                preparedStatement.setString(2, "S");
                preparedStatement.setString(3, "F");
                preparedStatement.setString(4, " ");
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = Convert.trimR((String)resultSet.getString("robot_job_number"));
                String string4 = Convert.trimR((String)resultSet.getString("robot_job_name"));
                String string5 = Convert.trimR((String)resultSet.getString("robot_job_desc"));
                arrayList.add(new RemoteObject((Object)string3, string4, string5));
            }
        }
        catch (SQLException sQLException) {
            String string6 = "SQL error while retrieving the list of jobs on the remote server.";
            throw new ResourceUnavailableException(string6, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList.toArray(new RemoteObject[arrayList.size()]);
    }

    private RemoteObject[] getGroupJobs() throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        return this.getGroupJobs(null, 0, 0);
    }

    private RemoteObject[] getGroupJobs(String string, int n, int n2) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        return this.getJobs(true, string, n, n2);
    }

    private RemoteScheduleServer getRemoteServerInfo() throws ResourceUnavailableException {
        RemoteScheduleServer remoteScheduleServer = (RemoteScheduleServer)this.remoteServersDM.getServer(this.remoteServerID);
        return remoteScheduleServer;
    }

    private String getRemoteServerName() {
        return this.remoteServersDM.getServerName(this.remoteServerID);
    }

    private boolean isDependencyAlreadyExists(long l, RemoteEventType remoteEventType, long l2) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        String string = "SELECT COUNT(*) FROM " + this.dependencyTable + " WHERE prereq_object_id=? AND prereq_object_type=? AND server_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, remoteEventType.persistanceCode());
            preparedStatement.setLong(3, l2);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"Error while checking if a dependency already exists for a {0} for the object with id (1} on the server with the server id / installed utc {2}.", (Object[])new Object[]{remoteEventType, l, l2});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public int removeDependency(long l, RemoteEventType remoteEventType, long l2) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        String string = "DELETE FROM " + this.dependencyTable + " WHERE prereq_object_id=? AND prereq_object_type=? AND server_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            int n;
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, remoteEventType.persistanceCode());
            preparedStatement.setLong(3, l2);
            int n2 = n = preparedStatement.executeUpdate();
            return n2;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"Error deleting dependency a {0} for the object with id (1} on the server with the server id {2}.", (Object[])new Object[]{remoteEventType, l, l2});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public int removeDependency(int n, long l, long l2) throws RemoteServerException {
        throw new IllegalStateException("Program error: This version of the removeDependency method should not be called on a Schedule type remote server.");
    }

    private boolean isInArray(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private boolean isInDatabase(RemoteEventType remoteEventType, long l) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: 
            case GROUP_JOB_STATUS_CHANGE: {
                return this.isInDatabase(this.jobTable, l);
            }
        }
        throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
    }

    private boolean isInDatabase(String string, long l) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        String string2 = "SELECT COUNT(*) FROM " + string + " WHERE robot_job_number=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            String string3 = String.format("%012d", l);
            preparedStatement.setString(1, string3);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                boolean bl = resultSet.getInt(1) > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException sQLException) {
            throw new ResourceUnavailableException(MessageUtil.formatMsg((String)"Error while checking if an object with ID {0} exists in database table {1}.", (Object[])new Object[]{l, string}), (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private void swapToRBTUSER(Connection connection) {
        String string = "RBTSYSLIB";
        try {
            CallableStatement callableStatement = connection.prepareCall("CALL " + string + ".RSL317");
            callableStatement.execute();
            callableStatement.close();
            callableStatement = connection.prepareCall("CALL " + string + ".RSL863");
            callableStatement.execute();
            callableStatement.close();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to swap to RBTUSER.");
        }
    }

    private void swapBack(Connection connection) {
        if (connection != null) {
            String string = "RBTSYSLIB";
            try {
                CallableStatement callableStatement = connection.prepareCall("CALL " + string + ".RSL187");
                callableStatement.execute();
                callableStatement.close();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to swap back from RBTUSER.");
            }
        }
    }

    private String toEventType_forMessageString(RemoteEventType remoteEventType) {
        if (remoteEventType == null) {
            return "null";
        }
        switch (remoteEventType) {
            case JOB_STATUS_CHANGE: {
                return "Job";
            }
            case GROUP_JOB_STATUS_CHANGE: {
                return "Group Job";
            }
        }
        return remoteEventType.toString();
    }

    private void validateRemoteEventType(RemoteEventType remoteEventType) {
        ValidationHelper.checkForNull((String)"Remote Event Type", (Object)remoteEventType);
        if (!this.isInArray(this.getNotifiableEventTypes(), remoteEventType.persistanceCode())) {
            throw new IllegalArgumentException(MessageUtil.formatMsg((String)"Program error: Remote Event Type {0} is not supported by this method.", (Object[])new Object[]{remoteEventType}));
        }
    }

    private void validateObject(RemoteEventType remoteEventType, long l) throws RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        boolean bl;
        ValidationHelper.checkForNull((String)"Remote Event Type", (Object)remoteEventType);
        try {
            bl = this.isInDatabase(remoteEventType, l);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Error while trying to determine if the {0} with ID {1} exists in the database.", (Object[])new Object[]{this.toEventType_forMessageString(remoteEventType), l}), resourceUnavailableException);
        }
        if (!bl) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"The {0} with ID {1} does not exist in the database.", (Object[])new Object[]{this.toEventType_forMessageString(remoteEventType), l}));
        }
    }

    public List<RBTNotification> getNotificationList(long l, int n) throws RemoteServerUnreachableException, RemoteServerNotConfiguredException, ResourceUnavailableException {
        ArrayList<RBTNotification> arrayList = new ArrayList<RBTNotification>();
        String string = "SELECT id,server_id,object_id,object_name,object_type,status, status_date,status_time,source_key,source_info FROM " + this.notificationTable + " WHERE server_id=?" + " ORDER BY id";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                RBTNotification rBTNotification = new RBTNotification();
                rBTNotification.setId(resultSet.getLong("id"));
                rBTNotification.setServerID(resultSet.getLong("server_id"));
                rBTNotification.setObjectID(resultSet.getLong("object_id"));
                rBTNotification.setObjectName(resultSet.getString("object_name"));
                int n2 = resultSet.getInt("status_date");
                int n3 = resultSet.getInt("status_time");
                long l2 = this.buildStatusDateTime(n2, n3);
                rBTNotification.setStatusTime(l2);
                rBTNotification.setSourceKey(resultSet.getInt("source_key"));
                rBTNotification.setSourceInfo(resultSet.getString("source_info"));
                try {
                    rBTNotification.setObjectType(this.translateEventType(resultSet.getInt("object_type")));
                    rBTNotification.setStatus(this.translateStatus(resultSet.getString("status")));
                }
                catch (Exception exception) {
                    logger.warn((Object)"Error translating notification data.", (Throwable)exception);
                    rBTNotification.setValid(false);
                }
                arrayList.add(rBTNotification);
                if (n <= 0 || n > arrayList.size()) continue;
                break;
            }
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while retrieving notifications from the remote server.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList;
    }

    private long buildStatusDateTime(int n, int n2) {
        if (n == 0) {
            return 0L;
        }
        long l = n;
        long l2 = n2;
        long l3 = l + 19000000L;
        return l3 * 1000000L + l2;
    }

    private RemoteEventType translateEventType(int n) {
        return RemoteEventType.persistanceCodeToEnum((int)n);
    }

    private PrereqStatusType translateStatus(String string) {
        if (string == null) {
            return PrereqStatusType.BLANK;
        }
        String string2 = string.trim().toUpperCase();
        if (string2.length() == 0) {
            return PrereqStatusType.BLANK;
        }
        if (string2.equals("T")) {
            return PrereqStatusType.FAILED;
        }
        if (string2.equals("B")) {
            return PrereqStatusType.BLANK;
        }
        if (string2.equals("S") || string2.equals("R") || string2.equals("C") || string2.equals("K")) {
            return PrereqStatusType.persistanceCodeToEnum((String)string2);
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Unexpected status {0}.", (Object[])new Object[]{string}));
    }

    public void removeNotificationById(long l) throws RemoteServerUnreachableException, RemoteServerNotConfiguredException, ResourceUnavailableException {
        String string = "DELETE FROM " + this.notificationTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = "SQL error while removing notification " + l + " from the remote server.";
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RegisteredServer[] getRegisteredServers(RemoteServer remoteServer) throws ResourceUnavailableException, RemoteServerUnreachableException, RemoteServerNotConfiguredException {
        RemoteScheduleServer remoteScheduleServer = null;
        if (remoteServer instanceof RemoteScheduleServer) {
            remoteScheduleServer = (RemoteScheduleServer)remoteServer;
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        ArrayList<RegisteredServer> arrayList = new ArrayList<RegisteredServer>();
        try {
            String string = this.skybotTable.replaceAll("\\{library\\}", remoteScheduleServer.getLibrary());
            String string2 = "SELECT servername, installutc, notifqname FROM " + string;
            connection = this.establishNonVerifiedJDBCConnection(remoteScheduleServer);
            preparedStatement = connection.prepareStatement(string2);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                RegisteredServer registeredServer = new RegisteredServer();
                registeredServer.setServerName(resultSet.getString("servername"));
                registeredServer.setInstalledDateTime(resultSet.getLong("installutc"));
                registeredServer.setNotificationQueue(resultSet.getString("notifqname"));
                arrayList.add(registeredServer);
            }
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
            if (connection == null) return arrayList.toArray(new RegisteredServer[0]);
        }
        catch (SQLException sQLException) {
            try {
                String string3 = "Error retrieving registered server list.";
                throw new ResourceUnavailableException(string3, (Throwable)sQLException);
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    this.closeConnection(preparedStatement);
                }
                if (connection == null) throw throwable;
                try {
                    connection.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            connection.close();
            return arrayList.toArray(new RegisteredServer[0]);
        }
        catch (Exception exception) {
            return arrayList.toArray(new RegisteredServer[0]);
        }
    }
}

