/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.remoteserver;

import com.helpsystems.common.access.AbstractBusObjGenerator;
import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.Convert;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentEventHistoryInfo;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobMonitorEvent;
import com.helpsystems.enterprise.core.busobj.PrereqEventSource;
import com.helpsystems.enterprise.core.busobj.PrereqEventType;
import com.helpsystems.enterprise.core.busobj.PrereqObjectType;
import com.helpsystems.enterprise.core.busobj.SendStatusEvent;
import com.helpsystems.enterprise.core.dm.AgentEventMonitorDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyDM;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyNotification;
import com.helpsystems.enterprise.core.remoteserver.RemoteDependencyProxy;
import com.helpsystems.enterprise.core.remoteserver.RemoteEventType;
import com.helpsystems.enterprise.core.remoteserver.RemoteServerType;
import com.helpsystems.enterprise.core.scheduler.JobSuiteDM;
import com.helpsystems.enterprise.core.scheduler.PrereqStatusType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteDependencyDMJdbc
extends AbstractDatabaseManager
implements RemoteDependencyDM {
    private static final Logger logger = Logger.getLogger(RemoteDependencyDMJdbc.class);
    private static final String REMOTE_DEPENDENCIES_TABLE = "remote_dependencies";
    private static final String REMOTE_NOTIFICATION_EVENTS_TABLE = "remote_notification_events";
    private static final String REMOTE_NOTIFICATION_HISTORIES_TABLE = "remote_notification_histories";
    private String remoteDependenciesTable;
    private String remoteNotificationEventsTable;
    private String remoteNotificationHistoriesTable;

    public RemoteDependencyDMJdbc(String string, String string2, String string3) {
        super(string);
        ValidationHelper.checkForNull((String)"Library", (Object)string2);
        ValidationHelper.checkForNull((String)"Manager Name", (Object)string3);
        this.remoteDependenciesTable = string2 + "." + REMOTE_DEPENDENCIES_TABLE;
        this.remoteNotificationEventsTable = string2 + "." + REMOTE_NOTIFICATION_EVENTS_TABLE;
        this.remoteNotificationHistoriesTable = string2 + "." + REMOTE_NOTIFICATION_HISTORIES_TABLE;
        this.setName(string3);
    }

    public void createRemoteDependency(RemoteEventType remoteEventType, long l, long l2) throws NotSavedException, ResourceUnavailableException {
        PrereqObjectType prereqObjectType = PrereqObjectType.convert((RemoteEventType)remoteEventType);
        int n = remoteEventType.persistanceCode();
        String string = "INSERT INTO " + this.remoteDependenciesTable + " (prereq_object_id, prereq_object_type, remote_server_id, prereq_type) VALUES(?,?,?,?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, prereqObjectType.persistanceCode());
            preparedStatement.setLong(3, l2);
            preparedStatement.setInt(4, n);
            int n2 = preparedStatement.executeUpdate();
            if (n2 < 1) {
                logger.info((Object)MessageUtil.formatMsg((String)"We are already notifying the remote server with id {0} when the {1} event occurs, for the object with id {2}.", (Object[])new Object[]{l2, remoteEventType, l}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while inserting the remote dependency entry for the remote server with id {0} when the {1} event occurs, for the object with id {2}.", (Object[])new Object[]{l2, remoteEventType, l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public void generateNotificationEvent(AgentEventHistoryInfo agentEventHistoryInfo, RemoteDependencyProxy remoteDependencyProxy, String string) throws NotSavedException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Agent Event History Info", (Object)agentEventHistoryInfo);
        RemoteDependencyNotification remoteDependencyNotification = RemoteDependencyNotification.fromAgentEventHistory((AgentEventHistoryInfo)agentEventHistoryInfo);
        remoteDependencyNotification.setServerID(remoteDependencyProxy.getRemoteServerID());
        remoteDependencyNotification.setRemoteDependencyID(remoteDependencyProxy.getId());
        this.insertNotificationEvent(remoteDependencyNotification, string);
    }

    public void generateNotificationEvent(JobHistory jobHistory, RemoteDependencyProxy remoteDependencyProxy, String string, RemoteServerType remoteServerType) throws NotSavedException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Job History", (Object)jobHistory);
        RemoteDependencyNotification remoteDependencyNotification = RemoteDependencyNotification.fromJobHistory((JobHistory)jobHistory);
        remoteDependencyNotification.setServerID(remoteDependencyProxy.getRemoteServerID());
        remoteDependencyNotification.setRemoteDependencyID(remoteDependencyProxy.getId());
        if (remoteServerType == RemoteServerType.SCHEDULE) {
            String string2;
            String string3 = remoteDependencyProxy.getUserJobName();
            if (string3 != null && !string3.isEmpty()) {
                string2 = string3;
            } else {
                String string4 = jobHistory.getJobName();
                string2 = RemoteDependencyNotification.convertSkybotNameToUserJobName((String)string4);
            }
            remoteDependencyNotification.setUserJobName(string2);
        }
        this.insertNotificationEvent(remoteDependencyNotification, string);
    }

    public void generateNotificationEvent(JobMonitorEvent jobMonitorEvent, RemoteDependencyProxy remoteDependencyProxy, String string) throws NotSavedException, ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Job Monitor Event", (Object)jobMonitorEvent);
        RemoteDependencyNotification remoteDependencyNotification = RemoteDependencyNotification.fromJobMonitorEvent((JobMonitorEvent)jobMonitorEvent);
        remoteDependencyNotification.setServerID(remoteDependencyProxy.getRemoteServerID());
        remoteDependencyNotification.setRemoteDependencyID(remoteDependencyProxy.getId());
        this.insertNotificationEvent(remoteDependencyNotification, string);
    }

    public void generateNotificationEvent(SendStatusEvent sendStatusEvent, RemoteDependencyProxy remoteDependencyProxy, String string, RemoteServerType remoteServerType) throws NotSavedException, ResourceUnavailableException {
        String string2;
        ValidationHelper.checkForNull((String)"Send Status Event", (Object)sendStatusEvent);
        ValidationHelper.checkForNull((String)"Remote Server Type", (Object)remoteServerType);
        RemoteDependencyNotification remoteDependencyNotification = RemoteDependencyNotification.fromSendStatusEvent((SendStatusEvent)sendStatusEvent);
        try {
            remoteDependencyNotification.setObjectName(this.getPrereqObjectName(sendStatusEvent));
        }
        catch (Exception exception) {
            string2 = this.toEventType_forMessageString(sendStatusEvent.getPrereqEventType());
            logger.warn((Object)MessageUtil.formatMsg((String)"Could not determine the object name associated with the prerequisite object {0} with ID {1}, for a Send Status Event. Will default to blank.", (Object[])new Object[]{string2, sendStatusEvent.getPrereqObjectID()}), (Throwable)exception);
            remoteDependencyNotification.setObjectName("");
        }
        remoteDependencyNotification.setServerID(remoteDependencyProxy.getRemoteServerID());
        remoteDependencyNotification.setRemoteDependencyID(remoteDependencyProxy.getId());
        if (remoteServerType == RemoteServerType.SCHEDULE) {
            String string3;
            string2 = remoteDependencyProxy.getUserJobName();
            if (string2 != null && !string2.isEmpty()) {
                string3 = string2;
            } else {
                String string4 = remoteDependencyNotification.getObjectName();
                string3 = RemoteDependencyNotification.convertSkybotNameToUserJobName((String)string4);
            }
            remoteDependencyNotification.setUserJobName(string3);
        }
        this.insertNotificationEvent(remoteDependencyNotification, string);
    }

    public RemoteDependencyProxy[] getDependentRemoteServers(long l, PrereqEventType prereqEventType) throws ResourceUnavailableException {
        if (prereqEventType == PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE) {
            return this.getDependentRemoteServersForMember(l);
        }
        HashSet<RemoteDependencyProxy> hashSet = new HashSet<RemoteDependencyProxy>();
        String string = "SELECT id, remote_server_id, user_job_name FROM " + this.remoteDependenciesTable + " WHERE prereq_object_id =? AND prereq_type =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, prereqEventType.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                RemoteDependencyProxy remoteDependencyProxy = new RemoteDependencyProxy();
                remoteDependencyProxy.setId(resultSet.getLong("id"));
                remoteDependencyProxy.setRemoteServerID(resultSet.getLong("remote_server_id"));
                remoteDependencyProxy.setUserJobName(resultSet.getString("user_job_name"));
                hashSet.add(remoteDependencyProxy);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the remote servers that are dependent on the {0} with id {1}.", (Object[])new Object[]{this.toEventType_forMessageString(prereqEventType), l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet.toArray(new RemoteDependencyProxy[hashSet.size()]);
    }

    private RemoteDependencyProxy[] getDependentRemoteServersForMember(long l) throws ResourceUnavailableException {
        HashSet<RemoteDependencyProxy> hashSet = new HashSet<RemoteDependencyProxy>();
        String string = "SELECT id, remote_server_id, user_job_name FROM " + this.remoteDependenciesTable + " WHERE prereq_object_id =? AND prereq_object_type =? AND prereq_type =?" + " OR prereq_object_id =? AND prereq_object_type =? AND prereq_type =?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, PrereqObjectType.JOB_SUITE_MEMBER_JOB.persistanceCode());
            preparedStatement.setInt(3, PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE.persistanceCode());
            preparedStatement.setLong(4, this.jobIdOfMemberJob(l, preparedStatement.getConnection()));
            preparedStatement.setString(5, PrereqObjectType.MEMBER_JOB.persistanceCode());
            preparedStatement.setInt(6, PrereqEventType.JOB_SUITE_MEMBER_STATUS_CHANGE.persistanceCode());
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                RemoteDependencyProxy remoteDependencyProxy = new RemoteDependencyProxy();
                remoteDependencyProxy.setId(resultSet.getLong("id"));
                remoteDependencyProxy.setRemoteServerID(resultSet.getLong("remote_server_id"));
                remoteDependencyProxy.setUserJobName(resultSet.getString("user_job_name"));
                hashSet.add(remoteDependencyProxy);
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while retrieving the remote servers that are dependent on the job suite member with ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return hashSet.toArray(new RemoteDependencyProxy[hashSet.size()]);
    }

    public List<RemoteDependencyNotification> getNotificationEvents() throws ResourceUnavailableException {
        ArrayList<RemoteDependencyNotification> arrayList = new ArrayList<RemoteDependencyNotification>();
        RemoteDependencyNotificationGenerator remoteDependencyNotificationGenerator = new RemoteDependencyNotificationGenerator();
        String string = "SELECT id, remote_server_id, event_type, event_status, object_id, object_name, event_source, event_source_id, user_job_name, event_source_info, status_time_utc, remote_notification_history_id, remote_dependency_id, job_suite_id, job_suite_name FROM " + this.remoteNotificationEventsTable + " ORDER BY status_time_utc";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    arrayList.add((RemoteDependencyNotification)remoteDependencyNotificationGenerator.generateObject(resultSet));
                }
                catch (BadDataException badDataException) {
                    RemoteDependencyNotification remoteDependencyNotification = (RemoteDependencyNotification)badDataException.getLoadedObject();
                    String string2 = this.constructBadDataDetails(badDataException.getErrorList());
                    String string3 = MessageUtil.formatMsg((String)"Corrupt data for remote dependency notification {0}.{1}", (Object[])new Object[]{remoteDependencyNotification, string2});
                    logger.error((Object)string3, (Throwable)badDataException);
                }
            }
        }
        catch (SQLException sQLException) {
            String string4 = "SQL error while retrieving the remote dependency notification events.";
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
        return arrayList;
    }

    public int getNotificationEventCount() throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.remoteNotificationEventsTable;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = this.getConnectionOrFail();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = wrappedConnection.createStatement();
        }
        catch (SQLException sQLException) {
            RemoteDependencyDMJdbc.closeEm((Connection)wrappedConnection, null, null);
            throw new ResourceUnavailableException("Error retrieving the Statement from the Connection.", (Throwable)sQLException);
        }
        try {
            resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            try {
                throw new IllegalStateException("Unable to obtain the remote dependency notification event count.");
            }
            catch (SQLException sQLException) {
                throw new ResourceUnavailableException("Error retrieving the remote dependency notification event count.", (Throwable)sQLException);
            }
        }
        finally {
            RemoteDependencyDMJdbc.closeEm((Connection)wrappedConnection, (Statement)statement, null);
        }
    }

    public void deleteNotificationEvent(long l) throws ResourceUnavailableException {
        String string = "DELETE FROM " + this.remoteNotificationEventsTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            int n = preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error deleting the remote dependency notification event with ID = {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public int deleteRemoteDependency(RemoteEventType remoteEventType, long l, long l2) throws ResourceUnavailableException {
        ValidationHelper.checkForNull((String)"Remote Event Type", (Object)remoteEventType);
        String string = "DELETE FROM " + this.remoteDependenciesTable + " WHERE prereq_object_id=? AND prereq_type=? AND remote_server_id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            preparedStatement.setInt(2, remoteEventType.persistanceCode());
            preparedStatement.setLong(3, l2);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException sQLException) {
            String string2;
            try {
                string2 = this.toEventType_forMessageString(this.toPrereqEventType(remoteEventType));
            }
            catch (Exception exception) {
                string2 = remoteEventType.toString();
            }
            String string3 = MessageUtil.formatMsg((String)"SQL error deleting the remote dependency entry for {0} with ID {1} to notify the remote server with ID {2}.", (Object[])new Object[]{string2, l, l2});
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public int deleteRemoteDependency(long l) throws ResourceUnavailableException {
        String string = "DELETE FROM " + this.remoteDependenciesTable + " WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error deleting the remote dependency entry with ID {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public boolean isInDatabase(RemoteEventType remoteEventType, long l, long l2) throws ResourceUnavailableException {
        String string = "SELECT COUNT(*) FROM " + this.remoteDependenciesTable + " WHERE prereq_object_id=? AND prereq_type=? AND remote_server_id=?";
        Object[] objectArray = new Object[]{new Long(l), new Integer(remoteEventType.persistanceCode()), new Long(l2)};
        try {
            return this.doCount(string, objectArray) > 0;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error while checking if a remote dependency exists in the database.", (Throwable)exception);
        }
    }

    public void markNotificationAsCanceled(long l) throws ResourceUnavailableException {
        String string = "UPDATE " + this.remoteNotificationHistoriesTable + " SET is_canceled= TRUE WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to mark the remote notification history row with id {0} as canceled because the id was not found.", (Object[])new Object[]{l}));
            } else if (n > 1) {
                logger.error((Object)MessageUtil.formatMsg((String)"Program error: More than 1 remote notification history row with id {0} was found and marked as canceled. Count = {1}.", (Object[])new Object[]{l, n}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while trying to mark that a remote server notification was canceled. The history ID was {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    public void markNotificationAsReceived(long l, long l2) throws ResourceUnavailableException {
        String string = "UPDATE " + this.remoteNotificationHistoriesTable + " SET notification_time_utc=?, notification_receipt_id=? WHERE id=?";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string);
        try {
            preparedStatement.setLong(1, System.currentTimeMillis());
            preparedStatement.setLong(2, l2);
            preparedStatement.setLong(3, l);
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                logger.error((Object)MessageUtil.formatMsg((String)"Unable to mark the remote notification history row with id {0} as received because the id was not found.", (Object[])new Object[]{l}));
            } else if (n > 1) {
                logger.error((Object)MessageUtil.formatMsg((String)"Program error: More than 1 remote notification history row with id {0} was found and marked as received. Count = {1}.", (Object[])new Object[]{l, n}));
            }
        }
        catch (SQLException sQLException) {
            String string2 = MessageUtil.formatMsg((String)"SQL error while trying to mark that a remote server notification was received. The history ID was {0}.", (Object[])new Object[]{l});
            throw new ResourceUnavailableException(string2, (Throwable)sQLException);
        }
        finally {
            this.closeConnection(preparedStatement);
        }
    }

    private String constructBadDataDetails(ErrorList errorList) {
        String string = "";
        if (errorList != null) {
            string = string + " Details:";
            while (errorList.nextError()) {
                string = string + " " + errorList.getErrorText();
            }
        }
        return string;
    }

    private String getPrereqObjectName(SendStatusEvent sendStatusEvent) {
        long l = sendStatusEvent.getPrereqObjectID();
        switch (sendStatusEvent.getPrereqEventType()) {
            case JOB_STATUS_CHANGE: 
            case JOB_SUITE_STATUS_CHANGE: 
            case JOB_MONITOR_EVENT: 
            case JOB_SUITE_MONITOR_EVENT: 
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                return this.getJobName(l);
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return this.getMemberJobName(l);
            }
            case AGENT_EVENT: {
                return this.getAgentEventMonitorName(l);
            }
        }
        throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Send Status Event type {0} is not supported by this method.", (Object[])new Object[]{sendStatusEvent.getPrereqEventType()}));
    }

    private String getAgentEventMonitorName(long l) {
        AgentEventMonitorDM agentEventMonitorDM = (AgentEventMonitorDM)ManagerRegistry.getManager((String)"ENTERPRISE.AgentEventMonitorDM");
        if (agentEventMonitorDM == null) {
            throw new IllegalStateException("Unable to retrieve an agent event monitor name. The agent event monitor data manager was not found.");
        }
        try {
            return agentEventMonitorDM.get(l, null).getName();
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Error while retrieving the name associated with agent event monitor id {0}.", (Object[])new Object[]{l}), exception);
        }
    }

    private String getJobName(long l) {
        ScheduleJobDM scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManager((String)"ENTERPRISE.ScheduleJobDM");
        if (scheduleJobDM == null) {
            throw new IllegalStateException("Unable to retrieve a job name. The schedule job data manager was not found.");
        }
        try {
            return scheduleJobDM.getScheduleJobProxy(l).getName();
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Error while retrieving the name associated with job id {0}.", (Object[])new Object[]{l}), exception);
        }
    }

    private String getMemberJobName(long l) {
        JobSuiteDM jobSuiteDM = (JobSuiteDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobSuiteDM");
        if (jobSuiteDM == null) {
            throw new IllegalStateException("Unable to retrieve a member job name. The job suite data manager was not found.");
        }
        try {
            return jobSuiteDM.getMember(l).getName();
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"Error while retrieving the name associated with member job id {0}.", (Object[])new Object[]{l}), exception);
        }
    }

    private void insertNotificationEvent(RemoteDependencyNotification remoteDependencyNotification, String string) throws NotSavedException, ResourceUnavailableException {
        long l = this.insertNotificationHistory(remoteDependencyNotification, string);
        String string2 = "INSERT INTO " + this.remoteNotificationEventsTable + " (remote_server_id, event_type, event_status, object_id, object_name, " + "event_source, event_source_id, event_source_info, status_time_utc, " + "remote_notification_history_id, user_job_name, remote_dependency_id, " + "job_suite_id, job_suite_name) " + "VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getDefaultPreparedStmt(string2);
        try {
            preparedStatement.setLong(1, remoteDependencyNotification.getServerID());
            preparedStatement.setInt(2, remoteDependencyNotification.getEventType().persistanceCode());
            preparedStatement.setString(3, remoteDependencyNotification.getEventStatus().persistanceCode());
            preparedStatement.setLong(4, remoteDependencyNotification.getObjectID());
            preparedStatement.setString(5, remoteDependencyNotification.getObjectName());
            preparedStatement.setInt(6, remoteDependencyNotification.getEventSource().persistanceCode());
            preparedStatement.setLong(7, remoteDependencyNotification.getEventSourceID());
            preparedStatement.setString(8, remoteDependencyNotification.getEventSourceInfo());
            preparedStatement.setLong(9, remoteDependencyNotification.getStatusTimestamp());
            preparedStatement.setLong(10, l);
            preparedStatement.setString(11, remoteDependencyNotification.getUserJobName());
            preparedStatement.setLong(12, remoteDependencyNotification.getRemoteDependencyID());
            preparedStatement.setLong(13, remoteDependencyNotification.getJobSuiteID());
            preparedStatement.setString(14, remoteDependencyNotification.getJobSuiteName());
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException(MessageUtil.formatMsg((String)"Unable to create a remote server dependency notification event for {0} (type = {1}, status {2}.", (Object[])new Object[]{remoteDependencyNotification.getObjectName(), remoteDependencyNotification.getEventType(), remoteDependencyNotification.getEventStatus()}));
            }
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while generating a remote server dependency notification event.", (Object[])new Object[0]);
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    private long insertNotificationHistory(RemoteDependencyNotification remoteDependencyNotification, String string) throws NotSavedException, ResourceUnavailableException {
        String string2 = "INSERT INTO " + this.remoteNotificationHistoriesTable + " (remote_server_id, prereq_object_id, prereq_object_type, status, " + "status_time_utc, remote_server_name, prereq_object_name, source_id, " + "source_info, event_source, user_job_name, remote_dependency_id, " + "job_suite_id, job_suite_name) " + "VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = this.getPreparedStmtThatReturnsGeneratedKeys(string2, null);
        try {
            preparedStatement.setLong(1, remoteDependencyNotification.getServerID());
            preparedStatement.setLong(2, remoteDependencyNotification.getObjectID());
            preparedStatement.setInt(3, remoteDependencyNotification.getEventType().persistanceCode());
            preparedStatement.setString(4, remoteDependencyNotification.getEventStatus().persistanceCode());
            preparedStatement.setLong(5, remoteDependencyNotification.getStatusTimestamp());
            preparedStatement.setString(6, string);
            preparedStatement.setString(7, remoteDependencyNotification.getObjectName());
            preparedStatement.setLong(8, remoteDependencyNotification.getEventSourceID());
            preparedStatement.setString(9, remoteDependencyNotification.getEventSourceInfo());
            preparedStatement.setInt(10, remoteDependencyNotification.getEventSource().persistanceCode());
            preparedStatement.setString(11, remoteDependencyNotification.getUserJobName());
            preparedStatement.setLong(12, remoteDependencyNotification.getRemoteDependencyID());
            preparedStatement.setLong(13, remoteDependencyNotification.getJobSuiteID());
            preparedStatement.setString(14, remoteDependencyNotification.getJobSuiteName());
            int n = preparedStatement.executeUpdate();
            if (n < 1) {
                throw new NotSavedException(MessageUtil.formatMsg((String)"Unable to create a remote server notification event for {0} (type = {1}, status {2}.", (Object[])new Object[]{remoteDependencyNotification.getObjectName(), remoteDependencyNotification.getEventType(), remoteDependencyNotification.getEventStatus()}));
            }
            long l = this.retrieveGeneratedKey(preparedStatement);
            return l;
        }
        catch (SQLException sQLException) {
            String string3 = MessageUtil.formatMsg((String)"SQL error while generating a remote server notification event.", (Object[])new Object[0]);
            throw new ResourceUnavailableException(string3, (Throwable)sQLException);
        }
        finally {
            if (preparedStatement != null) {
                this.closeConnection(preparedStatement);
            }
        }
    }

    private long jobIdOfMemberJob(long l, Connection connection) {
        JobSuiteDM jobSuiteDM = (JobSuiteDM)ManagerRegistry.getManager((String)"ENTERPRISE.JobSuiteDM");
        if (jobSuiteDM != null) {
            try {
                return jobSuiteDM.jobIdOfMemberJob(l, connection);
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage());
            }
        } else {
            logger.error((Object)"Unable to retrieve a job ID. The JobSuite data manager was not found.");
        }
        return -1L;
    }

    public void purgeHistory(int n) throws ResourceUnavailableException, SQLException {
        ScheduleLogEntry scheduleLogEntry;
        String[] stringArray;
        AbstractDatabaseManager.WrappedConnection wrappedConnection = null;
        String string = null;
        int n2 = 0;
        String string2 = RosettaMsg.PURGE_SKYBOT_EVENT_HISTORY_NAME.newLogEntry().getMessageText();
        try {
            wrappedConnection = this.getConnection();
            stringArray = new String[]{string2, String.valueOf(n)};
            scheduleLogEntry = RosettaMsg.PURGE_OLDER_THAN.newLogEntry(stringArray);
            logger.debug((Object)scheduleLogEntry.getMessageText());
            ScheduleLogger.write((Connection)wrappedConnection, (ScheduleLogEntry)scheduleLogEntry);
            long l = DateTranslator.getDaysOldAsMilliseconds((long)n);
            Date date = new Date(l);
            PreparedStatement preparedStatement = null;
            String string3 = "DELETE FROM remote_notification_histories WHERE notification_time_utc < ?";
            preparedStatement = this.getDefaultPreparedStmt(string3, (Connection)wrappedConnection);
            preparedStatement.setLong(1, date.getTime());
            n2 = preparedStatement.executeUpdate();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Purged " + n2 + " " + string2 + " entries."));
            }
        }
        catch (SQLException sQLException) {
            String string4 = "Error while purging the " + string2 + " data.";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)string4, (Throwable)sQLException);
                logger.debug((Object)("SQL query: " + string));
            }
            throw new ResourceUnavailableException(string4, (Throwable)sQLException);
        }
        finally {
            if (wrappedConnection != null) {
                try {
                    wrappedConnection.close();
                }
                catch (Exception exception) {}
            }
        }
        if (n2 > 0) {
            stringArray = new String[]{String.valueOf(n2), string2};
            scheduleLogEntry = RosettaMsg.HISTORY_PURGE_COMPLETE.newLogEntry(stringArray);
            ScheduleLogger.write((ScheduleLogEntry)scheduleLogEntry);
            logger.debug((Object)scheduleLogEntry.getMessageText());
        }
    }

    private String toEventType_forMessageString(PrereqEventType prereqEventType) {
        if (prereqEventType == null) {
            return "null";
        }
        switch (prereqEventType) {
            case JOB_STATUS_CHANGE: {
                return "Job";
            }
            case JOB_SUITE_STATUS_CHANGE: {
                return "Job Suite";
            }
            case JOB_SUITE_MEMBER_STATUS_CHANGE: {
                return "Job Suite Member";
            }
            case AGENT_EVENT: {
                return "Agent Event";
            }
            case SNMP_TRAP_EVENT: {
                return "SNMP Trap Event";
            }
            case JOB_MONITOR_EVENT: {
                return "Job Monitor Event";
            }
            case JOB_SUITE_MONITOR_EVENT: {
                return "Job Suite Monitor Event";
            }
            case JOB_SUITE_MEMBER_MONITOR_EVENT: {
                return "Job Suite Member Monitor Event";
            }
            case SAP_MONITOR_EVENT: {
                return "SAP Monitor Event";
            }
        }
        return prereqEventType.toString();
    }

    private PrereqEventType toPrereqEventType(RemoteEventType remoteEventType) {
        return PrereqEventType.persistanceCodeToEnum((int)remoteEventType.persistanceCode());
    }

    private class RemoteDependencyNotificationGenerator
    extends AbstractBusObjGenerator {
        public RemoteDependencyNotificationGenerator() {
            super(15, "RemoteDependencyNotification");
        }

        protected Object constructObject() {
            return new RemoteDependencyNotification();
        }

        protected void getDataFromRS(ResultSet resultSet, Object object, int n) throws SQLException, ResourceUnavailableException {
            ValidationHelper.checkForNull((String)"ResultSet", (Object)resultSet);
            ValidationHelper.checkForNull((String)"Object", (Object)object);
            RemoteDependencyNotification remoteDependencyNotification = (RemoteDependencyNotification)object;
            switch (n) {
                case 1: {
                    remoteDependencyNotification.setId(resultSet.getLong("id"));
                    break;
                }
                case 2: {
                    remoteDependencyNotification.setServerID(resultSet.getLong("remote_server_id"));
                    break;
                }
                case 3: {
                    remoteDependencyNotification.setEventType(PrereqEventType.persistanceCodeToEnum((int)resultSet.getInt("event_type")));
                    break;
                }
                case 4: {
                    remoteDependencyNotification.setEventStatus(PrereqStatusType.persistanceCodeToEnum((String)resultSet.getString("event_status")));
                    break;
                }
                case 5: {
                    remoteDependencyNotification.setObjectID(resultSet.getLong("object_id"));
                    break;
                }
                case 6: {
                    remoteDependencyNotification.setObjectName(Convert.trimR((String)resultSet.getString("object_name")));
                    break;
                }
                case 7: {
                    remoteDependencyNotification.setEventSource(PrereqEventSource.persistanceCodeToEnum((int)resultSet.getInt("event_source")));
                    break;
                }
                case 8: {
                    remoteDependencyNotification.setEventSourceID(resultSet.getLong("event_source_id"));
                    break;
                }
                case 9: {
                    remoteDependencyNotification.setEventSourceInfo(Convert.trimR((String)resultSet.getString("event_source_info")));
                    break;
                }
                case 10: {
                    remoteDependencyNotification.setStatusTimestamp(resultSet.getLong("status_time_utc"));
                    break;
                }
                case 11: {
                    remoteDependencyNotification.setNotificationHistoryID(resultSet.getLong("remote_notification_history_id"));
                    break;
                }
                case 12: {
                    remoteDependencyNotification.setUserJobName(resultSet.getString("user_job_name"));
                    break;
                }
                case 13: {
                    remoteDependencyNotification.setRemoteDependencyID(resultSet.getLong("remote_dependency_id"));
                    break;
                }
                case 14: {
                    remoteDependencyNotification.setJobSuiteID(resultSet.getLong("job_suite_id"));
                    break;
                }
                case 15: {
                    remoteDependencyNotification.setJobSuiteName(Convert.trimR((String)resultSet.getString("job_suite_name")));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Pass number argument exceeds maximum.");
                }
            }
        }
    }
}

