/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.Transform;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class XMLLayout
extends Layout {
    private boolean locationInfo = false;

    public XMLLayout() {
        this.ignoresThrowable = false;
    }

    public void setLocationInfo(boolean bl) {
        this.locationInfo = bl;
    }

    public boolean getLocationInfo() {
        return this.locationInfo;
    }

    public void activateOptions() {
    }

    public void format(Writer writer, LoggingEvent loggingEvent) throws IOException {
        Object object;
        writer.write("<log4j:event logger=\"");
        writer.write(loggingEvent.getLoggerName());
        writer.write("\" timestamp=\"");
        writer.write(Long.toString(loggingEvent.getTimeStamp()));
        writer.write("\" sequenceNumber=\"");
        writer.write(Long.toString(loggingEvent.getSequenceNumber()));
        writer.write("\" level=\"");
        writer.write(loggingEvent.getLevel().toString());
        writer.write("\" thread=\"");
        writer.write(loggingEvent.getThreadName());
        writer.write("\">\r\n");
        writer.write("<log4j:message><![CDATA[");
        String string = loggingEvent.getRenderedMessage();
        String string2 = XMLLayout.escapeBadCharacters(string);
        Transform.appendEscapingCDATA(writer, string2);
        writer.write("]]></log4j:message>\r\n");
        String string3 = loggingEvent.getNDC();
        if (string3 != null) {
            writer.write("<log4j:NDC><![CDATA[");
            writer.write(string3);
            writer.write("]]></log4j:NDC>\r\n");
        }
        if (!this.ignoresThrowable && (object = loggingEvent.getThrowableStrRep()) != null) {
            writer.write("<log4j:throwable><![CDATA[");
            for (int i = 0; i < ((Object)object).length; ++i) {
                writer.write((String)object[i]);
                writer.write("\r\n");
            }
            writer.write("]]></log4j:throwable>\r\n");
        }
        if (this.locationInfo) {
            object = loggingEvent.getLocationInformation();
            writer.write("<log4j:locationInfo class=\"");
            writer.write(((LocationInfo)object).getClassName());
            writer.write("\" method=\"");
            Transform.escapeTags(((LocationInfo)object).getMethodName(), writer);
            writer.write("\" file=\"");
            writer.write(((LocationInfo)object).getFileName());
            writer.write("\" line=\"");
            writer.write(((LocationInfo)object).getLineNumber());
            writer.write("\"/>\r\n");
        }
        if ((object = loggingEvent.getPropertyKeySet()) != null && object.size() > 0) {
            writer.write("<log4j:properties>\r\n");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string4 = iterator.next().toString();
                writer.write("    <log4j:data name=\"" + string4);
                String string5 = loggingEvent.getProperty(string4).toString();
                writer.write("\" value=\"" + string5);
                writer.write("\"/>\r\n");
            }
            writer.write("</log4j:properties>\r\n");
        }
        writer.write("</log4j:event>\r\n\r\n");
    }

    public static String escapeBadCharacters(String string) {
        if (string == null) {
            return string;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = stringBuffer.length() - 1; i > -1; --i) {
            char c = stringBuffer.charAt(i);
            if (c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c == '\t' || c == '\n' || c == '\r') continue;
            stringBuffer.insert(i + 1, "]");
            stringBuffer.replace(i, i + 1, Integer.toHexString(c));
            stringBuffer.insert(i, "[0x");
            bl = true;
        }
        if (!bl) {
            return string;
        }
        return stringBuffer.toString();
    }
}

