/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class TimestampEqualsRule
extends AbstractRule {
    private static final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private long timeStamp;

    private TimestampEqualsRule(String string) {
        try {
            this.timeStamp = dateFormat.parse(string).getTime();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Could not parse date: " + string);
        }
    }

    public static Rule getRule(String string) {
        return new TimestampEqualsRule(string);
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        long l = Long.parseLong(resolver.getValue("TIMESTAMP", loggingEvent).toString()) / 1000L * 1000L;
        return l == this.timeStamp;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.timeStamp = objectInputStream.readLong();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.timeStamp);
    }
}

