/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.InFixToPostFix;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.rule.RuleFactory;
import org.apache.log4j.spi.LoggingEvent;

public class ExpressionRule
extends AbstractRule {
    private static final InFixToPostFix convertor = new InFixToPostFix();
    private static final PostFixExpressionCompiler compiler = new PostFixExpressionCompiler();
    private final Rule rule;

    private ExpressionRule(Rule rule) {
        this.rule = rule;
    }

    public static Rule getRule(String string) {
        return ExpressionRule.getRule(string, false);
    }

    public static Rule getRule(String string, boolean bl) {
        if (!bl) {
            string = convertor.convert(string);
        }
        return new ExpressionRule(compiler.compileExpression(string));
    }

    public boolean evaluate(LoggingEvent loggingEvent) {
        return this.rule.evaluate(loggingEvent);
    }

    public String toString() {
        return this.rule.toString();
    }

    static class PostFixExpressionCompiler {
        PostFixExpressionCompiler() {
        }

        Rule compileExpression(String string) {
            String string2;
            RuleFactory ruleFactory = RuleFactory.getInstance();
            Stack<Object> stack = new Stack<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                boolean bl;
                string2 = stringTokenizer.nextToken();
                if (string2.startsWith("'") && string2.endsWith("'") && string2.length() > 2) {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                if (string2.startsWith("'") && string2.endsWith("'") && string2.length() == 2) {
                    string2 = "";
                }
                if (bl = string2.startsWith("'")) {
                    string2 = string2.substring(1);
                    while (bl && stringTokenizer.hasMoreTokens()) {
                        bl = !(string2 = string2 + " " + stringTokenizer.nextToken()).endsWith("'");
                    }
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (ruleFactory.isRule(string2)) {
                    Rule rule = ruleFactory.getRule(string2, stack);
                    stack.push(rule);
                    continue;
                }
                stack.push(string2);
            }
            if (stack.size() == 1 && !(stack.peek() instanceof Rule)) {
                string2 = stack.pop();
                stack.push("MSG");
                stack.push(string2);
                return ruleFactory.getRule("~=", stack);
            }
            if (stack.size() != 1 || !(stack.peek() instanceof Rule)) {
                throw new IllegalArgumentException("invalid expression: " + string);
            }
            return (Rule)stack.pop();
        }
    }
}

