/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rolling;

import java.io.File;
import org.apache.log4j.Logger;
import org.apache.log4j.rolling.RollingPolicySkeleton;
import org.apache.log4j.rolling.RolloverFailure;
import org.apache.log4j.rolling.helpers.Compress;
import org.apache.log4j.rolling.helpers.FileNamePattern;
import org.apache.log4j.rolling.helpers.Util;

public class SlidingWindowRollingPolicy
extends RollingPolicySkeleton {
    static Logger logger = Logger.getLogger(class$org$apache$log4j$rolling$SlidingWindowRollingPolicy == null ? (class$org$apache$log4j$rolling$SlidingWindowRollingPolicy = SlidingWindowRollingPolicy.class$("org.apache.log4j.rolling.SlidingWindowRollingPolicy")) : class$org$apache$log4j$rolling$SlidingWindowRollingPolicy);
    int maxIndex = 7;
    int minIndex = 1;
    FileNamePattern fileNamePattern;
    String fileNamePatternStr;
    String activeFileName = null;
    static /* synthetic */ Class class$org$apache$log4j$rolling$SlidingWindowRollingPolicy;

    public void rollover() throws RolloverFailure {
        if (this.maxIndex >= 0) {
            File file = new File(this.fileNamePattern.convert(this.maxIndex));
            if (file.exists()) {
                file.delete();
            }
            for (int i = this.maxIndex - 1; i >= this.minIndex; --i) {
                Util.rename(this.fileNamePattern.convert(i), this.fileNamePattern.convert(i + 1));
            }
            if (this.activeFileName != null) {
                switch (this.compressionMode) {
                    case 0: {
                        Util.rename(this.activeFileName, this.fileNamePattern.convert(this.minIndex));
                        break;
                    }
                    case 1: {
                        Compress.GZCompress(this.activeFileName, this.fileNamePattern.convert(this.minIndex));
                    }
                }
            }
        }
    }

    public void activateOptions() {
        if (this.activeFileName == null) {
            logger.warn("The active file name option must be set before using this rolling policy.");
            throw new IllegalStateException("The activeFileName option must be set.");
        }
        if (this.maxIndex < this.minIndex) {
            logger.warn("maxIndex (" + this.maxIndex + ") cannot be smaller than minIndex (" + this.minIndex + ").");
            logger.warn("Setting maxIndex to equal minIndex.");
            this.maxIndex = this.minIndex;
        }
        switch (this.compressionMode) {
            case 1: {
                if (this.fileNamePatternStr.endsWith(".gz")) break;
                this.fileNamePatternStr = this.fileNamePatternStr + ".gz";
            }
        }
        this.fileNamePattern = new FileNamePattern(this.fileNamePatternStr);
    }

    public String getActiveLogFileName() {
        return this.activeFileName;
    }

    public String getFileNamePattern() {
        return this.fileNamePatternStr;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public int getMinIndex() {
        return this.minIndex;
    }

    public void setFileNamePattern(String fnp) {
        this.fileNamePatternStr = fnp;
    }

    public void setMaxIndex(int maxIndex) {
        this.maxIndex = maxIndex;
    }

    public void setMinIndex(int minIndex) {
        this.minIndex = minIndex;
    }

    public String getActiveFileName() {
        return this.activeFileName;
    }

    public void setActiveFileName(String afn) {
        this.activeFileName = afn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

