/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import org.apache.joran.ErrorItem;
import org.apache.joran.ExecutionContext;
import org.apache.joran.action.Action;
import org.apache.joran.helper.Option;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.xml.sax.Attributes;

public class ConversionRuleAction
extends Action {
    static final Logger logger = Logger.getLogger(class$org$apache$log4j$joran$action$ConversionRuleAction == null ? (class$org$apache$log4j$joran$action$ConversionRuleAction = ConversionRuleAction.class$("org.apache.log4j.joran.action.ConversionRuleAction")) : class$org$apache$log4j$joran$action$ConversionRuleAction);
    Layout layout;
    boolean inError = false;
    static /* synthetic */ Class class$org$apache$log4j$joran$action$ConversionRuleAction;

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        this.inError = false;
        String conversionWord = attributes.getValue("conversionWord");
        String converterClass = attributes.getValue("converterClass");
        if (Option.isEmpty(conversionWord)) {
            this.inError = true;
            String errorMsg = "No 'conversionWord' attribute in <conversionRule>";
            logger.warn(errorMsg);
            ec.addError(new ErrorItem(errorMsg));
            return;
        }
        if (Option.isEmpty(converterClass)) {
            this.inError = true;
            String errorMsg = "No 'converterClass' attribute in <conversionRule>";
            logger.warn(errorMsg);
            ec.addError(new ErrorItem(errorMsg));
            return;
        }
        try {
            logger.debug("About to add conversion rule [" + conversionWord + ", " + converterClass + "] to layout");
            Object o = ec.peekObject();
            if (o instanceof PatternLayout) {
                PatternLayout patternLayout = (PatternLayout)o;
                patternLayout.addConversionRule(conversionWord, converterClass);
            }
        }
        catch (Exception oops) {
            this.inError = true;
            String errorMsg = "Could not add conversion rule to PatternLayout.";
            logger.error(errorMsg, oops);
            ec.addError(new ErrorItem(errorMsg));
        }
    }

    public void end(ExecutionContext ec, String n) {
    }

    public void finish(ExecutionContext ec) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

