/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.util.HashMap;
import org.apache.joran.ErrorItem;
import org.apache.joran.ExecutionContext;
import org.apache.joran.action.Action;
import org.apache.joran.helper.Option;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.AppenderAttachable;
import org.xml.sax.Attributes;

public class AppenderRefAction
extends Action {
    boolean inError = false;

    public void begin(ExecutionContext ec, String tagName, Attributes attributes) {
        this.inError = false;
        Object o = ec.peekObject();
        if (!(o instanceof AppenderAttachable)) {
            String errMsg = "Could not find an AppenderAttachable at the top of execution stack. Near <" + tagName + "> line " + this.getLineNumber(ec);
            LogLog.warn(errMsg);
            this.inError = true;
            ec.addError(new ErrorItem(errMsg));
            return;
        }
        AppenderAttachable appenderAttachable = (AppenderAttachable)o;
        String appenderName = attributes.getValue("ref");
        if (Option.isEmpty(appenderName)) {
            String errMsg = "Missing appender ref attribute in <appender-ref> tag.";
            LogLog.warn(errMsg);
            this.inError = true;
            ec.addError(new ErrorItem(errMsg));
            return;
        }
        HashMap appenderBag = (HashMap)ec.getObjectMap().get("APPENDER_BAG");
        Appender appender = (Appender)appenderBag.get(appenderName);
        if (appender == null) {
            LogLog.warn("Could not find an appender named [" + appenderName + "]");
            this.inError = true;
            ec.addError(new ErrorItem("Could not find an appender named [" + appenderName + "]"));
            return;
        }
        if (appenderAttachable instanceof Logger) {
            LogLog.debug("Attaching appender named [" + appenderName + "] to logger named [" + ((Logger)appenderAttachable).getName() + "].");
        } else {
            LogLog.debug("Attaching appender named [" + appenderName + "] to " + appenderAttachable);
        }
        appenderAttachable.addAppender(appender);
    }

    public void end(ExecutionContext ec, String n) {
    }

    public void finish(ExecutionContext ec) {
    }
}

