/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.util.HashMap;
import org.apache.joran.ErrorItem;
import org.apache.joran.ExecutionContext;
import org.apache.joran.action.Action;
import org.apache.joran.helper.Option;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.OptionHandler;
import org.xml.sax.Attributes;

public class AppenderAction
extends Action {
    static final Logger logger = Logger.getLogger(class$org$apache$log4j$joran$action$AppenderAction == null ? (class$org$apache$log4j$joran$action$AppenderAction = AppenderAction.class$("org.apache.log4j.joran.action.AppenderAction")) : class$org$apache$log4j$joran$action$AppenderAction);
    Appender appender;
    private boolean inError = false;
    static /* synthetic */ Class class$org$apache$log4j$joran$action$AppenderAction;
    static /* synthetic */ Class class$org$apache$log4j$Appender;

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        String className = attributes.getValue("class");
        try {
            logger.debug("About to instantiate appender of type [" + className + "]");
            Object instance = OptionConverter.instantiateByClassName(className, class$org$apache$log4j$Appender == null ? (class$org$apache$log4j$Appender = AppenderAction.class$("org.apache.log4j.Appender")) : class$org$apache$log4j$Appender, null);
            this.appender = (Appender)instance;
            String appenderName = attributes.getValue("name");
            if (Option.isEmpty(appenderName)) {
                logger.warn("No appender name given for appender of type " + className + "].");
            } else {
                this.appender.setName(appenderName);
                logger.debug("Appender named as [" + appenderName + "]");
            }
            HashMap appenderBag = (HashMap)ec.getObjectMap().get("APPENDER_BAG");
            appenderBag.put(appenderName, this.appender);
            logger.debug("Pushing appender on to the object stack.");
            ec.pushObject(this.appender);
        }
        catch (Exception oops) {
            this.inError = true;
            logger.error("Could not create an Appender. Reported error follows.", oops);
            ec.addError(new ErrorItem("Could not create appender of type " + className + "]."));
        }
    }

    public void end(ExecutionContext ec, String name) {
        Object o;
        if (this.inError) {
            return;
        }
        if (this.appender instanceof OptionHandler) {
            ((OptionHandler)((Object)this.appender)).activateOptions();
        }
        if ((o = ec.peekObject()) != this.appender) {
            logger.warn("The object at the of the stack is not the appender named [" + this.appender.getName() + "] pushed earlier.");
        } else {
            logger.warn("Popping appender named [" + this.appender.getName() + "] from the object stack");
            ec.popObject();
        }
    }

    public void finish(ExecutionContext ec) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

