/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.joran.ErrorItem;
import org.apache.joran.ExecutionContext;
import org.apache.joran.Interpreter;
import org.apache.joran.Pattern;
import org.apache.joran.action.NestComponentIA;
import org.apache.joran.action.NewRuleAction;
import org.apache.joran.action.ParamAction;
import org.apache.joran.helper.SimpleRuleStore;
import org.apache.log4j.Logger;
import org.apache.log4j.joran.action.AppenderAction;
import org.apache.log4j.joran.action.AppenderRefAction;
import org.apache.log4j.joran.action.ConfigurationAction;
import org.apache.log4j.joran.action.ConversionRuleAction;
import org.apache.log4j.joran.action.LayoutAction;
import org.apache.log4j.joran.action.LevelAction;
import org.apache.log4j.joran.action.LoggerAction;
import org.apache.log4j.joran.action.PluginAction;
import org.apache.log4j.joran.action.PriorityAction;
import org.apache.log4j.joran.action.RepositoryPropertyAction;
import org.apache.log4j.joran.action.RootLoggerAction;
import org.apache.log4j.joran.action.SubstitutionPropertyAction;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JoranConfigurator
implements Configurator {
    Interpreter joranInterpreter;
    LoggerRepository repository;
    private Logger logger;
    static /* synthetic */ Class class$org$apache$log4j$joran$JoranConfigurator;

    public JoranConfigurator() {
        this.selfInitialize();
    }

    public void doConfigure(URL url, LoggerRepository repository) {
        this.repository = repository;
        ExecutionContext ec = this.joranInterpreter.getExecutionContext();
        try {
            InputStream in = url.openStream();
            this.doConfigure(in, repository);
            in.close();
        }
        catch (IOException ioe) {
            String errMsg = "Could not open [" + url + "].";
            this.getLogger().error(errMsg, ioe);
            ec.addError(new ErrorItem(errMsg, ioe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doConfigure(String filename, LoggerRepository repository) {
        this.repository = repository;
        FileInputStream fis = null;
        ExecutionContext ec = this.joranInterpreter.getExecutionContext();
        this.getLogger().info("in JoranConfigurator doConfigure " + filename);
        fis = new FileInputStream(filename);
        this.doConfigure(fis, repository);
        Object var8_5 = null;
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (IOException e) {
            this.getLogger().error("Could not close [" + filename + "].", e);
        }
        return;
        {
            catch (IOException ioe) {
                String errMsg = "Could not open [" + filename + "].";
                this.getLogger().error(errMsg, ioe);
                ec.addError(new ErrorItem(errMsg, ioe));
                Object var8_6 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException e) {
                    this.getLogger().error("Could not close [" + filename + "].", e);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e) {
                this.getLogger().error("Could not close [" + filename + "].", e);
            }
            throw throwable;
        }
    }

    public void doConfigure(InputStream in, LoggerRepository repository) {
        this.doConfigure(new InputSource(in), repository);
    }

    public void doConfigure(InputSource inputSource, LoggerRepository repository) {
        this.repository = repository;
        ExecutionContext ec = this.joranInterpreter.getExecutionContext();
        ec.pushObject(repository);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            inputSource.setSystemId("dummy://log4j.dtd");
            saxParser.parse(inputSource, (DefaultHandler)this.joranInterpreter);
        }
        catch (SAXException e) {
        }
        catch (ParserConfigurationException pce) {
            String errMsg = "Parser configuration error occured";
            this.getLogger().error(errMsg, pce);
            ec.addError(new ErrorItem(errMsg, pce));
        }
        catch (IOException ie) {
            String errMsg = "I/O error occured while parsing xml file";
            ec.addError(new ErrorItem("Parser configuration error occured", ie));
        }
    }

    protected void selfInitialize() {
        SimpleRuleStore rs = new SimpleRuleStore();
        rs.addRule(new Pattern("log4j:configuration"), new ConfigurationAction());
        rs.addRule(new Pattern("log4j:configuration/substitutionProperty"), new SubstitutionPropertyAction());
        rs.addRule(new Pattern("log4j:configuration/repositoryProperty"), new RepositoryPropertyAction());
        rs.addRule(new Pattern("log4j:configuration/plugin"), new PluginAction());
        rs.addRule(new Pattern("log4j:configuration/logger"), new LoggerAction());
        rs.addRule(new Pattern("log4j:configuration/logger/level"), new LevelAction());
        rs.addRule(new Pattern("log4j:configuration/logger/priority"), new PriorityAction());
        rs.addRule(new Pattern("log4j:configuration/root"), new RootLoggerAction());
        rs.addRule(new Pattern("log4j:configuration/root/level"), new LevelAction());
        rs.addRule(new Pattern("log4j:configuration/root/priority"), new PriorityAction());
        rs.addRule(new Pattern("log4j:configuration/logger/appender-ref"), new AppenderRefAction());
        rs.addRule(new Pattern("log4j:configuration/root/appender-ref"), new AppenderRefAction());
        rs.addRule(new Pattern("log4j:configuration/appender"), new AppenderAction());
        rs.addRule(new Pattern("log4j:configuration/appender/layout"), new LayoutAction());
        rs.addRule(new Pattern("log4j:configuration/appender/layout/conversionRule"), new ConversionRuleAction());
        rs.addRule(new Pattern("log4j:configuration/newRule"), new NewRuleAction());
        rs.addRule(new Pattern("*/param"), new ParamAction());
        this.joranInterpreter = new Interpreter(rs);
        this.joranInterpreter.setEntityResolver(new Log4jEntityResolver());
        this.joranInterpreter.addImplcitAction(new NestComponentIA());
        ExecutionContext ec = this.joranInterpreter.getExecutionContext();
        HashMap omap = ec.getObjectMap();
        omap.put("APPENDER_BAG", new HashMap());
    }

    public ExecutionContext getExecutionContext() {
        return this.joranInterpreter.getExecutionContext();
    }

    public void logErrors() {
        List errorList = this.getExecutionContext().getErrorList();
        if (errorList.size() == 0) {
            return;
        }
        this.getLogger().warn("Errors occured while parsing the XML configuration file");
        for (int i = 0; i < errorList.size(); ++i) {
            this.getLogger().warn("" + errorList.get(i));
        }
    }

    Logger getLogger() {
        if (this.logger == null) {
            this.logger = this.repository.getLogger((class$org$apache$log4j$joran$JoranConfigurator == null ? (class$org$apache$log4j$joran$JoranConfigurator = JoranConfigurator.class$("org.apache.log4j.joran.JoranConfigurator")) : class$org$apache$log4j$joran$JoranConfigurator).getName());
        }
        return this.logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

