/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;

public class IntializationUtil {
    public static void log4jInternalConfiguration(LoggerRepository repository) {
        Logger logger = repository.getLogger("LOG4J");
        logger.setAdditivity(false);
        logger.addAppender(new ConsoleAppender(new PatternLayout("log4j-internal: %r %-22c{2} - %m%n")));
    }

    public static void initialConfiguration(LoggerRepository repository, String configuratonResourceStr, String configuratorClassNameStr) {
        if (configuratonResourceStr == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(configuratonResourceStr);
        }
        catch (MalformedURLException ex) {
            url = Loader.getResource(configuratonResourceStr);
        }
        if (url != null) {
            LogLog.info("Using URL [" + url + "] for automatic log4j configuration of repository named [" + repository.getName() + "].");
            OptionConverter.selectAndConfigure(url, configuratorClassNameStr, repository);
        } else {
            LogLog.debug("Could not find resources to perform automatic configuration.");
        }
    }
}

