/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.prefs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.EventListener;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.EventListenerList;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.Profileable;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;

public final class SettingsManager {
    private static final SettingsManager instance = new SettingsManager();
    private static final String GLOBAL_SETTINGS_FILE_NAME = "chainsaw.settings.properties";
    private static final String HEADER = "Chainsaws Settings Files";
    private EventListenerList listenerList = new EventListenerList();
    private Properties defaultProperties = new Properties();
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$prefs$SettingsListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SettingsManager() {
        InputStream inputStream = null;
        inputStream = this.getClass().getClassLoader().getResource("org/apache/log4j/chainsaw/prefs/default.properties").openStream();
        this.defaultProperties.load(inputStream);
        inputStream.close();
        Object var4_2 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var4_3 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (Exception exception) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static final SettingsManager getInstance() {
        return instance;
    }

    public void addSettingsListener(SettingsListener settingsListener) {
        this.listenerList.add(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener, settingsListener);
    }

    public void loadSettings() {
        File file = this.getSettingsDirectory();
        if (!file.exists()) {
            file.mkdir();
        }
        this.loadGlobalSettings();
        this.loadProfileableSettings();
    }

    private void loadProfileableSettings() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            SettingsListener settingsListener = (SettingsListener)eventListenerArray[i];
            if (!(settingsListener instanceof Profileable)) continue;
            Profileable profileable = (Profileable)settingsListener;
            this.loadProfileble(profileable);
        }
    }

    private void loadProfileble(Profileable profileable) {
        LoadSettingsEvent loadSettingsEvent = this.createProfilebleEvent(profileable);
        profileable.loadSettings(loadSettingsEvent);
    }

    private LoadSettingsEvent createProfilebleEvent(Profileable profileable) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.getDefaultSettings());
        properties.putAll((Map<?, ?>)this.loadProperties(profileable));
        LoadSettingsEvent loadSettingsEvent = new LoadSettingsEvent(this, properties);
        return loadSettingsEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadProperties(Profileable profileable) {
        Properties properties = new Properties(this.defaultProperties);
        BufferedInputStream bufferedInputStream = null;
        File file = new File(this.getSettingsDirectory(), URLEncoder.encode(profileable.getNamespace() + ".properties"));
        if (!file.exists()) {
            file = new File(this.getSettingsDirectory(), profileable.getNamespace() + ".properties");
        }
        if (!file.exists()) return properties;
        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Properties properties2 = new Properties();
        properties2.load(bufferedInputStream);
        properties.putAll((Map<?, ?>)properties2);
        Object var7_7 = null;
        if (bufferedInputStream == null) return properties;
        try {
            ((InputStream)bufferedInputStream).close();
            return properties;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
        {
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var7_8 = null;
                if (bufferedInputStream == null) return properties;
                try {
                    ((InputStream)bufferedInputStream).close();
                    return properties;
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                return properties;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    private void loadGlobalSettings() {
        EventListener[] eventListenerArray = this.listenerList.getListeners(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener);
        LoadSettingsEvent loadSettingsEvent = null;
        for (int i = 0; i < eventListenerArray.length; ++i) {
            SettingsListener settingsListener = (SettingsListener)eventListenerArray[i];
            if (loadSettingsEvent == null) {
                Properties properties = this.loadGlobalProperties();
                loadSettingsEvent = new LoadSettingsEvent(this, properties);
            }
            settingsListener.loadSettings(loadSettingsEvent);
        }
    }

    public void saveSettings() {
        File file = this.getSettingsDirectory();
        if (!file.exists()) {
            file.mkdir();
        }
        this.saveGlobalSettings(file);
        this.saveProfileableSetting(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void saveProfileableSetting(File file) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener);
        SaveSettingsEvent saveSettingsEvent = null;
        for (int i = 0; i < eventListenerArray.length; ++i) {
            SettingsListener settingsListener = (SettingsListener)eventListenerArray[i];
            if (!(settingsListener instanceof Profileable)) continue;
            Profileable profileable = (Profileable)settingsListener;
            saveSettingsEvent = new SaveSettingsEvent(this, this.getSettingsDirectory());
            profileable.saveSettings(saveSettingsEvent);
            OutputStream outputStream = null;
            outputStream = new BufferedOutputStream(new FileOutputStream(new File(file, URLEncoder.encode(profileable.getNamespace()) + ".properties")));
            saveSettingsEvent.getProperties().store(outputStream, HEADER);
            Object var10_9 = null;
            if (outputStream == null) continue;
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            continue;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    var10_9 = null;
                    if (outputStream == null) continue;
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var10_9 = null;
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveGlobalSettings(File file) {
        EventListener[] eventListenerArray = this.listenerList.getListeners(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener);
        SaveSettingsEvent saveSettingsEvent = null;
        for (int i = 0; i < eventListenerArray.length; ++i) {
            SettingsListener settingsListener = (SettingsListener)eventListenerArray[i];
            if (settingsListener instanceof Profileable) continue;
            if (saveSettingsEvent == null) {
                saveSettingsEvent = new SaveSettingsEvent(this, this.getSettingsDirectory());
            }
            settingsListener.saveSettings(saveSettingsEvent);
        }
        OutputStream outputStream = null;
        outputStream = new BufferedOutputStream(new FileOutputStream(new File(file, GLOBAL_SETTINGS_FILE_NAME)));
        saveSettingsEvent.getProperties().store(outputStream, HEADER);
        Object var7_8 = null;
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return;
        {
            catch (Exception exception) {
                exception.printStackTrace();
                Object var7_9 = null;
                if (outputStream == null) return;
                try {
                    outputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (outputStream == null) throw throwable;
            try {
                outputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    public File getSettingsDirectory() {
        return new File(System.getProperty("user.home"), ".chainsaw");
    }

    public void configure(SettingsListener settingsListener) {
        if (settingsListener instanceof Profileable) {
            this.loadProfileble((Profileable)settingsListener);
        } else {
            Properties properties = this.loadGlobalProperties();
            LoadSettingsEvent loadSettingsEvent = new LoadSettingsEvent(this, properties);
            settingsListener.loadSettings(loadSettingsEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties loadGlobalProperties() {
        Properties properties = new Properties(this.defaultProperties);
        BufferedInputStream bufferedInputStream = null;
        File file = new File(this.getSettingsDirectory(), GLOBAL_SETTINGS_FILE_NAME);
        if (!file.exists()) return properties;
        bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        Properties properties2 = new Properties();
        properties2.load(bufferedInputStream);
        properties.putAll((Map<?, ?>)properties2);
        Object var6_6 = null;
        if (bufferedInputStream == null) return properties;
        try {
            ((InputStream)bufferedInputStream).close();
            return properties;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
        {
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var6_7 = null;
                if (bufferedInputStream == null) return properties;
                try {
                    ((InputStream)bufferedInputStream).close();
                    return properties;
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                return properties;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (bufferedInputStream == null) throw throwable;
            try {
                ((InputStream)bufferedInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    public Properties getDefaultSettings() {
        return this.defaultProperties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

