/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.apache.log4j.Level;

final class ThresholdSlider
extends JSlider {
    final List priorityList;

    ThresholdSlider() {
        Level[] levelArray = new Level[]{Level.OFF, Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.ALL};
        this.priorityList = Arrays.asList(levelArray);
        Collections.sort(this.priorityList, new Comparator(){

            public int compare(Object object, Object object2) {
                Level level = (Level)object;
                Level level2 = (Level)object2;
                if (level.toInt() == level2.toInt()) {
                    return 0;
                }
                if (level.toInt() < level2.toInt()) {
                    return -1;
                }
                return 1;
            }
        });
        this.setModel(new DefaultBoundedRangeModel(this.priorityList.indexOf(Level.DEBUG), 0, 0, this.priorityList.size() - 1));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        Iterator iterator = this.priorityList.iterator();
        while (iterator.hasNext()) {
            Level level = (Level)iterator.next();
            hashtable.put(new Integer(this.priorityList.indexOf(level)), new JLabel(level.toString()));
        }
        this.setOrientation(1);
        this.setInverted(true);
        this.setLabelTable(hashtable);
        this.setPaintLabels(true);
        this.setSnapToTicks(true);
    }

    void setChosenLevel(Level level) {
        this.setValue(this.priorityList.indexOf(level));
    }

    Level getSelectedLevel() {
        Level level = (Level)this.priorityList.get(this.getValue());
        if (level == null) {
            level = Level.DEBUG;
        }
        return level;
    }
}

