/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.PortBased;

class NoReceiversWarningPanel
extends JPanel {
    private final JComboBox previousConfigs = new JComboBox();
    private final JRadioButton simpleReceiver = new JRadioButton("Let me use a simple Receiver:");
    private final JRadioButton justLoadingFile = new JRadioButton("I'm fine thanks, don't worry");
    private final JRadioButton searchOption = new JRadioButton("Let me search for a configuration file");
    private final JRadioButton manualOption = new JRadioButton("Let me define Receivers manually");
    private final JButton okButton = new JButton("Ok");
    private final PanelModel model = new PanelModel();
    final DefaultComboBoxModel configModel = new DefaultComboBoxModel();
    final DefaultComboBoxModel simpleReceiverModel = new DefaultComboBoxModel();
    final DefaultComboBoxModel simplePortModel = new DefaultComboBoxModel();
    private boolean dontWarnMeAgain = false;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketReceiver;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketHubReceiver;

    NoReceiversWarningPanel() {
        this.initComponents();
    }

    PanelModel getModel() {
        return this.model;
    }

    void setOkActionListener(ActionListener actionListener) {
        this.okButton.addActionListener(actionListener);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JTextArea jTextArea = new JTextArea("You will not be able to receive events from a Remote source unless you define one in the Log4J configuration file.\n");
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setFont(this.getFont());
        this.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 2;
        this.add(Box.createVerticalStrut(20), gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1, 3, 3));
        jPanel.setBackground(this.getBackground());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        final ButtonGroup buttonGroup = new ButtonGroup();
        this.simpleReceiver.setToolTipText("Creates one of the standard Receivers on one of the standard port");
        this.simpleReceiver.setMnemonic('p');
        this.searchOption.setToolTipText("Allows you to choose a Log4J Configuration file that contains Receiver definitions");
        this.searchOption.setMnemonic('S');
        this.manualOption.setToolTipText("Opens the Receivers panel so you can define them via a GUI");
        this.manualOption.setMnemonic('m');
        this.justLoadingFile.setToolTipText("Use this if you just want to view a Log4J Log file stored somewhere");
        this.justLoadingFile.setMnemonic('I');
        this.manualOption.setOpaque(false);
        this.justLoadingFile.setOpaque(false);
        buttonGroup.add(this.searchOption);
        buttonGroup.add(this.manualOption);
        buttonGroup.add(this.justLoadingFile);
        buttonGroup.add(this.simpleReceiver);
        gridBagConstraints.gridy = 3;
        this.configModel.removeAllElements();
        this.previousConfigs.setModel(this.configModel);
        this.previousConfigs.setOpaque(false);
        this.previousConfigs.setBackground(this.getBackground());
        this.previousConfigs.setToolTipText("Previously loaded configurations can be chosen here");
        this.previousConfigs.setEditable(true);
        this.previousConfigs.getModel().addListDataListener(new ListDataListener(){

            private void validateUrl() {
                NoReceiversWarningPanel.this.okButton.setEnabled(NoReceiversWarningPanel.this.isValidConfigURL());
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                this.validateUrl();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                this.validateUrl();
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                this.validateUrl();
            }
        });
        this.previousConfigs.setMaximumSize(new Dimension(200, (int)this.previousConfigs.getPreferredSize().getHeight()));
        this.previousConfigs.setPreferredSize(this.previousConfigs.getMaximumSize());
        this.previousConfigs.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                this.selectAll();
            }

            private void selectAll() {
                NoReceiversWarningPanel.this.previousConfigs.getEditor().selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        final JButton jButton = new JButton(new AbstractAction("Browse..."){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = NoReceiversWarningPanel.this.browseForConfig();
                    if (uRL != null) {
                        NoReceiversWarningPanel.this.getModel().configUrl = uRL;
                        NoReceiversWarningPanel.this.configModel.addElement(uRL);
                        NoReceiversWarningPanel.this.previousConfigs.getModel().setSelectedItem(uRL);
                    }
                }
                catch (Exception exception) {
                    LogLog.error("Error browswing for Configuration file", exception);
                }
            }
        });
        jButton.setToolTipText("Shows a File Open dialog to allow you to find a configuration file");
        this.simplePortModel.addElement(new PortBased(){

            private void unsupported() {
                throw new UnsupportedOperationException("Should not be used in this context");
            }

            public String getName() {
                this.unsupported();
                return null;
            }

            public boolean isActive() {
                this.unsupported();
                return false;
            }

            public int getPort() {
                return 4445;
            }

            public String toString() {
                return this.getPort() + " (Old style/standard Chainsaw port)";
            }
        });
        this.simplePortModel.addElement(new PortBased(){

            private void unsupported() {
                throw new UnsupportedOperationException("Should not be used in this context");
            }

            public String getName() {
                this.unsupported();
                return null;
            }

            public boolean isActive() {
                this.unsupported();
                return false;
            }

            public int getPort() {
                return 4560;
            }

            public String toString() {
                return this.getPort() + " (Default SocketAppender port)";
            }
        });
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel2.add((Component)this.simpleReceiver, gridBagConstraints2);
        final JComboBox jComboBox = new JComboBox(this.simplePortModel);
        this.simpleReceiverModel.addElement(class$org$apache$log4j$net$SocketReceiver == null ? (class$org$apache$log4j$net$SocketReceiver = NoReceiversWarningPanel.class$("org.apache.log4j.net.SocketReceiver")) : class$org$apache$log4j$net$SocketReceiver);
        this.simpleReceiverModel.addElement(class$org$apache$log4j$net$SocketHubReceiver == null ? (class$org$apache$log4j$net$SocketHubReceiver = NoReceiversWarningPanel.class$("org.apache.log4j.net.SocketHubReceiver")) : class$org$apache$log4j$net$SocketHubReceiver);
        final JComboBox<Object> jComboBox2 = new JComboBox<Object>(this.simpleReceiverModel);
        jComboBox2.setEditable(false);
        jComboBox2.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof Class) {
                    Class clazz = (Class)object;
                    JLabel jLabel = (JLabel)component;
                    String string = clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
                    jLabel.setText(string);
                }
                return component;
            }
        });
        jPanel2.add(jComboBox2);
        jPanel2.add(new JLabel(" on port "));
        jPanel2.add(jComboBox, gridBagConstraints2);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NoReceiversWarningPanel.this.previousConfigs.setEnabled(actionEvent.getSource() == NoReceiversWarningPanel.this.searchOption);
                jButton.setEnabled(actionEvent.getSource() == NoReceiversWarningPanel.this.searchOption);
                jComboBox.setEnabled(actionEvent.getSource() == NoReceiversWarningPanel.this.simpleReceiver);
                jComboBox2.setEnabled(actionEvent.getSource() == NoReceiversWarningPanel.this.simpleReceiver);
                if (buttonGroup.isSelected(NoReceiversWarningPanel.this.searchOption.getModel())) {
                    NoReceiversWarningPanel.this.okButton.setEnabled(NoReceiversWarningPanel.this.isValidConfigURL());
                } else {
                    NoReceiversWarningPanel.this.okButton.setEnabled(true);
                }
            }
        };
        this.searchOption.addActionListener(actionListener);
        this.manualOption.addActionListener(actionListener);
        this.justLoadingFile.addActionListener(actionListener);
        this.simpleReceiver.addActionListener(actionListener);
        this.justLoadingFile.doClick();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setOpaque(false);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.anchor = 17;
        jPanel3.add((Component)this.searchOption, gridBagConstraints3);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridx = 2;
        jPanel3.add(Box.createHorizontalStrut(5), gridBagConstraints3);
        gridBagConstraints3.gridx = 3;
        gridBagConstraints3.weightx = 0.0;
        jPanel3.add((Component)this.previousConfigs, gridBagConstraints3);
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.gridx = 4;
        jPanel3.add(Box.createHorizontalStrut(5), gridBagConstraints3);
        gridBagConstraints3.gridx = 5;
        jPanel3.add((Component)jButton, gridBagConstraints3);
        jPanel.add(this.justLoadingFile);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(this.manualOption);
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        this.add(Box.createVerticalStrut(20), gridBagConstraints);
        this.okButton.setMnemonic('O');
        final JCheckBox jCheckBox = new JCheckBox("Don't show me this again");
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jCheckBox);
        jPanel4.add(this.okButton);
        this.add((Component)jPanel4, gridBagConstraints);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NoReceiversWarningPanel.this.dontWarnMeAgain = jCheckBox.isSelected();
            }
        });
    }

    private URL browseForConfig() throws MalformedURLException {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Search for Log4j configuration...");
        jFileChooser.setDialogType(0);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".properties") || file.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "Log4j Configuration file";
            }
        });
        jFileChooser.showOpenDialog(this);
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        return jFileChooser.getSelectedFile().toURL();
    }

    private boolean isValidConfigURL() {
        if (this.previousConfigs.getSelectedItem() == null) {
            return false;
        }
        String string = this.previousConfigs.getSelectedItem().toString();
        try {
            this.getModel().configUrl = new URL(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new NoReceiversWarningPanel());
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.show();
    }

    public final boolean isDontWarnMeAgain() {
        return this.dontWarnMeAgain;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PanelModel {
        private URL configUrl;

        PanelModel() {
        }

        boolean isLoadLogFile() {
            return NoReceiversWarningPanel.this.justLoadingFile.isSelected();
        }

        boolean isSimpleReceiverMode() {
            return NoReceiversWarningPanel.this.simpleReceiver.isSelected();
        }

        int getSimplePort() {
            return ((PortBased)NoReceiversWarningPanel.this.simplePortModel.getSelectedItem()).getPort();
        }

        Class getSimpleReceiverClass() {
            return (Class)NoReceiversWarningPanel.this.simpleReceiverModel.getSelectedItem();
        }

        boolean isLoadConfig() {
            return NoReceiversWarningPanel.this.searchOption.isSelected();
        }

        boolean isManualMode() {
            return NoReceiversWarningPanel.this.manualOption.isSelected();
        }

        public Object[] getRememberedConfigs() {
            Object[] objectArray = new Object[NoReceiversWarningPanel.this.configModel.getSize()];
            for (int i = 0; i < NoReceiversWarningPanel.this.configModel.getSize(); ++i) {
                objectArray[i] = NoReceiversWarningPanel.this.configModel.getElementAt(i);
            }
            return objectArray;
        }

        public void setRememberedConfigs(Object[] objectArray) {
            SwingUtilities.invokeLater(new Runnable(this, objectArray){
                private final /* synthetic */ Object[] val$configs;
                private final /* synthetic */ PanelModel this$1;
                {
                    this.this$1 = panelModel;
                    this.val$configs = objectArray;
                }

                public void run() {
                    PanelModel.access$1000((PanelModel)this.this$1).configModel.removeAllElements();
                    for (int i = 0; i < this.val$configs.length; ++i) {
                        PanelModel.access$1000((PanelModel)this.this$1).configModel.addElement(this.val$configs[i]);
                    }
                }
            });
        }

        URL getConfigToLoad() {
            return this.configUrl;
        }

        static /* synthetic */ NoReceiversWarningPanel access$1000(PanelModel panelModel) {
            return panelModel.NoReceiversWarningPanel.this;
        }
    }
}

