/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.ApplicationPreferenceModelPanel;
import org.apache.log4j.chainsaw.ChainsawAbout;
import org.apache.log4j.chainsaw.ChainsawAppender;
import org.apache.log4j.chainsaw.ChainsawAppenderHandler;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.ChainsawEventBatchEntry;
import org.apache.log4j.chainsaw.ChainsawSplash;
import org.apache.log4j.chainsaw.ChainsawStatusBar;
import org.apache.log4j.chainsaw.ChainsawTabbedPane;
import org.apache.log4j.chainsaw.ChainsawToolBarAndMenus;
import org.apache.log4j.chainsaw.ChainsawViewer;
import org.apache.log4j.chainsaw.DockablePanel;
import org.apache.log4j.chainsaw.EventBatchListener;
import org.apache.log4j.chainsaw.EventCountListener;
import org.apache.log4j.chainsaw.LogPanel;
import org.apache.log4j.chainsaw.NoReceiversWarningPanel;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.ProgressPanel;
import org.apache.log4j.chainsaw.ShutdownListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.WelcomePanel;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.help.Tutorial;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.plugins.ChainsawCentral;
import org.apache.log4j.chainsaw.plugins.PluginClassLoaderFactory;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.chainsaw.receivers.ReceiversPanel;
import org.apache.log4j.chainsaw.version.VersionManager;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.joran.JoranConfigurator;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.plugins.PluginRegistry;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class LogUI
extends JFrame
implements ChainsawViewer,
SettingsListener {
    private static final String CONFIG_FILE_TO_USE = "config.file";
    private static final String MAIN_WINDOW_HEIGHT = "main.window.height";
    private static final String MAIN_WINDOW_WIDTH = "main.window.width";
    private static final String MAIN_WINDOW_Y = "main.window.y";
    private static final String MAIN_WINDOW_X = "main.window.x";
    private static ChainsawSplash splash;
    private static final double DEFAULT_MAIN_RECEIVER_SPLIT_LOCATION = 0.8;
    private final JFrame preferencesFrame = new JFrame();
    private URL configURLToUse;
    private boolean noReceiversDefined;
    private ReceiversPanel receiversPanel;
    private ChainsawTabbedPane tabbedPane;
    private JToolBar toolbar;
    private ChainsawStatusBar statusBar;
    private final ApplicationPreferenceModel applicationPreferenceModel = new ApplicationPreferenceModel();
    private final ApplicationPreferenceModelPanel applicationPreferenceModelPanel = new ApplicationPreferenceModelPanel(this.applicationPreferenceModel);
    private final Map tableModelMap = new HashMap();
    private final Map tableMap = new HashMap();
    private final List filterableColumns = new ArrayList();
    private final Map panelMap = new HashMap();
    ChainsawAppenderHandler handler;
    private ChainsawToolBarAndMenus tbms;
    private ChainsawAbout aboutBox;
    private final SettingsManager sm = SettingsManager.getInstance();
    private final JFrame tutorialFrame = new JFrame("Chainsaw Tutorial");
    private JSplitPane mainReceiverSplitPane;
    private double lastMainReceiverSplitLocation = 0.8;
    private final List identifierPanels = new ArrayList();
    private int dividerSize;
    private int cyclicBufferSize;
    private boolean isGUIFullyInitialized = false;
    private Object initializationLock = new Object();
    private Action shutdownAction = null;
    private EventListenerList shutdownListenerList = new EventListenerList();
    private WelcomePanel welcomePanel;
    private PluginRegistry pluginRegistry;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$ShutdownListener;
    static /* synthetic */ Class class$org$apache$log4j$plugins$Receiver;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$Generator;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketNodeEventListener;

    public LogUI() {
        super("Chainsaw v2 - Log Viewer");
        this.setDefaultCloseOperation(0);
        if (ChainsawIcons.WINDOW_ICON != null) {
            this.setIconImage(new ImageIcon(ChainsawIcons.WINDOW_ICON).getImage());
        }
    }

    private static final void showSplash(Frame frame) {
        splash = new ChainsawSplash(frame);
        SwingHelper.centerOnScreen(splash);
        splash.setVisible(true);
    }

    private static final void removeSplash() {
        if (splash != null) {
            splash.setVisible(false);
            splash.dispose();
        }
    }

    public void addShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownListenerList.add(class$org$apache$log4j$chainsaw$ShutdownListener == null ? (class$org$apache$log4j$chainsaw$ShutdownListener = LogUI.class$("org.apache.log4j.chainsaw.ShutdownListener")) : class$org$apache$log4j$chainsaw$ShutdownListener, shutdownListener);
    }

    public void removeShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownListenerList.remove(class$org$apache$log4j$chainsaw$ShutdownListener == null ? (class$org$apache$log4j$chainsaw$ShutdownListener = LogUI.class$("org.apache.log4j.chainsaw.ShutdownListener")) : class$org$apache$log4j$chainsaw$ShutdownListener, shutdownListener);
    }

    public static void main(String[] stringArray) {
        ApplicationPreferenceModel applicationPreferenceModel = new ApplicationPreferenceModel();
        SettingsManager.getInstance().configure(applicationPreferenceModel);
        LogUI.applyLookAndFeel(applicationPreferenceModel.getLookAndFeelClassName());
        LogUI.createChainsawGUI(applicationPreferenceModel, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createChainsawGUI(ApplicationPreferenceModel applicationPreferenceModel, Action action) {
        if (applicationPreferenceModel.isOkToRemoveSecurityManager()) {
            MessageCenter.getInstance().addMessage("User has authorised removal of Java Security Manager via preferences");
            System.setSecurityManager(null);
            Policy.setPolicy(new Policy(){

                public void refresh() {
                }

                public PermissionCollection getPermissions(CodeSource codeSource) {
                    Permissions permissions = new Permissions();
                    permissions.add(new AllPermission());
                    return permissions;
                }
            });
        }
        LogLog.info("SecurityManager is now: " + System.getSecurityManager());
        LogUI logUI = new LogUI();
        if (applicationPreferenceModel.isShowSplash()) {
            LogUI.showSplash(logUI);
        }
        logUI.cyclicBufferSize = applicationPreferenceModel.getCyclicBufferSize();
        ChainsawAppenderHandler chainsawAppenderHandler = logUI.handler = new ChainsawAppenderHandler();
        LogUI logUI2 = logUI;
        logUI2.getClass();
        chainsawAppenderHandler.addEventBatchListener(logUI2.new NewTabEventBatchReceiver());
        ClassLoader classLoader = PluginClassLoaderFactory.getInstance().getClassLoader();
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        String string = applicationPreferenceModel.getConfigurationURL();
        if (string != null && !string.trim().equals("")) {
            string = string.trim();
            LogLog.info("Using '" + string + "' for auto-configuration");
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                JoranConfigurator joranConfigurator = new JoranConfigurator();
                joranConfigurator.doConfigure(new URL(string), LogManager.getLoggerRepository());
                joranConfigurator.logErrors();
            }
            catch (MalformedURLException malformedURLException) {
                LogLog.error("Failed to use the auto-configuration file", malformedURLException);
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        } else {
            LogLog.info("No auto-configuration file found within the ApplicationPreferenceModel");
        }
        LogManager.getRootLogger().addAppender(logUI.handler);
        logUI.activateViewer();
        logUI.getApplicationPreferenceModel().apply(applicationPreferenceModel);
        logUI.checkForNewerVersion();
        if (action != null) {
            logUI.setShutdownAction(action);
        } else {
            logUI.setShutdownAction(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
        }
    }

    public void activateViewer(ChainsawAppender chainsawAppender) {
        ApplicationPreferenceModel applicationPreferenceModel = new ApplicationPreferenceModel();
        SettingsManager.getInstance().configure(applicationPreferenceModel);
        this.cyclicBufferSize = applicationPreferenceModel.getCyclicBufferSize();
        LogUI.applyLookAndFeel(applicationPreferenceModel.getLookAndFeelClassName());
        this.handler = new ChainsawAppenderHandler(chainsawAppender);
        this.handler.addEventBatchListener(new NewTabEventBatchReceiver());
        LogManager.getRootLogger().addAppender(chainsawAppender);
        this.setShutdownAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.activateViewer();
        this.getApplicationPreferenceModel().apply(applicationPreferenceModel);
    }

    private void initGUI() {
        this.setupHelpSystem();
        this.statusBar = new ChainsawStatusBar();
        this.setupReceiverPanel();
        this.setToolBarAndMenus(new ChainsawToolBarAndMenus(this));
        this.toolbar = this.getToolBarAndMenus().getToolbar();
        this.setJMenuBar(this.getToolBarAndMenus().getMenubar());
        this.setTabbedPane(new ChainsawTabbedPane());
        this.applicationPreferenceModelPanel.setOkCancelActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogUI.this.preferencesFrame.setVisible(false);
            }
        });
    }

    private void initPlugins(PluginRegistry pluginRegistry) {
        pluginRegistry.addPluginListener(new PluginListener(){

            public void pluginStarted(PluginEvent pluginEvent) {
                if (pluginEvent.getPlugin() instanceof JComponent) {
                    JComponent jComponent = (JComponent)((Object)pluginEvent.getPlugin());
                    LogUI.this.getTabbedPane().addANewTab(jComponent.getName(), jComponent, null, null);
                }
            }

            public void pluginStopped(PluginEvent pluginEvent) {
            }
        });
        ChainsawCentral chainsawCentral = new ChainsawCentral();
        pluginRegistry.addPlugin(chainsawCentral);
        chainsawCentral.activateOptions();
        try {
            Class<?> clazz = Class.forName("org.apache.log4j.chainsaw.vfs.VFSPlugin");
            Plugin plugin = (Plugin)clazz.newInstance();
            plugin.activateOptions();
            pluginRegistry.addPlugin(plugin);
            MessageCenter.getInstance().getLogger().info("Looks like VFS is available... WooHoo!");
        }
        catch (Throwable throwable) {
            MessageCenter.getInstance().getLogger().error("Doesn't look like VFS is available", throwable);
        }
    }

    private void setupReceiverPanel() {
        this.receiversPanel = new ReceiversPanel();
        this.receiversPanel.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MessageCenter.getInstance().getLogger().debug("Receiver's panel:" + propertyChangeEvent.getNewValue());
                LogUI.this.getApplicationPreferenceModel().setReceivers((Boolean)propertyChangeEvent.getNewValue());
            }
        });
    }

    private void setupHelpSystem() {
        this.welcomePanel = new WelcomePanel();
        JToolBar jToolBar = this.welcomePanel.getToolbar();
        jToolBar.add(new SmallButton(new AbstractAction("Tutorial", new ImageIcon(ChainsawIcons.HELP)){

            public void actionPerformed(ActionEvent actionEvent) {
                LogUI.this.setupTutorial();
            }
        }));
        jToolBar.addSeparator();
        AbstractAction abstractAction = new AbstractAction("View example Receiver configuration"){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpManager.getInstance().setHelpURL(ChainsawConstants.EXAMLE_CONFIG_URL);
            }
        };
        abstractAction.putValue("ShortDescription", "Displays an example Log4j configuration file with several Receivers defined.");
        SmallButton smallButton = new SmallButton(abstractAction);
        jToolBar.add(smallButton);
        jToolBar.add(Box.createHorizontalGlue());
        HelpManager.getInstance().addPropertyChangeListener("helpURL", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                URL uRL = (URL)propertyChangeEvent.getNewValue();
                if (uRL != null) {
                    LogUI.this.welcomePanel.setURL(uRL);
                    LogUI.this.ensureWelcomePanelVisible();
                }
            }
        });
    }

    private void ensureWelcomePanelVisible() {
        if (this.getTabbedPane().getSelectedComponent() != this.welcomePanel) {
            this.getTabbedPane().setSelectedIndex(this.getTabbedPane().indexOfComponent(this.welcomePanel));
        }
    }

    public void loadSettings(LoadSettingsEvent loadSettingsEvent) {
        this.setLocation(loadSettingsEvent.asInt(MAIN_WINDOW_X), loadSettingsEvent.asInt(MAIN_WINDOW_Y));
        this.setSize(loadSettingsEvent.asInt(MAIN_WINDOW_WIDTH), loadSettingsEvent.asInt(MAIN_WINDOW_HEIGHT));
        this.getToolBarAndMenus().stateChange();
    }

    public void saveSettings(SaveSettingsEvent saveSettingsEvent) {
        saveSettingsEvent.saveSetting(MAIN_WINDOW_X, (int)this.getLocation().getX());
        saveSettingsEvent.saveSetting(MAIN_WINDOW_Y, (int)this.getLocation().getY());
        saveSettingsEvent.saveSetting(MAIN_WINDOW_WIDTH, this.getWidth());
        saveSettingsEvent.saveSetting(MAIN_WINDOW_HEIGHT, this.getHeight());
        if (this.configURLToUse != null) {
            saveSettingsEvent.saveSetting(CONFIG_FILE_TO_USE, this.configURLToUse.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateViewer() {
        this.getSettingsManager().configure(new SettingsListener(){

            public void loadSettings(LoadSettingsEvent loadSettingsEvent) {
                String string = loadSettingsEvent.getSetting(LogUI.CONFIG_FILE_TO_USE);
                if (string != null && !string.trim().equals("") && System.getProperty("log4j.configuration") == null) {
                    try {
                        URL uRL = new URL(string);
                        OptionConverter.selectAndConfigure(uRL, null, LogManager.getLoggerRepository());
                        if (LogUI.this.getStatusBar() != null) {
                            MessageCenter.getInstance().getLogger().info("Configured Log4j using remembered URL :: " + uRL);
                        }
                        LogUI.this.configURLToUse = uRL;
                    }
                    catch (Exception exception) {
                        MessageCenter.getInstance().getLogger().error("error occurred initializing log4j", exception);
                    }
                }
            }

            public void saveSettings(SaveSettingsEvent saveSettingsEvent) {
            }
        });
        this.pluginRegistry = LogManager.getLoggerRepository().getPluginRegistry();
        this.initGUI();
        this.initPrefModelListeners();
        MessageCenter.getInstance().getLogger().addAppender(new AppenderSkeleton(){

            protected void append(LoggingEvent loggingEvent) {
                LogUI.this.getStatusBar().setMessage(loggingEvent.getMessage().toString());
            }

            public void close() {
            }

            public boolean requiresLayout() {
                return false;
            }
        });
        this.initSocketConnectionListener();
        if (this.pluginRegistry.getPlugins(class$org$apache$log4j$plugins$Receiver == null ? (class$org$apache$log4j$plugins$Receiver = LogUI.class$("org.apache.log4j.plugins.Receiver")) : class$org$apache$log4j$plugins$Receiver).size() == 0) {
            this.noReceiversDefined = true;
        }
        Level[] levelArray = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < levelArray.length; ++i) {
            arrayList.add(levelArray[i].toString());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Object object = arrayList2.iterator();
        while (object.hasNext()) {
            arrayList2.add(object.next().toString());
        }
        this.getFilterableColumns().add("Level");
        this.getFilterableColumns().add("Logger");
        this.getFilterableColumns().add("Thread");
        this.getFilterableColumns().add("NDC");
        this.getFilterableColumns().add("Properties");
        this.getFilterableColumns().add("Class");
        this.getFilterableColumns().add("Method");
        this.getFilterableColumns().add("File");
        this.getFilterableColumns().add("None");
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout(2, 2));
        this.getContentPane().setLayout(new BorderLayout());
        this.getTabbedPane().addChangeListener(this.getToolBarAndMenus());
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 2);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(37, 2);
        this.getTabbedPane().getInputMap(2).put(keyStroke, "MoveRight");
        this.getTabbedPane().getInputMap(2).put(keyStroke2, "MoveLeft");
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = LogUI.this.getTabbedPane().getSelectedIndex();
                if (++n != LogUI.this.getTabbedPane().getTabCount()) {
                    LogUI.this.getTabbedPane().setSelectedTab(n);
                }
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = LogUI.this.getTabbedPane().getSelectedIndex();
                if (--n > -1) {
                    LogUI.this.getTabbedPane().setSelectedTab(n);
                }
            }
        };
        this.getTabbedPane().getActionMap().put("MoveRight", abstractAction);
        this.getTabbedPane().getActionMap().put("MoveLeft", abstractAction2);
        this.getTabbedPane().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LogPanel logPanel;
                int n;
                super.mouseClicked(mouseEvent);
                if (mouseEvent.getClickCount() > 1 && (mouseEvent.getModifiers() & 0x10) > 0 && (n = LogUI.this.getTabbedPane().getSelectedIndex()) != -1 && n == LogUI.this.getTabbedPane().getSelectedIndex() && (logPanel = LogUI.this.getCurrentLogPanel()) != null) {
                    logPanel.undock();
                }
            }
        });
        ((Container)object).add(this.getTabbedPane());
        this.addWelcomePanel();
        this.initPlugins(this.pluginRegistry);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.mainReceiverSplitPane = new JSplitPane(1, (Component)object, this.receiversPanel);
        this.dividerSize = this.mainReceiverSplitPane.getDividerSize();
        this.mainReceiverSplitPane.setDividerLocation(-1);
        this.getContentPane().add((Component)this.mainReceiverSplitPane, "Center");
        this.mainReceiverSplitPane.setResizeWeight(1.0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LogUI.this.exit();
            }
        });
        this.preferencesFrame.setTitle("'Application-wide Preferences");
        this.preferencesFrame.setIconImage(((ImageIcon)ChainsawIcons.ICON_PREFERENCES).getImage());
        this.preferencesFrame.getContentPane().add(this.applicationPreferenceModelPanel);
        this.preferencesFrame.setSize(640, 520);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.preferencesFrame.setLocation(new Point(dimension.width / 2 - this.preferencesFrame.getSize().width / 2, dimension.height / 2 - this.preferencesFrame.getSize().height / 2));
        this.pack();
        JPopupMenu jPopupMenu = new JPopupMenu();
        final AbstractAction abstractAction3 = new AbstractAction("Hide"){

            public void actionPerformed(ActionEvent actionEvent) {
                LogUI.this.displayPanel(LogUI.this.getCurrentLogPanel().getIdentifier(), false);
                LogUI.this.tbms.stateChange();
            }
        };
        final AbstractAction abstractAction4 = new AbstractAction("Hide Others"){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = LogUI.this.getCurrentLogPanel().getIdentifier();
                int n = LogUI.this.getTabbedPane().getTabCount();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    String string2 = LogUI.this.getTabbedPane().getTitleAt(n2);
                    if (LogUI.this.getPanelMap().keySet().contains(string2) && !string2.equals(string)) {
                        LogUI.this.displayPanel(string2, false);
                        LogUI.this.tbms.stateChange();
                        continue;
                    }
                    ++n2;
                }
            }
        };
        AbstractAction abstractAction5 = new AbstractAction("Show All Hidden"){

            public void actionPerformed(ActionEvent actionEvent) {
                Iterator iterator = LogUI.this.getPanels().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Boolean bl = (Boolean)entry.getValue();
                    if (!bl.booleanValue()) continue;
                    String string = (String)entry.getKey();
                    int n = LogUI.this.getTabbedPane().getTabCount();
                    boolean bl2 = false;
                    for (int i = 0; i < n; ++i) {
                        String string2 = LogUI.this.getTabbedPane().getTitleAt(i);
                        if (!string2.equals(string)) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    LogUI.this.displayPanel(string, true);
                    LogUI.this.tbms.stateChange();
                }
            }
        };
        jPopupMenu.add(abstractAction3);
        jPopupMenu.add(abstractAction4);
        jPopupMenu.addSeparator();
        jPopupMenu.add(abstractAction5);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        this.getTabbedPane().addMouseListener(popupListener);
        final ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = LogUI.this.getCurrentLogPanel() != null;
                abstractAction3.setEnabled(bl);
                abstractAction4.setEnabled(bl);
            }
        };
        this.getTabbedPane().addChangeListener(changeListener);
        this.getTabbedPane().addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                changeListener.stateChanged(null);
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                changeListener.stateChanged(null);
            }
        });
        this.handler.addPropertyChangeListener("dataRate", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                double d = (Double)propertyChangeEvent.getNewValue();
                LogUI.this.statusBar.setDataRate(d);
            }
        });
        this.getSettingsManager().addSettingsListener(this);
        this.getSettingsManager().addSettingsListener(this.applicationPreferenceModel);
        this.getSettingsManager().loadSettings();
        this.setVisible(true);
        if (this.applicationPreferenceModel.isReceivers()) {
            this.showReceiverPanel();
        } else {
            this.hideReceiverPanel();
        }
        LogUI.removeSplash();
        Object object2 = this.initializationLock;
        synchronized (object2) {
            this.isGUIFullyInitialized = true;
            this.initializationLock.notifyAll();
        }
        if (this.noReceiversDefined && this.applicationPreferenceModel.isShowNoReceiverWarning()) {
            this.showNoReceiversWarningPanel();
        }
        object2 = this.tutorialFrame.getContentPane();
        final JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jEditorPane.setEditable(false);
        ((Container)object2).setLayout(new BorderLayout());
        try {
            jEditorPane.setPage(ChainsawConstants.TUTORIAL_URL);
            ((Container)object2).add((Component)new JScrollPane(jEditorPane), "Center");
        }
        catch (Exception exception) {
            MessageCenter.getInstance().getLogger().error("Error occurred loading the Tutorial", exception);
        }
        this.tutorialFrame.setIconImage(new ImageIcon(ChainsawIcons.HELP).getImage());
        this.tutorialFrame.setSize(new Dimension(640, 480));
        final AbstractAction abstractAction6 = new AbstractAction("Start Tutorial", new ImageIcon(ChainsawIcons.ICON_RESUME_RECEIVER)){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(null, "This will start 3 \"Generator\" receivers for use in the Tutorial.  Is that ok?", "Confirm", 0) == 0) {
                    new Thread(new Tutorial()).start();
                    this.putValue("TutorialStarted", Boolean.TRUE);
                } else {
                    this.putValue("TutorialStarted", Boolean.FALSE);
                }
            }
        };
        final AbstractAction abstractAction7 = new AbstractAction("Stop Tutorial", new ImageIcon(ChainsawIcons.ICON_STOP_RECEIVER)){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(null, "This will stop all of the \"Generator\" receivers used in the Tutorial, but leave any other Receiver untouched.  Is that ok?", "Confirm", 0) == 0) {
                    new Thread(new Runnable(this){
                        private final /* synthetic */ 23 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            PluginRegistry pluginRegistry = LogManager.getLoggerRepository().getPluginRegistry();
                            List list = pluginRegistry.getPlugins(class$org$apache$log4j$chainsaw$Generator == null ? (class$org$apache$log4j$chainsaw$Generator = LogUI.class$("org.apache.log4j.chainsaw.Generator")) : class$org$apache$log4j$chainsaw$Generator);
                            Iterator<E> iterator = list.iterator();
                            while (iterator.hasNext()) {
                                Plugin plugin = (Plugin)iterator.next();
                                pluginRegistry.stopPlugin(plugin.getName());
                            }
                        }
                    }).start();
                    this.setEnabled(false);
                    abstractAction6.putValue("TutorialStarted", Boolean.FALSE);
                }
            }
        };
        abstractAction7.putValue("ShortDescription", "Removes all of the Tutorials Generator Receivers, leaving all other Receivers untouched");
        abstractAction6.putValue("ShortDescription", "Begins the Tutorial, starting up some Generator Receivers so you can see Chainsaw in action");
        abstractAction7.setEnabled(false);
        final SmallToggleButton smallToggleButton = new SmallToggleButton(abstractAction6);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                abstractAction7.setEnabled(((Boolean)abstractAction6.getValue("TutorialStarted")).equals(Boolean.TRUE));
                smallToggleButton.setSelected(abstractAction7.isEnabled());
            }
        };
        abstractAction6.addPropertyChangeListener(propertyChangeListener);
        abstractAction7.addPropertyChangeListener(propertyChangeListener);
        this.pluginRegistry.addPluginListener(new PluginListener(){

            public void pluginStarted(PluginEvent pluginEvent) {
            }

            public void pluginStopped(PluginEvent pluginEvent) {
                List list = LogUI.this.pluginRegistry.getPlugins(class$org$apache$log4j$chainsaw$Generator == null ? (class$org$apache$log4j$chainsaw$Generator = LogUI.class$("org.apache.log4j.chainsaw.Generator")) : class$org$apache$log4j$chainsaw$Generator);
                if (list.size() == 0) {
                    abstractAction6.putValue("TutorialStarted", Boolean.FALSE);
                }
            }
        });
        SmallButton smallButton = new SmallButton(abstractAction7);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(smallToggleButton);
        jToolBar.add(smallButton);
        ((Container)object2).add((Component)jToolBar, "North");
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (hyperlinkEvent.getDescription().equals("StartTutorial")) {
                        abstractAction6.actionPerformed(null);
                    } else if (hyperlinkEvent.getDescription().equals("StopTutorial")) {
                        abstractAction7.actionPerformed(null);
                    } else {
                        try {
                            jEditorPane.setPage(hyperlinkEvent.getURL());
                        }
                        catch (IOException iOException) {
                            MessageCenter.getInstance().getLogger().error("Failed to change the URL for the Tutorial", iOException);
                        }
                    }
                }
            }
        });
    }

    private void checkForNewerVersion() {
        String string = this.getApplicationPreferenceModel().getLastUsedVersion();
        String string2 = VersionManager.getInstance().getVersionNumber();
        if (!(string != null && string.equals(string2) || JOptionPane.showConfirmDialog(this, "This version looks like it is different than the version you last ran. (" + string + " vs " + string2 + ")\n\nWould you like to view the Release Notes?", "Newer Version?", 0) != 0)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HelpManager.getInstance().setHelpURL(ChainsawConstants.RELEASE_NOTES_URL);
                }
            });
        }
        this.getApplicationPreferenceModel().setLastUsedVersion(string2);
    }

    private void showReceiverPanel() {
        this.mainReceiverSplitPane.setDividerSize(this.dividerSize);
        this.mainReceiverSplitPane.setDividerLocation(this.lastMainReceiverSplitLocation);
        this.receiversPanel.setVisible(true);
        this.mainReceiverSplitPane.repaint();
    }

    private void hideReceiverPanel() {
        int n = this.mainReceiverSplitPane.getWidth() - this.mainReceiverSplitPane.getDividerSize();
        if (this.mainReceiverSplitPane.getDividerLocation() > -1 && this.mainReceiverSplitPane.getDividerLocation() + 1 != n && this.mainReceiverSplitPane.getDividerLocation() - 1 != 0) {
            this.lastMainReceiverSplitLocation = (double)this.mainReceiverSplitPane.getDividerLocation() / (double)n;
        }
        this.mainReceiverSplitPane.setDividerSize(0);
        this.receiversPanel.setVisible(false);
        this.mainReceiverSplitPane.repaint();
    }

    private void initSocketConnectionListener() {
        final SocketNodeEventListener socketNodeEventListener = new SocketNodeEventListener(){

            public void socketOpened(String string) {
                LogUI.this.statusBar.remoteConnectionReceived(string);
            }

            public void socketClosedEvent(Exception exception) {
                MessageCenter.getInstance().getLogger().info("Connection lost! :: " + exception.getMessage());
            }
        };
        PluginListener pluginListener = new PluginListener(){

            public void pluginStarted(PluginEvent pluginEvent) {
                MessageCenter.getInstance().getLogger().info(pluginEvent.getPlugin().getName() + " started!");
                Method method = this.getAddListenerMethod(pluginEvent.getPlugin());
                if (method != null) {
                    try {
                        method.invoke((Object)pluginEvent.getPlugin(), socketNodeEventListener);
                    }
                    catch (Exception exception) {
                        MessageCenter.getInstance().getLogger().error("Failed to add a SocketNodeEventListener", exception);
                    }
                }
            }

            Method getRemoveListenerMethod(Plugin plugin) {
                try {
                    return plugin.getClass().getMethod("removeSocketNodeEventListener", class$org$apache$log4j$net$SocketNodeEventListener == null ? (class$org$apache$log4j$net$SocketNodeEventListener = LogUI.class$("org.apache.log4j.net.SocketNodeEventListener")) : class$org$apache$log4j$net$SocketNodeEventListener);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            Method getAddListenerMethod(Plugin plugin) {
                try {
                    return plugin.getClass().getMethod("addSocketNodeEventListener", class$org$apache$log4j$net$SocketNodeEventListener == null ? (class$org$apache$log4j$net$SocketNodeEventListener = LogUI.class$("org.apache.log4j.net.SocketNodeEventListener")) : class$org$apache$log4j$net$SocketNodeEventListener);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void pluginStopped(PluginEvent pluginEvent) {
                Method method = this.getRemoveListenerMethod(pluginEvent.getPlugin());
                if (method != null) {
                    try {
                        method.invoke((Object)pluginEvent.getPlugin(), socketNodeEventListener);
                    }
                    catch (Exception exception) {
                        MessageCenter.getInstance().getLogger().error("Failed to remove SocketNodeEventListener", exception);
                    }
                }
                MessageCenter.getInstance().getLogger().info(pluginEvent.getPlugin().getName() + " stopped!");
            }
        };
        this.pluginRegistry.addPluginListener(pluginListener);
    }

    private void initPrefModelListeners() {
        this.applicationPreferenceModel.addPropertyChangeListener("identifierExpression", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogUI.this.handler.setIdentifierExpression(propertyChangeEvent.getNewValue().toString());
            }
        });
        this.applicationPreferenceModel.addPropertyChangeListener("toolTipDisplayMillis", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ToolTipManager.sharedInstance().setDismissDelay((Integer)propertyChangeEvent.getNewValue());
            }
        });
        ToolTipManager.sharedInstance().setDismissDelay(this.applicationPreferenceModel.getToolTipDisplayMillis());
        this.applicationPreferenceModel.addPropertyChangeListener("responsiveness", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                LogUI.this.handler.setQueueInterval(n * 1000 - 750);
            }
        });
        this.applicationPreferenceModel.addPropertyChangeListener("tabPlacement", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(this, propertyChangeEvent){
                    private final /* synthetic */ PropertyChangeEvent val$evt;
                    private final /* synthetic */ 34 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$evt = propertyChangeEvent;
                    }

                    public void run() {
                        int n = (Integer)this.val$evt.getNewValue();
                        switch (n) {
                            case 1: 
                            case 3: {
                                LogUI.access$900(34.access$800(this.this$1)).setTabPlacement(n);
                                break;
                            }
                        }
                    }
                });
            }

            static /* synthetic */ LogUI access$800(34 var0) {
                return var0.LogUI.this;
            }
        });
        this.applicationPreferenceModel.addPropertyChangeListener("statusBar", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                LogUI.this.setStatusBarVisible(bl);
            }
        });
        this.applicationPreferenceModel.addPropertyChangeListener("receivers", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (bl) {
                    LogUI.this.showReceiverPanel();
                } else {
                    LogUI.this.hideReceiverPanel();
                }
            }
        });
        this.applicationPreferenceModel.addPropertyChangeListener("toolbar", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                LogUI.this.toolbar.setVisible(bl);
            }
        });
        this.toolbar.setVisible(this.applicationPreferenceModel.isToolbar());
        this.setStatusBarVisible(this.applicationPreferenceModel.isStatusBar());
    }

    private void showNoReceiversWarningPanel() {
        final NoReceiversWarningPanel noReceiversWarningPanel = new NoReceiversWarningPanel();
        SettingsListener settingsListener = new SettingsListener(){

            public void loadSettings(LoadSettingsEvent loadSettingsEvent) {
                int n = loadSettingsEvent.asInt("SavedConfigs.Size");
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = loadSettingsEvent.getSetting("SavedConfigs." + i);
                }
                noReceiversWarningPanel.getModel().setRememberedConfigs(objectArray);
            }

            public void saveSettings(SaveSettingsEvent saveSettingsEvent) {
                Object[] objectArray = noReceiversWarningPanel.getModel().getRememberedConfigs();
                saveSettingsEvent.saveSetting("SavedConfigs.Size", objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    saveSettingsEvent.saveSetting("SavedConfigs." + i, objectArray[i].toString());
                }
            }
        };
        this.getSettingsManager().addSettingsListener(settingsListener);
        this.getSettingsManager().configure(settingsListener);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                URL uRL;
                JDialog jDialog = new JDialog((Frame)LogUI.this, true);
                jDialog.setTitle("Warning: You have no Receivers defined...");
                jDialog.setDefaultCloseOperation(0);
                jDialog.setResizable(false);
                noReceiversWarningPanel.setOkActionListener(new ActionListener(this, jDialog){
                    private final /* synthetic */ JDialog val$dialog;
                    private final /* synthetic */ 40 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$dialog = jDialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$dialog.setVisible(false);
                    }
                });
                jDialog.getContentPane().add(noReceiversWarningPanel);
                jDialog.pack();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                jDialog.setLocation(dimension.width / 2 - jDialog.getWidth() / 2, dimension.height / 2 - jDialog.getHeight() / 2);
                jDialog.show();
                jDialog.dispose();
                LogUI.this.applicationPreferenceModel.setShowNoReceiverWarning(!noReceiversWarningPanel.isDontWarnMeAgain());
                if (noReceiversWarningPanel.getModel().isManualMode()) {
                    LogUI.this.applicationPreferenceModel.setReceivers(true);
                } else if (noReceiversWarningPanel.getModel().isSimpleReceiverMode()) {
                    int n = noReceiversWarningPanel.getModel().getSimplePort();
                    Class clazz = noReceiversWarningPanel.getModel().getSimpleReceiverClass();
                    try {
                        Receiver receiver = (Receiver)clazz.newInstance();
                        receiver.setName("Simple Receiver");
                        Method method = receiver.getClass().getMethod("setPort", Integer.TYPE);
                        method.invoke((Object)receiver, new Integer(n));
                        receiver.setThreshold(Level.DEBUG);
                        LogUI.this.pluginRegistry.addPlugin(receiver);
                        receiver.activateOptions();
                        LogUI.this.receiversPanel.updateReceiverTreeInDispatchThread();
                    }
                    catch (Exception exception) {
                        MessageCenter.getInstance().getLogger().error("Error creating Receiver", exception);
                        MessageCenter.getInstance().getLogger().info("An error occurred creating your Receiver");
                    }
                } else if (noReceiversWarningPanel.getModel().isLoadConfig() && (uRL = noReceiversWarningPanel.getModel().getConfigToLoad()) != null) {
                    MessageCenter.getInstance().getLogger().debug("Initialiazing Log4j with " + uRL.toExternalForm());
                    new Thread(new Runnable(this, uRL){
                        private final /* synthetic */ URL val$url;
                        private final /* synthetic */ 40 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$url = uRL;
                        }

                        public void run() {
                            try {
                                OptionConverter.selectAndConfigure(this.val$url, null, LogManager.getLoggerRepository());
                            }
                            catch (Exception exception) {
                                MessageCenter.getInstance().getLogger().error("Error initializing Log4j", exception);
                            }
                            LogManager.getLoggerRepository().getRootLogger().addAppender(40.access$1600(this.this$1).handler);
                            LogUI.access$1500(40.access$1600(this.this$1)).updateReceiverTreeInDispatchThread();
                        }
                    }).start();
                }
            }

            static /* synthetic */ LogUI access$1600(40 var0) {
                return var0.LogUI.this;
            }
        });
    }

    void exit() {
        this.getSettingsManager().saveSettings();
        this.shutdown();
    }

    void addWelcomePanel() {
        this.getTabbedPane().addANewTab("Welcome", this.welcomePanel, new ImageIcon(ChainsawIcons.ABOUT), "Welcome/Help");
    }

    void removeWelcomePanel() {
        if (this.getTabbedPane().containsWelcomePanel()) {
            this.getTabbedPane().remove(this.getTabbedPane().getComponentAt(this.getTabbedPane().indexOfTab("Welcome")));
        }
    }

    ChainsawStatusBar getStatusBar() {
        return this.statusBar;
    }

    void showApplicationPreferences() {
        this.applicationPreferenceModelPanel.updateModel();
        this.preferencesFrame.show();
    }

    void showAboutBox() {
        if (this.aboutBox == null) {
            this.aboutBox = new ChainsawAbout(this);
        }
        this.aboutBox.setVisible(true);
    }

    Map getPanels() {
        HashMap hashMap = new HashMap();
        Set set = this.getPanelMap().entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashMap.put(entry.getKey(), new Boolean(((DockablePanel)entry.getValue()).isDocked()));
        }
        return hashMap;
    }

    void displayPanel(String string, boolean bl) {
        Object v = this.getPanelMap().get(string);
        if (v instanceof LogPanel) {
            LogPanel logPanel = (LogPanel)v;
            int n = this.getTabbedPane().indexOfTab(string);
            if (n == -1 && bl) {
                this.getTabbedPane().addTab(string, logPanel);
            }
            if (n > -1 && !bl) {
                this.getTabbedPane().removeTabAt(n);
            }
        }
    }

    private void shutdown() {
        if (this.getApplicationPreferenceModel().isConfirmExit() && JOptionPane.showConfirmDialog(this, "Are you sure you want to exit Chainsaw?", "Confirm Exit", 0, 1) != 0) {
            return;
        }
        final JWindow jWindow = new JWindow();
        final ProgressPanel progressPanel = new ProgressPanel(1, 3, "Shutting down");
        jWindow.getContentPane().add(progressPanel);
        jWindow.pack();
        Point point = new Point(this.getLocation());
        point.move((int)this.getSize().getWidth() >> 1, (int)this.getSize().getHeight() >> 1);
        jWindow.setLocation(point);
        jWindow.setVisible(true);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    int n = 1;
                    LogUI.this.handler.close();
                    progressPanel.setProgress(n++);
                    Thread.sleep(25L);
                    LogUI.this.pluginRegistry.stopAllPlugins();
                    progressPanel.setProgress(n++);
                    Thread.sleep(25L);
                    progressPanel.setProgress(n++);
                    Thread.sleep(25L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                LogUI.this.fireShutdownEvent();
                LogUI.this.performShutdownAction();
                jWindow.setVisible(false);
            }
        };
        new Thread(runnable).start();
    }

    private void fireShutdownEvent() {
        ShutdownListener[] shutdownListenerArray = (ShutdownListener[])this.shutdownListenerList.getListeners(class$org$apache$log4j$chainsaw$ShutdownListener == null ? (class$org$apache$log4j$chainsaw$ShutdownListener = LogUI.class$("org.apache.log4j.chainsaw.ShutdownListener")) : class$org$apache$log4j$chainsaw$ShutdownListener);
        for (int i = 0; i < shutdownListenerArray.length; ++i) {
            shutdownListenerArray[i].shuttingDown();
        }
    }

    public final void setShutdownAction(Action action) {
        this.shutdownAction = action;
    }

    private void performShutdownAction() {
        MessageCenter.getInstance().getLogger().debug("Calling the shutdown Action. Goodbye!");
        this.shutdownAction.actionPerformed(new ActionEvent(this, 1001, "Shutting Down"));
    }

    LogPanel getCurrentLogPanel() {
        Component component = this.getTabbedPane().getSelectedComponent();
        if (component instanceof LogPanel) {
            return (LogPanel)component;
        }
        return null;
    }

    private void setStatusBarVisible(final boolean bl) {
        MessageCenter.getInstance().getLogger().debug("Setting StatusBar to " + bl);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogUI.this.statusBar.setVisible(bl);
            }
        });
    }

    boolean isStatusBarVisible() {
        return this.statusBar.isVisible();
    }

    public String getActiveTabName() {
        int n = this.getTabbedPane().getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.getTabbedPane().getTitleAt(n);
    }

    private static void applyLookAndFeel(String string) {
        if (UIManager.getLookAndFeel().getClass().getName().equals(string)) {
            return;
        }
        if (string == null || string.trim().equals("")) {
            string = UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showHelp(URL uRL) {
        this.removeWelcomePanel();
        this.addWelcomePanel();
        this.getWelcomePanel().setURL(uRL);
    }

    private WelcomePanel getWelcomePanel() {
        return this.welcomePanel;
    }

    public boolean isLogTreePanelVisible() {
        if (this.getCurrentLogPanel() == null) {
            return false;
        }
        return this.getCurrentLogPanel().isLogTreeVisible();
    }

    public String getInterestedIdentifier() {
        return null;
    }

    public Map getPanelMap() {
        return this.panelMap;
    }

    public SettingsManager getSettingsManager() {
        return this.sm;
    }

    public List getFilterableColumns() {
        return this.filterableColumns;
    }

    public void setToolBarAndMenus(ChainsawToolBarAndMenus chainsawToolBarAndMenus) {
        this.tbms = chainsawToolBarAndMenus;
    }

    public ChainsawToolBarAndMenus getToolBarAndMenus() {
        return this.tbms;
    }

    public Map getTableMap() {
        return this.tableMap;
    }

    public Map getTableModelMap() {
        return this.tableModelMap;
    }

    public void setTabbedPane(ChainsawTabbedPane chainsawTabbedPane) {
        this.tabbedPane = chainsawTabbedPane;
    }

    public ChainsawTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public final ApplicationPreferenceModel getApplicationPreferenceModel() {
        return this.applicationPreferenceModel;
    }

    public void setupTutorial() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                LogUI.this.setLocation(0, LogUI.this.getLocation().y);
                double d = 0.7;
                double d2 = 1.0 - d;
                LogUI.this.setSize((int)((double)dimension.width * d), LogUI.this.getSize().height);
                LogUI.this.invalidate();
                LogUI.this.validate();
                Dimension dimension2 = LogUI.this.getSize();
                Point point = LogUI.this.getLocation();
                LogUI.this.tutorialFrame.setSize((int)((double)dimension.width * d2), dimension2.height);
                LogUI.this.tutorialFrame.setLocation(point.x + dimension2.width, point.y);
                LogUI.this.tutorialFrame.setVisible(true);
            }
        });
    }

    private void buildLogPanel(boolean bl, final String string, List list) throws IllegalArgumentException {
        final LogPanel logPanel = new LogPanel(this.getStatusBar(), string, this.cyclicBufferSize);
        if (bl) {
            this.handler.addCustomEventBatchListener(string, logPanel);
        } else {
            this.identifierPanels.add(logPanel);
            this.handler.addEventBatchListener(logPanel);
        }
        TabIconHandler tabIconHandler = new TabIconHandler(string);
        logPanel.addEventCountListener(tabIconHandler);
        this.tabbedPane.addChangeListener(tabIconHandler);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogUI.this.tbms.stateChange();
            }
        };
        logPanel.addPropertyChangeListener(propertyChangeListener);
        logPanel.addPreferencePropertyChangeListener(propertyChangeListener);
        logPanel.addPropertyChangeListener("docked", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                LogPanel logPanel = (LogPanel)propertyChangeEvent.getSource();
                if (logPanel.isDocked()) {
                    LogUI.this.getPanelMap().put(logPanel.getIdentifier(), logPanel);
                    LogUI.this.getTabbedPane().addANewTab(logPanel.getIdentifier(), logPanel, null);
                    LogUI.this.getTabbedPane().setSelectedTab(LogUI.this.getTabbedPane().indexOfTab(logPanel.getIdentifier()));
                } else {
                    LogUI.this.getTabbedPane().remove(logPanel);
                }
            }
        });
        this.getTabbedPane().add(string, logPanel);
        this.getPanelMap().put(string, logPanel);
        this.getSettingsManager().addSettingsListener(logPanel);
        this.getSettingsManager().configure(logPanel);
        logPanel.receiveEventBatch(string, list);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogUI.this.getTabbedPane().addANewTab(string, logPanel, new ImageIcon(ChainsawIcons.ANIM_RADIO_TOWER));
            }
        });
        String string2 = "added tab " + string;
        MessageCenter.getInstance().getLogger().debug(string2);
    }

    public void createCustomExpressionLogPanel(String string) {
        try {
            ArrayList<ChainsawEventBatchEntry> arrayList = new ArrayList<ChainsawEventBatchEntry>();
            Rule rule = ExpressionRule.getRule(string);
            Iterator iterator = this.identifierPanels.iterator();
            while (iterator.hasNext()) {
                LogPanel logPanel = (LogPanel)iterator.next();
                Iterator iterator2 = logPanel.getMatchingEvents(rule).iterator();
                while (iterator2.hasNext()) {
                    LoggingEvent loggingEvent = (LoggingEvent)iterator2.next();
                    arrayList.add(new ChainsawEventBatchEntry(string, loggingEvent.getProperty("log4j.eventtype") == null ? "log4j" : loggingEvent.getProperty("log4j.eventtype"), loggingEvent));
                }
            }
            this.buildLogPanel(true, string, arrayList);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageCenter.getInstance().getLogger().info("Unable to add tab using expression: " + string + ", reason: " + illegalArgumentException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ ChainsawTabbedPane access$900(LogUI logUI) {
        return logUI.tabbedPane;
    }

    private class TabIconHandler
    implements EventCountListener,
    ChangeListener {
        private boolean newEvents = true;
        private boolean seenEvents = false;
        private final String ident;
        ImageIcon NEW_EVENTS = new ImageIcon(ChainsawIcons.ANIM_RADIO_TOWER);
        ImageIcon HAS_EVENTS = new ImageIcon(ChainsawIcons.INFO);
        Icon SELECTED = LineIconFactory.createBlankIcon();

        public TabIconHandler(String string) {
            this.ident = string;
            new Thread(new Runnable(this){
                private final /* synthetic */ TabIconHandler this$1;
                {
                    this.this$1 = tabIconHandler;
                }

                public void run() {
                    while (true) {
                        if (TabIconHandler.access$2300(this.this$1).getTabbedPane().getSelectedIndex() == TabIconHandler.access$2300(this.this$1).getTabbedPane().indexOfTab(TabIconHandler.access$2400(this.this$1))) {
                            TabIconHandler.access$2300(this.this$1).getTabbedPane().setIconAt(TabIconHandler.access$2300(this.this$1).getTabbedPane().indexOfTab(TabIconHandler.access$2400(this.this$1)), this.this$1.SELECTED);
                            TabIconHandler.access$2502(this.this$1, false);
                            TabIconHandler.access$2602(this.this$1, true);
                        } else if (TabIconHandler.access$2300(this.this$1).getTabbedPane().indexOfTab(TabIconHandler.access$2400(this.this$1)) > -1) {
                            if (TabIconHandler.access$2500(this.this$1)) {
                                TabIconHandler.access$2300(this.this$1).getTabbedPane().setIconAt(TabIconHandler.access$2300(this.this$1).getTabbedPane().indexOfTab(TabIconHandler.access$2400(this.this$1)), this.this$1.NEW_EVENTS);
                                TabIconHandler.access$2502(this.this$1, false);
                                TabIconHandler.access$2602(this.this$1, false);
                            } else if (!TabIconHandler.access$2600(this.this$1)) {
                                TabIconHandler.access$2300(this.this$1).getTabbedPane().setIconAt(TabIconHandler.access$2300(this.this$1).getTabbedPane().indexOfTab(TabIconHandler.access$2400(this.this$1)), this.this$1.HAS_EVENTS);
                            }
                        }
                        try {
                            Thread.sleep(TabIconHandler.access$2300((TabIconHandler)this.this$1).handler.getQueueInterval() + 1000);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            }).start();
        }

        public void eventCountChanged(int n, int n2) {
            this.newEvents = true;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (LogUI.this.getTabbedPane().indexOfTab(this.ident) == LogUI.this.getTabbedPane().getSelectedIndex()) {
                LogUI.this.getTabbedPane().setIconAt(LogUI.this.getTabbedPane().indexOfTab(this.ident), this.SELECTED);
            }
        }

        static /* synthetic */ LogUI access$2300(TabIconHandler tabIconHandler) {
            return tabIconHandler.LogUI.this;
        }

        static /* synthetic */ String access$2400(TabIconHandler tabIconHandler) {
            return tabIconHandler.ident;
        }

        static /* synthetic */ boolean access$2502(TabIconHandler tabIconHandler, boolean bl) {
            tabIconHandler.newEvents = bl;
            return tabIconHandler.newEvents;
        }

        static /* synthetic */ boolean access$2602(TabIconHandler tabIconHandler, boolean bl) {
            tabIconHandler.seenEvents = bl;
            return tabIconHandler.seenEvents;
        }

        static /* synthetic */ boolean access$2500(TabIconHandler tabIconHandler) {
            return tabIconHandler.newEvents;
        }

        static /* synthetic */ boolean access$2600(TabIconHandler tabIconHandler) {
            return tabIconHandler.seenEvents;
        }
    }

    private class NewTabEventBatchReceiver
    implements EventBatchListener {
        private NewTabEventBatchReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveEventBatch(String string, List list) {
            if (list.size() == 0) {
                return;
            }
            if (!LogUI.this.isGUIFullyInitialized) {
                Object object = LogUI.this.initializationLock;
                synchronized (object) {
                    while (!LogUI.this.isGUIFullyInitialized) {
                        System.out.println("Wanting to add a row, but GUI not initialized, waiting...");
                        try {
                            LogUI.this.initializationLock.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            if (!LogUI.this.getPanelMap().containsKey(string)) {
                try {
                    LogUI.this.buildLogPanel(false, string, list);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public String getInterestedIdentifier() {
            return null;
        }
    }
}

