/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.chainsaw.LoggerNameListener;
import org.apache.log4j.helpers.LogLog;

class LogPanelLoggerTreeModel
extends DefaultTreeModel
implements LoggerNameListener {
    private Map fullPackageMap = new HashMap();

    LogPanelLoggerTreeModel() {
        super(new LogPanelTreeNode("Root Logger"));
    }

    public void loggerNameAdded(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogPanelLoggerTreeModel.this.addLoggerNameInDispatchThread(string);
            }
        });
    }

    private void addLoggerNameInDispatchThread(String string) {
        String[] stringArray = this.tokenize(string);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
        block0: for (int i = 0; i < stringArray.length; ++i) {
            CharSequence charSequence;
            DefaultMutableTreeNode defaultMutableTreeNode2;
            String string2 = stringArray[i];
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
            while (enumeration.hasMoreElements()) {
                defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
                charSequence = defaultMutableTreeNode2.getUserObject().toString();
                if (!((String)charSequence).equals(string2)) continue;
                defaultMutableTreeNode = defaultMutableTreeNode2;
                continue block0;
            }
            defaultMutableTreeNode2 = new LogPanelTreeNode(string2);
            charSequence = new StringBuffer();
            for (int j = 0; j <= i; ++j) {
                ((StringBuffer)charSequence).append(stringArray[j]);
                if (j >= i) continue;
                ((StringBuffer)charSequence).append(".");
            }
            LogLog.debug("Adding to Map " + ((StringBuffer)charSequence).toString());
            this.fullPackageMap.put(((StringBuffer)charSequence).toString(), defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode;
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            int[] nArray = new int[defaultMutableTreeNode3.getChildCount()];
            for (int j = 0; j < nArray.length; ++j) {
                nArray[j] = j;
            }
            this.nodesWereInserted(defaultMutableTreeNode3, new int[]{defaultMutableTreeNode3.getIndex(defaultMutableTreeNode2)});
            this.nodesChanged(defaultMutableTreeNode3, nArray);
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
    }

    LogPanelTreeNode lookupLogger(String string) {
        if (this.fullPackageMap.containsKey(string)) {
            return (LogPanelTreeNode)this.fullPackageMap.get(string);
        }
        LogLog.debug("No logger found matching '" + string + "'");
        LogLog.debug("Map Dump: " + this.fullPackageMap);
        return null;
    }

    private String[] tokenize(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static class LogPanelTreeNode
    extends DefaultMutableTreeNode {
        protected static Comparator nodeComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareToIgnoreCase(object2.toString());
            }

            public boolean equals(Object object) {
                return false;
            }
        };

        private LogPanelTreeNode(String string) {
            super(string);
        }

        public void insert(MutableTreeNode mutableTreeNode, int n) {
            super.insert(mutableTreeNode, n);
            Collections.sort(this.children, nodeComparator);
        }
    }
}

