/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.chainsaw.SortHeaderRenderer;
import org.apache.log4j.chainsaw.SortTableModel;

public class JSortTable
extends JTable
implements MouseListener {
    protected int sortedColumnIndex = -1;
    protected boolean sortedColumnAscending = true;
    private String sortedColumn;

    public JSortTable() {
        this.initSortHeader();
    }

    public JSortTable(SortTableModel sortTableModel) {
        super(sortTableModel);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel sortTableModel, TableColumnModel tableColumnModel) {
        super(sortTableModel, tableColumnModel);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel sortTableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(sortTableModel, tableColumnModel, listSelectionModel);
        this.initSortHeader();
    }

    protected void initSortHeader() {
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setDefaultRenderer(new SortHeaderRenderer());
        jTableHeader.addMouseListener(this);
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public void updateSortedColumn() {
        if (this.sortedColumn != null) {
            try {
                this.sortedColumnIndex = this.columnModel.getColumnIndex(this.sortedColumn);
                this.getTableHeader().resizeAndRepaint();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.setSortedColumnIndex(-1);
            }
        }
    }

    public void setSortedColumnIndex(int n) {
        this.sortedColumnIndex = n;
        if (this.sortedColumnIndex > -1) {
            SortTableModel sortTableModel = (SortTableModel)this.getModel();
            sortTableModel.sortColumn(this.sortedColumnIndex, this.sortedColumnAscending);
        }
        this.getTableHeader().resizeAndRepaint();
    }

    public void scrollToRow(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n > -1 && n < JSortTable.this.getRowCount()) {
                    try {
                        JSortTable.this.setRowSelectionInterval(n, n);
                        JSortTable.this.scrollRectToVisible(JSortTable.this.getCellRect(n, n2 + 1, true));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void scrollToBottom(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n2 = JSortTable.this.getRowCount() - 1;
                try {
                    JSortTable.this.setRowSelectionInterval(n2, n2);
                    JSortTable.this.scrollRectToVisible(JSortTable.this.getCellRect(n2, n + 1, true));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() < 2 || mouseEvent.isPopupTrigger()) {
            return;
        }
        if (mouseEvent.getClickCount() > 1 && (mouseEvent.getModifiers() & 8) > 0) {
            return;
        }
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = tableColumnModel.getColumn(n).getModelIndex();
        SortTableModel sortTableModel = (SortTableModel)this.getModel();
        if (sortTableModel.isSortable(n2)) {
            if (this.sortedColumnIndex == n) {
                this.sortedColumnAscending = !this.sortedColumnAscending;
            }
            this.sortedColumnIndex = n;
            this.sortedColumn = tableColumnModel.getColumn(n).getHeaderValue().toString();
            sortTableModel.sortColumn(n2, this.sortedColumnAscending);
            this.getTableHeader().resizeAndRepaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

