/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.helpers.DateLayout;
import org.apache.log4j.spi.LoggingEvent;

public class TTCCLayout
extends DateLayout {
    private boolean threadPrinting = true;
    private boolean categoryPrefixing = true;
    private boolean contextPrinting = true;
    protected final StringBuffer buf = new StringBuffer(64);

    public TTCCLayout() {
        this.setDateFormat("RELATIVE", null);
    }

    public TTCCLayout(String dateFormatType) {
        this.setDateFormat(dateFormatType);
    }

    public void setThreadPrinting(boolean threadPrinting) {
        this.threadPrinting = threadPrinting;
    }

    public boolean getThreadPrinting() {
        return this.threadPrinting;
    }

    public void setCategoryPrefixing(boolean categoryPrefixing) {
        this.categoryPrefixing = categoryPrefixing;
    }

    public boolean getCategoryPrefixing() {
        return this.categoryPrefixing;
    }

    public void setContextPrinting(boolean contextPrinting) {
        this.contextPrinting = contextPrinting;
    }

    public boolean getContextPrinting() {
        return this.contextPrinting;
    }

    public void format(Writer output, LoggingEvent event) throws IOException {
        String ndc;
        this.buf.setLength(0);
        this.dateFormat(this.buf, event);
        output.write(this.buf.toString());
        if (this.threadPrinting) {
            output.write(91);
            output.write(event.getThreadName());
            output.write("] ");
        }
        output.write(event.getLevel().toString());
        output.write(32);
        if (this.categoryPrefixing) {
            output.write(event.getLoggerName());
            output.write(32);
        }
        if (this.contextPrinting && (ndc = event.getNDC()) != null) {
            output.write(ndc);
            output.write(32);
        }
        output.write("- ");
        output.write(event.getRenderedMessage());
        output.write(LINE_SEP);
    }
}

