/*
 * Decompiled with CFR 0.152.
 */
package org.apache.joran;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.joran.ErrorItem;
import org.apache.joran.ExecutionContext;
import org.apache.joran.Pattern;
import org.apache.joran.RuleStore;
import org.apache.joran.action.Action;
import org.apache.joran.action.ImplicitAction;
import org.apache.log4j.helpers.LogLog;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Interpreter
extends DefaultHandler {
    private static List EMPTY_LIST = new Vector(0);
    private RuleStore ruleStore;
    private ExecutionContext ec;
    private ArrayList implicitActions;
    Pattern pattern;
    Locator locator;
    private EntityResolver entityResolver;
    Stack actionListStack;

    public Interpreter(RuleStore rs) {
        this.ruleStore = rs;
        this.ec = new ExecutionContext(this);
        this.implicitActions = new ArrayList(3);
        this.pattern = new Pattern();
        this.actionListStack = new Stack();
    }

    public ExecutionContext getExecutionContext() {
        return this.ec;
    }

    public void startDocument() {
        LogLog.info(" in JP startDocument");
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        Object x = null;
        String tagName = this.getTagName(localName, qName);
        LogLog.debug("in startElement <" + tagName + ">");
        this.pattern.push(tagName);
        List applicableActionList = this.getapplicableActionList(this.pattern, atts);
        if (applicableActionList != null) {
            this.actionListStack.add(applicableActionList);
            this.callBeginAction(applicableActionList, tagName, atts);
        } else {
            this.actionListStack.add(EMPTY_LIST);
            String errMsg = "no applicable action for <" + tagName + ">, current pattern is [" + this.pattern + "]";
            LogLog.warn(errMsg);
            this.ec.addError(new ErrorItem(errMsg));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        List applicableActionList = (List)this.actionListStack.pop();
        if (applicableActionList != EMPTY_LIST) {
            this.callEndAction(applicableActionList, this.getTagName(localName, qName));
        }
        this.pattern.pop();
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    String getTagName(String localName, String qName) {
        String tagName = localName;
        if (tagName == null || tagName.length() < 1) {
            tagName = qName;
        }
        return tagName;
    }

    public void addImplcitAction(ImplicitAction ia) {
        this.implicitActions.add(ia);
    }

    List lookupImplicitAction(Pattern pattern, Attributes attributes, ExecutionContext ec) {
        int len = this.implicitActions.size();
        for (int i = 0; i < len; ++i) {
            ImplicitAction ia = (ImplicitAction)this.implicitActions.get(i);
            if (!ia.isApplicable(pattern, attributes, ec)) continue;
            ArrayList<ImplicitAction> actionList = new ArrayList<ImplicitAction>(1);
            actionList.add(ia);
            return actionList;
        }
        return null;
    }

    List getapplicableActionList(Pattern pattern, Attributes attributes) {
        List applicableActionList = this.ruleStore.matchActions(pattern);
        if (applicableActionList == null) {
            applicableActionList = this.lookupImplicitAction(pattern, attributes, this.ec);
        }
        return applicableActionList;
    }

    void callBeginAction(List applicableActionList, String tagName, Attributes atts) {
        if (applicableActionList == null) {
            return;
        }
        Iterator i = applicableActionList.iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            try {
                action.begin(this.ec, tagName, atts);
            }
            catch (Exception e) {
                this.ec.addError(new ErrorItem("Action threw an exception", e));
            }
        }
    }

    void callEndAction(List applicableActionList, String tagName) {
        if (applicableActionList == null) {
            return;
        }
        Iterator i = applicableActionList.iterator();
        while (i.hasNext()) {
            Action action = (Action)i.next();
            action.end(this.ec, tagName);
        }
    }

    public RuleStore getRuleStore() {
        return this.ruleStore;
    }

    public void setRuleStore(RuleStore ruleStore) {
        this.ruleStore = ruleStore;
    }

    public void endDocument() {
    }

    public void error(SAXParseException spe) throws SAXException {
        this.ec.addError(new ErrorItem("Parsing error", spe));
    }

    public void fatalError(SAXParseException spe) throws SAXException {
        this.ec.addError(new ErrorItem("Parsing fatal error", spe));
    }

    public void warning(SAXParseException spe) throws SAXException {
        this.ec.addError(new ErrorItem("Parsing warning", spe));
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void skippedEntity(String name) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.entityResolver == null) {
            return null;
        }
        try {
            return this.entityResolver.resolveEntity(publicId, systemId);
        }
        catch (IOException ioe) {
            return null;
        }
    }
}

