/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.automate;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.automate.AutoMateHelper;
import com.helpsystems.enterprise.automate.AutomateV11Helper;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSearchSelection;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSystemDefinition;
import com.helpsystems.enterprise.core.busobj.automate.AutoMateSystemType;
import com.helpsystems.enterprise.core.busobj.automate.RepositoryContents;
import com.helpsystems.enterprise.core.dm.automate.AutoMateSystemDefinitionsDM;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class AutoMateServlet
extends GenericServlet {
    private static Logger logger = Logger.getLogger(AutoMateServlet.class);
    static final String AUTOMATESERVLET = "AutoMateServlet";
    private static AutoMateSystemDefinitionsDM autoMateSystemDefinitionsDM;
    private static AutoMateHelper autoMateHelper;
    private static AutomateV11Helper automateV11Helper;

    public static String getAutoMateTasksJSON(long l, String string) throws Exception {
        return AutoMateServlet.getAutoMateTasksJSON(l, string, AutoMateSearchSelection.PATH_OR_ID);
    }

    public static int validateSystemDefinition(int n, String string, String string2, String string3, String string4) throws Exception {
        AutoMateSystemDefinition autoMateSystemDefinition = new AutoMateSystemDefinition();
        autoMateSystemDefinition.setEndPointURL(string);
        autoMateSystemDefinition.setEncryptedPassword(string3);
        autoMateSystemDefinition.setPasswordSalt(string4);
        AutoMateSystemType autoMateSystemType = AutoMateSystemType.persistanceCodeToEnum((int)n);
        try {
            switch (autoMateSystemType) {
                case AUTOMATE_V10: {
                    AutoMateServlet.getAutoMateHelper().validateSystemDefinition(autoMateSystemType, autoMateSystemDefinition, string2);
                    break;
                }
                case AUTOMATE_BPA_SERVER_V10: {
                    autoMateSystemDefinition.setUsername(string2);
                    AutoMateServlet.getAutoMateHelper().validateSystemDefinition(autoMateSystemType, autoMateSystemDefinition, string2);
                    break;
                }
                case AUTOMATE_V11: {
                    autoMateSystemDefinition.setVersion(11000);
                    AutoMateServlet.getAutomateV11Helper().validateSystemDefinition(autoMateSystemType, autoMateSystemDefinition, string2);
                    break;
                }
                case AUTOMATE_ENTERPRISE_V11: {
                    autoMateSystemDefinition.setUsername(string2);
                    AutoMateServlet.getAutomateV11Helper().validateSystemDefinition(autoMateSystemType, autoMateSystemDefinition, string2);
                    break;
                }
                default: {
                    throw new Exception("Invalid systemType of " + n + " passed.");
                }
            }
        }
        catch (Exception exception) {
            AutoMateServlet.logException(exception);
            AutoMateServlet.processAutomateException(exception, autoMateSystemDefinition.getEndPointURL());
        }
        return 0;
    }

    private static void processAutomateException(Exception exception, String string) throws Exception {
        if (exception instanceof AxisFault || exception instanceof IllegalArgumentException || exception instanceof ServiceException) {
            String string2 = string.trim().length() == 0 ? "Endpoint URL is empty." : "Error connecting to URL '" + string + "'";
            logger.error((Object)string2);
            throw new Exception(string2, exception);
        }
        throw new Exception(exception.getMessage());
    }

    public static String getAutoMateBPATaskAgentsJSON(long l, String string) throws Exception {
        if (string == null) {
            throw new Exception("searchString cannot be null");
        }
        AutoMateSystemDefinition autoMateSystemDefinition = AutoMateServlet.getAutoMateSystemDefinitionsDM().getAutoMateSystemDefinition(l);
        try {
            switch (autoMateSystemDefinition.getAutoMateSystemType()) {
                case AUTOMATE_BPA_SERVER_V10: {
                    return AutoMateServlet.getAutoMateHelper().getAutoMateBPATaskAgentsJSON(autoMateSystemDefinition, string);
                }
                case AUTOMATE_ENTERPRISE_V11: {
                    return AutoMateServlet.getAutomateV11Helper().getAutomateEnterpriseTaskAgentsJSON(autoMateSystemDefinition, string);
                }
            }
            throw new Exception("Invalid systemType of " + autoMateSystemDefinition.getAutoMateSystemType() + " passed.");
        }
        catch (Exception exception) {
            AutoMateServlet.logException(exception);
            AutoMateServlet.processAutomateException(exception, autoMateSystemDefinition.getEndPointURL());
            throw exception;
        }
    }

    public static String getAutoMateBPAProcessAgentsJSON(long l, String string) throws Exception {
        if (string == null) {
            throw new Exception("searchString cannot be null");
        }
        AutoMateSystemDefinition autoMateSystemDefinition = AutoMateServlet.getAutoMateSystemDefinitionsDM().getAutoMateSystemDefinition(l);
        try {
            switch (autoMateSystemDefinition.getAutoMateSystemType()) {
                case AUTOMATE_BPA_SERVER_V10: {
                    return AutoMateServlet.getAutoMateHelper().getAutoMateBPAProcessAgentsJSON(autoMateSystemDefinition, string);
                }
                case AUTOMATE_ENTERPRISE_V11: {
                    return AutoMateServlet.getAutomateV11Helper().getAutomateEnterpriseProcessAgentsJSON(autoMateSystemDefinition, string);
                }
            }
            throw new Exception("Invalid System Type of " + autoMateSystemDefinition.getAutoMateSystemType() + " passed.");
        }
        catch (Exception exception) {
            AutoMateServlet.logException(exception);
            AutoMateServlet.processAutomateException(exception, autoMateSystemDefinition.getEndPointURL());
            throw exception;
        }
    }

    public static String getAutoMateBPAAgentGroupsJSON(long l, String string) throws Exception {
        return AutoMateServlet.getAutoMateBPAAgentGroupsJSON(l, string, AutoMateSearchSelection.PATH_OR_ID);
    }

    public static String getAutoMateBPATasksJSON(long l, String string) throws Exception {
        return AutoMateServlet.getAutoMateBPARepositoryObjectsJSON(l, string, AutoMateSearchSelection.PATH_OR_ID, RepositoryContents.TASKS);
    }

    public static String getAutoMateBPAWorkflowsJSON(long l, String string) throws Exception {
        return AutoMateServlet.getAutoMateBPARepositoryObjectsJSON(l, string, AutoMateSearchSelection.PATH_OR_ID, RepositoryContents.WORKFLOWS);
    }

    public static String getAutoMateBPAProcessesJSON(long l, String string) throws Exception {
        return AutoMateServlet.getAutoMateBPARepositoryObjectsJSON(l, string, AutoMateSearchSelection.PATH_OR_ID, RepositoryContents.PROCESSES);
    }

    public static void touchTest() {
        logger.debug((Object)"*** AutoMateServlet touched.");
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        servletResponse.setContentType("text/html");
        String string = "Server Information not available";
        PrintWriter printWriter = servletResponse.getWriter();
        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD><TITLE>Automate Status</TITLE></HEAD>\n<BODY>\n<H1>Enterprise Server</H1>\n<p>" + string + "</p>" + "</BODY></HTML>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static String getAutoMateBPARepositoryObjectsJSON(long var0, String var2_1, AutoMateSearchSelection var3_2, RepositoryContents var4_3) throws Exception {
        if (var2_1 == null) {
            throw new Exception("searchString cannot be null");
        }
        var5_4 = "[";
        AutoMateServlet.logger.debug((Object)("*** About to retrieve Automate BPA " + var4_3 + " for Automate BPA System Definition ID " + var0 + " using search string '" + var2_1 + "'"));
        var6_5 = AutoMateServlet.getAutoMateSystemDefinitionsDM().getAutoMateSystemDefinition(var0);
        try {
            switch (1.$SwitchMap$com$helpsystems$enterprise$core$busobj$automate$AutoMateSystemType[var6_5.getAutoMateSystemType().ordinal()]) {
                case 2: {
                    var5_4 = var5_4 + AutoMateServlet.getAutoMateHelper().getAutoMateBPARepositoryObjectsJSON(var6_5, var2_1, var3_2, var4_3);
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                case 4: {
                    var5_4 = var5_4 + AutoMateServlet.getAutomateV11Helper().getAutomateEnterpriseRepositoryObjectsJSON(var6_5, var2_1, var3_2, var4_3);
                    ** break;
lbl15:
                    // 1 sources

                    break;
                }
                default: {
                    throw new Exception("Invalid System Type of " + var6_5.getAutoMateSystemType() + " passed.");
                }
            }
        }
        catch (Exception var7_6) {
            AutoMateServlet.logException(var7_6);
            AutoMateServlet.processAutomateException(var7_6, var6_5.getEndPointURL());
        }
        finally {
            var5_4 = var5_4 + "]";
        }
        if (AutoMateServlet.logger.isDebugEnabled()) {
            AutoMateServlet.logger.debug((Object)("Object list as JSON: " + var5_4));
        }
        return var5_4;
    }

    private static AutoMateHelper getAutoMateHelper() {
        if (autoMateHelper == null) {
            autoMateHelper = new AutoMateHelper(logger);
        }
        return autoMateHelper;
    }

    private static AutomateV11Helper getAutomateV11Helper() {
        if (automateV11Helper == null) {
            automateV11Helper = new AutomateV11Helper(logger);
        }
        return automateV11Helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static String getAutoMateBPAAgentGroupsJSON(long var0, String var2_1, AutoMateSearchSelection var3_2) throws Exception {
        if (var2_1 == null) {
            throw new Exception("searchString cannot be null");
        }
        var4_3 = "[";
        AutoMateServlet.logger.debug((Object)("*** About to retrieve Automate Agent Groups for Automate System Definition ID " + var0 + " using search string '" + var2_1 + "'"));
        var5_4 = "N/A";
        var6_5 = AutoMateServlet.getAutoMateSystemDefinitionsDM().getAutoMateSystemDefinition(var0);
        var5_4 = var6_5.getUsername();
        try {
            switch (1.$SwitchMap$com$helpsystems$enterprise$core$busobj$automate$AutoMateSystemType[var6_5.getAutoMateSystemType().ordinal()]) {
                case 2: {
                    var4_3 = var4_3 + AutoMateServlet.getAutoMateHelper().getAutoMateBPAAgentGroupsJSON(var5_4, var6_5, var2_1, var3_2);
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                case 4: {
                    var4_3 = var4_3 + AutoMateServlet.getAutomateV11Helper().getAutomateEnterpriseAgentGroupsJSON(var5_4, var6_5, var2_1, var3_2);
                    ** break;
lbl17:
                    // 1 sources

                    break;
                }
                default: {
                    throw new Exception("Invalid system Type of " + var6_5.getAutoMateSystemType() + " passed.");
                }
            }
        }
        catch (Exception var7_6) {
            AutoMateServlet.logException(var7_6);
            AutoMateServlet.processAutomateException(var7_6, var6_5.getEndPointURL());
        }
        finally {
            var4_3 = var4_3 + "]";
        }
        if (AutoMateServlet.logger.isDebugEnabled()) {
            AutoMateServlet.logger.debug((Object)("Agent Group List JSON: " + var4_3));
        }
        return var4_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getAutoMateTasksJSON(long l, String string, AutoMateSearchSelection autoMateSearchSelection) throws Exception {
        if (string == null) {
            throw new Exception("searchString cannot be null");
        }
        String string2 = "[";
        logger.debug((Object)("About to retrieve Automate Tasks for Automate System Definition ID " + l + " using search string '" + string + "' by " + autoMateSearchSelection));
        AutoMateSystemDefinition autoMateSystemDefinition = AutoMateServlet.getAutoMateSystemDefinitionsDM().getAutoMateSystemDefinition(l);
        try {
            switch (autoMateSystemDefinition.getAutoMateSystemType()) {
                case AUTOMATE_V10: {
                    string2 = string2 + AutoMateServlet.getAutoMateHelper().getAutoMateTasksJSON(autoMateSystemDefinition, string, autoMateSearchSelection);
                    return string2;
                }
                case AUTOMATE_V11: {
                    string2 = string2 + AutoMateServlet.getAutomateV11Helper().getAutoMateTasksJSON(autoMateSystemDefinition, string, autoMateSearchSelection);
                    return string2;
                }
                default: {
                    throw new Exception("Invalid System Type of " + autoMateSystemDefinition.getAutoMateSystemType() + " passed.");
                }
            }
        }
        catch (Exception exception) {
            AutoMateServlet.logException(exception);
            AutoMateServlet.processAutomateException(exception, autoMateSystemDefinition.getEndPointURL());
            return string2;
        }
        finally {
            string2 = string2 + "]";
        }
    }

    private static AutoMateSystemDefinitionsDM getAutoMateSystemDefinitionsDM() {
        if (autoMateSystemDefinitionsDM == null) {
            autoMateSystemDefinitionsDM = (AutoMateSystemDefinitionsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AutoMateSystemDefinitionsDM");
        }
        return autoMateSystemDefinitionsDM;
    }

    private static void logException(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            try {
                logger.error((Object)"Exception:", throwable);
            }
            catch (Throwable throwable2) {
                logger.error((Object)"Error logging Exception.");
            }
            return;
        }
        try {
            logger.error((Object)throwable.getMessage());
            if (throwable.getCause() != null) {
                AutoMateServlet.logException(throwable.getCause());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        logger = Logger.getLogger(AutoMateServlet.class);
        logger.debug((Object)"AutoMateServlet loaded.");
    }
}

