/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.windows;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.server.busobj.BasicProcessInfo;
import com.helpsystems.enterprise.module.windows.NativeProcessList;
import com.helpsystems.enterprise.module.windows.Process32;
import com.helpsystems.enterprise.module.windows.WMICProcessInfo;
import com.helpsystems.enterprise.module.windows.WMIC_Reader;
import com.helpsystems.enterprise.module.windows.WindowsException;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ProcessSnapshot {
    private static final Logger logger = Logger.getLogger(ProcessSnapshot.class);
    static int queryFlags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BasicProcessInfo[] getList() throws ResourceUnavailableException {
        ArrayList<BasicProcessInfo> arrayList = new ArrayList<BasicProcessInfo>();
        WinNT.HANDLE hANDLE = Process32.INSTANCE.CreateToolhelp32Snapshot(2, 0);
        if (hANDLE == null) {
            throw new ResourceUnavailableException("Couldn't get a handle to all processes.");
        }
        try {
            boolean bl = true;
            Process32.PROCESSENTRY32 pROCESSENTRY32 = new Process32.PROCESSENTRY32();
            HashMap<String, WMICProcessInfo> hashMap = new HashMap<String, WMICProcessInfo>();
            WMICProcessInfo[] wMICProcessInfoArray = WMIC_Reader.getProcessList();
            for (int i = 0; i < wMICProcessInfoArray.length; ++i) {
                hashMap.put(wMICProcessInfoArray[i].pid, wMICProcessInfoArray[i]);
            }
            while (true) {
                String string;
                int n;
                boolean bl2;
                String string2 = null;
                String string3 = null;
                if (bl) {
                    bl2 = Process32.INSTANCE.Process32First(hANDLE, pROCESSENTRY32);
                    bl = false;
                } else {
                    bl2 = Process32.INSTANCE.Process32Next(hANDLE, pROCESSENTRY32);
                }
                if (!bl2) {
                    n = Kernel32.INSTANCE.GetLastError();
                    if (n == 18) {
                        break;
                    }
                    logger.debug((Object)("Unable to get process info, Windows error " + n));
                }
                if ((n = pROCESSENTRY32.th32ProcessID) == 0) continue;
                int n2 = queryFlags;
                if (queryFlags == 0) {
                    n2 = 1040;
                }
                WinNT.HANDLE hANDLE2 = Process32.INSTANCE.OpenProcess(n2, false, n);
                if (queryFlags == 0) {
                    if (hANDLE2 == null) {
                        n2 = 4096;
                        hANDLE2 = Process32.INSTANCE.OpenProcess(n2, false, n);
                    }
                    if (hANDLE2 != null) {
                        queryFlags = n2;
                    }
                }
                if (hashMap.containsKey(string = String.valueOf(n))) {
                    string2 = ((WMICProcessInfo)hashMap.get((Object)string)).commandLine;
                }
                if (hANDLE2 != null) {
                    try {
                        string3 = NativeProcessList.getProcessUser(hANDLE2, "<N/A>", n);
                        if (string2 == null && n2 != 4096) {
                            string2 = NativeProcessList.getProcessName(hANDLE2);
                        }
                    }
                    catch (WindowsException windowsException) {
                        if (n != 4 || windowsException.getErrorCode() != 5) {
                            logger.trace((Object)windowsException.getMessage());
                        } else {
                            logger.debug((Object)windowsException);
                        }
                    }
                    finally {
                        Kernel32.INSTANCE.CloseHandle(hANDLE2);
                    }
                }
                if (string2 == null) {
                    string2 = ProcessSnapshot.convString(pROCESSENTRY32.exeFile);
                }
                if (string3 == null) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("User name is not available for process " + n + " (" + string2 + ")"));
                    continue;
                }
                BasicProcessInfo basicProcessInfo = new BasicProcessInfo();
                basicProcessInfo.setPid(Integer.toString(n));
                if ("Administrators".equalsIgnoreCase(string3) || "BUILTIN\\Administrators".equalsIgnoreCase(string3)) {
                    string3 = "SYSTEM";
                }
                basicProcessInfo.setUser(string3);
                basicProcessInfo.setCommand(string2);
                arrayList.add(basicProcessInfo);
            }
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Exception encountered while getting list of processes.");
            logger.debug((Object)throwable);
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(hANDLE);
        }
        BasicProcessInfo[] basicProcessInfoArray = new BasicProcessInfo[arrayList.size()];
        arrayList.toArray(basicProcessInfoArray);
        return basicProcessInfoArray;
    }

    static String convString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)byArray[i];
            if (c == '\u0000') {
                if (++n <= 10) continue;
                break;
            }
            n = 0;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

