/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.webservice;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.enterprise.core.util.SkybotURLHelper;
import com.helpsystems.enterprise.module.webservice.HttpsClientTrustingAllCerts;
import com.helpsystems.enterprise.module.webservice.WebServiceDetails;
import com.helpsystems.enterprise.module.webservice.WebServiceMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.UnknownHostException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WebServiceWorker {
    public static void main(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringArray[i].replace("^", "");
        }
        WebServiceDetails webServiceDetails = new WebServiceDetails();
        String string = "";
        try {
            webServiceDetails.parseParameters(stringArray);
            string = webServiceDetails.getServerurl();
        }
        catch (ActionFailedException actionFailedException) {
            WebServiceWorker.exit(1, "Command failed: " + actionFailedException.getMessage() + "\nThe -h option will show command help.");
        }
        try {
            Object object;
            HttpsClientTrustingAllCerts httpsClientTrustingAllCerts;
            DefaultHttpClient defaultHttpClient = null;
            if (webServiceDetails.isUseHttps()) {
                httpsClientTrustingAllCerts = new HttpsClientTrustingAllCerts(webServiceDetails.isSsl());
                defaultHttpClient = httpsClientTrustingAllCerts.httpClientTrustingAllSSLCerts();
            } else {
                defaultHttpClient = new DefaultHttpClient();
            }
            httpsClientTrustingAllCerts = null;
            String string2 = new String(Base64.encodeBase64((byte[])(webServiceDetails.getUsername() + ":" + webServiceDetails.getPassword()).getBytes("UTF-8")));
            if (webServiceDetails.getAction().equalsIgnoreCase("delete")) {
                httpsClientTrustingAllCerts = WebServiceWorker.sendDeleteRequest(webServiceDetails.getServerUrl(false), (HttpClient)defaultHttpClient, string2);
            } else if (webServiceDetails.getAction().equalsIgnoreCase("create")) {
                httpsClientTrustingAllCerts = WebServiceWorker.addJob(webServiceDetails.getServerUrl(true), webServiceDetails.getFileName(), (HttpClient)defaultHttpClient, string2);
            } else if (webServiceDetails.getAction().equalsIgnoreCase("index") || webServiceDetails.getAction().equalsIgnoreCase("all_jobs")) {
                WebServiceWorker.exit(1, "Error: Action '" + webServiceDetails.getAction() + "' of Controller '" + webServiceDetails.getType() + "' is not available through a web service!");
            } else if (webServiceDetails.getAction().equalsIgnoreCase("get")) {
                object = webServiceDetails.getUrl();
                object = SkybotURLHelper.makeURLSafe((String)object);
                HttpGet httpGet = new HttpGet((String)object);
                httpGet.addHeader("Authorization", "Basic " + string2);
                httpGet.addHeader("Accept", "application/xml");
                httpsClientTrustingAllCerts = defaultHttpClient.execute((HttpUriRequest)httpGet);
            } else {
                object = webServiceDetails.getUrl();
                object = SkybotURLHelper.makeURLSafe((String)object);
                HttpGet httpGet = new HttpGet((String)object);
                httpGet.addHeader("Authorization", "Basic " + string2);
                httpGet.addHeader("Accept", "application/xml");
                httpsClientTrustingAllCerts = defaultHttpClient.execute((HttpUriRequest)httpGet);
            }
            if (httpsClientTrustingAllCerts.getStatusLine().getStatusCode() != 200 && httpsClientTrustingAllCerts.getStatusLine().getStatusCode() != 401) {
                WebServiceWorker.exit(1, "Command failed: " + httpsClientTrustingAllCerts.getStatusLine().toString());
            }
            object = null;
            object = webServiceDetails.getAction().equalsIgnoreCase("get") ? WebServiceWorker.getSucceedHandle((HttpResponse)httpsClientTrustingAllCerts, webServiceDetails) : (webServiceDetails.getAction().equalsIgnoreCase("find_id_by_name") ? WebServiceWorker.getSucceedHandleFindId((HttpResponse)httpsClientTrustingAllCerts) : WebServiceWorker.getErrorHandle((HttpResponse)httpsClientTrustingAllCerts));
            if (object != null) {
                WebServiceWorker.exit(((WebServiceMessage)object).getReturnCode(), ((WebServiceMessage)object).getMessageText());
            } else {
                System.out.println("Response Status Line: " + httpsClientTrustingAllCerts.getStatusLine());
                System.out.println("Response Status Code: " + httpsClientTrustingAllCerts.getStatusLine().getStatusCode());
                System.out.println("Response Reason Phrase: " + httpsClientTrustingAllCerts.getStatusLine().getReasonPhrase());
                WebServiceWorker.exit(1, "Command failed: Unable to parse the response.");
            }
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            WebServiceWorker.exit(1, "Command failed: This Automate Schedule server is configured for secure connections but the certificate is Untrusted.\nUse the -ssl=any option parameter to accept the Untrusted Connection.");
        }
        catch (HttpHostConnectException httpHostConnectException) {
            WebServiceWorker.exit(1, "Command failed: Connection to " + string + " refused.");
        }
        catch (ClientProtocolException clientProtocolException) {
            WebServiceWorker.exit(1, "Command failed: The server failed to respond with a valid HTTP response.");
        }
        catch (UnknownHostException unknownHostException) {
            WebServiceWorker.exit(1, "Command failed: Could not connect to " + string + " the host is unknown.");
        }
        catch (Exception exception) {
            System.out.println("Failed. Cause: " + exception.getMessage());
            if (exception.getCause() != null) {
                System.out.println(exception.getCause().getMessage());
            }
            WebServiceWorker.exit(1, "Command failed: " + exception.getLocalizedMessage(), exception);
        }
    }

    private static HttpResponse sendDeleteRequest(String string, HttpClient httpClient, String string2) throws ClientProtocolException, IOException {
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Accept", "application/xml");
        httpDelete.addHeader("Authorization", "Basic " + string2);
        return httpClient.execute((HttpUriRequest)httpDelete);
    }

    private static HttpResponse addJob(String string, String string2, HttpClient httpClient, String string3) throws ClientProtocolException, IOException {
        HttpPost httpPost = new HttpPost(string);
        httpPost.addHeader("Accept", "application/xml");
        httpPost.addHeader("Authorization", "Basic " + string3);
        File file = new File(string2);
        InputStreamEntity inputStreamEntity = new InputStreamEntity((InputStream)new FileInputStream(file), -1L);
        inputStreamEntity.setContentType("application/xml");
        inputStreamEntity.setChunked(true);
        httpPost.setEntity((HttpEntity)inputStreamEntity);
        return httpClient.execute((HttpUriRequest)httpPost);
    }

    private static WebServiceMessage getSucceedHandleFindId(HttpResponse httpResponse) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(httpResponse.getEntity().getContent());
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("response");
        WebServiceMessage webServiceMessage = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            int n = 1;
            if (WebServiceWorker.getValue("result", element).equals("succeed")) {
                n = 0;
            }
            if (n == 1) {
                webServiceMessage = new WebServiceMessage(n, WebServiceWorker.getMessage("message", element));
                continue;
            }
            String string = WebServiceWorker.getValue("id", element);
            webServiceMessage = new WebServiceMessage(n, "The object id is " + string);
        }
        return webServiceMessage;
    }

    private static WebServiceMessage getErrorHandle(HttpResponse httpResponse) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(httpResponse.getEntity().getContent());
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("response");
        WebServiceMessage webServiceMessage = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            int n = 1;
            if (WebServiceWorker.getValue("result", element).equals("succeed")) {
                n = 0;
            }
            webServiceMessage = new WebServiceMessage(n, WebServiceWorker.getMessage("message", element));
        }
        return webServiceMessage;
    }

    private static WebServiceMessage getSucceedHandle(HttpResponse httpResponse, WebServiceDetails webServiceDetails) throws Exception {
        String string = WebServiceWorker.getResponseMessage(httpResponse);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("response");
        WebServiceMessage webServiceMessage = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            int n = 1;
            if (WebServiceWorker.getValue("result", element).equals("succeed")) {
                n = 0;
            }
            webServiceMessage = (string2 = WebServiceWorker.writeToFile(string, webServiceDetails)) != null ? new WebServiceMessage(n, "Your HTTP response has been successfully saved in " + string2 + " file.") : new WebServiceMessage(1, "Command failed: Failed to save HTTP response in file.");
        }
        return webServiceMessage;
    }

    private static String getResponseMessage(HttpResponse httpResponse) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuilder.append(string2).append(string);
        }
        return stringBuilder.toString();
    }

    private static String getValue(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string).item(0).getChildNodes();
        Node node = nodeList.item(0);
        return node.getNodeValue();
    }

    private static String getMessage(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string);
        String string2 = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                for (int k = 0; k < node2.getChildNodes().getLength(); ++k) {
                    String string3 = node2.getChildNodes().item(k).getNodeValue();
                    string2 = node2.getNodeName().equals("type") ? string2 + Character.toUpperCase(string3.charAt(0)) + string3.substring(1) + ": " : string2 + string3.trim() + System.getProperty("line.separator");
                }
            }
        }
        return string2;
    }

    private static void exit(int n, String string) {
        WebServiceWorker.exit(n, string, null);
    }

    private static void exit(int n, String string, Throwable throwable) {
        if (string != null) {
            System.err.println(string);
            System.err.flush();
        }
        if (throwable != null) {
            throwable.printStackTrace(System.err);
            System.err.flush();
        }
        System.exit(n);
    }

    public static String writeToFile(String string, WebServiceDetails webServiceDetails) {
        Writer writer = null;
        String string2 = webServiceDetails.getFilepath() + "/";
        string2 = webServiceDetails.getFileName() != null ? string2 + webServiceDetails.getFileName() : string2 + System.currentTimeMillis() + ".xml";
        try {
            if (writer == null) {
                writer = new FileWriter(new File(string2));
            }
            if (writer != null) {
                writer.write(string);
                ((OutputStreamWriter)writer).flush();
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return string2;
    }
}

