/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.webservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpsClientTrustingAllCerts {
    private boolean ssl;

    public HttpsClientTrustingAllCerts(boolean bl) {
        this.ssl = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DefaultHttpClient httpClientTrustingAllSSLCerts() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        DefaultHttpClient defaultHttpClient = null;
        if (!this.ssl) {
            String string = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
            File file = new File(string);
            if (!file.exists()) throw new CertificateException("Command failed: This Automate Schedule server is configured for secure connections but the certificate is Untrusted.\nUse the -ssl=any option parameter to accept the Untrusted Connection.");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fileInputStream = new FileInputStream(string);){
                keyStore.load(fileInputStream, null);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, null);
            X509KeyManager x509KeyManager = (X509KeyManager)keyManagerFactory.getKeyManagers()[0];
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(new KeyManager[]{x509KeyManager}, null, null);
            SSLSocketFactory sSLSocketFactory = new SSLSocketFactory(sSLContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Scheme scheme = new Scheme("https", 443, (SchemeSocketFactory)sSLSocketFactory);
            defaultHttpClient = new DefaultHttpClient();
            defaultHttpClient.getConnectionManager().getSchemeRegistry().register(scheme);
            return defaultHttpClient;
        }
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        sSLContext.init(null, this.getTrustingManager(), new SecureRandom());
        SSLSocketFactory sSLSocketFactory = new SSLSocketFactory(sSLContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Scheme scheme = new Scheme("https", 443, (SchemeSocketFactory)sSLSocketFactory);
        defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getConnectionManager().getSchemeRegistry().register(scheme);
        return defaultHttpClient;
    }

    public TrustManager[] getTrustingManager() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
        return trustManagerArray;
    }
}

