/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.unix;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.server.busobj.BasicProcessInfo;
import com.helpsystems.common.server.dm.ActiveProcessAM;
import com.helpsystems.enterprise.module.AbstractActiveProcessAM;
import com.helpsystems.enterprise.module.exec.PipeCleaner;
import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnixActiveProcessAM
extends AbstractActiveProcessAM
implements ActiveProcessAM {
    private static final Logger logger = Logger.getLogger(UnixActiveProcessAM.class);
    private static final String[] PS_COMMAND = new String[]{"ps", "-eo", "pid,user,args"};
    private static final String PS_COMMAND_STRING = UnixActiveProcessAM.makeString(PS_COMMAND);
    private static long lastEncodingComplaint;
    private static Object complaintLock;

    public UnixActiveProcessAM() throws ResourceUnavailableException {
        this.setName("COMMON.ActiveProcessAM");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BasicProcessInfo[] listProcesses() throws ResourceUnavailableException {
        BasicProcessInfo[] basicProcessInfoArray;
        ArrayList<BasicProcessInfo> arrayList = new ArrayList<BasicProcessInfo>();
        boolean bl = true;
        Process process = null;
        BufferedReader bufferedReader = null;
        try {
            basicProcessInfoArray = new ProcessBuilder(PS_COMMAND);
            Map<String, String> map = basicProcessInfoArray.environment();
            map.put("UNIX_STD", "2003");
            map.put("UNIX95", "1");
            process = basicProcessInfoArray.start();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean bl2 = false;
            block16: while (!bl2) {
                try {
                    process.exitValue();
                    bl2 = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (true) {
                    String string = bufferedReader.readLine();
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    if (string == null) continue block16;
                    String[] stringArray = string.trim().split("\\s+");
                    if (stringArray.length <= 2) continue;
                    BasicProcessInfo basicProcessInfo = new BasicProcessInfo();
                    basicProcessInfo.setPid(stringArray[0]);
                    basicProcessInfo.setUser(stringArray[1]);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 2; i < stringArray.length; ++i) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(' ');
                        }
                        stringBuilder.append(stringArray[i]);
                    }
                    basicProcessInfo.setCommand(stringBuilder.toString());
                    if (basicProcessInfo.getCommand().endsWith(PS_COMMAND_STRING)) continue;
                    arrayList.add(basicProcessInfo);
                }
            }
        }
        catch (Exception exception) {
            if (process != null) {
                PipeCleaner.addPipes(process);
            }
            String string = "Unable to get a list of processes.";
            if (exception instanceof CharConversionException) {
                String string2 = Charset.defaultCharset().name();
                Object object = complaintLock;
                synchronized (object) {
                    long l = System.currentTimeMillis();
                    long l2 = l - lastEncodingComplaint;
                    string = "Returning a partial process listing due to a character encoding error.";
                    if (l2 / 1000L / 60L < 30L) {
                        logger.debug((Object)string);
                    } else {
                        string = string + "\nThe output from the 'ps' command contained bytes that are incompatible with the character encoding " + string2 + ".\n" + UnixActiveProcessAM.getCharConversionExceptionMessage();
                        logger.warn((Object)string, (Throwable)exception);
                        lastEncodingComplaint = l;
                    }
                    string = null;
                }
            }
            if (string != null) {
                throw new ResourceUnavailableException(string, (Throwable)exception);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        basicProcessInfoArray = new BasicProcessInfo[arrayList.size()];
        arrayList.toArray(basicProcessInfoArray);
        return basicProcessInfoArray;
    }

    public static String getCharConversionExceptionMessage() {
        String string = UnixActiveProcessAM.isIBMJava5() ? "IBM Java v1.5 ('Java 5') is unable to read the rest of the output from this process, however IBM Java v1.6 ('Java 6') is better at recovering from this type of problem." : " The rest of the process output cannot be read.";
        return string;
    }

    public static boolean isIBMJava5() {
        String string = System.getProperty("java.vendor");
        if (string == null) {
            string = System.getProperty("java.vm.vendor");
        }
        if (string == null) {
            return false;
        }
        String string2 = System.getProperty("java.version");
        if (string2 == null) {
            return false;
        }
        return string.startsWith("IBM") && string2.startsWith("1.5.");
    }

    private static String makeString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    static {
        complaintLock = new Object();
    }
}

