/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.sap;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.NotSavedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.AgentReturnCode;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.DeleteJobException;
import com.helpsystems.enterprise.core.busobj.EndJobException;
import com.helpsystems.enterprise.core.busobj.EnterpriseLicenseInfo;
import com.helpsystems.enterprise.core.busobj.EnterpriseProductLicense;
import com.helpsystems.enterprise.core.busobj.JobHistory;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPProgram;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStep;
import com.helpsystems.enterprise.core.busobj.sap.SAPABAPStepSet;
import com.helpsystems.enterprise.core.busobj.sap.SAPChildJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPConnectionType;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriteria;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriteriaField;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriteriaItem;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriteriaNode;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriterion;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriterionProfile;
import com.helpsystems.enterprise.core.busobj.sap.SAPCriterionProfiles;
import com.helpsystems.enterprise.core.busobj.sap.SAPEvent;
import com.helpsystems.enterprise.core.busobj.sap.SAPEventHistory;
import com.helpsystems.enterprise.core.busobj.sap.SAPEventMonitor;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutable;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutableJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPExecutableProcessChain;
import com.helpsystems.enterprise.core.busobj.sap.SAPFunctionException;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptCriteria;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptCriterion;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptedJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobNotFoundException;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobProcessor;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobProxy;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobSelectParameters;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobSelection;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobSimple;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobSpoolRequest;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobStatus;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobTimeType;
import com.helpsystems.enterprise.core.busobj.sap.SAPLanguageKeys;
import com.helpsystems.enterprise.core.busobj.sap.SAPOutputDevice;
import com.helpsystems.enterprise.core.busobj.sap.SAPPollInfoComparator;
import com.helpsystems.enterprise.core.busobj.sap.SAPPollJobsInfo;
import com.helpsystems.enterprise.core.busobj.sap.SAPProfileTypeSelection;
import com.helpsystems.enterprise.core.busobj.sap.SAPReturnMessage;
import com.helpsystems.enterprise.core.busobj.sap.SAPStep;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystem;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemDefinition;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemEnvironment;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemSetup;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantAction;
import com.helpsystems.enterprise.core.busobj.sap.SAPVariantActionList;
import com.helpsystems.enterprise.core.busobj.sap.SAPXBPVersion;
import com.helpsystems.enterprise.core.busobj.sap.actions.SAPPollJobsEvent;
import com.helpsystems.enterprise.core.busobj.traps.SAPEventSNMPTrap;
import com.helpsystems.enterprise.core.dm.EnterpriseEmailAM;
import com.helpsystems.enterprise.core.dm.EnterpriseLicenseInfoAM;
import com.helpsystems.enterprise.core.dm.EnterpriseSNMPTrapAM;
import com.helpsystems.enterprise.core.dm.NotificationListDM;
import com.helpsystems.enterprise.core.dm.sap.SAPEventHistoryDM;
import com.helpsystems.enterprise.core.dm.sap.SAPEventMonitorDM;
import com.helpsystems.enterprise.core.dm.sap.SAPEventsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptedJobMonitorAM;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptedJobsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPJobDefinitionsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPJobsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPProcessChainsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPServerHelperAM;
import com.helpsystems.enterprise.core.dm.sap.SAPSystemSetupDM;
import com.helpsystems.enterprise.core.dm.sap.SAPVariantActionsDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.module.sap.SAPConnection;
import com.helpsystems.enterprise.module.sap.SAPConnectionProvider;
import com.helpsystems.enterprise.module.sap.SAPFunctionUtility;
import com.helpsystems.enterprise.peer.AgentPeer;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.math.BigDecimal;
import java.security.InvalidParameterException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.log4j.Logger;

public class SAPServerHelperAMImpl
extends SAPConnectionProvider
implements SAPServerHelperAM {
    private static final Logger logger = Logger.getLogger(SAPServerHelperAMImpl.class);
    private static final String XBP_30_STRING = "3.0";
    private static final String XBP_20_STRING = "2.0";
    private static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    private static PriorityBlockingQueue<SAPPollJobsInfo> collectorPollQueue;
    private static BlockingQueue<SAPPollJobsInfo> removerPollQueue;
    private ArrayList<Long> requestsToTerminateAL = new ArrayList();
    private SAPJobDefinitionsDM sapJobDefinitionsDM;
    private SAPEventsDM sapEventsDM;
    private SAPInterceptedJobsDM sapInterceptedJobsDM;
    private SAPVariantActionsDM sapVariantActionsDM;
    private SAPProcessChainsDM sapProcessChainsDM;
    private SAPJobsDM sapJobsDM;
    private AgentPeer peer;
    private Thread sapJobCollectorThread;
    private SAPJobCollectorRunner sapJobCollectorRunner;
    private Thread sapJobRemoverThread;
    private SAPJobRemoverRunner sapJobRemoverRunner;
    private SAPEventHistoryDM sapEventHistoryDM;
    private SAPInterceptedJobMonitorAM sapInterceptedJobMonitorAM;
    private EnterpriseEmailAM enterpriseEmailAM;
    private EnterpriseSNMPTrapAM enterpriseSNMPTrapAM;

    public SAPServerHelperAMImpl(AgentPeer agentPeer, boolean bl) {
        this.setName("ENTERPRISE.SAPServerHelperAM");
        this.peer = agentPeer;
        this.init(bl);
    }

    private void init(boolean bl) {
        if (bl) {
            logger.debug((Object)"License valid for SAP.  OK to start processes.");
            this.startSAPJobCollector();
            this.startSAPJobRemover();
        } else {
            logger.debug((Object)"License is not valid for SAP.");
        }
    }

    private void startSAPJobCollector() {
        if (this.sapJobCollectorThread == null || !this.sapJobCollectorThread.isAlive()) {
            this.sapJobCollectorRunner = new SAPJobCollectorRunner();
            this.sapJobCollectorThread = new Thread(this.sapJobCollectorRunner);
            this.sapJobCollectorThread.setName("SAPJobCollector");
            this.sapJobCollectorThread.start();
        }
    }

    private void startSAPJobRemover() {
        if (this.sapJobRemoverThread == null || !this.sapJobRemoverThread.isAlive()) {
            this.sapJobRemoverRunner = new SAPJobRemoverRunner();
            this.sapJobRemoverThread = new Thread(this.sapJobRemoverRunner);
            this.sapJobRemoverThread.setName("SAPJobRemover");
            this.sapJobRemoverThread.start();
        }
    }

    @Override
    public void stopCollectorProcesses() {
        this.stopScheduledJobCollectorRunner();
        this.stopScheduledJobRemoverRunner();
    }

    private void stopScheduledJobCollectorRunner() {
        if (this.sapJobCollectorRunner != null) {
            this.sapJobCollectorRunner.shutdown = true;
            if (this.sapJobCollectorThread != null && this.sapJobCollectorThread.isAlive()) {
                this.sapJobCollectorThread.interrupt();
            }
        }
    }

    private void stopScheduledJobRemoverRunner() {
        if (this.sapJobRemoverRunner != null) {
            this.sapJobRemoverRunner.shutdown = true;
            if (this.sapJobRemoverThread != null && this.sapJobRemoverThread.isAlive()) {
                this.sapJobRemoverThread.interrupt();
            }
        }
    }

    private boolean isSAPOn() {
        return this.sapJobCollectorThread != null && this.sapJobCollectorThread.isAlive() && this.sapJobRemoverThread != null && this.sapJobRemoverThread.isAlive();
    }

    public AgentPeer getPeer() {
        return this.peer;
    }

    private void confirmCollectedJob(SAPConnection sAPConnection, SAPJobSimple sAPJobSimple) throws Exception {
        try {
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionConfirmJob(sAPConnection, sAPJobSimple);
            logger.debug((Object)("About to confirm SAP Job " + sAPJobSimple.getNameAndCount()));
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                logger.error((Object)("Error executing " + jCoFunction.getName()));
                String string = "SAP Error " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string);
                throw new Exception(string);
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBS");
            int n = jCoTable.getNumRows();
            if (n > 0) {
                logger.debug((Object)("SAP job " + sAPJobSimple.getNameAndCount() + " was not confirmed on the SAP System " + sAPConnection.getSapSystemDefinitionName() + " and will be deleted from Automate Schedule."));
                String string = this.getSAPJobsDM().delete(sAPJobSimple) ? "Deleted SAP Job " + sAPJobSimple.getNameAndCount() + " from Automate Schedule because it was not confirmed." : "SAP Job " + sAPJobSimple.getNameAndCount() + " for SAP System Definition ID " + sAPJobSimple.getSapSystemDefinitionID() + " was not deleted because it was not found in the Automate Schedule database.";
                logger.error((Object)string);
                throw new Exception(string);
            }
            this.getSAPJobsDM().updateToConfirmed(sAPJobSimple);
            logger.debug((Object)("Updated SAP Job " + sAPJobSimple.getNameAndCount() + " to confirmed in Automate Schedule."));
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error confirming collected SAP jobs.", (Throwable)jCoException);
        }
    }

    private int confirmCollectedJobs(SAPConnection sAPConnection, HashMap<String, SAPJobSimple> hashMap) throws Exception {
        int n = 0;
        ArrayList<SAPJobProxy> arrayList = new ArrayList<SAPJobProxy>();
        try {
            int n2;
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionConfirmJob(sAPConnection, hashMap.values());
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                logger.error((Object)("Error executing " + jCoFunction.getName()));
                String string = "SAP Error: " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string);
                throw new SAPFunctionException(string, sAPReturnMessage);
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBS");
            int n3 = 0;
            n3 = jCoTable.getNumRows();
            for (n2 = 0; n2 < n3; ++n2) {
                jCoTable.setRow(n2);
                String string = jCoTable.getString("JOBNAME");
                String string2 = jCoTable.getString("JOBCOUNT");
                SAPJobSimple sAPJobSimple = new SAPJobSimple(string, string2);
                arrayList.add(sAPJobSimple);
                hashMap.remove(sAPJobSimple.getNameAndCount());
            }
            if (arrayList.size() > 0) {
                logger.debug((Object)(arrayList.size() + " jobs were not confirmed on the SAP System " + sAPConnection.getSapSystemDefinitionName() + " and will be deleted from Automate Schedule."));
                n2 = this.getSAPJobsDM().delete(arrayList);
                logger.debug((Object)("Deleted " + n2 + " SAP job(s) that were not confirmed."));
            }
            if (hashMap.size() > 0) {
                n = this.getSAPJobsDM().updateToConfirmed(hashMap.values());
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error confirming collected SAP jobs.", (Throwable)jCoException);
        }
        return n;
    }

    private int loadSAPJobsIntoSkybot(SAPConnection sAPConnection, SAPJobSelection sAPJobSelection) throws ResourceUnavailableException {
        TimeZone timeZone = sAPConnection.getTimeZone();
        int n = 0;
        HashMap<String, SAPJobSimple> hashMap = new HashMap<String, SAPJobSimple>(10000);
        JCoFunction jCoFunction = null;
        SAPJobSelectParameters sAPJobSelectParameters = new SAPJobSelectParameters("*", "*", "*");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.PRELIM, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.SCHEDUL, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.READY, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.RUNNING, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.FINISHED, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.ABORTED, "X");
        try {
            jCoFunction = SAPFunctionUtility.getFunctionJobSelect(sAPConnection, sAPJobSelection, sAPJobSelectParameters);
            jCoFunction.getTableParameterList().setActive("SELECTED_JOBS", false);
            long l = System.currentTimeMillis();
            sAPConnection.executeMiddleFunction(jCoFunction);
            long l2 = System.currentTimeMillis();
            logger.debug((Object)("BAPI_XBP_JOB_SELECT took " + (l2 - l) / 1000L + " seconds"));
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string = "Error executing " + jCoFunction.getName() + ".  SAP Error " + sAPReturnMessage.getFullReturnMessage();
                if (sAPReturnMessage.getReturnID().equals("XM")) {
                    switch (sAPReturnMessage.getReturnNumber()) {
                        case 57: {
                            logger.debug((Object)string);
                            return n;
                        }
                    }
                    logger.warn((Object)("Unhandled SAP Message Number " + sAPReturnMessage.getReturnNumber() + " for XM message."));
                }
                throw new ResourceUnavailableException(string);
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOB_HEAD");
            int n2 = jCoTable.getNumRows();
            logger.debug((Object)("Found " + n2 + " job(s) using selection " + (Object)((Object)sAPJobSelection) + " on SAP System " + sAPConnection.getSapSystemDefinitionName()));
            SAPJobSimple sAPJobSimple = null;
            l = System.currentTimeMillis();
            for (int i = 0; i < n2; ++i) {
                if (this.sapJobCollectorRunner.isRequestedToStop(sAPConnection.getSapSystemDefinitionID())) {
                    return n;
                }
                jCoTable.setRow(i);
                try {
                    sAPJobSimple = this.getSAPJobFromRowJobHead(jCoTable, sAPConnection.getSapSystemDefinitionID(), timeZone);
                    hashMap.put(sAPJobSimple.getNameAndCount(), sAPJobSimple);
                    if (hashMap.size() < 10000) continue;
                    logger.debug((Object)("Total saved so far = " + (n += this.saveUnconfirmedGroup(hashMap))));
                    hashMap.clear();
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.warn((Object)"Error collecting SAP Job.", (Throwable)illegalArgumentException);
                }
            }
            if (hashMap.size() > 0) {
                n += this.saveUnconfirmedGroup(hashMap);
                hashMap.clear();
            }
            l2 = System.currentTimeMillis();
            logger.debug((Object)("Processing " + n2 + " jobs took " + (l2 - l) / 1000L + " seconds"));
        }
        catch (JCoException jCoException) {
            logger.error((Object)"Error in loadSAPJobsIntoSkybot", (Throwable)jCoException);
        }
        catch (NotSavedException notSavedException) {
            logger.warn((Object)("Error saving SAP Jobs collected from SAP System " + sAPConnection.getSapSystemDefinitionName()), (Throwable)notSavedException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error((Object)("Error collecting jobs from SAP System " + sAPConnection.getSapSystemDefinitionName()), (Throwable)outOfMemoryError);
        }
        return n;
    }

    private int loadSAPJobsIntoSkybotInitialPoll(SAPConnection sAPConnection, SAPJobSelection sAPJobSelection) throws ResourceUnavailableException {
        String string = "Initial Poll of SAP System " + sAPConnection.getSapSystemDefinitionName() + ":  ";
        HashMap<String, SAPJobSimple> hashMap = new HashMap<String, SAPJobSimple>(10000);
        int n = 0;
        SAPJobSelectParameters sAPJobSelectParameters = new SAPJobSelectParameters("*", "*", "*");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.PRELIM, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.SCHEDUL, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.READY, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.RUNNING, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.FINISHED, "X");
        sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.ABORTED, "X");
        try {
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobSelect(sAPConnection, sAPJobSelection, sAPJobSelectParameters);
            jCoFunction.getTableParameterList().setActive("JOB_HEAD", false);
            long l = System.currentTimeMillis();
            sAPConnection.executeMiddleFunction(jCoFunction);
            long l2 = System.currentTimeMillis();
            logger.debug((Object)(string + "BAPI_XBP_JOB_SELECT took " + (l2 - l) / 1000L + " seconds"));
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string2 = "Error executing " + jCoFunction.getName() + ".  SAP Error " + sAPReturnMessage.getFullReturnMessage();
                logger.warn((Object)(string + string2));
                throw new ResourceUnavailableException(string2);
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("SELECTED_JOBS");
            int n2 = jCoTable.getNumRows();
            logger.info((Object)(string + "Found " + n2 + " job(s) using selection " + (Object)((Object)sAPJobSelection)));
            String[] stringArray = new String[]{String.valueOf(n2), sAPConnection.getSapSystemDefinitionName()};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.SAP_INITIAL_POLL_START.newLogEntry(stringArray);
            ScheduleLogger.write(scheduleLogEntry);
            logger.debug((Object)scheduleLogEntry.getMessageText());
            logger.info((Object)"About to get job details and save into Automate Schedule...");
            SAPJobSimple sAPJobSimple = null;
            String string3 = "Unknown";
            JCoFunction jCoFunction2 = null;
            TimeZone timeZone = sAPConnection.getTimeZone();
            l = System.currentTimeMillis();
            for (int i = 0; i < n2; ++i) {
                if (this.sapJobCollectorRunner.isRequestedToStop(sAPConnection.getSapSystemDefinitionID())) {
                    logger.info((Object)(string + "Canceled.  " + n + " jobs were collected."));
                    return n;
                }
                jCoTable.setRow(i);
                try {
                    string3 = "Unknown";
                    sAPJobSimple = this.getSAPJobFromRowSelectedJobs(jCoTable, sAPConnection.getSapSystemDefinitionID());
                    string3 = sAPJobSimple.getNameAndCount();
                    jCoFunction2 = SAPFunctionUtility.getFunctionJobRead(sAPConnection, sAPJobSimple, true);
                    this.addSAPJobDetails(sAPJobSimple, jCoFunction2, sAPConnection, timeZone);
                    hashMap.put(sAPJobSimple.getNameAndCount(), sAPJobSimple);
                    if (hashMap.size() < 10000) continue;
                    logger.info((Object)(string + "Total saved so far = " + (n += this.saveUnconfirmedGroup(hashMap))));
                    hashMap.clear();
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.warn((Object)(string + "Error collecting SAP Job " + string3), (Throwable)illegalArgumentException);
                    continue;
                }
                catch (SAPFunctionException sAPFunctionException) {
                    if (!this.isXM28Error(sAPFunctionException)) continue;
                    logger.warn((Object)("A connection error occurred while performing the initial poll of SAP System Definition " + sAPConnection.getSapSystemDefinitionName() + ".  About to clear all jobs to reset for next poll attempt."));
                    try {
                        int n3 = this.getSAPJobsDM().deleteAll(sAPConnection.getSapSystemDefinitionID());
                        logger.debug((Object)("Deleted " + n3 + " SAP jobs from Automate Schedule due to error during initial polling process."));
                        hashMap.clear();
                        n = 0;
                    }
                    catch (DataException dataException) {
                        throw new ResourceUnavailableException("Error deleting SAP jobs for SAP System Definition " + sAPConnection.getSapSystemDefinitionName(), (Throwable)dataException);
                    }
                    throw new ResourceUnavailableException(sAPFunctionException.getMessage());
                }
            }
            if (hashMap.size() > 0) {
                n += this.saveUnconfirmedGroup(hashMap);
                hashMap.clear();
            }
            l2 = System.currentTimeMillis();
            logger.debug((Object)(string + "Processing " + n2 + " jobs took " + (l2 - l) / 1000L + " seconds"));
            scheduleLogEntry = RosettaMsg.SAP_INITIAL_POLL_END.newLogEntry(stringArray);
            ScheduleLogger.write(scheduleLogEntry);
            logger.debug((Object)scheduleLogEntry.getMessageText());
        }
        catch (JCoException jCoException) {
            logger.error((Object)"Error in loadSAPJobsIntoSkybotInitialPoll", (Throwable)jCoException);
        }
        catch (NotSavedException notSavedException) {
            logger.warn((Object)("Error saving SAP Jobs collected from SAP System " + sAPConnection.getSapSystemDefinitionName()), (Throwable)notSavedException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error((Object)("Error collecting jobs from SAP System " + sAPConnection.getSapSystemDefinitionName()), (Throwable)outOfMemoryError);
        }
        return n;
    }

    private boolean isXM28Error(Exception exception) {
        SAPReturnMessage sAPReturnMessage;
        if (exception instanceof SAPFunctionException && (sAPReturnMessage = ((SAPFunctionException)exception).getSAPReturnMessage()) != null && sAPReturnMessage.getReturnMessageIDAndNumber().equals("XM28")) {
            logger.error((Object)"Unable to continue process due to not logged on error.");
            return true;
        }
        return false;
    }

    private void addSAPJobDetails(SAPJobSimple sAPJobSimple, JCoFunction jCoFunction, SAPConnection sAPConnection, TimeZone timeZone) throws SAPFunctionException {
        try {
            sAPConnection.executeMiddleFunction(jCoFunction, false);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                logger.error((Object)("Error executing " + jCoFunction.getName() + ".  SAP Error " + sAPReturnMessage.getFullReturnMessage()));
                String string = "SAP Error " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string);
                throw new SAPFunctionException(string, sAPReturnMessage);
            }
            JCoStructure jCoStructure = jCoFunction.getExportParameterList().getStructure("JOBHEAD");
            String string = jCoStructure.getString("STATUS");
            sAPJobSimple.setJobStatusAsString(string);
            String string2 = jCoStructure.getString("EVENTID");
            sAPJobSimple.setEventIdentifier(string2);
            String string3 = jCoStructure.getString("SDLUNAME");
            sAPJobSimple.setJobInitiator(string3);
            Date date = jCoStructure.getDate("SDLSTRTDT");
            Date date2 = jCoStructure.getTime("SDLSTRTTM");
            SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.PLANNED_START, sAPJobSimple, date, date2, timeZone);
            Date date3 = jCoStructure.getDate("STRTDATE");
            Date date4 = jCoStructure.getTime("STRTTIME");
            SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.JOB_START, sAPJobSimple, date3, date4, timeZone);
            Date date5 = jCoStructure.getDate("ENDDATE");
            Date date6 = jCoStructure.getTime("ENDTIME");
            SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.JOB_END, sAPJobSimple, date5, date6, timeZone);
            String string4 = jCoStructure.getString("PERIODIC");
            sAPJobSimple.setPeriodicAsString(string4);
        }
        catch (JCoException jCoException) {
            logger.error((Object)("Error getting job details for SAP Job " + sAPJobSimple.getNameAndCount()));
        }
    }

    private int saveUnconfirmedGroup(HashMap<String, SAPJobSimple> hashMap) throws NotSavedException, ResourceUnavailableException {
        int n = 0;
        ArrayList<SAPJobSimple> arrayList = this.getSAPJobsDM().save(hashMap.values());
        if (arrayList.size() > 0) {
            int n2 = this.getSAPJobsDM().updateToUnconfirmed(arrayList);
            logger.debug((Object)(n2 + " duplicate SAP jobs were reverted to unconfirmed."));
        }
        return n += hashMap.size() - arrayList.size();
    }

    private SAPJobSimple getSAPJobFromRowJobHead(JCoTable jCoTable, long l, TimeZone timeZone) throws IllegalArgumentException {
        SAPJobSimple sAPJobSimple;
        try {
            String string = jCoTable.getString("JOBNAME");
            sAPJobSimple = new SAPJobSimple(l);
            sAPJobSimple.setJobName(string);
            String string2 = jCoTable.getString("JOBCOUNT");
            sAPJobSimple.setJobCount(string2);
            logger.trace((Object)("jobName(jobCount): " + string + "(" + string2 + ")"));
            Date date = jCoTable.getDate("SDLSTRTDT");
            Date date2 = jCoTable.getTime("SDLSTRTTM");
            logger.trace((Object)("plannedStartDate: " + date));
            logger.trace((Object)("plannedStartTime: " + date2));
            SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.PLANNED_START, sAPJobSimple, date, date2, timeZone);
            String string3 = jCoTable.getString("STATUS");
            sAPJobSimple.setJobStatusAsString(string3);
            int n = jCoTable.getInt("STEPCOUNT");
            sAPJobSimple.setJobStepCount(n);
            String string4 = jCoTable.getString("SDLUNAME");
            sAPJobSimple.setJobInitiator(string4);
            Date date3 = jCoTable.getDate("STRTDATE");
            Date date4 = jCoTable.getTime("STRTTIME");
            SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.JOB_START, sAPJobSimple, date3, date4, timeZone);
            Date date5 = jCoTable.getDate("ENDDATE");
            Date date6 = jCoTable.getTime("ENDTIME");
            SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.JOB_END, sAPJobSimple, date5, date6, timeZone);
            String string5 = jCoTable.getString("PERIODIC");
            sAPJobSimple.setPeriodicAsString(string5);
            String string6 = jCoTable.getString("EVENTID");
            sAPJobSimple.setEventIdentifier(string6);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return sAPJobSimple;
    }

    private SAPJobSimple getSAPJobFromRowSelectedJobs(JCoTable jCoTable, long l) throws IllegalArgumentException {
        SAPJobSimple sAPJobSimple;
        try {
            String string = jCoTable.getString("JOBNAME");
            sAPJobSimple = new SAPJobSimple(l);
            sAPJobSimple.setJobName(string);
            String string2 = jCoTable.getString("JOBCOUNT");
            sAPJobSimple.setJobCount(string2);
            logger.trace((Object)("jobName(jobCount): " + string + "(" + string2 + ")"));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
        return sAPJobSimple;
    }

    private void processUpdatedJobInfoForJobs(SAPConnection sAPConnection, HashMap<String, SAPJobProxy> hashMap) {
        TimeZone timeZone = sAPConnection.getTimeZone();
        for (SAPJobProxy sAPJobProxy : hashMap.values()) {
            if (!sAPJobProxy.getJobStatus().isIndicativeOfNewData()) continue;
            SAPJobSelectParameters sAPJobSelectParameters = new SAPJobSelectParameters(sAPJobProxy.getJobName(), sAPJobProxy.getJobCount());
            try {
                JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobSelect(sAPConnection, SAPJobSelection.ALL, sAPJobSelectParameters);
                sAPConnection.executeMiddleFunction(jCoFunction, false);
                SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
                if (sAPReturnMessage.isError()) {
                    logger.error((Object)("Error executing " + jCoFunction.getName() + ".  SAP Error " + sAPReturnMessage.getFullReturnMessage()));
                    continue;
                }
                JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOB_HEAD");
                int n = jCoTable.getNumRows();
                logger.trace((Object)("Found " + n + " job(s) on SAP System " + sAPConnection.getJCoDestination().getApplicationServerHost()));
                for (int i = 0; i < n; ++i) {
                    jCoTable.setRow(i);
                    Date date = jCoTable.getDate("SDLSTRTDT");
                    Date date2 = jCoTable.getTime("SDLSTRTTM");
                    SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.PLANNED_START, sAPJobProxy, date, date2, timeZone);
                    Date date3 = jCoTable.getDate("STRTDATE");
                    Date date4 = jCoTable.getTime("STRTTIME");
                    SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.JOB_START, sAPJobProxy, date3, date4, timeZone);
                    Date date5 = jCoTable.getDate("ENDDATE");
                    Date date6 = jCoTable.getTime("ENDTIME");
                    SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.JOB_END, sAPJobProxy, date5, date6, timeZone);
                    String string = jCoTable.getString("PERIODIC");
                    sAPJobProxy.setPeriodicAsString(string);
                }
            }
            catch (JCoException jCoException) {
                logger.error((Object)("Error processing updated information for " + sAPJobProxy.getNameAndCount()), (Throwable)jCoException);
            }
        }
        try {
            int n = this.getSAPJobsDM().update(hashMap.values());
            logger.debug((Object)(n + " SAP job(s) were updated."));
        }
        catch (Exception exception) {
            logger.error((Object)"Error updating SAP jobs.", (Throwable)exception);
        }
    }

    private HashMap<String, SAPJobProxy> getDeletedSAPJobsFromList(HashMap<String, SAPJobProxy> hashMap) {
        HashMap<String, SAPJobProxy> hashMap2 = new HashMap<String, SAPJobProxy>();
        for (SAPJobProxy sAPJobProxy : hashMap.values()) {
            if (!sAPJobProxy.getJobStatus().isDeleted()) continue;
            hashMap2.put(sAPJobProxy.getNameAndCount(), sAPJobProxy);
        }
        for (SAPJobProxy sAPJobProxy : hashMap2.values()) {
            hashMap.remove(sAPJobProxy.getNameAndCount());
        }
        return hashMap2;
    }

    private HashMap<String, SAPJobProxy> getUpdatedStatusFromList(SAPConnection sAPConnection, HashMap<String, SAPJobProxy> hashMap) throws ResourceUnavailableException {
        HashMap<String, SAPJobProxy> hashMap2 = new HashMap<String, SAPJobProxy>();
        try {
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobListStatusGet(sAPConnection, hashMap.values());
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                logger.error((Object)("Error executing " + jCoFunction.getName() + ".  SAP Error " + sAPReturnMessage.getFullReturnMessage()));
                return hashMap2;
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBLIST");
            int n = jCoTable.getNumRows();
            logger.debug((Object)(jCoFunction.getName() + " returned the latest status of " + n + " job(s)"));
            for (int i = 0; i < n; ++i) {
                jCoTable.setRow(i);
                String string = jCoTable.getString("JOBNAME");
                String string2 = jCoTable.getString("JOBCOUNT");
                String string3 = jCoTable.getString("STATUS");
                try {
                    SAPJobStatus sAPJobStatus = SAPJobStatus.persistanceCodeToEnum(string3);
                    SAPJobProxy sAPJobProxy = new SAPJobProxy(sAPConnection.getSapSystemDefinitionID(), string, string2, sAPJobStatus);
                    SAPJobProxy sAPJobProxy2 = hashMap.get(sAPJobProxy.getNameAndCount());
                    if (sAPJobProxy2.getJobStatus().equals(sAPJobProxy.getJobStatus())) continue;
                    sAPJobProxy2.setJobStatus(sAPJobProxy.getJobStatus());
                    hashMap2.put(sAPJobProxy.getNameAndCount(), sAPJobProxy2);
                    continue;
                }
                catch (IllegalStateException illegalStateException) {
                    logger.warn((Object)("SAP Job " + string + "(" + string2 + ") on SAP System Definition " + sAPConnection.getSapSystemDefinitionName() + " has an unknown status of '" + string3 + "' and will not be updated in Automate Schedule."));
                }
            }
        }
        catch (JCoException jCoException) {
            logger.error((Object)"Error getting updated statuses for SAP jobs.", (Throwable)jCoException);
        }
        return hashMap2;
    }

    private void deleteSAPJob(SAPConnection sAPConnection, SAPJobProxy sAPJobProxy, String string) throws DeleteJobException {
        try {
            JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_DELETE");
            jCoFunction.getImportParameterList().setValue("JOBNAME", sAPJobProxy.getJobName());
            jCoFunction.getImportParameterList().setValue("JOBCOUNT", sAPJobProxy.getJobCount());
            jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
            sAPConnection.execute(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string2 = "SAP Error " + sAPReturnMessage.getFullReturnMessage() + ".  " + sAPJobProxy.getNameAndCount() + " was not deleted on the SAP System " + sAPConnection.getSapSystemDefinitionName() + ".";
                DeleteJobException.Reason reason = DeleteJobException.Reason.OTHER;
                if (sAPReturnMessage.getReturnID().equals("XM")) {
                    switch (sAPReturnMessage.getReturnNumber()) {
                        case 57: {
                            reason = DeleteJobException.Reason.JOB_DOES_NOT_EXIST;
                            break;
                        }
                        case 85: {
                            reason = DeleteJobException.Reason.JOB_IS_ACTIVE;
                            break;
                        }
                        default: {
                            logger.warn((Object)("Unhandled SAP Message Number " + sAPReturnMessage.getReturnNumber() + " for XM message."));
                        }
                    }
                }
                throw new DeleteJobException(string2, reason);
            }
            String string3 = "SAP Job " + sAPJobProxy.getNameAndCount() + " was deleted from SAP System " + sAPConnection.getSapSystemDefinitionName();
            logger.debug((Object)string3);
        }
        catch (JCoException jCoException) {
            throw new DeleteJobException("Error deleting SAP job " + sAPJobProxy.getNameAndCount(), (Exception)((Object)jCoException));
        }
    }

    private void startSAPJob(SAPConnection sAPConnection, SAPExecutableJob sAPExecutableJob) throws Exception {
        try {
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobStart(sAPExecutableJob, sAPConnection.getExternalUserName(), sAPConnection);
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string = "SAP Error " + sAPReturnMessage.getFullReturnMessage() + ".  " + sAPExecutableJob.getNameAndCount() + " was not started.";
                logger.error((Object)string);
                return;
            }
            String string = "Successfully started SAP Job " + sAPExecutableJob.getNameAndCount() + " " + SAPFunctionUtility.getStartString(sAPExecutableJob.isStartImmediately()) + " on SAP System " + sAPConnection.getSapSystemDefinitionName();
            logger.debug((Object)string);
            Thread.sleep(500L);
            try {
                SAPJobSelectParameters sAPJobSelectParameters = new SAPJobSelectParameters(sAPExecutableJob.getJobName(), sAPExecutableJob.getJobCount());
                sAPJobSelectParameters.setAllStatuses(true);
                SAPJobSimple sAPJobSimple = this.getSAPJob(sAPConnection, sAPExecutableJob, sAPJobSelectParameters, SAPJobSelection.ALL);
                this.getSAPJobsDM().update(sAPJobSimple);
                logger.debug((Object)("Successfully updated Automate Schedule record for SAP job " + ((SAPJobProxy)sAPJobSimple).getNameAndCount() + "."));
            }
            catch (Exception exception) {
                logger.warn((Object)("Error updating Automate Schedule record for " + sAPExecutableJob.getNameAndCount() + " on SAP System " + sAPConnection.getSapSystemDefinitionName()));
            }
        }
        catch (JCoException jCoException) {
            String string = "Error starting intercepted SAP Job " + sAPExecutableJob.getNameAndCount() + ".  " + jCoException.getMessage();
            logger.error((Object)string);
            throw new Exception(string, jCoException);
        }
    }

    private SAPJobSimple getSAPJob(SAPConnection sAPConnection, SAPJobProxy sAPJobProxy, SAPJobSelectParameters sAPJobSelectParameters, SAPJobSelection sAPJobSelection) throws Exception {
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobSelect(sAPConnection, sAPJobSelection, sAPJobSelectParameters);
        sAPConnection.executeMiddleFunction(jCoFunction);
        SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
        if (sAPReturnMessage.isError()) {
            logger.warn((Object)("Error executing " + jCoFunction.getName() + ".  SAP Error " + sAPReturnMessage.getFullReturnMessage()));
            logger.warn((Object)("Error getting updated record for SAP Job " + sAPJobProxy.getNameAndCount() + " with JobSelectParameters " + (Object)((Object)sAPJobSelectParameters) + "."));
            throw new Exception("Error getting updated record for SAP Job " + sAPJobProxy.getNameAndCount() + " with JobSelectParameters " + (Object)((Object)sAPJobSelectParameters) + ". " + sAPReturnMessage.getFullReturnMessage());
        }
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOB_HEAD");
        int n = jCoTable.getNumRows();
        if (n == 0 || n > 1) {
            String string = "Found " + n + " job(s) polling for " + sAPJobProxy.getNameAndCount() + " on SAP System " + sAPConnection.getSapSystemDefinitionName();
            logger.error((Object)string);
            logger.error((Object)("Error polling SAP Job " + sAPJobProxy.getNameAndCount() + ". " + string));
            throw new Exception("Error polling SAP Job " + sAPJobProxy.getNameAndCount() + ". " + string);
        }
        jCoTable.setRow(0);
        TimeZone timeZone = sAPConnection.getTimeZone();
        return this.getSAPJobFromRowJobHead(jCoTable, sAPConnection.getSapSystemDefinitionID(), timeZone);
    }

    private void terminateSAPJob(SAPJobProxy sAPJobProxy, SAPConnection sAPConnection) throws JCoException, EndJobException {
        Object object;
        Object object2;
        JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobAbort(sAPConnection, sAPJobProxy);
        sAPConnection.executeMiddleFunction(jCoFunction);
        SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
        EndJobException endJobException = null;
        if (sAPReturnMessage.isError()) {
            object2 = "Error terminating SAP job " + sAPJobProxy.getNameAndCount() + ". " + sAPReturnMessage.getFullReturnMessage();
            object = EndJobException.Reason.OTHER;
            if (sAPReturnMessage.getReturnID().equals("XM")) {
                switch (sAPReturnMessage.getReturnNumber()) {
                    case 49: {
                        object = EndJobException.Reason.JOB_DOES_NOT_EXIST;
                        logger.info((Object)("Unable to cancel the SAP Job " + sAPJobProxy.getNameAndCount() + " on SAP System " + sAPConnection.getSapSystemDefinitionName() + ".  The job does not exist."));
                        break;
                    }
                    case 55: {
                        object = EndJobException.Reason.JOB_NOT_ACTIVE;
                        break;
                    }
                    default: {
                        logger.warn((Object)("Unhandled SAP Message Number " + sAPReturnMessage.getReturnNumber() + " for XM message."));
                    }
                }
            }
            endJobException = new EndJobException((String)object2, (EndJobException.Reason)((Object)object));
            if (((Enum)object).equals((Object)EndJobException.Reason.JOB_DOES_NOT_EXIST)) {
                try {
                    if (this.getSAPJobsDM().delete(sAPJobProxy)) {
                        logger.info((Object)("Successfully deleted Automate Schedule record for non-existant SAP job " + sAPJobProxy.getNameAndCount() + " on SAP System " + sAPConnection.getSapSystemDefinitionName()));
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)("Error deleting Automate Schedule record for SAP job " + sAPJobProxy.getNameAndCount()), (Throwable)exception);
                }
                throw endJobException;
            }
        } else {
            logger.debug((Object)("Successfully canceled SAP job " + sAPJobProxy.getNameAndCount() + "."));
        }
        try {
            object2 = new SAPJobSelectParameters(sAPJobProxy.getJobName(), sAPJobProxy.getJobCount());
            ((SAPJobSelectParameters)((Object)object2)).setAllStatuses(true);
            Thread.sleep(500L);
            object = this.getSAPJob(sAPConnection, sAPJobProxy, (SAPJobSelectParameters)((Object)object2), SAPJobSelection.ALL);
            logger.trace((Object)(((SAPJobSimple)object).getNameAndCount() + " status = " + ((SAPJobProxy)object).getJobStatus()));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(((SAPJobSimple)object).getNameAndCount(), object);
            this.getSAPJobsDM().update(hashMap.values());
            logger.debug((Object)("Successfully updated Automate Schedule record for SAP job " + ((SAPJobSimple)object).getNameAndCount() + " to status " + ((SAPJobProxy)object).getJobStatus()));
        }
        catch (Exception exception) {
            logger.warn((Object)("Error updating Automate Schedule record for " + sAPJobProxy.getNameAndCount() + " on SAP System " + sAPConnection.getSapSystemDefinitionName()), (Throwable)exception);
        }
        if (endJobException != null) {
            logger.debug((Object)endJobException);
            throw endJobException;
        }
    }

    @Override
    public void appendSAPCriteria(String string, long l, SAPInterceptCriteria sAPInterceptCriteria) throws ResourceUnavailableException {
        this.getInterceptCriteria(l, sAPInterceptCriteria, true, false);
    }

    @Override
    public void replaceSAPCriteriaTable(String string, long l, String string2) throws ResourceUnavailableException {
        Object object;
        String string3 = this.getSAPSystemDefinition(l).getName();
        SAPInterceptCriteria sAPInterceptCriteria = new SAPInterceptCriteria(string3);
        logger.debug((Object)("Starting criteria string: " + string2));
        String string4 = string2.replace("[", "");
        string4 = string4.replace("]", "");
        String[] stringArray = string4.split(",");
        logger.trace((Object)("criteria split into " + stringArray.length + " by comma."));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        SAPInterceptCriterion sAPInterceptCriterion = null;
        for (int i = 0; !bl && i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            if (string5.startsWith("{")) {
                bl2 = true;
                bl3 = false;
                string5 = string5.replace("{", "");
                sAPInterceptCriterion = new SAPInterceptCriterion(l);
            }
            if (string5.endsWith("}")) {
                bl3 = true;
                string5 = string5.replace("}", "");
            }
            if (!bl2) continue;
            object = string5.split(":");
            try {
                sAPInterceptCriterion.setValue((String[])object);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw new ResourceUnavailableException("Error setting criterion value.", (Throwable)invalidParameterException);
            }
            if (!bl3) continue;
            bl2 = false;
            sAPInterceptCriterion.setSapSystemDefinitionName(string3);
            sAPInterceptCriteria.addSAPInterceptCriterion(sAPInterceptCriterion);
        }
        this.getInterceptCriteria(l, sAPInterceptCriteria, false, false);
        if (sAPInterceptCriteria.isEmpty()) {
            String[] stringArray2 = new String[]{sAPInterceptCriteria.getSapSystemDefinitionName(), "no", string};
            object = RosettaMsg.SAP_INTERCEPT_CRITERIA_SET.newLogEntry(stringArray2);
            ScheduleLogger.write((ScheduleLogEntry)object);
            logger.debug((Object)((ScheduleLogEntry)object).getMessageText());
        } else {
            ArrayList<SAPInterceptCriterion> arrayList = sAPInterceptCriteria.getSAPInterceptCriterions();
            String[] stringArray3 = new String[]{sAPInterceptCriteria.getSapSystemDefinitionName(), String.valueOf(arrayList.size()), string};
            object = RosettaMsg.SAP_INTERCEPT_CRITERIA_SET.newLogEntry(stringArray3);
            ScheduleLogger.write((ScheduleLogEntry)object);
            logger.debug((Object)((ScheduleLogEntry)object).getMessageText());
            for (SAPInterceptCriterion sAPInterceptCriterion2 : arrayList) {
                String[] stringArray4 = new String[]{sAPInterceptCriterion2.getJobCreator(), sAPInterceptCriterion2.getJobName(), sAPInterceptCriterion2.getClient(), sAPInterceptCriterion2.getSapSystemDefinitionName(), string};
                object = RosettaMsg.SAP_INTERCEPT_CRITERION_SET.newLogEntry(stringArray4);
                ScheduleLogger.write((ScheduleLogEntry)object);
                logger.debug((Object)((ScheduleLogEntry)object).getMessageText());
            }
        }
    }

    @Override
    public void replaceSAPCriterionProfile(String string, long l, SAPProfileTypeSelection sAPProfileTypeSelection, int n, String string2) throws ResourceUnavailableException {
        logger.debug((Object)("About to set SAP " + (Object)((Object)sAPProfileTypeSelection) + " criterion profile ID " + n + " with XML: " + string2));
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionCMCriteriaSet(sAPConnection, string, n, sAPProfileTypeSelection, string2);
            sAPConnection.execute(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string3 = "Error executing " + jCoFunction.getName() + ".  SAP Error " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string3);
                throw new ResourceUnavailableException(string3);
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error setting SAP " + (Object)((Object)sAPProfileTypeSelection) + " criterion profile ID " + n + " with XML: " + string2, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
    }

    private String getSAPCriteriaTable(SAPConnection sAPConnection) throws ResourceUnavailableException {
        String string = "[";
        SAPInterceptCriteria sAPInterceptCriteria = this.getInterceptCriteria(sAPConnection, null, false, true);
        ArrayList<SAPInterceptCriterion> arrayList = sAPInterceptCriteria.getSAPInterceptCriterions();
        Iterator<SAPInterceptCriterion> iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            SAPInterceptCriterion sAPInterceptCriterion = iterator.next();
            if (bl) {
                string = string + ",";
            }
            string = string + "{";
            string = string + "\"user\":\"" + sAPInterceptCriterion.getJobCreator() + "\",\"job\":\"" + sAPInterceptCriterion.getJobName() + "\",\"client\":\"" + sAPInterceptCriterion.getClient() + "\"}";
            bl = true;
        }
        string = string + "]";
        return string;
    }

    @Override
    public String getSAPCriteriaTable(long l) throws ResourceUnavailableException {
        String string = "[";
        SAPInterceptCriteria sAPInterceptCriteria = this.getInterceptCriteria(l, null, false, true);
        ArrayList<SAPInterceptCriterion> arrayList = sAPInterceptCriteria.getSAPInterceptCriterions();
        Iterator<SAPInterceptCriterion> iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            SAPInterceptCriterion sAPInterceptCriterion = iterator.next();
            if (bl) {
                string = string + ",";
            }
            string = string + "{";
            string = string + "\"user\":\"" + sAPInterceptCriterion.getJobCreator() + "\",\"job\":\"" + sAPInterceptCriterion.getJobName() + "\",\"client\":\"" + sAPInterceptCriterion.getClient() + "\"}";
            bl = true;
        }
        string = string + "]";
        return string;
    }

    @Override
    public String getSAPProcessChains(long l, String string) throws ResourceUnavailableException {
        return this.getSAPProcessChains(l, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSAPProcessChains(long l, String string, boolean bl) throws ResourceUnavailableException {
        String string2;
        block8: {
            string2 = "[";
            SAPConnection sAPConnection = this.getSAPConnection(l);
            JCoFunction jCoFunction = null;
            try {
                this.startSAPXMISession(sAPConnection);
                jCoFunction = SAPFunctionUtility.getFunctionGetChains(sAPConnection, string, bl);
                sAPConnection.execute(jCoFunction);
                JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("E_T_CHAINS");
                int n = jCoTable.getNumRows();
                logger.debug((Object)("*** Found " + n + " process chain(s) for search '" + string + "'."));
                boolean bl2 = false;
                for (int i = 0; i < n; ++i) {
                    jCoTable.setRow(i);
                    String string3 = jCoTable.getString("LANGU");
                    String string4 = jCoTable.getString("CHAIN_ID");
                    String string5 = jCoTable.getString("OBJVERS");
                    String string6 = jCoTable.getString("TXTLG");
                    if (string6.contains("\"")) {
                        logger.debug((Object)("*** Found \" in description: " + string6 + ". Converting to \\\""));
                        string6 = string6.replaceAll("\"", "\\\\\"");
                    }
                    if (bl2) {
                        string2 = string2 + ",";
                    }
                    string2 = string2 + "{";
                    string2 = string2 + "\"name\":\"" + string4 + "\",\"description\":\"" + string6 + "\"}";
                    bl2 = true;
                    logger.debug((Object)(string3 + " | " + string4 + " | " + string5 + " | " + string6));
                }
                string2 = string2 + "]";
            }
            catch (JCoException jCoException) {
                logger.error((Object)"JCoException in getSAPBWProcessChains:", (Throwable)jCoException);
                SAPFunctionUtility.logExceptionDetails(jCoFunction, true);
            }
            finally {
                if (this.endSAPXMISession(sAPConnection)) break block8;
                throw new ResourceUnavailableException("Error ending SAP XMI session.");
            }
        }
        return string2;
    }

    @Override
    public String getSAPEventHistoryCriterionProfiles(String string, long l) throws ResourceUnavailableException {
        String string2 = "[";
        SAPCriterionProfiles sAPCriterionProfiles = this.getCriterionProfiles(string, l, SAPProfileTypeSelection.EVENT_HISTORY);
        ArrayList<SAPCriterionProfile> arrayList = sAPCriterionProfiles.getSAPCriterionProfiles();
        Iterator<SAPCriterionProfile> iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            SAPCriterionProfile sAPCriterionProfile = iterator.next();
            if (bl) {
                string2 = string2 + ",";
            }
            string2 = string2 + "{";
            string2 = string2 + "\"profileID\":\"" + sAPCriterionProfile.getProfileID() + "\",\"criterionType\":\"" + sAPCriterionProfile.getCriterionType() + "\",\"description\":\"" + sAPCriterionProfile.getDescription() + "\",\"profileStatus\":\"" + sAPCriterionProfile.getProfileStatus() + "\",\"createUser\":\"" + sAPCriterionProfile.getCreateUser() + "\",\"lastChangeUser\":\"" + sAPCriterionProfile.getLastchUser() + "\",\"lastChangeTimeUTC\":\"" + sAPCriterionProfile.getLastChTimeUTC() + "\"}";
            bl = true;
        }
        string2 = string2 + "]";
        return string2;
    }

    @Override
    public String getSAPInterceptCriterionProfiles(String string, long l) throws ResourceUnavailableException {
        String string2 = "[";
        SAPCriterionProfiles sAPCriterionProfiles = this.getCriterionProfiles(string, l, SAPProfileTypeSelection.JOB_INTERCEPTION);
        ArrayList<SAPCriterionProfile> arrayList = sAPCriterionProfiles.getSAPCriterionProfiles();
        Iterator<SAPCriterionProfile> iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            SAPCriterionProfile sAPCriterionProfile = iterator.next();
            if (bl) {
                string2 = string2 + ",";
            }
            string2 = string2 + "{";
            string2 = string2 + "\"profileID\":\"" + sAPCriterionProfile.getProfileID() + "\",\"criterionType\":\"" + sAPCriterionProfile.getCriterionType() + "\",\"description\":\"" + sAPCriterionProfile.getDescription() + "\",\"profileStatus\":\"" + sAPCriterionProfile.getProfileStatus() + "\",\"createUser\":\"" + sAPCriterionProfile.getCreateUser() + "\",\"lastChangeUser\":\"" + sAPCriterionProfile.getLastchUser() + "\",\"lastChangeTimeUTC\":\"" + sAPCriterionProfile.getLastChTimeUTC() + "\"}";
            bl = true;
        }
        string2 = string2 + "]";
        return string2;
    }

    public void setSAPInterceptCriteriaJSON(String string, long l, int n, String string2) {
    }

    @Override
    public String getSAPInterceptCriteriaJSON(String string, long l, int n) throws ResourceUnavailableException {
        String string2 = "{\"interceptProfile\": {";
        SAPCriterionProfile sAPCriterionProfile = this.getSAPCriteriaProfile(string, l, n, SAPProfileTypeSelection.JOB_INTERCEPTION);
        string2 = string2 + "\"profileDescription\":\"" + sAPCriterionProfile.getDescription() + "\",";
        string2 = string2 + "\"profileStatus\":\"" + sAPCriterionProfile.getProfileStatus() + "\",";
        string2 = string2 + "\"profileLastChangeUser\":\"" + sAPCriterionProfile.getLastchUser() + "\",";
        string2 = string2 + "\"profileLastChangeTime\":\"" + sAPCriterionProfile.getLastChTimeUTC() + "\",";
        string2 = string2 + "\"profileCreateUser\":\"" + sAPCriterionProfile.getCreateUser() + "\",";
        string2 = string2 + "\"nodes\": ";
        SAPCriteria sAPCriteria = sAPCriterionProfile.getSapCriteria();
        ArrayList<SAPCriteriaNode> arrayList = sAPCriteria.getNodes();
        logger.debug((Object)("criterion profile contains " + arrayList.size() + " node(s)."));
        string2 = string2 + "[";
        Iterator<SAPCriteriaNode> iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            SAPCriteriaNode sAPCriteriaNode = iterator.next();
            String string3 = this.getSAPCriteriaNodeString(sAPCriteriaNode);
            if (bl) {
                string2 = string2 + ",";
            }
            string2 = string2 + string3;
            bl = true;
        }
        string2 = string2 + "]";
        string2 = string2 + "}";
        string2 = string2 + "}";
        return string2;
    }

    private String getSAPCriteriaNodeString(SAPCriteriaNode sAPCriteriaNode) {
        Object object;
        String string = "{ \"nodeType\":\"" + sAPCriteriaNode.getNodeType() + "\", \"insideNodes\": [";
        ArrayList<SAPCriteriaNode> arrayList = sAPCriteriaNode.getInsideNodes();
        if (arrayList.size() > 0) {
            logger.debug((Object)("currentNode of type " + sAPCriteriaNode.getNodeType() + " contains " + arrayList.size() + " inside node(s)."));
            object = arrayList.iterator();
            boolean bl = false;
            while (object.hasNext()) {
                SAPCriteriaNode sAPCriteriaNode2 = (SAPCriteriaNode)object.next();
                String string2 = this.getSAPCriteriaNodeString(sAPCriteriaNode2);
                if (bl) {
                    string = string + ",";
                }
                string = string + string2;
                bl = true;
            }
        }
        string = string + "], \"items\": ";
        object = sAPCriteriaNode.getItems();
        String string3 = this.getSAPCriteriaItemsString((ArrayList<SAPCriteriaItem>)object);
        string = string + string3;
        string = string + "}";
        return string;
    }

    private String getSAPCriteriaItemsString(ArrayList<SAPCriteriaItem> arrayList) {
        String string = "[";
        Iterator<SAPCriteriaItem> iterator = arrayList.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (bl) {
                string = string + ",";
            }
            SAPCriteriaItem sAPCriteriaItem = iterator.next();
            string = string + "{\"itemDescription\":\"" + sAPCriteriaItem.getDescription() + "\", \"fields\": [";
            ArrayList<SAPCriteriaField> arrayList2 = sAPCriteriaItem.getFields();
            Iterator<SAPCriteriaField> iterator2 = arrayList2.iterator();
            boolean bl2 = false;
            while (iterator2.hasNext()) {
                SAPCriteriaField sAPCriteriaField = iterator2.next();
                if (bl2) {
                    string = string + ",";
                }
                string = string + "{\"fieldName\":\"" + sAPCriteriaField.getFieldName() + "\", \"criterions\": [";
                ArrayList<SAPCriterion> arrayList3 = sAPCriteriaField.getSAPCriterions();
                Iterator<SAPCriterion> iterator3 = arrayList3.iterator();
                boolean bl3 = false;
                while (iterator3.hasNext()) {
                    SAPCriterion sAPCriterion = iterator3.next();
                    if (bl3) {
                        string = string + ",";
                    }
                    string = string + "{\"fieldSign\":\"" + sAPCriterion.getSapCriterionSign().persistanceCode() + "\"";
                    string = string + ",\"fieldOption\":\"" + sAPCriterion.getSapCriterionOption().persistanceCode() + "\"";
                    string = string + ",\"fieldLow\":\"" + sAPCriterion.getLowValue() + "\"";
                    string = string + ",\"fieldHigh\":\"" + sAPCriterion.getHighValue() + "\"}";
                    bl3 = true;
                }
                string = string + "]}";
                bl2 = true;
            }
            string = string + "]";
            string = string + "}";
            bl = true;
        }
        string = string + "]";
        return string;
    }

    private SAPCriterionProfiles getCriterionProfiles(String string, long l, SAPProfileTypeSelection sAPProfileTypeSelection) throws ResourceUnavailableException {
        SAPCriterionProfiles sAPCriterionProfiles = new SAPCriterionProfiles();
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            String string2 = sAPConnection.getExternalUserName();
            if (string != null && string.length() > 0) {
                string2 = string;
            }
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionCMProfilesGet(sAPConnection, string2, sAPProfileTypeSelection);
            sAPConnection.execute(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string3 = "Error obtaining " + (Object)((Object)sAPProfileTypeSelection) + " criteria profiles for SAP system " + sAPConnection.getSapSystemDefinitionName() + ". " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string3);
                throw new ResourceUnavailableException(string3);
            }
            JCoTable jCoTable = jCoFunction.getExportParameterList().getTable("E_T_PROFILES");
            int n = jCoTable.getNumRows();
            logger.debug((Object)("Found " + n + (Object)((Object)sAPProfileTypeSelection) + " criteria profiles on SAP System " + sAPConnection.getSapSystemDefinitionName()));
            for (int i = 0; i < n; ++i) {
                jCoTable.setRow(i);
                int n2 = jCoTable.getInt("ID");
                String string4 = jCoTable.getString("TYPE");
                String string5 = jCoTable.getString("DESCRIPTION");
                String string6 = jCoTable.getString("STATE");
                String string7 = jCoTable.getString("CREATEUSER");
                String string8 = jCoTable.getString("LASTCHUSER");
                BigDecimal bigDecimal = jCoTable.getBigDecimal("LASTCHTMSTMP");
                sAPCriterionProfiles.addSAPCriteriaProfile(n2, string4, string5, string6, string7, string8, bigDecimal);
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining SAP Intercept Criterion Profiles from SAP System Definition ID " + l, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return sAPCriterionProfiles;
    }

    private SAPCriterionProfile getSAPCriteriaProfile(String string, long l, int n, SAPProfileTypeSelection sAPProfileTypeSelection) throws ResourceUnavailableException {
        SAPCriterionProfile sAPCriterionProfile = new SAPCriterionProfile();
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            String string2 = sAPConnection.getExternalUserName();
            if (string != null && string.length() > 0) {
                string2 = string;
            }
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionCMCriteriaGet(sAPConnection, string2, n, sAPProfileTypeSelection);
            sAPConnection.execute(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string3 = "Error obtaining " + (Object)((Object)sAPProfileTypeSelection) + " criteria for profileID " + n + " on SAP system " + sAPConnection.getSapSystemDefinitionName() + ". " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string3);
                throw new ResourceUnavailableException(string3);
            }
            String string4 = jCoFunction.getExportParameterList().getString("E_CRITERIA_XML");
            sAPCriterionProfile = new SAPCriterionProfile(n, string4);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining SAP " + (Object)((Object)sAPProfileTypeSelection) + " Criteria for Profile ID " + n + " on SAP System Definition ID " + l, (Throwable)exception);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return sAPCriterionProfile;
    }

    @Override
    public String getSAPInterceptCriteriaTable(SAPConnectionType sAPConnectionType, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) throws Exception {
        String string13;
        SAPSystemDefinition sAPSystemDefinition = new SAPSystemDefinition();
        sAPSystemDefinition.setName("for_criteria");
        if (sAPConnectionType.equals(SAPConnectionType.GROUP_SERVER_SELECTION)) {
            sAPSystemDefinition.setConnectionType(SAPConnectionType.GROUP_SERVER_SELECTION.persistanceCode());
            sAPSystemDefinition.setMessageServer(string5);
            sAPSystemDefinition.setGroupOrServer(string6);
            string13 = "Message Server(" + string5 + ")";
        } else {
            sAPSystemDefinition.setSystemNumber(string3);
            sAPSystemDefinition.setAshost(string2);
            string13 = string2;
        }
        sAPSystemDefinition.setR3name(string4);
        sAPSystemDefinition.setRouter(string7);
        String string14 = TimeZone.getDefault().getID();
        sAPSystemDefinition.setTimeZoneString(string14);
        SAPSystemEnvironment sAPSystemEnvironment = string11 != null && string11.length() > 0 ? new SAPSystemEnvironment("test", "for criteria", string12, string8, string9, string10, string11, 0L) : new SAPSystemEnvironment("test", "for criteria", string12, string8, string9, string10, 0L);
        SAPSystem sAPSystem = new SAPSystem(sAPSystemDefinition, sAPSystemEnvironment);
        JCoDestination jCoDestination = this.getDestination(sAPSystem);
        String string15 = "";
        try {
            SAPConnection sAPConnection = new SAPConnection(jCoDestination, sAPSystem);
            logger.debug((Object)("Connection established to " + string13));
            sAPConnection.setUsableSystemName(string13);
            return this.getSAPCriteriaTable(sAPConnection);
        }
        catch (JCoException jCoException) {
            string15 = "Error connecting to SAP System " + sAPSystemDefinition.getName() + ".";
            switch (jCoException.getGroup()) {
                case 102: {
                    string15 = string15 + " Communication error: " + jCoException.getMessage();
                    break;
                }
                case 103: {
                    string15 = string15 + " Logon error: " + jCoException.getMessage();
                    break;
                }
                default: {
                    throw new Exception(string15, jCoException);
                }
            }
            logger.error((Object)(string15 + ": " + jCoException.getMessage()));
            Throwable throwable = jCoException.getCause();
            logger.debug((Object)("theCause = " + throwable));
            return null;
        }
    }

    private SAPExecutable getSAPExecutableFromCommand(CommandSetCommand commandSetCommand, boolean bl) throws ResourceUnavailableException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        return this.getSAPExecutableFromCommand(commandSetCommand, hashMap, bl);
    }

    @Override
    public SAPExecutable getSAPExecutableFromCommand(CommandSetCommand commandSetCommand, Map<String, String> map, boolean bl) throws ResourceUnavailableException {
        long l = commandSetCommand.getOid();
        int n = commandSetCommand.getCommandType();
        long l2 = 0L;
        SAPExecutable sAPExecutable = new SAPExecutable();
        SAPSystemEnvironment sAPSystemEnvironment = null;
        switch (n) {
            case 4: {
                long l3 = this.getSAPJobIDFromCommandID(l);
                SAPExecutableJob sAPExecutableJob = this.getSAPJobViaSAPJobID(l3, map, bl);
                sAPExecutable.setSapCommand(sAPExecutableJob);
                l2 = sAPExecutableJob.getSAPSystemEnvironmentID();
                sAPSystemEnvironment = this.getSAPSystemEnvironment(l2);
                sAPExecutable.setSapSystemEnvironment(sAPSystemEnvironment);
                break;
            }
            case 5: {
                SAPEvent sAPEvent = this.getSAPEvent(l, map, bl);
                sAPExecutable.setSapCommand(sAPEvent);
                sAPSystemEnvironment = this.getSAPSystemEnvironment(sAPEvent.getSAPSystemEnvironmentID());
                sAPExecutable.setSapSystemEnvironment(sAPSystemEnvironment);
                break;
            }
            case 6: {
                sAPExecutable = commandSetCommand.getSAPExecutable();
                break;
            }
            case 7: {
                SAPVariantActionList sAPVariantActionList = new SAPVariantActionList();
                sAPVariantActionList = this.getSAPVariantActionList(l, map, bl);
                sAPExecutable.setSapCommand(sAPVariantActionList);
                sAPSystemEnvironment = this.getSAPSystemEnvironment(sAPVariantActionList.getSAPSystemEnvironmentID());
                sAPExecutable.setSapSystemEnvironment(sAPSystemEnvironment);
                break;
            }
            case 11: {
                SAPExecutableProcessChain sAPExecutableProcessChain = this.getSAPProcessChain(l);
                sAPExecutable.setSapCommand(sAPExecutableProcessChain);
                sAPSystemEnvironment = this.getSAPSystemEnvironment(sAPExecutableProcessChain.getSAPSystemEnvironmentID());
                sAPExecutable.setSapSystemEnvironment(sAPSystemEnvironment);
                break;
            }
            default: {
                String string = "Invalid SAP commandType of " + n + " for line number " + commandSetCommand.getLineNumber();
                throw new InvalidParameterException(string);
            }
        }
        sAPExecutable.setCommandString(commandSetCommand.getCommandString());
        SAPSystemDefinition sAPSystemDefinition = this.getSAPSystemDefinition(sAPExecutable.getSapSystemDefinitionID());
        sAPExecutable.setSapSystemDefinition(sAPSystemDefinition);
        if (sAPSystemEnvironment == null) {
            sAPSystemEnvironment = this.getSAPSystemEnvironment(sAPSystemDefinition.getDefaultEnvironmentID());
            sAPExecutable.setSapSystemEnvironment(sAPSystemEnvironment);
        }
        return sAPExecutable;
    }

    private SAPExecutableProcessChain getSAPProcessChain(long l) throws ResourceUnavailableException {
        try {
            if (this.sapProcessChainsDM == null) {
                this.sapProcessChainsDM = (SAPProcessChainsDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.SAPProcessChainsDM");
            }
            SAPExecutableProcessChain sAPExecutableProcessChain = this.sapProcessChainsDM.getViaCommandID(l);
            return sAPExecutableProcessChain;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining SAPExecutableProcessChain for command ID " + l, (Throwable)exception);
        }
    }

    private long getSAPJobIDFromCommandID(long l) throws ResourceUnavailableException {
        try {
            return this.getSAPJobDefinitionsDM().getSAPJobIDViaCommandID(l);
        }
        catch (NoDataException noDataException) {
            throw new ResourceUnavailableException("Error obtaining SAP Job ID for command ID " + l, (Throwable)noDataException);
        }
    }

    private SAPJobDefinitionsDM getSAPJobDefinitionsDM() {
        if (this.sapJobDefinitionsDM == null) {
            this.sapJobDefinitionsDM = (SAPJobDefinitionsDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.SAPJobDefinitionsDM");
        }
        return this.sapJobDefinitionsDM;
    }

    private SAPExecutableJob getSAPJobViaSAPJobID(long l, Map<String, String> map, boolean bl) throws ResourceUnavailableException {
        try {
            SAPExecutableJob sAPExecutableJob = this.getSAPJobDefinitionsDM().getViaSAPJobID(l);
            SAPABAPStepSet sAPABAPStepSet = sAPExecutableJob.getAbapStepSet();
            ArrayList<SAPABAPStep> arrayList = sAPABAPStepSet.getStepList();
            for (SAPABAPStep sAPABAPStep : arrayList) {
                String string = sAPABAPStep.getAbapProgramVariantName();
                if (string == null || string.length() <= 0) continue;
                sAPABAPStep.setAbapProgramVariantName(this.getResolvedWithEnvironmentVariables(string, map, bl));
            }
            return sAPExecutableJob;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining SAPJob for SAP Job ID " + l, (Throwable)exception);
        }
    }

    private SAPEvent getSAPEvent(long l, Map<String, String> map, boolean bl) throws ResourceUnavailableException {
        try {
            if (this.sapEventsDM == null) {
                this.sapEventsDM = (SAPEventsDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.SAPEventsDM");
            }
            SAPEvent sAPEvent = this.sapEventsDM.getViaCommandID(l);
            String string = this.getResolvedWithEnvironmentVariables(sAPEvent.getEventParameters(), map, bl);
            sAPEvent.setEventParameters(string);
            return sAPEvent;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining SAPEvent for command ID " + l, (Throwable)exception);
        }
    }

    private String getResolvedWithEnvironmentVariables(String string, Map<String, String> map, boolean bl) {
        String string2 = string;
        if (map.isEmpty()) {
            return string2;
        }
        for (String string3 : map.keySet()) {
            if (bl) {
                if (!string2.contains("%" + string3 + "%")) continue;
                string2 = string2.replace("%" + string3 + "%", map.get(string3));
                continue;
            }
            if (!string2.contains("$" + string3)) continue;
            string2 = string2.replace("$" + string3, map.get(string3));
        }
        return string2;
    }

    private SAPInterceptedJobsDM getSAPInterceptedJobsDM() {
        if (this.sapInterceptedJobsDM == null) {
            this.sapInterceptedJobsDM = (SAPInterceptedJobsDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.SAPInterceptedJobsDM");
        }
        return this.sapInterceptedJobsDM;
    }

    private SAPVariantActionList getSAPVariantActionList(long l, Map<String, String> map, boolean bl) throws ResourceUnavailableException {
        try {
            if (this.sapVariantActionsDM == null) {
                this.sapVariantActionsDM = (SAPVariantActionsDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.SAPVariantActionsDM");
            }
            SAPVariantActionList sAPVariantActionList = this.sapVariantActionsDM.getViaCommandID(l);
            if (!map.isEmpty()) {
                ArrayList<SAPVariantAction> arrayList = sAPVariantActionList.getSAPVariantActions();
                for (SAPVariantAction sAPVariantAction : arrayList) {
                    String string = sAPVariantAction.getParameterLowValue();
                    string = this.getResolvedWithEnvironmentVariables(string, map, bl);
                    String string2 = sAPVariantAction.getParameterHighValue();
                    string2 = this.getResolvedWithEnvironmentVariables(string2, map, bl);
                    sAPVariantAction.setParameterLowValue(string);
                    sAPVariantAction.setParameterHighValue(string2);
                }
            }
            return sAPVariantActionList;
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining SAPVariantActions for command ID " + l, (Throwable)exception);
        }
    }

    @Override
    public SAPExecutableJob getSAPExecutableJob(String string, long l, String string2, String string3) throws ResourceUnavailableException {
        SAPExecutableJob sAPExecutableJob = new SAPExecutableJob(l, string2, string3);
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            String string4;
            String string5;
            String string6;
            Object object;
            Object object2;
            JCoStructure jCoStructure;
            this.startSAPXMISession(sAPConnection);
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobRead(sAPConnection, sAPExecutableJob, false);
            sAPConnection.executeFinalFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string7 = "Error obtaining job details for SAP job " + sAPExecutableJob.getNameAndCount() + " on SAP system " + sAPConnection.getSapSystemDefinitionName() + ". " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string7);
                throw new ResourceUnavailableException(string7);
            }
            JCoStructure jCoStructure2 = jCoFunction.getExportParameterList().getStructure("JOBHEAD");
            String string8 = jCoStructure2.getString("EXECSERVER");
            sAPExecutableJob.setSapExecTarget(string8);
            String string9 = jCoStructure2.getString("JOBCLASS");
            sAPExecutableJob.setSapJobClassAsString(string9);
            try {
                jCoStructure = jCoFunction.getExportParameterList().getStructure("RECIPIENT");
                object2 = jCoStructure.getString("RECIPIENT");
                sAPExecutableJob.setSapSpoolListRecipient((String)object2);
                String string10 = jCoStructure.getString("COPY");
                object = jCoStructure.getString("BLIND_COPY");
                string6 = jCoStructure.getString("EXPRESS");
                string5 = jCoStructure.getString("NO_FORWARDING");
                string4 = this.getSAPRecipientSettingsString(string10, (String)object, string6, string5);
                sAPExecutableJob.setSapRecipientAttributes(string4);
            }
            catch (JCoRuntimeException jCoRuntimeException) {
                logger.warn((Object)("Error obtaining Recipient information for SAP job " + sAPExecutableJob.getNameAndCount()), (Throwable)jCoRuntimeException);
            }
            jCoStructure = jCoFunction.getTableParameterList().getTable("STEPS");
            logger.debug((Object)("SAP Job " + sAPExecutableJob.getNameAndCount() + " contains " + jCoStructure.getNumRows() + " steps."));
            object2 = new SAPABAPStepSet();
            for (int i = 0; i < jCoStructure.getNumRows(); ++i) {
                String string11;
                jCoStructure.setRow(i);
                object = new SAPABAPStep();
                string6 = jCoStructure.getString("PROGRAM");
                string5 = jCoStructure.getString("TYP");
                string4 = jCoStructure.getString("PARAMETER");
                String string12 = jCoStructure.getString("LANGUAGE");
                if (string12 != null && string12.length() > 0) {
                    string11 = SAPLanguageKeys.getISOCodeForKey(string12);
                    ((SAPABAPStep)object).setLanguageCode(string11);
                    logger.debug((Object)("SAP Language key " + string12 + " converted to isoLanguageCode = " + string11));
                }
                string11 = jCoStructure.getString("AUTHCKNAM");
                ((SAPStep)object).setStepType(string5);
                ((SAPABAPStep)object).setAbapProgramName(string6);
                ((SAPABAPStep)object).setAbapProgramVariantName(string4);
                ((SAPABAPStep)object).setSapUserName(string11);
                ((SAPABAPStepSet)object2).addStep((SAPABAPStep)object);
            }
            sAPExecutableJob.setAbapStepSet((SAPABAPStepSet)object2);
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining job definition for SAP job " + sAPExecutableJob.getNameAndCount() + " on SAP System ID " + l, (Throwable)jCoException);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error obtaining job definition for SAP job " + sAPExecutableJob.getNameAndCount() + " on SAP System ID " + l, (Throwable)exception);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return sAPExecutableJob;
    }

    private String getSAPRecipientSettingsString(String string, String string2, String string3, String string4) {
        String string5 = "";
        string5 = string5 + this.getSkybotCodeForAttribute(string);
        string5 = string5 + ":";
        string5 = string5 + this.getSkybotCodeForAttribute(string2);
        string5 = string5 + ":";
        string5 = string5 + this.getSkybotCodeForAttribute(string3);
        string5 = string5 + ":";
        string5 = string5 + this.getSkybotCodeForAttribute(string4);
        return string5;
    }

    private String getSkybotCodeForAttribute(String string) {
        if (string.equals("X")) {
            return "1";
        }
        return "0";
    }

    @Override
    public String getSAPJobLog(String string, long l, String string2, String string3) throws SAPJobNotFoundException, ResourceUnavailableException {
        SAPJobProxy sAPJobProxy = new SAPJobProxy(string2, string3);
        String string4 = "[";
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobJoblogRead(sAPConnection, sAPJobProxy, string);
            sAPConnection.executeFinalFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string5 = "Error obtaining joblog for SAP job " + sAPJobProxy.getNameAndCount() + " on SAP system " + sAPConnection.getSapSystemDefinitionName() + ". " + sAPReturnMessage.getFullReturnMessage();
                if (sAPReturnMessage.getReturnID().equals("XM")) {
                    switch (sAPReturnMessage.getReturnNumber()) {
                        case 49: {
                            string5 = "Job does not exist on SAP System " + sAPConnection.getSapSystemDefinitionName() + ".";
                            throw new SAPJobNotFoundException(string5);
                        }
                    }
                }
                throw new ResourceUnavailableException(string5);
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOB_PROTOCOL_NEW");
            logger.debug((Object)("SAP Joblog for " + sAPJobProxy.getNameAndCount() + " contains " + jCoTable.getNumRows() + " rows."));
            boolean bl = false;
            for (int i = 0; i < jCoTable.getNumRows(); ++i) {
                jCoTable.setRow(i);
                if (bl) {
                    string4 = string4 + ",";
                }
                String string6 = "{\"date\"=>\"" + jCoTable.getString("ENTERDATE") + "\", " + "\"time\"=>\"" + jCoTable.getString("ENTERTIME") + "\", " + "\"text\"=>\"" + jCoTable.getString("TEXT") + "\", " + "\"class\"=>\"" + jCoTable.getString("MSGID") + "\", " + "\"number\"=>\"" + jCoTable.getString("MSGNO") + "\", " + "\"type\"=>\"" + jCoTable.getString("MSGTYPE") + "\"" + "}";
                string4 = string4 + string6;
                logger.debug((Object)("Joblog row " + i + ": " + string6));
                bl = true;
            }
            string4 = string4 + "]";
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining joblog for SAP job " + sAPJobProxy.getNameAndCount() + " on SAP System ID " + l, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return string4;
    }

    @Override
    public SAPJobSpoolRequest[] getSAPJobSpoolRequests(String string, long l, String string2, String string3) throws ResourceUnavailableException {
        SAPJobSpoolRequest[] sAPJobSpoolRequestArray = new SAPJobSpoolRequest[]{};
        SAPJobProxy sAPJobProxy = new SAPJobProxy(string2, string3);
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            Object object;
            this.startSAPXMISession(sAPConnection);
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobDefinitionGet(sAPConnection, sAPJobProxy);
            sAPConnection.executeFinalFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string4 = "Error obtaining job definition for SAP job " + sAPJobProxy.getNameAndCount() + " on SAP system " + sAPConnection.getSapSystemDefinitionName() + ". " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string4);
                throw new ResourceUnavailableException(string4);
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("STEP_TBL");
            int n = jCoTable.getNumRows();
            logger.debug((Object)("SAP Job Definition Step table for " + sAPJobProxy.getNameAndCount() + " contains " + n + " rows."));
            for (int i = 0; i < n; ++i) {
                jCoTable.setRow(i);
                String string5 = jCoTable.getString("PROGRAM");
                object = jCoTable.getString("TYP");
                String string6 = jCoTable.getString("LANGUAGE");
                String string7 = jCoTable.getString("PRDSN");
                logger.debug((Object)("Step " + i + ": Program: " + string5 + " Type: " + (String)object + " Language: " + string6 + " Spool File: " + string7));
            }
            JCoTable jCoTable2 = jCoFunction.getTableParameterList().getTable("SPOOL_ATTR");
            int n2 = jCoTable2.getNumRows();
            logger.debug((Object)("SAP Job spool list for " + sAPJobProxy.getNameAndCount() + " contains " + n2 + " rows."));
            sAPJobSpoolRequestArray = new SAPJobSpoolRequest[n2];
            for (int i = 0; i < n2; ++i) {
                jCoTable2.setRow(i);
                int n3 = jCoTable2.getInt("STEPNO");
                int n4 = jCoTable2.getInt("SPOOLID");
                String string8 = jCoTable2.getString("OWNER");
                String string9 = jCoTable2.getString("LANGU");
                sAPJobSpoolRequestArray[i] = object = new SAPJobSpoolRequest(l, string2, string3, n3, n4, string8, string9);
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining job spool requests for SAP job " + sAPJobProxy.getNameAndCount() + " on SAP System ID " + l, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return sAPJobSpoolRequestArray;
    }

    @Override
    public String getSAPJobSingleSpool(String string, long l, int n, boolean bl) throws Exception {
        String string2 = "";
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionJobReadSingleSpool(sAPConnection, n, bl, 0, 0);
            sAPConnection.executeFinalFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string3 = "Error obtaining job spool for request " + n + " on SAP system " + sAPConnection.getSapSystemDefinitionName() + ". " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string3);
                throw new ResourceUnavailableException(string3);
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("SPOOL_LIST");
            int n2 = jCoTable.getNumRows();
            logger.debug((Object)("SAP SPOOL_LIST table for request " + n + " contains " + n2 + " rows."));
            boolean bl2 = false;
            for (int i = 0; i < n2; ++i) {
                jCoTable.setRow(i);
                String string4 = jCoTable.getString("LINE");
                logger.debug((Object)("Row[" + i + "]: " + string4));
                if (bl2) {
                    string2 = string2 + "\n";
                }
                string2 = string2 + string4;
                bl2 = true;
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining job spool for request " + n + " on SAP System ID " + l, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return string2;
    }

    private SAPInterceptCriteria getInterceptCriteria(long l, SAPInterceptCriteria sAPInterceptCriteria, boolean bl, boolean bl2) throws ResourceUnavailableException {
        SAPConnection sAPConnection = this.getSAPConnection(l);
        return this.getInterceptCriteria(sAPConnection, sAPInterceptCriteria, bl, bl2);
    }

    private SAPInterceptCriteria getInterceptCriteria(SAPConnection sAPConnection, SAPInterceptCriteria sAPInterceptCriteria, boolean bl, boolean bl2) throws ResourceUnavailableException {
        SAPInterceptCriteria sAPInterceptCriteria2 = new SAPInterceptCriteria(sAPConnection.getSapSystemDefinitionName());
        try {
            this.startSAPXMISession(sAPConnection);
            String string = sAPConnection.getExternalUserName();
            JCoFunction jCoFunction = this.getModifyCriteriaTableFunction(string, bl, bl2, sAPInterceptCriteria, sAPConnection);
            sAPConnection.execute(jCoFunction);
            if (bl2) {
                JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("TBCICPT_TABLE");
                int n = jCoTable.getNumRows();
                logger.debug((Object)("Found " + n + " intercept criterion(s) on " + sAPConnection.getUsableSystemName()));
                for (int i = 0; i < n; ++i) {
                    jCoTable.setRow(i);
                    String string2 = jCoTable.getString("CLNT");
                    String string3 = jCoTable.getString("JOBNAME");
                    String string4 = jCoTable.getString("JOBCREATOR");
                    sAPInterceptCriteria2.addSAPInterceptCriterion(sAPConnection.getSapSystemDefinitionName(), sAPConnection.getSapSystemEnvironmentID(), string2, string3, string4);
                }
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining SAP Intercept Criteria from SAP System Definition " + sAPConnection.getSapSystemDefinitionName(), (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return sAPInterceptCriteria2;
    }

    private JCoFunction getModifyCriteriaTableFunction(String string, boolean bl, boolean bl2, SAPInterceptCriteria sAPInterceptCriteria, SAPConnection sAPConnection) throws JCoException {
        String string2 = "BAPI_XBP_MODIFY_CRITERIA_TABLE";
        JCoFunction jCoFunction = sAPConnection.getFunction(string2);
        if (jCoFunction == null) {
            throw new RuntimeException(string2 + " not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
        if (bl2) {
            jCoFunction.getImportParameterList().setValue("CONTENTS", "X");
            return jCoFunction;
        }
        if (!bl) {
            jCoFunction.getImportParameterList().setValue("APPEND", "");
        }
        JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("TBCICPT_TABLE");
        if (sAPInterceptCriteria != null) {
            ArrayList<SAPInterceptCriterion> arrayList = sAPInterceptCriteria.getSAPInterceptCriterions();
            for (SAPInterceptCriterion sAPInterceptCriterion : arrayList) {
                jCoTable.appendRow();
                jCoTable.setValue("CLNT", sAPInterceptCriterion.getClient());
                jCoTable.setValue("JOBNAME", sAPInterceptCriterion.getJobName());
                jCoTable.setValue("JOBCREATOR", sAPInterceptCriterion.getJobCreator());
            }
        }
        return jCoFunction;
    }

    @Override
    public void terminateCommand(long l) {
        logger.debug((Object)("Received notification to terminate the process for Automate Schedule event " + l));
        this.requestsToTerminateAL.add(l);
    }

    @Override
    public SAPChildJob[] getSAPChildJobs(String string, long l, SAPJob sAPJob) throws ResourceUnavailableException {
        SAPChildJob[] sAPChildJobArray = new SAPChildJob[]{};
        try {
            SAPConnection sAPConnection = this.getSAPConnection(l);
            JCoFunction jCoFunction = this.getJobChildrenGetFunction(sAPConnection, sAPJob.getJobCount(), sAPJob.getJobName(), string);
            sAPConnection.executeMiddleFunction(jCoFunction);
            int n = jCoFunction.getExportParameterList().getInt("NR_OF_CHILDREN");
            logger.debug((Object)("NR_OF_CHILDREN = " + n));
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOB_CHILDREN");
            int n2 = jCoTable.getNumRows();
            logger.debug((Object)("Found " + n2 + " child jobs " + " for parent job " + sAPJob.getNameAndCount() + " on SAP System " + sAPConnection.getSapSystemDefinitionName()));
            sAPChildJobArray = new SAPChildJob[n2];
            for (int i = 0; i < n2; ++i) {
                SAPChildJob sAPChildJob;
                jCoTable.setRow(i);
                String string2 = jCoTable.getString("JOBNAME");
                String string3 = jCoTable.getString("JOBCOUNT");
                logger.debug((Object)("ChildJob[" + i + "]: " + string2 + "(" + string3 + ")"));
                sAPChildJobArray[i] = sAPChildJob = new SAPChildJob(sAPJob.getJobName(), string2, string3);
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error getting child jobs for SAP job " + sAPJob.getNameAndCount(), (Throwable)jCoException);
        }
        return sAPChildJobArray;
    }

    @Override
    public int getABAPReportCount(String string, long l, String string2) throws ResourceUnavailableException {
        int n = 0;
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            String string3 = sAPConnection.getExternalUserName();
            if (string != null) {
                string3 = string;
            }
            JCoFunction jCoFunction = this.getABAPReportSelectFunction(sAPConnection, string2, string3, 0);
            sAPConnection.execute(jCoFunction);
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("REPORTS");
            n = jCoTable.getNumRows();
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining count of ABAP Reports from SAP System Definition ID " + l, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return n;
    }

    @Override
    public SAPABAPProgram[] getABAPReports(String string, long l, String string2, int n) throws ResourceUnavailableException {
        logger.debug((Object)"Received request for ABAP Reports.");
        SAPABAPProgram[] sAPABAPProgramArray = new SAPABAPProgram[]{};
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            String string3 = sAPConnection.getExternalUserName();
            if (string != null) {
                string3 = string;
            }
            JCoFunction jCoFunction = this.getABAPReportSelectFunction(sAPConnection, string2, string3, n);
            sAPConnection.execute(jCoFunction);
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("REPORTS");
            int n2 = jCoTable.getNumRows();
            logger.debug((Object)("BAPI_XBP_REPORT_SEARCH(REPORT:" + string2 + ", COUNT:" + n + ") returned " + n2 + " ABAP Reports on SAP System " + sAPConnection.getSapSystemDefinitionName()));
            sAPABAPProgramArray = new SAPABAPProgram[n2];
            for (int i = 0; i < n2; ++i) {
                SAPABAPProgram sAPABAPProgram;
                jCoTable.setRow(i);
                String string4 = jCoTable.getString("NAME");
                String string5 = jCoTable.getString("TEXT");
                sAPABAPProgramArray[i] = sAPABAPProgram = new SAPABAPProgram(string4, string5);
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining ABAP Reports from SAP System Definition ID " + l, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return sAPABAPProgramArray;
    }

    private JCoFunction getABAPReportSelectFunction(SAPConnection sAPConnection, String string, String string2, int n) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_REPORT_SEARCH");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_REPORT_SEARCH not found in SAP.");
        }
        if (string.length() > 0) {
            jCoFunction.getImportParameterList().setValue("REPORT", string);
        }
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string2);
        if (n > 0) {
            jCoFunction.getImportParameterList().setValue("COUNT", n);
        }
        logger.debug((Object)("BAPI_XBP_REPORT_SEARCH function REPORT:" + jCoFunction.getImportParameterList().getValue("REPORT") + " COUNT:" + jCoFunction.getImportParameterList().getValue("COUNT")));
        return jCoFunction;
    }

    private JCoFunction getJobChildrenGetFunction(SAPConnection sAPConnection, String string, String string2, String string3) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_CHILDREN_GET");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_CHILDREN_GET not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", string);
        jCoFunction.getImportParameterList().setValue("JOBNAME", string2);
        jCoFunction.getImportParameterList().setValue("SELECTION", "AL");
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string3);
        return jCoFunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copySAPJob(String string, long l, String string2, String string3, String string4) throws Exception {
        SAPJobSimple sAPJobSimple = new SAPJobSimple(string2, string3);
        SAPSystemDefinition sAPSystemDefinition = this.getSAPSystemDefinition(l);
        SAPConnection sAPConnection = this.getSAPConnection(sAPSystemDefinition);
        String string5 = "SAP job " + sAPJobSimple.getNameAndCount() + " to " + string4 + " on SAP system " + sAPConnection.getSapSystemDefinitionName() + ".";
        logger.debug((Object)("About to copy " + string5));
        try {
            this.startSAPXMISession(sAPConnection);
            JCoFunction jCoFunction = this.getCopyJobFunction(sAPConnection, sAPJobSimple, string4, 1);
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string6 = "Error copying " + string5 + " " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string6);
                throw new Exception(string6);
            }
            String string7 = jCoFunction.getExportParameterList().getString("TARGET_JOBCOUNT");
            logger.debug((Object)("SAP Job " + sAPJobSimple.getNameAndCount() + " copied to " + string4 + "(" + string7 + ")."));
            SAPJobProxy sAPJobProxy = new SAPJobProxy(string4, string7);
            SAPJobSelectParameters sAPJobSelectParameters = new SAPJobSelectParameters(string4, string7);
            sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.SCHEDUL, "X");
            sAPJobSelectParameters.setField(SAPJobSelectParameters.JobSelectField.PRELIM, "X");
            SAPJobSimple sAPJobSimple2 = this.getSAPJob(sAPConnection, sAPJobProxy, sAPJobSelectParameters, SAPJobSelection.NO_GENERAL_CONFIRM);
            this.getSAPJobsDM().save(sAPJobSimple2);
            this.confirmCollectedJob(sAPConnection, sAPJobSimple2);
            logger.debug((Object)("Successfully copied, polled, confirmed and saved newly copied SAP Job " + string4 + "(" + string7 + ")."));
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
    }

    private SAPInterceptedJobMonitorAM getSAPInterceptedJobMonitorAM() throws ResourceUnavailableException {
        if (this.sapInterceptedJobMonitorAM == null) {
            this.sapInterceptedJobMonitorAM = (SAPInterceptedJobMonitorAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPInterceptedJobMonitorAM");
        }
        return this.sapInterceptedJobMonitorAM;
    }

    private JCoFunction getCopyJobFunction(SAPConnection sAPConnection, SAPJobSimple sAPJobSimple, String string, int n) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_COPY");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_JOB_COPY not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("SOURCE_JOBCOUNT", sAPJobSimple.getJobCount());
        jCoFunction.getImportParameterList().setValue("SOURCE_JOBNAME", sAPJobSimple.getJobName());
        jCoFunction.getImportParameterList().setValue("TARGET_JOBNAME", string);
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        jCoFunction.getImportParameterList().setValue("STEP_NUMBER", n);
        return jCoFunction;
    }

    @Override
    public String[] getSAPABAPVariants(long l, String string) throws ResourceUnavailableException {
        String[] stringArray = new String[]{};
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            JCoFunction jCoFunction = this.getVariantInfoGetFunction(sAPConnection, string);
            sAPConnection.execute(jCoFunction);
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("ABAP_VARIANT_TABLE");
            int n = jCoTable.getNumRows();
            logger.debug((Object)("Found " + n + " variants for  ABAP Program '" + string + "' jobs on SAP System " + sAPConnection.getSapSystemDefinitionName()));
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                String string2;
                jCoTable.setRow(i);
                stringArray[i] = string2 = jCoTable.getString("VARIANT");
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining Variants for ABAP Program " + string + " from SAP System Definition ID " + l, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return stringArray;
    }

    private JCoFunction getVariantInfoGetFunction(SAPConnection sAPConnection, String string) throws JCoException {
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_VARIANT_INFO_GET");
        if (jCoFunction == null) {
            throw new RuntimeException("BAPI_XBP_VARIANT_INFO_GET not found in SAP.");
        }
        jCoFunction.getImportParameterList().setValue("ABAP_PROGRAM_NAME", string);
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", sAPConnection.getExternalUserName());
        jCoFunction.getImportParameterList().setValue("VARIANT_SELECT_OPTION", "A");
        return jCoFunction;
    }

    @Override
    public SAPOutputDevice[] getSAPOutputDevices(String string, long l, String string2, String string3) throws ResourceUnavailableException {
        SAPOutputDevice[] sAPOutputDeviceArray = new SAPOutputDevice[]{};
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            JCoTable jCoTable;
            this.startSAPXMISession(sAPConnection);
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionOutputDeviceSearch(sAPConnection, string2, string3, string);
            sAPConnection.executeMiddleFunction(jCoFunction);
            if (sAPConnection.getXBPVersion().equals(SAPXBPVersion.XBP_30)) {
                logger.debug((Object)"Using XBP 3.0 version of BAPI_XBP_OUTPUT_DEVICE_SEARCH");
                jCoTable = jCoFunction.getTableParameterList().getTable("OUTPUT_DEVICES_LONG");
            } else {
                jCoTable = jCoFunction.getTableParameterList().getTable("OUTPUT_DEVICES");
            }
            int n = jCoTable.getNumRows();
            logger.debug((Object)("Found " + n + " output device(s) for search strings short:'" + string2 + "' and long:'" + string3 + "' on SAP System " + sAPConnection.getSapSystemDefinitionName()));
            sAPOutputDeviceArray = new SAPOutputDevice[n];
            for (int i = 0; i < n; ++i) {
                Object object;
                jCoTable.setRow(i);
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                boolean bl = false;
                if (sAPConnection.getXBPVersion().equals(SAPXBPVersion.XBP_30)) {
                    string4 = jCoTable.getString("DEVICELONG");
                    string5 = jCoTable.getString("DEVICESHORT");
                    string6 = jCoTable.getString("DEVICETYPE");
                    string7 = jCoTable.getString("ACCESSMETHOD");
                    string9 = jCoTable.getString("HOSTPRINTER");
                    string10 = jCoTable.getString("STATE_LOCA");
                    object = jCoTable.getString("DEVICELOCKED");
                    bl = ((String)object).equals("X");
                } else {
                    string5 = jCoTable.getString("DEVICE");
                    string6 = jCoTable.getString("DEVICETYPE");
                    string8 = jCoTable.getString("LAYOUT");
                    string10 = jCoTable.getString("STATE_LOCA");
                }
                object = new SAPOutputDevice(string4, string5, string6, string7, string8, string9, string10, bl);
                logger.debug((Object)("device[" + i + "] = " + object));
                sAPOutputDeviceArray[i] = object;
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining Output Devices from SAP System Definition ID " + l, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return sAPOutputDeviceArray;
    }

    @Override
    public void deleteInterceptedSAPJob(String string, long l, String string2, String string3) throws Exception {
        this.deleteSAPJob(string, l, string2, string3);
        this.getSAPInterceptedJobMonitorAM().deleteInterceptedJob(l, string2, string3);
    }

    @Override
    public void notifyInterceptedJobScheduler() {
        try {
            this.getSAPInterceptedJobMonitorAM().notifyOfScheduleChange();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error notifying Intercepted Job Scheduler of schedule change.", (Throwable)resourceUnavailableException);
        }
    }

    @Override
    public void notifyOfLicenseChange(boolean bl) {
        if (bl && !this.isSAPOn()) {
            logger.debug((Object)"Received notification that Automate Schedule is now licensed for SAP.");
            this.startSAPJobCollector();
            this.startSAPJobRemover();
        } else if (!bl && this.isSAPOn()) {
            logger.debug((Object)"Received notification that Automate Schedule is no longer licensed for SAP.");
            this.stopCollectorProcesses();
        }
    }

    @Override
    public void deleteSAPJob(String string, long l, String string2, String string3) throws Exception {
        SAPJobProxy sAPJobProxy = new SAPJobProxy(string2, string3);
        sAPJobProxy.setSapSystemDefinitionID(l);
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            try {
                this.deleteSAPJob(sAPConnection, sAPJobProxy, string);
            }
            catch (DeleteJobException deleteJobException) {
                if (deleteJobException.getReason().equals((Object)DeleteJobException.Reason.JOB_DOES_NOT_EXIST)) {
                    logger.info((Object)("Unable to delete the SAP Job " + sAPJobProxy.getNameAndCount() + " on SAP System " + sAPConnection.getSapSystemDefinitionName() + ".  The job does not exist."));
                }
                logger.error((Object)deleteJobException);
                if (deleteJobException.getCause() != null && deleteJobException.getCause() instanceof JCoException) {
                    throw (JCoException)deleteJobException.getCause();
                }
                throw new ResourceUnavailableException("Error deleting SAP job " + sAPJobProxy.getNameAndCount(), (Throwable)deleteJobException);
            }
            this.getSAPJobsDM().delete(sAPJobProxy);
            logger.debug((Object)("The Automate Schedule record for SAP Job " + sAPJobProxy.getNameAndCount() + " on SAP System " + sAPConnection.getSapSystemDefinitionName() + " was deleted."));
        }
        catch (JCoException jCoException) {
            logger.error((Object)("Error deleting SAP job " + sAPJobProxy.getNameAndCount()), (Throwable)jCoException);
            if (jCoException.getGroup() == 102) {
                throw new ResourceUnavailableException("Error connecting to SAP System " + sAPConnection.getSapSystemDefinitionName() + ".", (Throwable)jCoException);
            }
            throw new ResourceUnavailableException("See Server Diagnostic Log.", (Throwable)jCoException);
        }
        catch (DataException dataException) {
            throw new ResourceUnavailableException("Error deleting SAP job " + sAPJobProxy.getNameAndCount() + " from the Automate Schedule table.", (Throwable)dataException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
    }

    @Override
    public void deleteSAPSystemDefinition(String string, long l) throws ResourceUnavailableException {
        String string2;
        try {
            SAPSystemDefinition sAPSystemDefinition = this.getSAPSystemDefinition(l);
            string2 = sAPSystemDefinition.getName();
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to obtain SAP System Definition for ID " + l + ".  Using ID."));
            string2 = "ID " + l;
        }
        if (this.sapJobRemoverRunner != null) {
            this.sapJobRemoverRunner.stopPollingForSystem(l);
        }
        if (this.sapJobCollectorRunner != null) {
            this.sapJobCollectorRunner.stopPollingForSystem(l);
            while (this.sapJobCollectorRunner.isPollingThisSystem(l)) {
                try {
                    logger.debug((Object)("Waiting on polling to stop for SAP System " + string2 + " before deleting jobs."));
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.warn((Object)"Sleep thread was interrupted in deleteSAPJobs.", (Throwable)interruptedException);
                }
            }
        }
        this.getSAPInterceptedJobMonitorAM().stopPollingForSystem(l);
        try {
            int n = this.getSAPJobsDM().deleteAll(l);
            String[] stringArray = new String[]{String.valueOf(n), string2, string};
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.SAP_JOBS_DELETED.newLogEntry(stringArray);
            ScheduleLogger.write(scheduleLogEntry);
            logger.debug((Object)scheduleLogEntry.getMessageText());
        }
        catch (DataException dataException) {
            throw new ResourceUnavailableException("Error deleting SAP jobs for SAP System Definition " + string2, (Throwable)dataException);
        }
    }

    private SAPJobsDM getSAPJobsDM() {
        if (this.sapJobsDM == null) {
            this.sapJobsDM = (SAPJobsDM)ManagerRegistry.getManagerStartsWith((BasicIdentifier)this.peer.getConnectedAgentServer(), (String)"ENTERPRISE.SAPJobsDM");
        }
        return this.sapJobsDM;
    }

    @Override
    public void cancelSAPJob(String string, long l, String string2, String string3) throws EndJobException {
        SAPJobProxy sAPJobProxy = new SAPJobProxy(string2, string3);
        sAPJobProxy.setSapSystemDefinitionID(l);
        SAPConnection sAPConnection = null;
        try {
            sAPConnection = this.getSAPConnection(l);
            this.startSAPXMISession(sAPConnection);
            this.terminateSAPJob(sAPJobProxy, sAPConnection);
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new EndJobException("Error ending SAP Job " + sAPJobProxy.getNameAndCount(), (Exception)((Object)resourceUnavailableException));
        }
        catch (JCoException jCoException) {
            throw new EndJobException("Error ending SAP Job " + sAPJobProxy.getNameAndCount(), (Exception)((Object)jCoException));
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
    }

    @Override
    public void runSAPJob(String string, long l, String string2, String string3, boolean bl) throws ResourceUnavailableException {
        SAPConnection sAPConnection = null;
        try {
            sAPConnection = this.getSAPConnection(l);
            this.startSAPXMISession(sAPConnection);
            SAPExecutableJob sAPExecutableJob = new SAPExecutableJob(l, string2, string3, bl);
            this.startSAPJob(sAPConnection, sAPExecutableJob);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Error starting SAP Job " + string2 + "(" + string3 + ")", (Throwable)exception);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
    }

    @Override
    public void pollJobsInfoUpdate(SAPPollJobsEvent sAPPollJobsEvent) {
        logger.debug((Object)("Received notification of changes to the poll jobs settings for SAP System Definition ID " + sAPPollJobsEvent.getSAPSystemDefinitionID()));
        try {
            SAPSystemDefinition sAPSystemDefinition = this.getSAPSystemDefinitionsDM().get(sAPPollJobsEvent.getSAPSystemDefinitionID());
            String[] stringArray = new String[]{sAPSystemDefinition.getName(), String.valueOf(sAPSystemDefinition.getPollJobIntervalInMinutes())};
            if (!sAPSystemDefinition.isPollJobs()) {
                this.sapJobCollectorRunner.stopPollingForSystem(sAPSystemDefinition.getOID());
                this.sapJobRemoverRunner.stopPollingForSystem(sAPSystemDefinition.getOID());
                ScheduleLogEntry scheduleLogEntry = RosettaMsg.SAP_POLLING_DISABLED.newLogEntry(stringArray);
                ScheduleLogger.write(scheduleLogEntry);
                logger.info((Object)scheduleLogEntry.getMessageText());
                return;
            }
            this.sapJobCollectorRunner.resetPollingForSystem(sAPSystemDefinition.getOID(), sAPSystemDefinition.getName(), sAPSystemDefinition.getPollJobIntervalSeconds());
            this.sapJobRemoverRunner.resetPollingForSystem(sAPSystemDefinition.getOID(), sAPSystemDefinition.getName(), sAPSystemDefinition.getPollJobIntervalSeconds());
            ScheduleLogEntry scheduleLogEntry = RosettaMsg.SAP_POLLING_ENABLED.newLogEntry(stringArray);
            ScheduleLogger.write(scheduleLogEntry);
            logger.info((Object)scheduleLogEntry.getMessageText());
        }
        catch (Exception exception) {
            logger.error((Object)("Error updating SAP Job Collector for changes to SAP System Definition ID " + sAPPollJobsEvent.getSAPSystemDefinitionID()), (Throwable)exception);
        }
    }

    @Override
    public String getSAPXBPVersions(String string, long l) throws ResourceUnavailableException {
        SAPConnection sAPConnection = this.getSAPConnection(l);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "[";
        try {
            String string3;
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionSXMIVersionsGet(sAPConnection);
            sAPConnection.execute(jCoFunction);
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("VERSIONS");
            int n = jCoTable.getNumRows();
            logger.debug((Object)("VERSIONS contains " + jCoTable.getNumRows() + " row(s)."));
            if (n == 0) {
                throw new ResourceUnavailableException("XBP not found on SAP System " + sAPConnection.getJCoDestination().getApplicationServerHost());
            }
            for (int i = 0; i < n; ++i) {
                jCoTable.setRow(i);
                string3 = jCoTable.getString("VERSION");
                logger.debug((Object)("*** XBP Version = " + string3));
                arrayList.add(string3);
            }
            if (arrayList.size() == 1 && arrayList.contains(XBP_30_STRING)) {
                arrayList.add(XBP_20_STRING);
            }
            Iterator iterator = arrayList.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
                if (bl) {
                    string2 = string2 + ",";
                }
                string2 = string2 + "{";
                string2 = string2 + "\"version\"=>\"" + string3 + "\"}";
                bl = true;
            }
        }
        catch (JCoException jCoException) {
            logger.error((Object)("Error obtaining XBP Versions from SAP System " + sAPConnection.getSapSystemDefinitionName()), (Throwable)jCoException);
        }
        string2 = string2 + "]";
        return string2;
    }

    @Override
    public void createSAPJob(String string, long l, String string2) throws ResourceUnavailableException {
        logger.debug((Object)("Received request to create SAP job " + string2 + " on SAP System Definition ID " + l + ".  Note: This code is not complete."));
    }

    @Override
    public int createSAPCriterionProfile(String string, long l, SAPProfileTypeSelection sAPProfileTypeSelection, int n, String string2) throws ResourceUnavailableException {
        int n2 = -1;
        String string3 = SAPFunctionUtility.getCreateCMProfileXML(sAPProfileTypeSelection, n, string2);
        SAPConnection sAPConnection = this.getSAPConnection(l);
        try {
            this.startSAPXMISession(sAPConnection);
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionCMProfileCreate(sAPConnection, string, string3);
            sAPConnection.execute(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string4 = "Error executing " + jCoFunction.getName() + ".  SAP Error " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string4);
                throw new ResourceUnavailableException(string4);
            }
            n2 = jCoFunction.getExportParameterList().getInt("E_PROFILEID");
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error creating SAP criterion profile using XML: " + string3, (Throwable)jCoException);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
        return n2;
    }

    @Override
    public int validateSAPConnection(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws Exception {
        return this.validateSAPConnection(SAPConnectionType.CUSTOM_APPLICATION_SERVER, null, null, string2, string3, string4, string5, string6, string7, string8, string9, string10);
    }

    @Override
    public int validateSAPConnectionLB(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws Exception {
        return this.validateSAPConnection(SAPConnectionType.GROUP_SERVER_SELECTION, string2, string3, null, null, string4, string5, string6, string7, string8, string9, string10);
    }

    private int validateSAPConnection(SAPConnectionType sAPConnectionType, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) throws Exception {
        String string12;
        int n = 0;
        SAPSystemDefinition sAPSystemDefinition = new SAPSystemDefinition();
        sAPSystemDefinition.setName("test");
        sAPSystemDefinition.setConnectionType(sAPConnectionType.persistanceCode());
        if (sAPConnectionType.equals(SAPConnectionType.GROUP_SERVER_SELECTION)) {
            string12 = "Message Server(" + string + ") Group(" + string2 + ")";
            sAPSystemDefinition.setMessageServer(string);
            sAPSystemDefinition.setGroupOrServer(string2);
        } else {
            string12 = string3;
            sAPSystemDefinition.setAshost(string3);
            sAPSystemDefinition.setSystemNumber(string4);
        }
        sAPSystemDefinition.setR3name(string5);
        sAPSystemDefinition.setRouter(string6);
        String string13 = TimeZone.getDefault().getID();
        sAPSystemDefinition.setTimeZoneString(string13);
        SAPSystemEnvironment sAPSystemEnvironment = string10 != null && string10.length() > 0 ? new SAPSystemEnvironment("test", "testing connection", string11, string7, string8, string9, string10, 0L) : new SAPSystemEnvironment("test", "testing connection", string11, string7, string8, string9, 0L);
        SAPSystem sAPSystem = new SAPSystem(sAPSystemDefinition, sAPSystemEnvironment);
        JCoDestination jCoDestination = this.getDestination(sAPSystem);
        String string14 = "";
        try {
            new SAPConnection(jCoDestination, sAPSystem);
            logger.debug((Object)("Connection established to " + string12));
            return n;
        }
        catch (JCoException jCoException) {
            string14 = "Error connecting to SAP System " + sAPSystemDefinition.getName() + ".";
            switch (jCoException.getGroup()) {
                case 102: {
                    string14 = string14 + " Communication error: " + jCoException.getMessage();
                    n = 1;
                    break;
                }
                case 103: {
                    string14 = string14 + " Logon error: " + jCoException.getMessage();
                    n = 2;
                    break;
                }
                default: {
                    throw new Exception(string14, jCoException);
                }
            }
            logger.error((Object)(string14 + ": " + jCoException.getMessage()));
            Throwable throwable = jCoException.getCause();
            logger.debug((Object)("theCause = " + throwable));
            return n;
        }
    }

    @Override
    public void processSAPEventHistoryRecords(long l) throws ResourceUnavailableException {
        try {
            logger.debug((Object)"Starting processing SAP Event history monitors...");
            ArrayList<SAPSystemDefinition> arrayList = this.getSAPSystemDefinitionsDM().getAll();
            for (SAPSystemDefinition sAPSystemDefinition : arrayList) {
                this.processSapSystemDefRequest(sAPSystemDefinition, l);
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)"Error while retrieving SAP System Definitions.", throwable);
        }
    }

    private void processSapSystemDefRequest(SAPSystemDefinition sAPSystemDefinition, long l) throws ResourceUnavailableException {
        long l2 = System.currentTimeMillis();
        logger.debug((Object)("Checking for active monitors for SAP System Definition " + sAPSystemDefinition.getName() + "."));
        SAPEventMonitorDM sAPEventMonitorDM = (SAPEventMonitorDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPEventMonitorDM");
        SAPEventMonitor[] sAPEventMonitorArray = new SAPEventMonitor[]{};
        try {
            sAPEventMonitorArray = sAPEventMonitorDM.getListByServerID(sAPSystemDefinition.getOID(), true);
        }
        catch (DataException dataException) {
            logger.debug((Object)("Unable to obtain the list of SAP Event Monitors from system " + sAPSystemDefinition.getName() + "."), (Throwable)dataException);
            return;
        }
        boolean bl = this.isLicensedForSAP();
        if (l > 0L) {
            l2 = l;
        } else {
            try {
                l2 = this.getFromDate(sAPSystemDefinition, l2);
            }
            catch (DataException dataException) {
                logger.debug((Object)"Unable to retrieve the read back information.  Using default value of NONE.");
            }
        }
        SAPConnection sAPConnection = null;
        try {
            sAPConnection = this.getSAPConnection(sAPSystemDefinition);
            logger.debug((Object)("Requesting SAP Event history for SAP System Definition " + sAPConnection.getJCoDestination().getApplicationServerHost() + "."));
            this.startSAPXMISession(sAPConnection);
            logger.debug((Object)("Using From Date: " + new Date(l2) + " : " + l2));
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionEventHistoryRecords(sAPConnection, l2);
            sAPConnection.executeFinalFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string = "Error obtaining SAP Event History  on SAP system " + sAPConnection.getJCoDestination().getApplicationServerHost() + ". " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string);
                throw new ResourceUnavailableException(string);
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("RAISED_EVENTS");
            int n = jCoTable.getNumRows();
            logger.debug((Object)("Found " + n + " Event History records " + "on SAP System " + sAPConnection.getJCoDestination().getApplicationServerHost()));
            for (int i = 0; i < n; ++i) {
                jCoTable.setRow(i);
                SAPEventHistory sAPEventHistory = this.getSAPEventHistoryRecord(jCoTable, sAPSystemDefinition.getOID());
                this.checkMonitors(sAPEventMonitorArray, sAPEventHistory, sAPSystemDefinition, bl);
            }
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("Error obtaining SAP Event hitory  on SAP System ID " + sAPConnection.getJCoDestination().getApplicationServerHost(), throwable);
        }
        finally {
            this.endSAPXMISession(sAPConnection);
        }
    }

    @Override
    public boolean isLicensedForSAP() {
        EnterpriseLicenseInfoAM enterpriseLicenseInfoAM = (EnterpriseLicenseInfoAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseLicenseInfoAM");
        try {
            EnterpriseLicenseInfo enterpriseLicenseInfo = enterpriseLicenseInfoAM.getLicenseInfo();
            if (enterpriseLicenseInfo == null) {
                logger.error((Object)"Error obtaining license information.");
                return false;
            }
            return enterpriseLicenseInfo.isLicensedForFeature(EnterpriseProductLicense.FEATURE.SAP, this.peer.getRemotePeerID().getHardwareKey().toUpperCase());
        }
        catch (Exception exception) {
            logger.error((Object)"Error obtaining license information.", (Throwable)exception);
            return false;
        }
    }

    private boolean isValid(SAPEventMonitor[] sAPEventMonitorArray, SAPEventHistory sAPEventHistory, SAPSystemDefinition sAPSystemDefinition) {
        if (sAPEventHistory == null) {
            logger.debug((Object)"SAP Event History record is required.");
            return false;
        }
        if (sAPSystemDefinition == null) {
            logger.debug((Object)"SAP System Defintion is required.");
        }
        if (sAPEventMonitorArray == null || sAPEventMonitorArray.length < 1) {
            logger.debug((Object)("No monitors present for SAP Event History event ID " + sAPEventHistory.getEventIdentifier()));
            return false;
        }
        if (sAPEventHistory.getEventIdentifier() == null || sAPEventHistory.getEventIdentifier().trim().length() < 1) {
            logger.debug((Object)("No event identifioer found for SAP Event History event ID " + sAPEventHistory.getName()));
            return false;
        }
        return true;
    }

    private void checkMonitors(SAPEventMonitor[] sAPEventMonitorArray, SAPEventHistory sAPEventHistory, SAPSystemDefinition sAPSystemDefinition, boolean bl) {
        if (this.isValid(sAPEventMonitorArray, sAPEventHistory, sAPSystemDefinition)) {
            boolean bl2 = false;
            for (int i = 0; i < sAPEventMonitorArray.length; ++i) {
                SAPEventMonitor sAPEventMonitor = sAPEventMonitorArray[i];
                logger.debug((Object)("Checking critera match: " + sAPEventHistory.getEventIdentifier()));
                if (!this.matchesCriteria(sAPEventMonitorArray[i].getDataFilter(), sAPEventHistory)) continue;
                bl2 = true;
                this.processEventHistoryRecord(sAPEventHistory, sAPEventMonitor, bl);
            }
            if (!bl2) {
                logger.debug((Object)("Event " + sAPEventHistory.getEventIdentifier() + " was skipped: " + sAPEventHistory.toString()));
                if (logger.isTraceEnabled()) {
                    this.logSkippedEventHistory(sAPEventHistory);
                }
            }
        } else {
            logger.debug((Object)"List was not found to be valid.");
        }
    }

    private void logSkippedEventHistory(SAPEventHistory sAPEventHistory) {
        logger.trace((Object)("Skipping the SAP Event History Event: " + sAPEventHistory.toString()));
    }

    private void processEventHistoryRecord(SAPEventHistory sAPEventHistory, SAPEventMonitor sAPEventMonitor, boolean bl) {
        sAPEventHistory.setEventMonitorName(sAPEventMonitor.getName());
        sAPEventHistory.setEventMonitorOID(sAPEventMonitor.getID());
        if (!bl) {
            sAPEventHistory.setReasonCode(1);
        } else if (sAPEventMonitor.isDisabled()) {
            sAPEventHistory.setReasonCode(2);
        } else if (!this.checkTimeOK(sAPEventMonitor, sAPEventHistory)) {
            sAPEventHistory.setReasonCode(3);
        } else {
            sAPEventHistory.setReasonCode(0);
        }
        this.writeHistory(sAPEventHistory);
        ScheduleLogEntry scheduleLogEntry = this.getSLEAndWriteLogEntry(sAPEventHistory, sAPEventMonitor);
        if (sAPEventMonitor.isSendEmail()) {
            this.sendNotification(sAPEventHistory, sAPEventMonitor, scheduleLogEntry);
        }
        if (sAPEventMonitor.isSendSNMPTrap()) {
            this.sendSNMPTrap(sAPEventHistory, scheduleLogEntry.getMessageText());
        }
    }

    private void sendSNMPTrap(SAPEventHistory sAPEventHistory, String string) {
        SAPEventSNMPTrap sAPEventSNMPTrap = new SAPEventSNMPTrap();
        if (sAPEventSNMPTrap != null) {
            sAPEventSNMPTrap.setEventID(sAPEventHistory.getOID());
            sAPEventSNMPTrap.setEventName(sAPEventHistory.getEventIdentifier());
            sAPEventSNMPTrap.setServerName(sAPEventHistory.getServerName());
            sAPEventSNMPTrap.setServerDateTime(new Timestamp(sAPEventHistory.getEventTimestampUTC()));
            sAPEventSNMPTrap.setEventData(sAPEventHistory.getEventParameters());
            sAPEventSNMPTrap.setText(string);
            try {
                this.getEnterpriseSNMPTrapAM().sendSNMPTrap(sAPEventSNMPTrap);
            }
            catch (Exception exception) {
                logger.error((Object)"Error sending an Agent Event SNMP Trap.", (Throwable)exception);
            }
        }
    }

    private EnterpriseSNMPTrapAM getEnterpriseSNMPTrapAM() {
        if (this.enterpriseSNMPTrapAM == null) {
            this.enterpriseSNMPTrapAM = (EnterpriseSNMPTrapAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.EnterpriseSNMPTrapAM");
        }
        return this.enterpriseSNMPTrapAM;
    }

    private void sendNotification(SAPEventHistory sAPEventHistory, SAPEventMonitor sAPEventMonitor, ScheduleLogEntry scheduleLogEntry) {
        NotificationListDM notificationListDM = (NotificationListDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.NotificationListDM");
        String[] stringArray = null;
        try {
            stringArray = notificationListDM.get(sAPEventMonitor.getNotificationListID()).getListOfUniqueEmails();
        }
        catch (Exception exception) {
            logger.error((Object)"Error retrieving Agent Notification Options.", (Throwable)exception);
        }
        if (stringArray.length > 0) {
            String string = scheduleLogEntry.getMessageText();
            this.sendEmail(stringArray, "Automate Schedule SAP Event Notice " + string, string + "<br/>SAP Event Parameters:  " + sAPEventHistory.getEventParameters().trim());
        }
    }

    private void sendEmail(String[] stringArray, String string, String string2) {
        try {
            this.getEnterpriseEmailAM().sendMessage(stringArray, string, string2);
        }
        catch (Exception exception) {
            logger.error((Object)"Error sending an email.", (Throwable)exception);
        }
    }

    private EnterpriseEmailAM getEnterpriseEmailAM() {
        if (this.enterpriseEmailAM == null) {
            this.enterpriseEmailAM = (EnterpriseEmailAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.EnterpriseEmailAM");
        }
        return this.enterpriseEmailAM;
    }

    private ScheduleLogEntry getSLEAndWriteLogEntry(SAPEventHistory sAPEventHistory, SAPEventMonitor sAPEventMonitor) {
        ScheduleLogEntry scheduleLogEntry;
        String string = String.valueOf(sAPEventHistory.getOID());
        String[] stringArray = new String[]{sAPEventHistory.getEventMonitorName(), string, sAPEventHistory.getServerName()};
        switch (sAPEventHistory.getReasonCode()) {
            case 2: {
                scheduleLogEntry = RosettaMsg.SAP_EVENT_HELD.newLogEntry(stringArray);
                break;
            }
            case 3: {
                scheduleLogEntry = RosettaMsg.SAP_EVENT_OUTSIDE_TIME_SCOPE.newLogEntry(stringArray);
                break;
            }
            case 1: {
                scheduleLogEntry = RosettaMsg.SAP_EVENT_NOT_LICENSED.newLogEntry(stringArray);
                break;
            }
            default: {
                scheduleLogEntry = RosettaMsg.SAP_EVENT_OCCURED.newLogEntry(stringArray);
            }
        }
        ScheduleLogger.write(null, scheduleLogEntry);
        return scheduleLogEntry;
    }

    private SAPEventHistoryDM getSAPEventHistoryDM() {
        if (this.sapEventHistoryDM == null) {
            this.sapEventHistoryDM = (SAPEventHistoryDM)ManagerRegistry.getManager((String)"ENTERPRISE.SAPEventHistoryDM");
        }
        return this.sapEventHistoryDM;
    }

    private boolean writeHistory(SAPEventHistory sAPEventHistory) {
        try {
            this.getSAPEventHistoryDM().save(sAPEventHistory, null);
            return true;
        }
        catch (Throwable throwable) {
            logger.debug((Object)"Unable to save the SAP Event history record.", throwable);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Event not saved: " + sAPEventHistory.toString()));
            }
            return false;
        }
    }

    private boolean checkTimeOK(SAPEventMonitor sAPEventMonitor, SAPEventHistory sAPEventHistory) {
        int n = sAPEventMonitor.getFromTime();
        int n2 = sAPEventMonitor.getToTime();
        String string = DateTranslator.packTime((Date)new Date(sAPEventHistory.getEventTimestampUTC()));
        int n3 = Integer.parseInt(string);
        if (n2 > n) {
            if (n3 < n || n3 >= n2) {
                logger.debug((Object)("SAP Event is outside time range for SAP Event Monitor " + sAPEventMonitor.getName()));
                return false;
            }
        } else if (n3 < n2 && n3 >= n2) {
            logger.debug((Object)("SAP Event is outside time range for SAP Event Monitor " + sAPEventMonitor.getName()));
            return false;
        }
        return true;
    }

    private boolean matchesCriteria(DataFilter dataFilter, SAPEventHistory sAPEventHistory) {
        String string = sAPEventHistory.getEventIdentifier();
        if (string == null || string.trim().length() < 1) {
            logger.debug((Object)("No event Identifier was found on the event.  Record: " + sAPEventHistory.toString()));
            return false;
        }
        String string2 = sAPEventHistory.getEventParameters();
        FilterCriteria[] filterCriteriaArray = dataFilter.getCriteria();
        block8: for (int i = 0; i < filterCriteriaArray.length; ++i) {
            if (!filterCriteriaArray[i].getFieldName().equals(string)) {
                logger.debug((Object)("Event Identifiers do NOT match.  Record: " + filterCriteriaArray[i].getFieldName() + " : " + string));
                return false;
            }
            String string3 = (String)((Object)filterCriteriaArray[i].getValue());
            switch (filterCriteriaArray[i].getOperator()) {
                case 0: {
                    if (string2.equals(string3)) continue block8;
                    logger.trace((Object)"Failed =");
                    return false;
                }
                case 1: {
                    if (!string2.equals(string3)) continue block8;
                    logger.trace((Object)"Failed !=");
                    return false;
                }
                case 6: {
                    if (string2.startsWith(string3)) continue block8;
                    logger.trace((Object)"Failed startswith");
                    return false;
                }
                case 10: {
                    if (!string2.startsWith(string3)) continue block8;
                    logger.trace((Object)"Failed !startswith");
                    return false;
                }
                case 9: {
                    if (string2.contains(string3)) continue block8;
                    logger.trace((Object)"Failed contains");
                    return false;
                }
                case 11: {
                    if (!string2.contains(string3)) continue block8;
                    logger.trace((Object)"Failed deos NOT contain");
                    return false;
                }
            }
        }
        return true;
    }

    private SAPEventHistory getSAPEventHistoryRecord(JCoTable jCoTable, long l) {
        SAPEventHistory sAPEventHistory = new SAPEventHistory();
        sAPEventHistory.setEventGuid(jCoTable.getString("EVENTGUID"));
        sAPEventHistory.setEventIdentifier(jCoTable.getString("EVENTID"));
        sAPEventHistory.setEventParameters(jCoTable.getString("EVENTPARM"));
        sAPEventHistory.setServerName(jCoTable.getString("EVENTSERVER"));
        sAPEventHistory.setSapSystemDefinitionID(l);
        sAPEventHistory.setEventState(jCoTable.getString("EVENTSTATE"));
        BigDecimal bigDecimal = jCoTable.getBigDecimal("EVTTIMESTAMP");
        logger.debug((Object)("Using raw data: " + bigDecimal.toPlainString()));
        long l2 = this.convertBigDecimalToLong(bigDecimal);
        logger.debug((Object)("Converted date: " + new Date(l2)));
        sAPEventHistory.setEventTimestampUTC(l2);
        sAPEventHistory.setProcessState(jCoTable.getString("PROCESSSTATE"));
        return sAPEventHistory;
    }

    private long convertBigDecimalToLong(BigDecimal bigDecimal) {
        Date date = DateTranslator.getDateFromBigDecimal((BigDecimal)bigDecimal);
        return date.getTime();
    }

    private long getFromDate(SAPSystemDefinition sAPSystemDefinition, long l) throws DataException, ResourceUnavailableException {
        if (sAPSystemDefinition.isUseStartupDefaults()) {
            SAPSystemSetupDM sAPSystemSetupDM = (SAPSystemSetupDM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.SAPSystemSetupDM");
            SAPSystemSetup sAPSystemSetup = sAPSystemSetupDM.get();
            return SAPSystemSetup.getStartDate(sAPSystemSetup.getReadBacktype(), sAPSystemSetup.getReadBackValue(), sAPSystemSetup.getReadBackUnitOfMeasure(), l);
        }
        return SAPSystemSetup.getStartDate(sAPSystemDefinition.getReadBackType(), sAPSystemDefinition.getReadBackValue(), sAPSystemDefinition.getReadbackUnitOfMeasure(), l);
    }

    @Override
    public SAPJobSpoolRequest[] getSapJobSpoolNumber(String string, long l, String string2, String string3) throws Exception {
        SAPConnection sAPConnection = this.getSAPConnection(l);
        JCoFunction jCoFunction = sAPConnection.getFunction("BAPI_XBP_JOB_DEFINITION_GET");
        this.startSAPXMISession(sAPConnection);
        jCoFunction.getImportParameterList().setValue("JOBNAME", string2);
        jCoFunction.getImportParameterList().setValue("JOBCOUNT", string3);
        jCoFunction.getImportParameterList().setValue("EXTERNAL_USER_NAME", string);
        sAPConnection.execute(jCoFunction);
        SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
        if (sAPReturnMessage.isError()) {
            // empty if block
        }
        return null;
    }

    @Override
    public CommandSetCommand[] getExpandedCSCArray(JobHistory jobHistory, CommandSetCommand[] commandSetCommandArray, long l, boolean bl) {
        CommandSetCommand[] commandSetCommandArray2 = commandSetCommandArray;
        logger.debug((Object)("Job History " + jobHistory.getId() + " is ScheduleType " + ScheduleJobProxy.ScheduleType.SAP_RUN_INTERCEPT + " "));
        ArrayList<Object> arrayList = new ArrayList();
        String string = "";
        try {
            Object object;
            if (jobHistory.getInitiationCode().equals(JobInitCode.USER_DO)) {
                logger.debug((Object)"User Do on Run Intercepted Job.");
                string = "Automate Schedule job ID " + l;
                arrayList = this.getSAPInterceptedJobsDM().getAllForJobID(l);
            } else {
                long l2 = jobHistory.getId();
                if (jobHistory.getInitiationCode().equals(JobInitCode.RESTART)) {
                    l2 = jobHistory.getRestartParentHistoryID();
                    arrayList = this.getSAPInterceptedJobsDM().getForJobHistoryIDOnRestart(l2);
                } else {
                    arrayList = this.getSAPInterceptedJobsDM().getForJobHistoryID(l2);
                }
                string = "Automate Schedule job history ID " + l2;
            }
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            int n = 0;
            for (Object object2 : commandSetCommandArray) {
                arrayList2.add(object2);
                n = object2.getLineNumber();
            }
            ++n;
            if (arrayList.size() == 0) {
                String string2 = "No non-terminal nor scheduled intercepted jobs found for this Automate Schedule job with schedule type " + ScheduleJobProxy.ScheduleType.SAP_RUN_INTERCEPT;
                logger.warn((Object)string2);
                String string3 = "REM " + string2;
                if (!bl) {
                    string3 = "# " + string2;
                }
                object = new CommandSetCommand(string3);
                ((CommandSetCommand)((Object)object)).setCancelOnError(false);
                ((CommandSetCommand)((Object)object)).setLineNumber(n);
            } else {
                SAPInterceptedJob sAPInterceptedJob;
                Object object2;
                logger.debug((Object)("Found " + arrayList.size() + " non-terminal intercepted job(s) to run for " + string));
                SAPExecutableJob sAPExecutableJob = new SAPExecutableJob();
                String string4 = arrayList.size() + " Intercepted SAP ";
                string4 = arrayList.size() == 1 ? string4 + "job" : string4 + "jobs";
                object2 = "Release " + string4;
                String string5 = bl ? "REM " + (String)object2 : "# " + (String)object2;
                if (arrayList.size() == 1) {
                    sAPInterceptedJob = (SAPInterceptedJob)arrayList.get(0);
                    sAPExecutableJob = new SAPExecutableJob(sAPInterceptedJob);
                    sAPExecutableJob.setExecutableSAPJobType(SAPExecutableJob.ExecutableSAPJobType.SINGLE_INTERCEPTED);
                } else {
                    sAPExecutableJob.setWaitOnCompletion(false);
                    sAPExecutableJob.setJobName((String)object2);
                    sAPExecutableJob.setExecutableSAPJobType(SAPExecutableJob.ExecutableSAPJobType.MULTIPLE_INTERCEPTED);
                }
                sAPExecutableJob.setInterceptedJobsToRelease(arrayList);
                object = new CommandSetCommand(string5);
                ((CommandSetCommand)((Object)object)).setReturnCode(AgentReturnCode.getInstanceStandard());
                ((CommandSetCommand)((Object)object)).setCommandType(6);
                ((CommandSetCommand)((Object)object)).setLineNumber(n);
                ((CommandSetCommand)((Object)object)).setCancelOnError(true);
                sAPInterceptedJob = (SAPInterceptedJob)arrayList.get(0);
                sAPExecutableJob.setSapSystemDefinitionID(sAPInterceptedJob.getSapSystemDefinitionID());
                SAPExecutable sAPExecutable = new SAPExecutable(sAPExecutableJob);
                ((CommandSetCommand)((Object)object)).setSAPExecutable(sAPExecutable);
                sAPExecutable = this.getSAPExecutableFromCommand((CommandSetCommand)((Object)object), bl);
                ((CommandSetCommand)((Object)object)).setSAPExecutable(sAPExecutable);
            }
            arrayList2.add(object);
            commandSetCommandArray2 = arrayList2.toArray(new CommandSetCommand[arrayList2.size()]);
            if (arrayList.size() > 0) {
                this.getSAPInterceptedJobsDM().update(arrayList, jobHistory.getId(), SAPInterceptedJob.InterceptedJobStatus.SUBMITTED);
                this.notifyInterceptedJobScheduler();
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error loading Run Intercepted Jobs for this job.", (Throwable)exception);
        }
        return commandSetCommandArray2;
    }

    private List<Long> getDeletedSAPJobIDs(HashMap<String, SAPJobProxy> hashMap) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Iterator<SAPJobProxy> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            long l = iterator.next().getOID();
            arrayList.add(l);
        }
        return arrayList;
    }

    static /* synthetic */ int access$500(SAPServerHelperAMImpl sAPServerHelperAMImpl, SAPConnection sAPConnection, SAPJobSelection sAPJobSelection) throws ResourceUnavailableException {
        return sAPServerHelperAMImpl.loadSAPJobsIntoSkybotInitialPoll(sAPConnection, sAPJobSelection);
    }

    static /* synthetic */ int access$600(SAPServerHelperAMImpl sAPServerHelperAMImpl, SAPConnection sAPConnection, SAPJobSelection sAPJobSelection) throws ResourceUnavailableException {
        return sAPServerHelperAMImpl.loadSAPJobsIntoSkybot(sAPConnection, sAPJobSelection);
    }

    static /* synthetic */ int access$700(SAPServerHelperAMImpl sAPServerHelperAMImpl, SAPConnection sAPConnection, HashMap hashMap) throws Exception {
        return sAPServerHelperAMImpl.confirmCollectedJobs(sAPConnection, hashMap);
    }

    static /* synthetic */ boolean access$800(SAPServerHelperAMImpl sAPServerHelperAMImpl, Exception exception) {
        return sAPServerHelperAMImpl.isXM28Error(exception);
    }

    static /* synthetic */ void access$1100(SAPServerHelperAMImpl sAPServerHelperAMImpl, SAPConnection sAPConnection, HashMap hashMap) {
        sAPServerHelperAMImpl.processUpdatedJobInfoForJobs(sAPConnection, hashMap);
    }

    static {
        numberFormatter.setMinimumIntegerDigits(2);
        collectorPollQueue = new PriorityBlockingQueue<SAPPollJobsInfo>(11, new SAPPollInfoComparator());
        removerPollQueue = new LinkedBlockingQueue<SAPPollJobsInfo>();
    }

    class SAPJobRemoverRunner
    extends SAPJobProcessor {
        private boolean shutdown = false;
        private Object mainWaitObject = new Object();
        private SAPPollJobsInfo earliestPI;
        private boolean waitingForPollTime = false;
        private boolean resetForPolling = false;
        private long waitTimeMS;

        SAPJobRemoverRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug((Object)"SAPJobRemoverRunner is about to start.");
            this.loadInitialPollInfoObjects();
            while (!this.shutdown) {
                Object object = this.mainWaitObject;
                synchronized (object) {
                    try {
                        this.earliestPI = this.getNextPollInfo(removerPollQueue);
                        this.waitTimeMS = this.earliestPI.getPollTimeMS();
                        if (this.waitTimeMS == 0L) {
                            this.waitingForPollTime = false;
                            logger.debug((Object)"The Runner currently has no SAP systems to process and will wait to be notified.");
                        } else {
                            this.waitingForPollTime = true;
                            this.waitTimeMS = this.getNewWaitTime(this.earliestPI);
                        }
                        this.mainWaitObject.wait(this.waitTimeMS);
                        logger.debug((Object)"SAP Job Remover is waking up...");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug((Object)"The SAP Job Remover was interrupted.");
                    }
                    catch (SAPJobProcessor.NowOrPastException nowOrPastException) {
                        logger.debug((Object)"The SAP Job Remover Poll time is in the past or now...");
                    }
                    this.waitingForPollTime = false;
                    if (this.shutdown) {
                        continue;
                    }
                    if (this.resetForPolling) {
                        this.resetForPolling = false;
                        continue;
                    }
                    logger.debug((Object)("About to process terminal SAP jobs for SAP System Definition ID " + this.earliestPI.getSapSystemDefinitionID()));
                    long l = System.currentTimeMillis();
                    this.processSAPSystemJobs(this.earliestPI.getSapSystemDefinitionID());
                    long l2 = System.currentTimeMillis();
                    logger.debug((Object)("Processing terminal SAP Jobs for SAP System Definition ID " + this.earliestPI.getSapSystemDefinitionID() + " took " + (l2 - l) / 1000L + " seconds."));
                    this.processNextPollForThisSystem(this.earliestPI.getSapSystemDefinitionID());
                }
            }
            logger.debug((Object)"SAPJobRemoverRunner has ended.");
        }

        @Override
        public void loadInitialPollInfoObjects() {
            try {
                ArrayList<SAPSystemDefinition> arrayList = SAPServerHelperAMImpl.this.getSAPSystemDefinitionsDM().getAllForPollingJobs();
                Iterator<SAPSystemDefinition> iterator = arrayList.iterator();
                long l = this.getNextTerminalJobPollTime();
                while (iterator.hasNext()) {
                    SAPSystemDefinition sAPSystemDefinition = iterator.next();
                    SAPPollJobsInfo sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_TERMINAL_JOBS, sAPSystemDefinition.getOID(), sAPSystemDefinition.getName(), l);
                    this.postPollInfo(sAPPollJobsInfo, removerPollQueue);
                    String[] stringArray = new String[]{sAPSystemDefinition.getName()};
                    ScheduleLogEntry scheduleLogEntry = RosettaMsg.SAP_REMOVER_ENABLED.newLogEntry(stringArray);
                    logger.debug((Object)scheduleLogEntry.getMessageText());
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Error while retrieving SAP System Definitions.", (Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopPollingForSystem(long l) {
            if (this.waitingForPollTime) {
                logger.debug((Object)("About to stop polling SAP System ID " + l + " for terminal jobs."));
                Object object = this.mainWaitObject;
                synchronized (object) {
                    if (this.earliestPI.getSapSystemDefinitionID() == l) {
                        this.removeSystemFromPollQueue(l, collectorPollQueue);
                    } else {
                        this.removeSystemFromPollQueue(l, removerPollQueue, this.earliestPI);
                    }
                    this.resetForPolling = true;
                    this.mainWaitObject.notify();
                }
                return;
            }
            logger.debug((Object)"No SAP Systems are waiting to poll for terminal jobs.");
        }

        @Override
        protected void processNextPollForThisSystem(long l) {
            long l2 = this.getNextTerminalJobPollTime();
            try {
                SAPSystemDefinition sAPSystemDefinition = SAPServerHelperAMImpl.this.getSAPSystemDefinitionsDM().get(l);
                if (!sAPSystemDefinition.isPollJobs()) {
                    logger.debug((Object)("Polling jobs for SAP System Definition " + sAPSystemDefinition.getName() + " is disabled."));
                    return;
                }
                SAPPollJobsInfo sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_TERMINAL_JOBS, l, sAPSystemDefinition.getName(), l2);
                this.postPollInfo(sAPPollJobsInfo, removerPollQueue);
            }
            catch (Exception exception) {
                logger.error((Object)("Error obtaining SAP System Definition for ID " + l + ". No further polling for this system will be scheduled."), (Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetPollingForSystem(long l, String string, int n) {
            Object object = this.mainWaitObject;
            synchronized (object) {
                long l2 = this.getNextTerminalJobPollTime();
                SAPPollJobsInfo sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_TERMINAL_JOBS, l, string, l2);
                if (this.waitingForPollTime) {
                    if (this.earliestPI.getSapSystemDefinitionID() == l) {
                        this.reconfigurePollQueue(l, removerPollQueue, sAPPollJobsInfo, null);
                        this.resetForPolling = true;
                        this.mainWaitObject.notify();
                        return;
                    }
                    if (this.isSystemInPollQueue(l, removerPollQueue)) {
                        this.removeSystemFromPollQueue(l, removerPollQueue, sAPPollJobsInfo);
                    } else {
                        sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_TERMINAL_JOBS, l, string, l2);
                        this.postPollInfo(sAPPollJobsInfo, removerPollQueue);
                    }
                    return;
                }
                sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_TERMINAL_JOBS, l, string, l2);
                this.postPollInfo(sAPPollJobsInfo, removerPollQueue);
                this.resetForPolling = true;
                this.mainWaitObject.notify();
            }
        }

        private long getNextTerminalJobPollTime() {
            long l = Calendar.getInstance().getTimeInMillis();
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 1);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (l > calendar.getTimeInMillis()) {
                calendar.add(5, 1);
            }
            return calendar.getTimeInMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processSAPSystemJobs(long l) {
            Stack<Long> stack;
            HashMap<String, SAPJobSimple> hashMap = new HashMap<String, SAPJobSimple>();
            try {
                stack = SAPServerHelperAMImpl.this.getSAPJobsDM().getTerminalSAPJobIDsForSystemDefinitionID(l);
                logger.debug((Object)("allTerminalSAPJobsForThisSystemStack.size() = " + stack.size()));
                if (stack.size() == 0) {
                    return;
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Error obtaining terminal SAP Jobs for SAP System Definition ID " + l), (Throwable)exception);
                return;
            }
            logger.debug((Object)("About to get updated statuses for " + stack.size() + " terminal SAP jobs on SAP System Definition ID " + l + " ..."));
            SAPConnection sAPConnection = null;
            try {
                Object object;
                Object object2;
                Object object3;
                sAPConnection = SAPServerHelperAMImpl.this.getSAPConnection(l);
                SAPServerHelperAMImpl.this.startSAPXMISession(sAPConnection);
                Stack<Long> stack2 = new Stack<Long>();
                while (stack.size() > 0) {
                    long l2 = System.currentTimeMillis();
                    while (!stack.isEmpty() && hashMap.size() < 10000) {
                        Long l3 = stack.pop();
                        SAPJobSimple sAPJobSimple = SAPServerHelperAMImpl.this.getSAPJobsDM().getSAPJobForCopy(l3);
                        hashMap.put(((SAPJobProxy)sAPJobSimple).getNameAndCount(), sAPJobSimple);
                    }
                    long l4 = System.currentTimeMillis();
                    logger.debug((Object)("Getting SAPJobProxy for " + hashMap.size() + " SAP jobs took " + (l4 - l2) / 1000L + " seconds."));
                    l2 = System.currentTimeMillis();
                    object3 = SAPServerHelperAMImpl.this.getUpdatedStatusFromList(sAPConnection, hashMap);
                    l4 = System.currentTimeMillis();
                    logger.debug((Object)("BAPI_XBP_JOBLIST_STATUS_GET took " + (l4 - l2) / 1000L + " seconds and returned " + ((HashMap)object3).size() + " updated status jobs from " + hashMap.size() + " terminal SAP jobs."));
                    hashMap.clear();
                    object2 = "Of the " + ((HashMap)object3).size() + " updated SAP jobs ";
                    object = SAPServerHelperAMImpl.this.getDeletedSAPJobsFromList((HashMap)object3);
                    logger.debug((Object)((String)object2 + ((HashMap)object).size() + " are no longer on the SAP system " + sAPConnection.getSapSystemDefinitionName() + "."));
                    List list = SAPServerHelperAMImpl.this.getDeletedSAPJobIDs((HashMap)object);
                    stack2.addAll(list);
                    logger.debug((Object)("allDeletedSAPJobsStack.size() = " + stack2.size()));
                }
                if (!stack2.isEmpty()) {
                    if (logger.isDebugEnabled()) {
                        object3 = "jobs";
                        object2 = "exist";
                        if (stack2.size() == 1) {
                            object3 = "job";
                            object2 = "exists";
                        }
                        logger.debug((Object)("About to delete " + stack2.size() + " SAP " + (String)object3 + " that no longer " + (String)object2 + "."));
                    }
                    int n = SAPServerHelperAMImpl.this.getSAPJobsDM().delete(stack2);
                    object = new String[]{String.valueOf(n), sAPConnection.getSapSystemDefinitionName()};
                    object2 = RosettaMsg.SAP_OBSOLETE_JOBS_DELETED.newLogEntry((String[])object);
                    ScheduleLogger.write((ScheduleLogEntry)object2);
                    logger.info((Object)((ScheduleLogEntry)object2).getMessageText());
                }
            }
            catch (Exception exception) {
                logger.error((Object)("Error getting updated status for jobs from SAP System Definition ID " + l), (Throwable)exception);
            }
            finally {
                SAPServerHelperAMImpl.this.endSAPXMISession(sAPConnection);
            }
        }
    }

    class SAPJobCollectorRunner
    extends SAPJobProcessor {
        private boolean shutdown = false;
        private long stopPollingForSystemID = 0L;
        private Object mainWaitObject = new Object();
        private SAPPollJobsInfo earliestPI;
        private boolean waitingForPollTime = false;
        private boolean resetForPolling = false;
        private long waitTimeMS;

        SAPJobCollectorRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug((Object)"SAPJobCollectorRunner is about to start.");
            this.loadInitialPollInfoObjects();
            while (!this.shutdown) {
                Object object = this.mainWaitObject;
                synchronized (object) {
                    try {
                        this.earliestPI = this.getNextPollInfo(collectorPollQueue);
                        this.waitTimeMS = this.earliestPI.getPollTimeMS();
                        if (this.waitTimeMS == 0L) {
                            this.waitingForPollTime = false;
                            logger.debug((Object)"The Runner currently has no SAP systems to poll and will wait to be notified.");
                        } else {
                            this.waitingForPollTime = true;
                            this.waitTimeMS = this.getNewWaitTime(this.earliestPI);
                        }
                        this.mainWaitObject.wait(this.waitTimeMS);
                        logger.debug((Object)"SAP Job Collector is waking up...");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug((Object)"The SAP Job Collector was interrupted.");
                    }
                    catch (SAPJobProcessor.NowOrPastException nowOrPastException) {
                        logger.debug((Object)"The SAP Job Collector Poll time is in the past or now...");
                    }
                    this.waitingForPollTime = false;
                    if (this.shutdown) {
                        continue;
                    }
                    if (this.resetForPolling) {
                        this.resetForPolling = false;
                        continue;
                    }
                }
                logger.debug((Object)("About to poll SAP jobs from system " + this.earliestPI.getSapSystemName()));
                long l = System.currentTimeMillis();
                this.processSAPSystemJobs(this.earliestPI.getSapSystemDefinitionID());
                logger.info((Object)("Completed polling SAP jobs from system " + this.earliestPI.getSapSystemName()));
                long l2 = System.currentTimeMillis();
                logger.debug((Object)("Polling Jobs for SAP System " + this.earliestPI.getSapSystemName() + " took " + (l2 - l) / 1000L + " seconds."));
                if (this.isRequestedToStop(this.earliestPI.getSapSystemDefinitionID())) {
                    this.resetRequestToStop();
                    continue;
                }
                this.processNextPollForThisSystem(this.earliestPI.getSapSystemDefinitionID());
            }
            logger.debug((Object)"SAPJobCollectorRunner has ended.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPollingThisSystem(long l) {
            Object object = this.mainWaitObject;
            synchronized (object) {
                return !this.waitingForPollTime && this.earliestPI.getSapSystemDefinitionID() == l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isRequestedToStop(long l) {
            Object object = this.mainWaitObject;
            synchronized (object) {
                return this.stopPollingForSystemID == l;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resetRequestToStop() {
            Object object = this.mainWaitObject;
            synchronized (object) {
                this.stopPollingForSystemID = 0L;
            }
        }

        @Override
        protected void processNextPollForThisSystem(long l) {
            long l2 = Calendar.getInstance().getTimeInMillis();
            try {
                SAPSystemDefinition sAPSystemDefinition = SAPServerHelperAMImpl.this.getSAPSystemDefinitionsDM().get(l);
                if (!sAPSystemDefinition.isPollJobs()) {
                    logger.debug((Object)("Polling Jobs for SAP System Definition " + sAPSystemDefinition.getName() + " is disabled."));
                    return;
                }
                int n = sAPSystemDefinition.getPollJobIntervalSeconds() * 1000;
                SAPPollJobsInfo sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_JOBS, l, sAPSystemDefinition.getName(), l2 += (long)n);
                this.postPollInfo(sAPPollJobsInfo, collectorPollQueue);
            }
            catch (Exception exception) {
                logger.error((Object)("Error obtaining SAP System Definition for ID " + l + ". No further polling for this system will be scheduled."), (Throwable)exception);
            }
        }

        @Override
        public void loadInitialPollInfoObjects() {
            try {
                ArrayList<SAPSystemDefinition> arrayList = SAPServerHelperAMImpl.this.getSAPSystemDefinitionsDM().getAllForPollingJobs();
                Iterator<SAPSystemDefinition> iterator = arrayList.iterator();
                long l = Calendar.getInstance().getTimeInMillis();
                while (iterator.hasNext()) {
                    SAPSystemDefinition sAPSystemDefinition = iterator.next();
                    SAPPollJobsInfo sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_JOBS, sAPSystemDefinition.getOID(), sAPSystemDefinition.getName(), l);
                    this.postPollInfo(sAPPollJobsInfo, collectorPollQueue);
                    String[] stringArray = new String[]{sAPSystemDefinition.getName(), String.valueOf(sAPSystemDefinition.getPollJobIntervalInMinutes())};
                    ScheduleLogEntry scheduleLogEntry = RosettaMsg.SAP_POLLING_ENABLED.newLogEntry(stringArray);
                    ScheduleLogger.write(scheduleLogEntry);
                    logger.debug((Object)scheduleLogEntry.getMessageText());
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Error while retrieving SAP System Definitions.", (Throwable)exception);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void processSAPSystemJobs(long var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 15[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void removeConfirmExceptions(HashMap<String, SAPJobSimple> hashMap, ArrayList<SAPJobProxy> arrayList) {
            Iterator<SAPJobProxy> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                hashMap.remove(iterator.next().getNameAndCount());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopPollingForSystem(long l) {
            logger.debug((Object)("About to stop polling SAP System ID " + l + " for jobs."));
            Object object = this.mainWaitObject;
            synchronized (object) {
                if (this.earliestPI.getSapSystemDefinitionID() == l) {
                    if (this.waitingForPollTime) {
                        this.resetForPolling = true;
                        this.mainWaitObject.notify();
                        return;
                    }
                    this.stopPollingForSystemID = l;
                    this.removeSystemFromPollQueue(l, collectorPollQueue);
                    return;
                }
                if (this.waitingForPollTime) {
                    this.removeSystemFromPollQueue(l, collectorPollQueue, this.earliestPI);
                    this.resetForPolling = true;
                    this.mainWaitObject.notify();
                } else {
                    this.removeSystemFromPollQueue(l, collectorPollQueue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetPollingForSystem(long l, String string, int n) {
            Object object = this.mainWaitObject;
            synchronized (object) {
                long l2 = Calendar.getInstance().getTimeInMillis();
                int n2 = n * 1000;
                SAPPollJobsInfo sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_JOBS, l, string, l2 += (long)n2);
                if (this.waitingForPollTime) {
                    if (this.earliestPI.getSapSystemDefinitionID() == l) {
                        this.reconfigurePollQueue(l, collectorPollQueue, sAPPollJobsInfo, null);
                        this.resetForPolling = true;
                        this.mainWaitObject.notify();
                        return;
                    }
                    if (this.isSystemInPollQueue(l, collectorPollQueue)) {
                        this.removeSystemFromPollQueue(l, collectorPollQueue, sAPPollJobsInfo);
                        if (!this.earliestPI.isEmpty()) {
                            this.postPollInfo(this.earliestPI, collectorPollQueue);
                        }
                    } else {
                        long l3 = Calendar.getInstance().getTimeInMillis();
                        sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_JOBS, l, string, l3);
                        this.postPollInfo(sAPPollJobsInfo, collectorPollQueue);
                        if (!this.earliestPI.isEmpty()) {
                            this.postPollInfo(this.earliestPI, collectorPollQueue);
                        }
                    }
                    this.resetForPolling = true;
                    this.mainWaitObject.notify();
                    return;
                }
                if (this.earliestPI.getSapSystemDefinitionID() == l) {
                    return;
                }
                long l4 = Calendar.getInstance().getTimeInMillis();
                sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_JOBS, l, string, l4);
                this.postPollInfo(sAPPollJobsInfo, collectorPollQueue);
                if (this.waitTimeMS == 0L) {
                    this.resetForPolling = true;
                    this.mainWaitObject.notify();
                }
            }
        }
    }
}

