/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.sap;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemDefinition;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.dm.sap.SAPSLDRegistrarAM;
import com.helpsystems.enterprise.core.dm.sap.SAPSystemDefinitionsDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.module.sap.SAPFunctionUtility;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class SAPSLDRegistrarAMImpl
extends AbstractManager
implements SAPSLDRegistrarAM {
    private Thread sldRegistrarThread;
    private SLDRegistrarRunner sldRegistrarRunner;
    private boolean sldRegistrarIsActive;
    private SAPSystemDefinitionsDM sapSystemDefinitionsDM;
    private EnterpriseServerAM enterpriseServerAM;
    private static final Logger logger = Logger.getLogger(SAPSLDRegistrarAMImpl.class);
    private static final String TITLE = "SAP SLD Registrar - generates XML Documents and sends to the SLD";
    private static final String CR = System.getProperty("line.separator");
    private static final String RETURNCODE_0 = "SLDReg XML File successfully created.  All variables replaced.";
    private static final String RETURNCODE_1 = "Could not replace all variables.";
    private static final String RETURNCODE_8 = "Error occurred during generating SLDReg XML File.";
    private static final String TEMPLATE_FILENAME = "ThirdPartySystem.template";
    private static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    private Object waitOnServerStartup = new Object();
    private boolean serverStartupComplete = false;

    public SAPSLDRegistrarAMImpl(boolean bl) {
        this.setName("ENTERPRISE.SAPSLDRegistrarAM");
        this.init(bl);
    }

    private void init(boolean bl) {
        if (bl) {
            this.startSLDRegistrar();
        } else {
            logger.debug((Object)"License is not valid for SAP.");
        }
    }

    private void startSLDRegistrar() {
        if (this.sldRegistrarThread == null || !this.sldRegistrarThread.isAlive()) {
            this.sldRegistrarRunner = new SLDRegistrarRunner();
            this.sldRegistrarThread = new Thread(this.sldRegistrarRunner);
            this.sldRegistrarThread.setName("SLDRegistrarRunner");
            this.sldRegistrarThread.start();
            this.sldRegistrarIsActive = true;
        }
    }

    @Override
    public void stopSLDRegistrarProcess() {
        logger.debug((Object)"About to stop the SLD Registrar Process...");
        this.stopSAPSLDRegistrarRunner();
    }

    @Override
    public void notifyOfSystemDefinitionChange() {
        if (this.sldRegistrarIsActive) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sldRegistrarRunner.restartForChangeInDefinition();
        }
    }

    @Override
    public void notifyOfLicenseChange(boolean bl) {
        if (bl && !this.isSAPOn()) {
            logger.debug((Object)"Received notification that Automate Schedule is now licensed for SAP.");
            this.startSLDRegistrar();
        } else if (!bl && this.isSAPOn()) {
            logger.debug((Object)"Received notification that Automate Schedule is no longer licensed for SAP.");
            this.stopSLDRegistrarProcess();
        }
    }

    private boolean isSAPOn() {
        return this.sldRegistrarThread != null && this.sldRegistrarThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyServerStartupComplete() {
        logger.debug((Object)"Received notification of server startup complete.");
        this.serverStartupComplete = true;
        Object object = this.waitOnServerStartup;
        synchronized (object) {
            this.waitOnServerStartup.notify();
        }
    }

    private String getGeneratedXMLFileName(SAPSystemDefinition sAPSystemDefinition) throws Exception {
        Object object;
        String string;
        String string2 = sAPSystemDefinition.getAshost() + sAPSystemDefinition.getR3name();
        string2 = string2 + numberFormatter.format(Integer.parseInt(sAPSystemDefinition.getSystemNumber()));
        string2 = string2 + ".xml";
        logger.debug((Object)("About to generate XML file (" + string2 + ")"));
        String string3 = string = System.getProperty("user.dir");
        String string4 = string;
        String string5 = "";
        try {
            String string62;
            Iterator iterator;
            String string7;
            object = new Properties();
            ((Properties)object).put("LocalSystemName", sAPSystemDefinition.getSLDLocalSystemName());
            logger.debug((Object)("LocalSystemName(" + ((Properties)object).get("LocalSystemName") + ")"));
            ((Properties)object).put("ComputerName", sAPSystemDefinition.getSLDComputerName());
            logger.debug((Object)("ComputerName(" + ((Properties)object).get("ComputerName") + ")"));
            ((Properties)object).put("ProductID", "0");
            ((Properties)object).put("ProductName", "Automate Schedule");
            ((Properties)object).put("ProductVendor", "sap.com");
            String string8 = this.getProductVersion();
            ((Properties)object).put("ProductVersion", string8);
            logger.debug((Object)("ProductVersion(" + ((Properties)object).get("ProductVersion") + ")"));
            ((Properties)object).put("SoftwareComponentID", "0");
            ((Properties)object).put("SoftwareComponentName", "Automate Schedule");
            ((Properties)object).put("SoftwareComponentVendor", "sap.com");
            ((Properties)object).put("SoftwareComponentVersion", "3.0");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(new File(string3, TEMPLATE_FILENAME))), "UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string7 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string7).append('\n');
            }
            string5 = stringBuffer.toString();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (Map.Entry<Object, Object> object22 : ((Properties)object).entrySet()) {
                iterator = object22.getKey().toString();
                string62 = "${" + (String)((Object)iterator) + "}";
                String string9 = object22.getValue().toString();
                if (string5.indexOf(string62) == -1) {
                    treeSet.add(string62);
                    continue;
                }
                string5 = string5.replaceAll("\\$\\{" + (String)((Object)iterator) + "\\}", string9);
            }
            TreeSet treeSet2 = new TreeSet();
            Matcher matcher = Pattern.compile("\\$\\{[a-zA-Z0-9_]+\\}").matcher(string5);
            while (matcher.find()) {
                treeSet2.add(matcher.group());
            }
            if (treeSet2.size() > 0 || treeSet.size() > 0) {
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("Returncode = 1").append(CR).append(RETURNCODE_1).append(CR).append(CR);
                if (treeSet.size() > 0) {
                    stringBuffer2.append("Variables that are not part of template, but estimated by parameter file:");
                    for (String string62 : treeSet) {
                        stringBuffer2.append(CR).append(string62);
                    }
                    stringBuffer2.append(CR);
                }
                if (treeSet2.size() > 0) {
                    stringBuffer2.append(CR);
                    stringBuffer2.append("Variables that could not replaced:");
                    iterator = treeSet2.iterator();
                    while (iterator.hasNext()) {
                        string62 = (String)iterator.next();
                        stringBuffer2.append(CR).append(string62);
                    }
                    stringBuffer2.append(CR);
                }
                string5 = "<!--" + CR + new Date().toString() + CR + TITLE + CR + stringBuffer2.toString() + "-->" + CR + CR + string5;
                logger.debug((Object)stringBuffer2);
            } else {
                logger.debug((Object)"Returncode = 0");
                logger.debug((Object)RETURNCODE_0);
            }
        }
        catch (Exception exception) {
            String string10 = CR + "Returncode = 8" + CR + RETURNCODE_8 + CR + CR + exception.toString();
            string5 = CR + new Date().toString() + CR + TITLE + CR + string10.toString() + CR + CR + string5;
            throw new Exception(string10, exception);
        }
        try {
            object = new PrintWriter((Writer)new FileWriter(new File(string4, string2)), true);
            ((PrintWriter)object).println(string5);
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
        return string2;
    }

    private String getProductVersion() {
        String string = "3.0";
        try {
            Properties properties = this.getEnterpriseServerAM().getServerProperties();
            if (properties != null && properties.containsKey("Module Release/Modification")) {
                string = properties.getProperty("Module Release/Modification");
            }
        }
        catch (ActionFailedException actionFailedException) {
            logger.warn((Object)"Error retrieving server relmod.", (Throwable)actionFailedException);
        }
        return string;
    }

    private EnterpriseServerAM getEnterpriseServerAM() {
        if (this.enterpriseServerAM == null) {
            this.enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManagerStartsWith((String)"ENTERPRISE.EnterpriseServerAM");
        }
        return this.enterpriseServerAM;
    }

    @Override
    public void requestRegistration(SAPSystemDefinition sAPSystemDefinition) throws Exception {
        int n;
        String string = this.getGeneratedXMLFileName(sAPSystemDefinition);
        URL uRL = new URL(sAPSystemDefinition.getSLDURLString());
        String string2 = sAPSystemDefinition.getSLDUser();
        String string3 = sAPSystemDefinition.getDecryptedSLDPassword();
        String string4 = string2 + ":" + string3;
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        String string5 = new BASE64Encoder().encode(string4.getBytes("utf-8"));
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Length", Long.toString(file.length()));
        httpURLConnection.setRequestProperty("Authorization", "Basic " + string5);
        httpURLConnection.setRequestProperty("dsxmlversion", "2.0");
        httpURLConnection.setRequestProperty("UserAgent", "SLD Data Supplier sldreg");
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.connect();
        OutputStream outputStream = httpURLConnection.getOutputStream();
        while ((n = fileInputStream.read()) != -1) {
            outputStream.write(n);
        }
        outputStream.close();
        fileInputStream.close();
        int n2 = httpURLConnection.getResponseCode();
        httpURLConnection.disconnect();
        logger.debug((Object)("requestRegistration return code = '" + n2 + "'"));
        String string6 = "";
        switch (n2) {
            case 200: {
                logger.info((Object)("Successfully registered " + string + " to the SLD at " + sAPSystemDefinition.getSLDURLString()));
                return;
            }
            case 400: {
                string6 = n2 + " Bad Request: For example, your XML may be invalid or " + "was sent in other encoding than UTF-8";
                break;
            }
            case 401: {
                string6 = n2 + " Unauthorized: " + "You have not specified valid authentication data " + "or the specified user does not have the necessary " + "permission to supply data to SLD.";
                break;
            }
            case 403: {
                string6 = n2 + " Forbidden: " + "You have not specific valid authentication data " + "or the specified user does not have the necessary " + "permission to supply data to SLD.";
                break;
            }
            case 503: {
                string6 = n2 + " Service Unavailable: The SLD application is not active on the target server.";
                break;
            }
            default: {
                string6 = "Unknown return code of " + n2 + " was returned by the requestRegistration process.";
            }
        }
        throw new Exception(string6);
    }

    private SAPSystemDefinitionsDM getSAPSystemDefinitionsDM() throws ResourceUnavailableException {
        if (this.sapSystemDefinitionsDM == null) {
            this.sapSystemDefinitionsDM = (SAPSystemDefinitionsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPSystemDefinitionsDM");
        }
        return this.sapSystemDefinitionsDM;
    }

    private void stopSAPSLDRegistrarRunner() {
        if (this.sldRegistrarRunner != null) {
            this.sldRegistrarRunner.shutdown = true;
            if (this.sldRegistrarThread != null && this.sldRegistrarThread.isAlive()) {
                this.sldRegistrarThread.interrupt();
            }
        }
    }

    private boolean isServerStartupComplete() {
        return this.serverStartupComplete;
    }

    public ArrayList<SAPSystemDefinition> getSAPSystemDefinitionsForSLDRegistration() {
        ArrayList<SAPSystemDefinition> arrayList = new ArrayList();
        try {
            arrayList = this.getSAPSystemDefinitionsDM().getAllForSLDRegistration();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error retrieving SAP System Definitions for SLD registration.", (Throwable)resourceUnavailableException);
        }
        return arrayList;
    }

    public void registerSkybotWithSAPSLDs(ArrayList<SAPSystemDefinition> arrayList) {
        if (arrayList.isEmpty()) {
            logger.info((Object)"There are no SAP System Definitions defined to register with the SLD.");
            return;
        }
        logger.info((Object)(arrayList.size() + " SAP System Definition(s) defined to register with the SLD."));
        for (SAPSystemDefinition sAPSystemDefinition : arrayList) {
            ScheduleLogEntry scheduleLogEntry;
            if (logger.isDebugEnabled()) {
                if (sAPSystemDefinition.getRegisteredWithSLDMS() > 0L) {
                    logger.debug((Object)("SAP System Definition " + sAPSystemDefinition.getName() + " was previously registered with an SLD on " + SAPFunctionUtility.getDateTimeString(sAPSystemDefinition.getRegisteredWithSLDMS())));
                } else {
                    logger.debug((Object)("SAP System Definition " + sAPSystemDefinition.getName() + " was not previously registered."));
                }
            }
            try {
                this.requestRegistration(sAPSystemDefinition);
                this.getSAPSystemDefinitionsDM().updateToSLDRegistered(sAPSystemDefinition.getOID());
                String[] stringArray = new String[]{sAPSystemDefinition.getSLDLocalSystemName(), sAPSystemDefinition.getSLDComputerName(), sAPSystemDefinition.getSLDURLString()};
                scheduleLogEntry = RosettaMsg.SAP_SKYBOT_REGISTERED_WITH_SLD.newLogEntry(stringArray);
            }
            catch (Exception exception) {
                logger.error((Object)("Error registering " + sAPSystemDefinition.getSLDLocalSystemName() + " on " + sAPSystemDefinition.getSLDComputerName() + " with SLD at " + sAPSystemDefinition.getSLDURLString() + "."), (Throwable)exception);
                String[] stringArray = new String[]{sAPSystemDefinition.getSLDLocalSystemName(), sAPSystemDefinition.getSLDComputerName(), sAPSystemDefinition.getSLDURLString(), exception.getMessage()};
                scheduleLogEntry = RosettaMsg.SAP_SLD_REGISTRATION_ERROR.newLogEntry(stringArray);
            }
            ScheduleLogger.write(scheduleLogEntry);
        }
    }

    static {
        numberFormatter.setMinimumIntegerDigits(2);
    }

    class SLDRegistrarRunner
    implements Runnable {
        private static final int REGISTER_HOUR_1 = 4;
        private Object mainWaitObject = new Object();
        private boolean shutdown = false;
        private ArrayList<SAPSystemDefinition> sapSystemDefinitions;
        private Calendar nextSLDRegisterTime;
        private boolean sapSystemDefinitionChange = false;

        SLDRegistrarRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            while (!SAPSLDRegistrarAMImpl.this.isServerStartupComplete()) {
                logger.debug((Object)"Waiting for server startup to complete before starting.");
                object = SAPSLDRegistrarAMImpl.this.waitOnServerStartup;
                synchronized (object) {
                    try {
                        SAPSLDRegistrarAMImpl.this.waitOnServerStartup.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            logger.info((Object)"SAP SLD Registrar Runner is about to start.");
            while (!this.shutdown) {
                object = this.mainWaitObject;
                synchronized (object) {
                    this.sapSystemDefinitions = SAPSLDRegistrarAMImpl.this.getSAPSystemDefinitionsForSLDRegistration();
                    SAPSLDRegistrarAMImpl.this.registerSkybotWithSAPSLDs(this.sapSystemDefinitions);
                    try {
                        this.mainWaitObject.wait(this.getNewWaitTime());
                        logger.debug((Object)"SAP SLD Registrar is waking up...");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug((Object)"SAP SLD Registrar was interrupted.");
                    }
                    if (this.shutdown) {
                        continue;
                    }
                    if (this.sapSystemDefinitionChange) {
                        this.sapSystemDefinitionChange = false;
                    }
                }
            }
            logger.info((Object)"SAP SLD Registrar Runner ended.");
            SAPSLDRegistrarAMImpl.this.sldRegistrarIsActive = false;
        }

        private long getNewWaitTime() {
            long l;
            if (this.sapSystemDefinitions.isEmpty()) {
                logger.debug((Object)"Automate Schedule currently has no SAP SLDs with which to register.");
                return 0L;
            }
            long l2 = System.currentTimeMillis();
            this.nextSLDRegisterTime = Calendar.getInstance();
            this.nextSLDRegisterTime.set(11, 4);
            this.nextSLDRegisterTime.set(12, 0);
            this.nextSLDRegisterTime.set(13, 0);
            if (this.nextSLDRegisterTime.getTimeInMillis() < l2) {
                this.nextSLDRegisterTime.add(5, 1);
            }
            if ((l = this.nextSLDRegisterTime.getTimeInMillis() - l2) < 1000L) {
                l += 500L;
            }
            l = this.roundToNearestSecond(l);
            this.postMonitorWaitMessage();
            return l;
        }

        private long roundToNearestSecond(long l) {
            return (l + 500L) / 1000L * 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restartForChangeInDefinition() {
            Object object = this.mainWaitObject;
            synchronized (object) {
                this.sapSystemDefinitionChange = true;
                this.mainWaitObject.notify();
            }
        }

        private void postMonitorWaitMessage() {
            logger.info((Object)("SAP SLD Registrar will now wait until " + SAPFunctionUtility.getDateTimeString(this.nextSLDRegisterTime.getTimeInMillis()) + " to " + "register Automate Schedule with the defined SAP SLDs."));
        }
    }
}

