/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.sap;

import com.helpsystems.common.core.access.DataException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.NoDataException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.enterprise.core.RosettaMsg;
import com.helpsystems.enterprise.core.busobj.Agent;
import com.helpsystems.enterprise.core.busobj.JobInitCode;
import com.helpsystems.enterprise.core.busobj.sap.SAPFunctionException;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptCriteria;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptCriterion;
import com.helpsystems.enterprise.core.busobj.sap.SAPInterceptedJob;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobProcessor;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobSelection;
import com.helpsystems.enterprise.core.busobj.sap.SAPJobTimeType;
import com.helpsystems.enterprise.core.busobj.sap.SAPPollJobsInfo;
import com.helpsystems.enterprise.core.busobj.sap.SAPReturnMessage;
import com.helpsystems.enterprise.core.busobj.sap.SAPSpecialConfirmJobSelection;
import com.helpsystems.enterprise.core.busobj.sap.SAPSystemDefinition;
import com.helpsystems.enterprise.core.busobj.sap.actions.SAPPollInterceptEvent;
import com.helpsystems.enterprise.core.dm.AgentDM;
import com.helpsystems.enterprise.core.dm.ScheduleJobDM;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptCriterionsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptedJobMonitorAM;
import com.helpsystems.enterprise.core.dm.sap.SAPInterceptedJobsDM;
import com.helpsystems.enterprise.core.dm.sap.SAPSystemDefinitionsDM;
import com.helpsystems.enterprise.core.logger.ScheduleLogEntry;
import com.helpsystems.enterprise.core.logger.ScheduleLogger;
import com.helpsystems.enterprise.core.scheduler.DateObject;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsDM;
import com.helpsystems.enterprise.core.scheduler.JobDateObjectsType;
import com.helpsystems.enterprise.core.scheduler.JobInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleInfo;
import com.helpsystems.enterprise.core.scheduler.ScheduleJobProxy;
import com.helpsystems.enterprise.core.util.LongConverter;
import com.helpsystems.enterprise.module.sap.SAPConnection;
import com.helpsystems.enterprise.module.sap.SAPConnectionProvider;
import com.helpsystems.enterprise.module.sap.SAPFunctionUtility;
import com.helpsystems.enterprise.scheduler.JobSubmitter;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoTable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import sun.util.calendar.ZoneInfo;

public class SAPInterceptedJobMonitorAMImpl
extends SAPConnectionProvider
implements SAPInterceptedJobMonitorAM {
    private static Logger logger = Logger.getLogger(SAPInterceptedJobMonitorAMImpl.class);
    public static final int CONFIRM_GROUP_SIZE = 5000;
    private static BlockingQueue<SAPPollJobsInfo> pollQueue = new LinkedBlockingQueue<SAPPollJobsInfo>();
    private static Thread interceptedJobGetterThread;
    private static Thread interceptedJobSchedulerThread;
    private SAPSystemDefinitionsDM sapSystemDefinitionsDM;
    private SAPInterceptedJobsDM sapInterceptedJobsDM;
    private SAPInterceptCriterionsDM sapInterceptCriterionsDM;
    private ScheduleJobDM scheduleJobDM;
    private JobSubmitter jobSubmitter;
    private AgentDM agentDM;
    private JobDateObjectsDM jobDateObjectsDM;
    private SAPInterceptedJobSchedulerRunner interceptedJobSchedulerRunner;
    private SAPInterceptedJobGetterRunner interceptedJobGetterRunner;
    private boolean missedJobsProcessComplete = false;
    private Object waitOnMissedJobsProcess = new Object();
    private boolean interceptedJobSchedulerIsActive = false;
    private boolean interceptedJobGetterIsActive = false;

    public SAPInterceptedJobMonitorAMImpl(boolean bl) {
        this.setName("ENTERPRISE.SAPInterceptedJobMonitorAM");
        this.sapSystemDefinitionsDM = (SAPSystemDefinitionsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPSystemDefinitionsDM");
        this.sapInterceptedJobsDM = (SAPInterceptedJobsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPInterceptedJobsDM");
        this.sapInterceptCriterionsDM = (SAPInterceptCriterionsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.SAPInterceptCriterionsDM");
        this.scheduleJobDM = (ScheduleJobDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ScheduleJobDM");
        this.jobSubmitter = new JobSubmitter(this.scheduleJobDM);
        this.agentDM = (AgentDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.AgentDM");
        this.init(bl);
    }

    private void init(boolean bl) {
        if (bl) {
            this.startInterceptedJobScheduler();
            this.startSAPInterceptedJobGetter();
        } else {
            logger.debug((Object)"License is not valid for SAP.");
        }
    }

    private void startSAPInterceptedJobGetter() {
        if (interceptedJobGetterThread == null || !interceptedJobGetterThread.isAlive()) {
            this.interceptedJobGetterRunner = new SAPInterceptedJobGetterRunner();
            interceptedJobGetterThread = new Thread(this.interceptedJobGetterRunner);
            interceptedJobGetterThread.setName("SAPInterceptedJobGetter");
            interceptedJobGetterThread.start();
            this.interceptedJobGetterIsActive = true;
        }
    }

    private void startInterceptedJobScheduler() {
        if (interceptedJobSchedulerThread == null || !interceptedJobSchedulerThread.isAlive()) {
            this.interceptedJobSchedulerRunner = new SAPInterceptedJobSchedulerRunner();
            interceptedJobSchedulerThread = new Thread(this.interceptedJobSchedulerRunner);
            interceptedJobSchedulerThread.setName("SAPInterceptedJobScheduler");
            interceptedJobSchedulerThread.start();
            this.interceptedJobSchedulerIsActive = true;
        }
    }

    @Override
    public boolean isMonitorStopped() {
        return !this.interceptedJobGetterIsActive && !this.interceptedJobSchedulerIsActive;
    }

    @Override
    public void stopMonitorProcesses() {
        logger.debug((Object)"About to stop Monitor Processes...");
        this.stopInterceptedJobGetterRunner();
        this.stopInterceptedJobSchedulerRunner();
    }

    @Override
    public void deleteInterceptedJob(long l, String string, String string2) throws Exception {
        logger.debug((Object)("Received request to delete SAP Intercepted job " + string + "(" + string2 + ") for SAP System Definition ID " + l));
        try {
            this.sapInterceptedJobsDM.delete(l, string, string2);
            this.interceptedJobSchedulerRunner.restartForNewMonitorTime();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            throw new Exception("Error deleting intercepted job history.", resourceUnavailableException);
        }
    }

    @Override
    public void notifyOfScheduleChange() {
        this.interceptedJobSchedulerRunner.restartForNewMonitorTime();
    }

    @Override
    public void notifyOfLicenseChange(boolean bl) {
        if (bl && !this.isSAPOn()) {
            logger.debug((Object)"Received notification that Automate Schedule is now licensed for SAP.");
            this.startSAPInterceptedJobGetter();
            this.startInterceptedJobScheduler();
        } else if (!bl && this.isSAPOn()) {
            logger.debug((Object)"Received notification that Automate Schedule is no longer licensed for SAP.");
            this.stopMonitorProcesses();
        }
    }

    private boolean isSAPOn() {
        return interceptedJobGetterThread != null && interceptedJobGetterThread.isAlive() && interceptedJobSchedulerThread != null && interceptedJobSchedulerThread.isAlive();
    }

    private void stopInterceptedJobGetterRunner() {
        if (this.interceptedJobGetterRunner != null) {
            this.interceptedJobGetterRunner.shutdown = true;
            if (interceptedJobGetterThread != null && interceptedJobGetterThread.isAlive()) {
                interceptedJobGetterThread.interrupt();
            }
        }
    }

    private void stopInterceptedJobSchedulerRunner() {
        if (this.interceptedJobSchedulerRunner != null) {
            this.interceptedJobSchedulerRunner.shutdown = true;
            if (interceptedJobSchedulerThread != null && interceptedJobSchedulerThread.isAlive()) {
                interceptedJobSchedulerThread.interrupt();
            }
        }
    }

    @Override
    public void stopPollingForSystem(long l) {
        this.interceptedJobGetterRunner.stopPollingForSystem(l);
    }

    @Override
    public void pollInfoUpdate(SAPPollInterceptEvent sAPPollInterceptEvent) {
        String string;
        String[] stringArray;
        logger.debug((Object)("Received notification that the Poll Settings were modified for SAP System Definition ID " + sAPPollInterceptEvent.getSAPSystemDefinitionID()));
        try {
            stringArray = this.sapSystemDefinitionsDM.get(sAPPollInterceptEvent.getSAPSystemDefinitionID());
            string = stringArray.getName();
        }
        catch (Exception exception) {
            logger.warn((Object)("Unable to obtain SAP System Definition for ID " + sAPPollInterceptEvent.getSAPSystemDefinitionID() + ".  Using ID for now."));
            string = "ID(" + sAPPollInterceptEvent.getSAPSystemDefinitionID() + ")";
        }
        stringArray = new String[]{string, String.valueOf(sAPPollInterceptEvent.getIntervalSeconds() / 60)};
        if (!sAPPollInterceptEvent.isPollingActive()) {
            this.interceptedJobGetterRunner.stopPollingForSystem(sAPPollInterceptEvent.getSAPSystemDefinitionID());
            RosettaMsg rosettaMsg = RosettaMsg.SAP_INTERCEPT_POLLING_DISABLED;
            this.postScheduleLogEntry(stringArray, rosettaMsg);
        } else {
            RosettaMsg rosettaMsg = RosettaMsg.SAP_INTERCEPT_POLLING_ENABLED;
            this.postScheduleLogEntry(stringArray, rosettaMsg);
            this.interceptedJobGetterRunner.resetPollingForSystem(sAPPollInterceptEvent.getSAPSystemDefinitionID(), string, sAPPollInterceptEvent.getIntervalSeconds());
        }
    }

    private void postScheduleLogEntry(String[] stringArray, RosettaMsg rosettaMsg) {
        ScheduleLogEntry scheduleLogEntry = rosettaMsg.newLogEntry(stringArray);
        ScheduleLogger.write(scheduleLogEntry);
        logger.debug((Object)scheduleLogEntry.getMessageText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMissedJobsProcessComplete(boolean bl) {
        this.missedJobsProcessComplete = bl;
        Object object = this.waitOnMissedJobsProcess;
        synchronized (object) {
            this.waitOnMissedJobsProcess.notify();
        }
    }

    private boolean processInterceptedJobsForCriteriaMatch(HashMap<String, SAPInterceptedJob> hashMap, SAPInterceptCriteria sAPInterceptCriteria) {
        boolean bl = false;
        for (SAPInterceptedJob sAPInterceptedJob : hashMap.values()) {
            SAPInterceptCriterion sAPInterceptCriterion = sAPInterceptCriteria.getBestMatchingCriterion(sAPInterceptedJob);
            if (sAPInterceptCriterion != null) {
                bl = true;
                sAPInterceptedJob.setSkybotJobID(sAPInterceptCriterion.getSkybotJobID());
                sAPInterceptedJob.setSkybotAgentID(sAPInterceptCriterion.getSkybotTargetID());
                sAPInterceptedJob.setSkybotJobName(sAPInterceptCriterion.getSkybotJobName());
                sAPInterceptedJob.setSkybotAgentName(sAPInterceptCriterion.getSkybotAgentName());
                Calendar calendar = this.getSkybotScheduledRelease(sAPInterceptCriterion, sAPInterceptedJob.getNameAndCount());
                logger.debug((Object)(sAPInterceptedJob.getNameAndCount() + " scheduled for release on " + SAPFunctionUtility.getDateTimeString(calendar.getTimeInMillis()) + " on SAP System " + sAPInterceptedJob.getSapSystemName()));
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                sAPInterceptedJob.setSkybotScheduledReleaseMS(timestamp.getTime());
                sAPInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.SCHEDULED);
                continue;
            }
            logger.debug((Object)("No Criterions match the Intercepted SAP Job " + sAPInterceptedJob));
        }
        return bl;
    }

    private Calendar getSkybotScheduledRelease(SAPInterceptCriterion sAPInterceptCriterion, String string) {
        TimeZone timeZone;
        try {
            timeZone = this.timezone(sAPInterceptCriterion);
        }
        catch (Exception exception) {
            logger.warn((Object)("Error setting scheduled release time for Automate Schedule job ID " + sAPInterceptCriterion.getSkybotJobID() + ".  Setting release time to immediate."), (Throwable)exception);
            return Calendar.getInstance();
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        long l = sAPInterceptCriterion.getSkybotJobID();
        try {
            DateObject dateObject = this.getJobDateObjectsDM().get(JobDateObjectsType.OMIT_DATE_OBJECTS, l);
            boolean bl = false;
            while (!bl) {
                while (this.isOmittedToday(sAPInterceptCriterion, calendar, string, dateObject)) {
                    calendar.add(5, 1);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                }
                SAPInterceptCriterion.DayOfWeek dayOfWeek = SAPInterceptCriterion.DayOfWeek.persistanceCodeToEnum(calendar.get(7));
                int n = sAPInterceptCriterion.getAllowedFromHHMM();
                int n2 = sAPInterceptCriterion.getAllowedToHHMM();
                logger.debug((Object)("Allowed from " + n + " to " + n2));
                if (n == 0 && n2 == 2359) {
                    return calendar;
                }
                if (sAPInterceptCriterion.isRestricted()) {
                    boolean bl2 = sAPInterceptCriterion.isRestrictedDay(dayOfWeek);
                    logger.debug((Object)("Scheduled release day is a " + dayOfWeek + " and restricted = " + bl2));
                    if (!bl2) {
                        return calendar;
                    }
                }
                logger.debug((Object)"Checking time range...");
                ScheduleInfo.TimeZoneType timeZoneType = sAPInterceptCriterion.getTimeZoneType();
                if (timeZoneType == ScheduleInfo.TimeZoneType.AGENT) {
                    try {
                        Agent agent = this.agentDM.get(sAPInterceptCriterion.getSkybotTargetID());
                        TimeZone timeZone2 = TimeZone.getTimeZone(agent.getTimeZone());
                        logger.trace((Object)("Exception Agent Time Zone: " + agent.getTimeZone()));
                        calendar.setTimeZone(timeZone2);
                        logger.debug((Object)("scheduledReleaseCalendar adjusted for Agent timezone of " + timeZone2.getDisplayName()));
                    }
                    catch (Exception exception) {
                        logger.warn((Object)("Error setting scheduled release time for Automate Schedule job ID " + sAPInterceptCriterion.getSkybotJobID() + ".  Setting release time to immediate."), (Throwable)exception);
                        return calendar;
                    }
                }
                int n3 = calendar.get(11);
                int n4 = calendar.get(12);
                int n5 = n3 * 100 + n4;
                logger.debug((Object)("Scheduled Release time set to " + n5));
                int n6 = n / 100;
                int n7 = n - n6 * 100;
                if (n2 < n) {
                    logger.debug((Object)"Allowed time spans midnight");
                    if (n5 <= n2 || n5 >= n) {
                        return calendar;
                    }
                    logger.debug((Object)("After " + n2 + " and before " + n + " allowed time. Scheduling for FROM time."));
                    calendar.set(11, n6);
                    calendar.set(12, n7);
                    calendar.set(13, 0);
                    return calendar;
                }
                if (n5 >= n && n5 <= n2) {
                    return calendar;
                }
                logger.debug((Object)"Outside allowed time range.");
                if (n5 < n) {
                    logger.debug((Object)("Before FROM allowed time " + n + ". Scheduling for FROM time."));
                    calendar.set(11, n6);
                    calendar.set(12, n7);
                } else {
                    logger.debug((Object)("After TO allowed time " + n2 + ". Scheduling for FROM time next day."));
                    SAPInterceptCriterion.DayOfWeek dayOfWeek2 = SAPInterceptCriterion.DayOfWeek.getTomorrow(dayOfWeek);
                    if (sAPInterceptCriterion.isRestricted()) {
                        if (sAPInterceptCriterion.isRestrictedDay(dayOfWeek2)) {
                            calendar.set(11, n6);
                            calendar.set(12, n7);
                        } else {
                            calendar.set(11, 0);
                            calendar.set(12, 0);
                        }
                    } else {
                        calendar.set(11, n6);
                        calendar.set(12, n7);
                    }
                    calendar.add(5, 1);
                }
                calendar.set(13, 0);
                if (this.isOmittedToday(sAPInterceptCriterion, calendar, string, dateObject)) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.error((Object)("Error checking omit dates for Automate Schedule Job ID: " + l), (Throwable)exception);
        }
        return calendar;
    }

    private boolean isOmittedToday(SAPInterceptCriterion sAPInterceptCriterion, Calendar calendar, String string, DateObject dateObject) {
        int n = calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
        if (dateObject != null) {
            boolean bl = dateObject.contains(n);
            String string2 = sAPInterceptCriterion.getJobName();
            String string3 = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
            if (bl) {
                return true;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Automate Schedule Job " + string2 + " is defined with an omit date list that does not omit " + string3 + ".  Intercepted SAP job " + string + " can be released on " + string3 + "."));
            }
        }
        return false;
    }

    private JobDateObjectsDM getJobDateObjectsDM() {
        if (this.jobDateObjectsDM == null) {
            this.jobDateObjectsDM = (JobDateObjectsDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.JobDateObjectsDM");
        }
        return this.jobDateObjectsDM;
    }

    private boolean isMissedJobsProcessComplete() {
        return this.missedJobsProcessComplete;
    }

    public SAPInterceptedJob getNextInterceptedJob() {
        try {
            SAPInterceptedJob sAPInterceptedJob = this.sapInterceptedJobsDM.getNextScheduledJob();
            return sAPInterceptedJob;
        }
        catch (NoDataException noDataException) {
            logger.debug((Object)"No scheduled SAP Intercepted jobs found.");
            return new SAPInterceptedJob();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            logger.error((Object)"Error getting next scheduled SAP Intercepted Job for the  Intercepted SAP Job Scheduler.  Returning empty job.", (Throwable)resourceUnavailableException);
            return new SAPInterceptedJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollInterceptedJobs(long l) {
        block19: {
            SAPConnection sAPConnection;
            try {
                sAPConnection = this.getSAPConnection(l);
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                logger.error((Object)("Error establishing connection to SAP System Definition ID " + l), (Throwable)resourceUnavailableException);
                return;
            }
            try {
                SAPSystemDefinition sAPSystemDefinition = this.getSAPSystemDefinition(l);
                this.startSAPXMISession(sAPConnection);
                HashMap<String, SAPInterceptedJob> hashMap = this.getSAPInterceptedJobs(sAPConnection);
                HashMap<String, SAPInterceptedJob> hashMap2 = new HashMap<String, SAPInterceptedJob>();
                Collection<SAPInterceptedJob> collection = hashMap.values();
                Iterator<SAPInterceptedJob> iterator = collection.iterator();
                int n = 0;
                ArrayList<Object> arrayList = new ArrayList();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                while (iterator.hasNext()) {
                    arrayList.clear();
                    SAPInterceptedJob sAPInterceptedJob = iterator.next();
                    hashMap2.put(sAPInterceptedJob.getNameAndCount(), sAPInterceptedJob);
                    if (hashMap2.size() < 5000) continue;
                    arrayList = this.processConfirmJobGroup(sAPConnection, hashMap2);
                    logger.debug((Object)("Total confirmed = " + (n += hashMap2.size() - arrayList.size())));
                    arrayList2.addAll(arrayList);
                    hashMap2.clear();
                }
                if (hashMap2.size() > 0) {
                    arrayList = this.processConfirmJobGroup(sAPConnection, hashMap2);
                    logger.debug((Object)("Total confirmed = " + (n += hashMap2.size() - arrayList.size())));
                    arrayList2.addAll(arrayList);
                }
                if (!arrayList2.isEmpty()) {
                    for (SAPInterceptedJob sAPInterceptedJob : arrayList2) {
                        logger.debug((Object)("Intercepted Job Not confirmed: " + sAPInterceptedJob.getNameAndCount()));
                        hashMap.remove(sAPInterceptedJob.getNameAndCount());
                    }
                }
                if (!hashMap.isEmpty()) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        SAPInterceptCriteria sAPInterceptCriteria = this.sapInterceptCriterionsDM.getForSAPSystemDefinitionID(l, sAPSystemDefinition.getName());
                        if (!sAPInterceptCriteria.isEmpty()) {
                            bl = this.processInterceptedJobsForCriteriaMatch(hashMap, sAPInterceptCriteria);
                        } else {
                            logger.debug((Object)("No Intercept Criterions exist for SAP System Definition ID " + l));
                        }
                    }
                    catch (Exception dataException) {
                        logger.error((Object)"Error checking intercepted job criteria for matches.", (Throwable)dataException);
                    }
                    logger.debug((Object)("Saving " + hashMap.size() + " intercepted job(s) from SAP System " + sAPSystemDefinition.getName()));
                    try {
                        this.sapInterceptedJobsDM.save(hashMap);
                    }
                    catch (DataException dataException) {
                        logger.error((Object)"Error saving SAP Intercepted jobs.", (Throwable)dataException);
                    }
                    if (bl) {
                        this.interceptedJobSchedulerRunner.restartForNewMonitorTime();
                    }
                    break block19;
                }
                logger.debug((Object)"No intercepted jobs to save.");
            }
            catch (Exception exception) {
                logger.error((Object)("Error polling intercepted jobs on SAP System Definition " + sAPConnection.getSapSystemDefinitionName()), (Throwable)exception);
            }
            finally {
                this.endSAPXMISession(sAPConnection);
            }
        }
    }

    private ArrayList<SAPInterceptedJob> processConfirmJobGroup(SAPConnection sAPConnection, HashMap<String, SAPInterceptedJob> hashMap) throws ResourceUnavailableException {
        ArrayList<SAPInterceptedJob> arrayList = new ArrayList();
        logger.debug((Object)("About to confirm " + hashMap.size() + " intercepted jobs."));
        try {
            arrayList = this.getSpecialConfirmJobs(sAPConnection, hashMap);
        }
        catch (SAPFunctionException sAPFunctionException) {
            logger.error((Object)"Group confirmation failed.  Attempting one job at a time...");
            SAPInterceptedJob sAPInterceptedJob = null;
            HashMap<String, SAPInterceptedJob> hashMap2 = new HashMap<String, SAPInterceptedJob>();
            for (SAPInterceptedJob sAPInterceptedJob2 : hashMap.values()) {
                hashMap2.put(sAPInterceptedJob2.getNameAndCount(), sAPInterceptedJob2);
                try {
                    ArrayList<SAPInterceptedJob> arrayList2 = this.getSpecialConfirmJobs(sAPConnection, hashMap2);
                    if (arrayList2.size() > 0) {
                        sAPInterceptedJob = arrayList2.get(0);
                    }
                    if (sAPInterceptedJob == null) {
                        logger.debug((Object)("Confirmed SAP Job " + sAPInterceptedJob2.getNameAndCount()));
                    } else {
                        arrayList.add(sAPInterceptedJob);
                    }
                }
                catch (SAPFunctionException sAPFunctionException2) {
                    logger.error((Object)("Error confirming SAP job " + sAPInterceptedJob2.getNameAndCount()), (Throwable)sAPFunctionException2);
                    arrayList.add(sAPInterceptedJob2);
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    logger.error((Object)("Error confirming SAP job " + sAPInterceptedJob2.getNameAndCount()), (Throwable)resourceUnavailableException);
                    arrayList.add(sAPInterceptedJob2);
                }
                hashMap2.clear();
            }
        }
        return arrayList;
    }

    private ArrayList<SAPInterceptedJob> getSpecialConfirmJobs(SAPConnection sAPConnection, HashMap<String, SAPInterceptedJob> hashMap) throws ResourceUnavailableException, SAPFunctionException {
        ArrayList<SAPInterceptedJob> arrayList = new ArrayList<SAPInterceptedJob>();
        try {
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionSpecialConfirmJob(sAPConnection, SAPSpecialConfirmJobSelection.INTERCEPTED_JOBS, hashMap);
            sAPConnection.executeMiddleFunction(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string = "Error confirming " + hashMap.size() + " intercepted SAP jobs on SAP system " + sAPConnection.getSapSystemDefinitionName() + ". " + sAPReturnMessage.getFullReturnMessage();
                logger.error((Object)string);
                throw new SAPFunctionException(string);
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBS");
            int n = jCoTable.getNumRows();
            String string = "";
            string = n == 0 ? "All " + hashMap.size() + " intercepted jobs were confirmed" : n + " intercepted jobs were not confirmed";
            string = string + " on the SAP System " + sAPConnection.getSapSystemDefinitionName();
            logger.debug((Object)string);
            for (int i = 0; i < n; ++i) {
                jCoTable.setRow(i);
                String string2 = jCoTable.getString("JOBNAME");
                String string3 = jCoTable.getString("JOBCOUNT");
                SAPInterceptedJob sAPInterceptedJob = new SAPInterceptedJob(string2, string3);
                arrayList.add(sAPInterceptedJob);
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error confirming Intercepted Jobs from SAP System Definition " + sAPConnection.getSapSystemDefinitionName(), (Throwable)jCoException);
        }
        return arrayList;
    }

    private HashMap<String, SAPInterceptedJob> getSAPInterceptedJobs(SAPConnection sAPConnection) throws ResourceUnavailableException {
        HashMap<String, SAPInterceptedJob> hashMap = new HashMap<String, SAPInterceptedJob>();
        try {
            JCoFunction jCoFunction = SAPFunctionUtility.getFunctionGetInterceptedJobs(sAPConnection, SAPJobSelection.NOT_CONFIRMED_INTERCEPTED, true);
            sAPConnection.execute(jCoFunction);
            SAPReturnMessage sAPReturnMessage = SAPFunctionUtility.getSAPReturnMessage(jCoFunction);
            if (sAPReturnMessage.isError()) {
                String string = "Error polling intercepted SAP jobs on SAP system " + sAPConnection.getSapSystemDefinitionName() + ". " + sAPReturnMessage.getFullReturnMessage();
                logger.warn((Object)string);
                return hashMap;
            }
            JCoTable jCoTable = jCoFunction.getTableParameterList().getTable("JOBINFO2");
            int n = jCoTable.getNumRows();
            logger.debug((Object)("Found " + n + " unconfirmed intercepted jobs on SAP System " + sAPConnection.getSapSystemDefinitionName()));
            for (int i = 0; i < n; ++i) {
                jCoTable.setRow(i);
                String string = jCoTable.getString("JOBNAME");
                String string2 = jCoTable.getString("JOBCOUNT");
                String string3 = jCoTable.getString("AUTHCKMAN");
                String string4 = jCoTable.getString("SDLUNAME");
                TimeZone timeZone = sAPConnection.getTimeZone();
                Date date = jCoTable.getDate("ICPDATE");
                Date date2 = jCoTable.getTime("ICPTIME");
                SAPInterceptedJob sAPInterceptedJob = new SAPInterceptedJob(sAPConnection.getSapSystemDefinitionID(), sAPConnection.getSapSystemDefinitionName(), string, string2, string3, string4);
                SAPFunctionUtility.setSAPJobTime(SAPJobTimeType.PLANNED_START, sAPInterceptedJob, date, date2, timeZone);
                hashMap.put(sAPInterceptedJob.getNameAndCount(), sAPInterceptedJob);
            }
        }
        catch (JCoException jCoException) {
            throw new ResourceUnavailableException("Error obtaining Intercepted Jobs from SAP System Definition " + sAPConnection.getSapSystemDefinitionName(), (Throwable)jCoException);
        }
        return hashMap;
    }

    private TimeZone timezone(SAPInterceptCriterion sAPInterceptCriterion) throws DataException, ResourceUnavailableException {
        TimeZone timeZone;
        String string = sAPInterceptCriterion.getSkybotJobName();
        long l = sAPInterceptCriterion.getSkybotTargetID();
        ScheduleInfo.TimeZoneType timeZoneType = sAPInterceptCriterion.getTimeZoneType();
        switch (timeZoneType) {
            case SERVER: {
                timeZone = this.serverTimeZone();
                break;
            }
            case AGENT: {
                Agent agent = this.agentDM.get(l);
                String string2 = agent.getTimeZone();
                timeZone = this.timezone(string2, string);
                break;
            }
            case JOB: {
                String string3 = sAPInterceptCriterion.getJobTimezone();
                if (string3 != null && !string3.isEmpty()) {
                    timeZone = this.timezone(string3, string);
                    break;
                }
                throw new IllegalStateException(MessageUtil.formatMsg((String)"The job-specific time zone ID for job {0} is missing.", (Object[])new Object[]{string}));
            }
            default: {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"Program error: Timezone Type {0} is not supported by this method.", (Object[])new Object[]{timeZoneType}));
            }
        }
        return timeZone;
    }

    private TimeZone serverTimeZone() {
        return TimeZone.getDefault();
    }

    private TimeZone timezone(String string, String string2) {
        TimeZone timeZone = null;
        try {
            timeZone = ZoneInfo.getTimeZone(string);
            if (timeZone == null) {
                throw new IllegalStateException(MessageUtil.formatMsg((String)"The time zone ID {0}, for job {1} is unrecognized.", (Object[])new Object[]{string, string2}));
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException(MessageUtil.formatMsg((String)"An error occurred while trying to convert the time zone ID {0} for job {1} to a TimeZone object.", (Object[])new Object[]{string, string2}), exception);
        }
        return timeZone;
    }

    class SAPInterceptedJobSchedulerRunner
    implements Runnable {
        private Object mainWaitObject = new Object();
        private boolean shutdown = false;
        private SAPInterceptedJob earliestInterceptedJob;
        private boolean scheduledReleaseJobChange = false;

        SAPInterceptedJobSchedulerRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            logger.debug((Object)"SAP Intercepted Job Scheduler Runner is about to start.");
            while (!SAPInterceptedJobMonitorAMImpl.this.isMissedJobsProcessComplete()) {
                logger.debug((Object)"Waiting for missed jobs to be processed before starting.");
                object = SAPInterceptedJobMonitorAMImpl.this.waitOnMissedJobsProcess;
                synchronized (object) {
                    try {
                        SAPInterceptedJobMonitorAMImpl.this.waitOnMissedJobsProcess.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            logger.debug((Object)"After waiting for missed jobs to be processed.");
            while (!this.shutdown) {
                object = this.mainWaitObject;
                synchronized (object) {
                    this.earliestInterceptedJob = SAPInterceptedJobMonitorAMImpl.this.getNextInterceptedJob();
                    try {
                        this.mainWaitObject.wait(this.getNewWaitTime());
                        logger.debug((Object)"SAP Intercepted Job Scheduler is waking up...");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug((Object)"SAP Intercepted Job Scheduler was interrupted.");
                    }
                    catch (NowOrPastException nowOrPastException) {
                        logger.debug((Object)"The SAP Intercepted Job Scheduled release time is in the past or now...");
                    }
                    if (this.shutdown) {
                        continue;
                    }
                    if (this.scheduledReleaseJobChange) {
                        this.scheduledReleaseJobChange = false;
                        continue;
                    }
                    this.earliestInterceptedJob = SAPInterceptedJobMonitorAMImpl.this.getNextInterceptedJob();
                    if (this.earliestInterceptedJob.getSkybotScheduledReleaseMS() > 0L) {
                        if (this.earliestInterceptedJob.getSkybotScheduledReleaseMS() > System.currentTimeMillis()) {
                            continue;
                        }
                    } else {
                        continue;
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(this.earliestInterceptedJob.getSkybotScheduledReleaseMS());
                    String string = "Error submitting Automate Schedule job to run SAP intercepted job " + this.earliestInterceptedJob.getNameAndCount();
                    long l = this.earliestInterceptedJob.getSkybotJobID();
                    try {
                        ScheduleJobProxy scheduleJobProxy = SAPInterceptedJobMonitorAMImpl.this.scheduleJobDM.getScheduleJobProxy(l);
                        String string2 = SAPInterceptedJobMonitorAMImpl.this.getSAPSystemDefinition(this.earliestInterceptedJob.getSapSystemDefinitionID()).getName();
                        SAPInterceptCriterion sAPInterceptCriterion = SAPInterceptedJobMonitorAMImpl.this.sapInterceptCriterionsDM.getForSkybotJobID(l, string2);
                        Calendar calendar2 = SAPInterceptedJobMonitorAMImpl.this.getSkybotScheduledRelease(sAPInterceptCriterion, this.earliestInterceptedJob.getNameAndCount());
                        String string3 = SAPFunctionUtility.getDateTimeString(calendar2.getTimeInMillis());
                        if (calendar2.getTimeInMillis() > System.currentTimeMillis()) {
                            logger.debug((Object)("The intercepted job " + this.earliestInterceptedJob.getNameAndCount() + " has been rescheduled to " + string3 + " due to the system being down or delayed."));
                            this.earliestInterceptedJob.setSkybotScheduledReleaseMS(calendar2.getTimeInMillis());
                            this.earliestInterceptedJob.setStatus(SAPInterceptedJob.InterceptedJobStatus.SCHEDULED);
                            SAPInterceptedJobMonitorAMImpl.this.sapInterceptedJobsDM.update(this.earliestInterceptedJob);
                            continue;
                        }
                        int n = LongConverter.intValue(l);
                        long l2 = this.earliestInterceptedJob.getSkybotAgentID();
                        String string4 = this.earliestInterceptedJob.getSkybotAgentName();
                        int n2 = LongConverter.intValue(l2);
                        JobInfo jobInfo = new JobInfo(n, scheduleJobProxy.getName(), n2, string4);
                        Calendar calendar3 = Calendar.getInstance();
                        String string5 = "SAP Intercepted Job " + this.earliestInterceptedJob.getNameAndCount() + " on " + string2;
                        SAPInterceptedJobMonitorAMImpl.this.jobSubmitter.submitSAPIntercept(this.earliestInterceptedJob, n, n2, jobInfo, calendar3.getTime(), calendar, JobInitCode.REACTIVE, string5, false);
                    }
                    catch (Exception exception) {
                        logger.error((Object)string, (Throwable)exception);
                    }
                }
            }
            logger.debug((Object)"SAP Intercepted Job Scheduler Runner ended.");
            SAPInterceptedJobMonitorAMImpl.this.interceptedJobSchedulerIsActive = false;
        }

        private long getNewWaitTime() throws NowOrPastException {
            if (this.earliestInterceptedJob.getSkybotScheduledReleaseMS() == 0L) {
                logger.debug((Object)"The Monitor currently has no intercepted SAP jobs to monitor.");
                return 0L;
            }
            if (logger.isDebugEnabled()) {
                this.postMonitorWaitMessage();
            }
            long l = System.currentTimeMillis();
            if (this.earliestInterceptedJob.getSkybotScheduledReleaseMS() <= l) {
                throw new NowOrPastException();
            }
            long l2 = this.earliestInterceptedJob.getSkybotScheduledReleaseMS() - l;
            if (l2 < 1000L) {
                l2 += 500L;
            }
            l2 = this.roundToNearestSecond(l2);
            return l2;
        }

        private void postMonitorWaitMessage() {
            logger.debug((Object)("Monitor will now wait until " + SAPFunctionUtility.getDateTimeString(this.earliestInterceptedJob.getSkybotScheduledReleaseMS()) + " to " + "release the SAP intercepted job " + this.earliestInterceptedJob.getNameAndCount() + " on agent " + this.earliestInterceptedJob.getSkybotAgentName()));
        }

        private long roundToNearestSecond(long l) {
            return (l + 500L) / 1000L * 1000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restartForNewMonitorTime() {
            Object object = this.mainWaitObject;
            synchronized (object) {
                this.scheduledReleaseJobChange = true;
                this.mainWaitObject.notify();
            }
        }

        class NowOrPastException
        extends Exception {
            NowOrPastException() {
            }
        }
    }

    class SAPInterceptedJobGetterRunner
    extends SAPJobProcessor {
        private Object mainWaitObject = new Object();
        private SAPPollJobsInfo earliestPI;
        private boolean waitingForPollTime = false;
        private boolean resetForPolling = false;
        private long waitTimeMS;
        private boolean shutdown = false;

        SAPInterceptedJobGetterRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug((Object)"SAP Intercepted Job Getter Runner is about to start.");
            this.loadInitialPollInfoObjects();
            while (!this.shutdown) {
                Object object = this.mainWaitObject;
                synchronized (object) {
                    try {
                        this.earliestPI = this.getNextPollInfo(pollQueue);
                        this.waitTimeMS = this.earliestPI.getPollTimeMS();
                        if (this.waitTimeMS == 0L) {
                            this.waitingForPollTime = false;
                            logger.debug((Object)"The Runner currently has no SAP systems to poll and will wait to be notified.");
                        } else {
                            this.waitingForPollTime = true;
                            this.waitTimeMS = this.getNewWaitTime(this.earliestPI);
                        }
                        this.mainWaitObject.wait(this.waitTimeMS);
                        logger.debug((Object)"SAP Intercepted Job Getter is waking up...");
                    }
                    catch (InterruptedException interruptedException) {
                        logger.debug((Object)"The SAP Intercepted Job Getter was interrupted.");
                    }
                    catch (SAPJobProcessor.NowOrPastException nowOrPastException) {
                        logger.debug((Object)"The SAP Intercept Poll time is in the past or now...");
                    }
                    this.waitingForPollTime = false;
                    if (this.shutdown) {
                        continue;
                    }
                    if (this.resetForPolling) {
                        this.resetForPolling = false;
                        continue;
                    }
                    logger.debug((Object)("About to poll SAP intercepted jobs from system " + this.earliestPI.getSapSystemName()));
                    this.processSAPSystemJobs(this.earliestPI.getSapSystemDefinitionID());
                    logger.debug((Object)("Completed polling SAP intercepted jobs from system " + this.earliestPI.getSapSystemName()));
                    this.processNextPollForThisSystem(this.earliestPI.getSapSystemDefinitionID());
                }
            }
            logger.debug((Object)"SAP Intercepted Job Getter Runner has ended.");
            SAPInterceptedJobMonitorAMImpl.this.interceptedJobGetterIsActive = false;
        }

        @Override
        protected void processNextPollForThisSystem(long l) {
            long l2 = Calendar.getInstance().getTimeInMillis();
            try {
                SAPSystemDefinition sAPSystemDefinition = SAPInterceptedJobMonitorAMImpl.this.sapSystemDefinitionsDM.get(l);
                if (!sAPSystemDefinition.isPollInterceptedJobs()) {
                    logger.debug((Object)("Polling Intercepted Jobs for SAP System Definition " + sAPSystemDefinition.getName() + " is disabled."));
                    return;
                }
                int n = sAPSystemDefinition.getPollInterceptIntervalSeconds() * 1000;
                SAPPollJobsInfo sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_INTERCEPTED_JOBS, l, sAPSystemDefinition.getName(), l2 += (long)n);
                this.postPollInfo(sAPPollJobsInfo, pollQueue);
            }
            catch (Exception exception) {
                logger.error((Object)("Error obtaining SAP System Definition of ID " + l + ". No further polling for this system will be scheduled."), (Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopPollingForSystem(long l) {
            if (this.waitingForPollTime) {
                logger.debug((Object)("About to stop polling SAP System ID " + l + " for intercepted jobs."));
                Object object = this.mainWaitObject;
                synchronized (object) {
                    if (this.earliestPI.getSapSystemDefinitionID() == l) {
                        this.removeSystemFromPollQueue(l, pollQueue);
                    } else {
                        this.removeSystemFromPollQueue(l, pollQueue, this.earliestPI);
                    }
                    this.resetForPolling = true;
                    this.mainWaitObject.notify();
                }
                return;
            }
            logger.debug((Object)"No SAP Systems are waiting to poll for jobs.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetPollingForSystem(long l, String string, int n) {
            Object object = this.mainWaitObject;
            synchronized (object) {
                long l2 = Calendar.getInstance().getTimeInMillis();
                int n2 = n * 1000;
                SAPPollJobsInfo sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_INTERCEPTED_JOBS, l, string, l2 += (long)n2);
                if (this.waitingForPollTime) {
                    if (this.earliestPI.getSapSystemDefinitionID() == l) {
                        this.reconfigurePollQueue(l, pollQueue, sAPPollJobsInfo, null);
                        this.resetForPolling = true;
                        this.mainWaitObject.notify();
                        return;
                    }
                    if (this.isSystemInPollQueue(l, pollQueue)) {
                        this.removeSystemFromPollQueue(l, pollQueue, sAPPollJobsInfo);
                    } else {
                        long l3 = Calendar.getInstance().getTimeInMillis();
                        sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_INTERCEPTED_JOBS, l, string, l3);
                        this.postPollInfo(sAPPollJobsInfo, pollQueue);
                    }
                    return;
                }
                long l4 = Calendar.getInstance().getTimeInMillis();
                sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_INTERCEPTED_JOBS, l, string, l4);
                this.postPollInfo(sAPPollJobsInfo, pollQueue);
                this.resetForPolling = true;
                this.mainWaitObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restartForNewPollTime() {
            Object object = this.mainWaitObject;
            synchronized (object) {
                this.resetForPolling = true;
                this.mainWaitObject.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SAPPollJobsInfo getEarliestPollInfo() {
            Object object = this.mainWaitObject;
            synchronized (object) {
                return this.earliestPI;
            }
        }

        @Override
        public void loadInitialPollInfoObjects() {
            try {
                ArrayList<SAPSystemDefinition> arrayList = SAPInterceptedJobMonitorAMImpl.this.sapSystemDefinitionsDM.getAll();
                Iterator<SAPSystemDefinition> iterator = arrayList.iterator();
                long l = Calendar.getInstance().getTimeInMillis();
                while (iterator.hasNext()) {
                    SAPSystemDefinition sAPSystemDefinition = iterator.next();
                    if (!sAPSystemDefinition.isPollInterceptedJobs()) continue;
                    SAPPollJobsInfo sAPPollJobsInfo = new SAPPollJobsInfo(SAPPollJobsInfo.SAPPollJobType.SAP_INTERCEPTED_JOBS, sAPSystemDefinition.getOID(), sAPSystemDefinition.getName(), l);
                    this.postPollInfo(sAPPollJobsInfo, pollQueue);
                    String[] stringArray = new String[]{sAPSystemDefinition.getName(), String.valueOf(sAPSystemDefinition.getPollInterceptIntervalInMinutes())};
                    SAPInterceptedJobMonitorAMImpl.this.postScheduleLogEntry(stringArray, RosettaMsg.SAP_INTERCEPT_POLLING_ENABLED);
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Error while retrieving SAP System Definitions for initial poll load.", (Throwable)exception);
            }
        }

        @Override
        public void processSAPSystemJobs(long l) {
            SAPInterceptedJobMonitorAMImpl.this.pollInterceptedJobs(l);
        }
    }
}

