/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.enterprise.core.busobj.InvalidStateException;
import com.helpsystems.enterprise.core.reports.Report;
import com.helpsystems.enterprise.core.reports.ReportException;
import com.helpsystems.enterprise.core.reports.ReportRenderer;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.module.reports.jasper.JobSetupReportHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRVirtualizer;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.fill.JRFileVirtualizer;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.log4j.Logger;

public class JasperReportRenderer
implements ReportRenderer {
    private static final Logger logger = Logger.getLogger(JasperReportRenderer.class);
    private JasperReportData reportData = null;
    private JasperReport jreport = null;
    private Report report = null;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    public static final String VIRT_DIR_KEY = "virtualizer.directory";
    private JRVirtualizer virtualizer = null;
    private JasperPrint print = null;

    public static void setPropertyForFont() {
        try {
            Properties properties = new Properties();
            if (JasperReportRenderer.isWindows()) {
                properties.setProperty("net.sf.jasperreports.extension.simple.font.families.resource", "../../../report/font/font.xml");
            } else {
                properties.setProperty("net.sf.jasperreports.extension.simple.font.families.resource", "report/font/font.xml");
            }
            properties.setProperty("net.sf.jasperreports.extension.registry.factory.simple.font.families", "net.sf.jasperreports.engine.fonts.SimpleFontExtensionsRegistryFactory");
            File file = new File("jasperreports_extension.properties");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, "jasper reports extension");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("Win") > -1;
    }

    public JasperReportRenderer(JasperReportData jasperReportData, JasperReport jasperReport, Report report) {
        this.report = report;
        this.reportData = jasperReportData;
        this.jreport = jasperReport;
        Object object = report.getParameters().get(VIRT_DIR_KEY);
        this.virtualizer = new JRFileVirtualizer(5, String.valueOf(object));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void render() throws ReportException {
        JRVirtualizer jRVirtualizer = null;
        try {
            jRVirtualizer = this.createVirtualizer();
            switch (this.report.getOutputType()) {
                case PDF: {
                    JRAbstractExporter jRAbstractExporter = this.createExporter(this.createPrint());
                    jRAbstractExporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)this.report.getDestinationFile());
                    JasperReportRenderer.export(jRAbstractExporter);
                    return;
                }
                case CSV: {
                    this.createCsvFile(this.report.getDestinationFile(), this.reportData.getParameters());
                    return;
                }
                default: {
                    throw new ReportException("Unsupported report type: " + this.report.getOutputType());
                }
            }
        }
        catch (Throwable throwable) {
            String string = "Unable to render report.";
            logger.debug((Object)string, throwable);
            throw new ReportException(string, throwable);
        }
        finally {
            jRVirtualizer.cleanup();
        }
    }

    private void createCsvFile(File file, Map<String, Object> map) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        PrintWriter printWriter = new PrintWriter(fileWriter);
        String string = (String)map.get("HEADER_REPORT_NAME");
        String string2 = (String)map.get("FORECAST_DEF");
        printWriter.print("Model:" + string2 + ",,");
        printWriter.println(string);
        String string3 = (String)map.get("SERVER_HOST_NAME");
        String string4 = (String)map.get("GEN_TIME");
        printWriter.println(string4);
        printWriter.println(string3);
        printWriter.println();
        Boolean bl = (Boolean)map.get("DATA_EXISTS");
        if (bl.booleanValue()) {
            String string5 = (String)map.get("REPORT_COLUMN_NAMES");
            printWriter.print(string5);
            printWriter.println();
            ArrayList arrayList = (ArrayList)map.get("ROW_DATA");
            for (int i = 0; i < arrayList.size(); ++i) {
                StringBuilder stringBuilder = (StringBuilder)arrayList.get(i);
                printWriter.println(stringBuilder);
            }
        } else {
            printWriter.print("No Forecasted Job Runs records");
        }
        printWriter.flush();
        printWriter.close();
        fileWriter.close();
    }

    private JRVirtualizer createVirtualizer() {
        if (this.virtualizer == null) {
            this.virtualizer = new JRFileVirtualizer(10);
        }
        return this.virtualizer;
    }

    private JasperPrint createPrint() throws ReportException, InvalidStateException {
        if (this.print == null) {
            try {
                Map<String, Object> map = this.reportData.getParameters();
                if (this.virtualizer != null) {
                    map.put("REPORT_VIRTUALIZER", this.virtualizer);
                }
                this.print = JasperFillManager.fillReport((JasperReport)this.jreport, map, (JRDataSource)this.reportData.getData());
                String string = (String)map.get("REPORT_NAME");
                if (string != null && (string.equals("JobSetupReport") || string.equals("SAPSystemDefinitionReport") || string.equals("SAPAbapStepSetReport") || string.equals("SAPJobDefinitionReport") || string.equals("SecurityReport"))) {
                    JobSetupReportHelper.completeIndexPageNumbers(this.print);
                }
            }
            catch (Throwable throwable) {
                if ((throwable instanceof ReportException || throwable instanceof IllegalStateException) && throwable.getMessage().equalsIgnoreCase("Shutdown in progress")) {
                    throw new InvalidStateException("Enterprise Server is ending.");
                }
                System.out.println("Problem occured while filling data into report, cause: {} " + throwable.getMessage());
                System.out.println("Problem occured while filling data into report. " + throwable);
                throw new ReportException(throwable);
            }
        }
        return this.print;
    }

    private JRAbstractExporter createExporter(JasperPrint jasperPrint) throws ReportException, InvalidStateException {
        switch (this.report.getOutputType()) {
            case PDF: {
                return JasperReportRenderer.createPdfExporter(jasperPrint);
            }
            case XLS: {
                return JasperReportRenderer.createXlsExporter(jasperPrint);
            }
            case ODT: {
                return JasperReportRenderer.createOdtExporter(jasperPrint);
            }
            case CSV: {
                return JasperReportRenderer.createCsvExporter(jasperPrint);
            }
            case HTML: {
                return JasperReportRenderer.createHtmlExporter(jasperPrint);
            }
        }
        throw new ReportException("Unsupported report type: " + this.report.getOutputType());
    }

    private static void export(JRAbstractExporter jRAbstractExporter) throws ReportException, InvalidStateException {
        try {
            jRAbstractExporter.exportReport();
        }
        catch (Exception exception) {
            System.out.println("Problem occured while exporting report. " + exception);
            if ((exception instanceof ReportException || exception instanceof IllegalStateException) && exception.getMessage().equalsIgnoreCase("Shutdown in progress")) {
                throw new InvalidStateException("Enterprise Server is ending.");
            }
            throw new ReportException(exception);
        }
    }

    private static JRAbstractExporter createPdfExporter(JasperPrint jasperPrint) throws ReportException, InvalidStateException {
        JRPdfExporter jRPdfExporter = null;
        try {
            jRPdfExporter = new JRPdfExporter();
            jRPdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            jRPdfExporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        }
        catch (Throwable throwable) {
            String string = "Unable to create the PDF exporter.";
            logger.debug((Object)string, throwable);
            if ((throwable instanceof ReportException || throwable instanceof IllegalStateException) && throwable.getMessage().equalsIgnoreCase("Shutdown in progress")) {
                throw new InvalidStateException("Enterprise Server is ending.");
            }
            throw new ReportException(string, throwable);
        }
        return jRPdfExporter;
    }

    private static JRAbstractExporter createXlsExporter(JasperPrint jasperPrint) throws ReportException, InvalidStateException {
        JRXlsExporter jRXlsExporter = null;
        try {
            jRXlsExporter = new JRXlsExporter();
            jRXlsExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            jRXlsExporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
            jRXlsExporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)false);
        }
        catch (Throwable throwable) {
            String string = "Unable to create XLS Exporter.";
            logger.debug((Object)string, throwable);
            if ((throwable instanceof ReportException || throwable instanceof IllegalStateException) && throwable.getMessage().equalsIgnoreCase("Shutdown in progress")) {
                throw new InvalidStateException("Enterprise Server is ending.");
            }
            throw new ReportException(string, throwable);
        }
        return jRXlsExporter;
    }

    private static JRAbstractExporter createOdtExporter(JasperPrint jasperPrint) throws ReportException, InvalidStateException {
        JROdtExporter jROdtExporter = null;
        try {
            jROdtExporter = new JROdtExporter();
            jROdtExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            jROdtExporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        }
        catch (Throwable throwable) {
            String string = "Unable to create ODT Exporter.";
            logger.debug((Object)string, throwable);
            if ((throwable instanceof ReportException || throwable instanceof IllegalStateException) && throwable.getMessage().equalsIgnoreCase("Shutdown in progress")) {
                throw new InvalidStateException("Enterprise Server is ending.");
            }
            throw new ReportException(string, throwable);
        }
        return jROdtExporter;
    }

    private static JRAbstractExporter createCsvExporter(JasperPrint jasperPrint) throws ReportException, InvalidStateException {
        JRCsvExporter jRCsvExporter = null;
        try {
            jRCsvExporter = new JRCsvExporter();
            jRCsvExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            jRCsvExporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
            jRCsvExporter.setParameter((JRExporterParameter)JRCsvExporterParameter.RECORD_DELIMITER, (Object)"\n");
            jRCsvExporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)", ");
        }
        catch (Throwable throwable) {
            String string = "Unable to create CSV Exporter.";
            logger.debug((Object)string, throwable);
            if ((throwable instanceof ReportException || throwable instanceof IllegalStateException) && throwable.getMessage().equalsIgnoreCase("Shutdown in progress")) {
                throw new InvalidStateException("Enterprise Server is ending.");
            }
            throw new ReportException(string, throwable);
        }
        return jRCsvExporter;
    }

    private static JRAbstractExporter createHtmlExporter(JasperPrint jasperPrint) throws ReportException, InvalidStateException {
        JRHtmlExporter jRHtmlExporter = null;
        try {
            jRHtmlExporter = new JRHtmlExporter();
            jRHtmlExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            jRHtmlExporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)"UTF-8");
        }
        catch (Throwable throwable) {
            String string = "Unable to create CSV Exporter.";
            logger.debug((Object)string, throwable);
            if ((throwable instanceof ReportException || throwable instanceof IllegalStateException) && throwable.getMessage().equalsIgnoreCase("Shutdown in progress")) {
                throw new InvalidStateException("Enterprise Server is ending.");
            }
            throw new ReportException(string, throwable);
        }
        return jRHtmlExporter;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> map) {
        this.parameters = map;
    }

    static {
        JRProperties.setProperty((String)"net.sf.jasperreports.export.csv.exclude.origin.keep.first.band.pageHeader", (String)"pageHeader");
        JRProperties.setProperty((String)"net.sf.jasperreports.export.csv.exclude.origin.keep.first.band.columnHeader", (String)"columnHeader");
        JRProperties.setProperty((String)"net.sf.jasperreports.export.csv.exclude.origin.band.columnFooter", (String)"columnFooter");
        JasperReportRenderer.setPropertyForFont();
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
    }
}

