/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.reports.jasper;

import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.enterprise.core.dm.ReportDM;
import com.helpsystems.enterprise.core.reports.ReportHelper;
import com.helpsystems.enterprise.core.reports.ReportOutput;
import com.helpsystems.enterprise.core.reports.Reports;
import com.helpsystems.enterprise.module.reports.jasper.AbstractJasperReport;
import com.helpsystems.enterprise.module.reports.jasper.JasperReportData;
import com.helpsystems.enterprise.scheduler.SchedulerStatusAMImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImportValidationReport
extends AbstractJasperReport
implements Serializable {
    public static final String REPORT_NAME = "ImportValidationReport";
    public static final int REPORT_ID = Reports.ReportType.IMPORT_VALIDATION_REPORT.getReportID();
    public static final String HEADER_DATE = "HEADER_DATE";
    private static final String ITEM_PARAM = "item";
    private static final String MESSAGE_PARAM = "message";
    private static final int ITEM_PARAM_ID = 1;
    private static final int MESSAGE_PARAM_ID = 2;
    private String fileName = "";
    private static final Logger logger = Logger.getLogger(ImportValidationReport.class);
    final Map<String, Object> parentParams = new HashMap<String, Object>();
    ArrayList<HashMap<String, Object>> rDataRows = new ArrayList();

    public ImportValidationReport(Locale locale, ReportOutput.OutputType outputType, String string, Object ... objectArray) {
        super(locale, outputType, string, objectArray);
        this.reportDM = (ReportDM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.ReportDM");
    }

    @Override
    public int getReportID() {
        return REPORT_ID;
    }

    @Override
    public String getReportName() {
        return REPORT_NAME;
    }

    @Override
    JasperReportData buildReportData() {
        AbstractJasperReport.ReportDataBuilder reportDataBuilder = ImportValidationReport.createReportDataBuilder();
        this.parentParams.put("HEADER_REPORT_NAME", "Import Validation");
        this.parentParams.put(HEADER_DATE, ReportHelper.getFormatedDate(new Date()));
        this.parentParams.put("REPORT_OUTPUT_TYPE", this.getOutputType().name());
        this.parentParams.put("SKYBOT_VERSION", SchedulerStatusAMImpl.serverRelMod);
        this.parentParams.put("SERVER_HOST_NAME", ReportHelper.getServerHostName());
        this.parentParams.put("IMPORT_FILE_NAME", this.fileName);
        if (this.rDataRows != null && !this.rDataRows.isEmpty()) {
            this.parentParams.put("DATA_EXISTS", new Boolean(true));
            int n = this.rDataRows.size();
            for (int i = 0; i < n; ++i) {
                reportDataBuilder.nextRow();
                String string = (String)this.rDataRows.get(i).get("VALIDATION_OBJECT_TYPE");
                reportDataBuilder.setFieldValue("VALIDATION_OBJECT_TYPE", string);
                String string2 = (String)this.rDataRows.get(i).get("VALIDATION_OBJECT_MESSAGE");
                reportDataBuilder.setFieldValue("VALIDATION_OBJECT_MESSAGE", string2);
            }
            logger.trace((Object)"The Imort Validation has been built.");
        } else {
            this.parentParams.put("DATA_EXISTS", new Boolean(false));
        }
        JasperReportData jasperReportData = new JasperReportData();
        jasperReportData.setParameters(this.parentParams);
        jasperReportData.setData(reportDataBuilder.toJRDataSource());
        logger.trace((Object)"Validation Message data has been built.");
        return jasperReportData;
    }

    @Override
    protected void parseParameters(Object ... objectArray) {
        String string;
        Object object = objectArray[0];
        this.fileName = string = (String)object;
        int n = -1;
        HashMap<String, String> hashMap = null;
        block4: for (int i = 1; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            String string2 = (String)object2;
            if (ITEM_PARAM.equalsIgnoreCase(string2)) {
                hashMap = new HashMap<String, String>();
                n = 1;
                continue;
            }
            if (MESSAGE_PARAM.equalsIgnoreCase(string2)) {
                n = 2;
                continue;
            }
            switch (n) {
                case 1: {
                    String string3 = string2.toString().replace("*", ": ");
                    hashMap.put("VALIDATION_OBJECT_TYPE", string3);
                    continue block4;
                }
                case 2: {
                    String string4 = string2.toString().replace("*", ": ");
                    hashMap.put("VALIDATION_OBJECT_MESSAGE", string4);
                    this.rDataRows.add(hashMap);
                }
            }
        }
    }

    @Override
    protected void replaceIfNotAKey(Object ... objectArray) {
    }

    @Override
    protected boolean isEqualToKey(String string) {
        return false;
    }
}

