/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.oracle;

import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.enterprise.core.busobj.CommandSetCommand;
import com.helpsystems.enterprise.core.busobj.oracle.OracleCommandException;
import com.helpsystems.enterprise.core.busobj.oracle.OracleStatusCode;
import com.helpsystems.enterprise.core.busobj.oracle.OracleSystemDefinition;
import com.helpsystems.enterprise.core.exec.ExecutableJob;
import org.apache.log4j.Logger;

public class OracleProcessUtility {
    private static final Logger logger = Logger.getLogger(OracleProcessUtility.class);
    private static final String SUBMITTED_REQUEST = "Submitted request";
    private CommandSetCommand commandSetCommand;
    private OracleSystemDefinition oracleSystemDefinition;
    private String regexPrefix;
    private String regexString;
    private int currentOracleRequestID;

    public OracleProcessUtility(CommandSetCommand commandSetCommand) {
        this.commandSetCommand = commandSetCommand;
        this.oracleSystemDefinition = commandSetCommand.getOracleExecutable().getOracleSystemDefinition();
    }

    public String getRegexPrefix() throws ResourceUnavailableException {
        if (this.regexPrefix == null) {
            this.regexPrefix = "CONCSUB " + this.oracleSystemDefinition.getOracleUserName() + "/";
        }
        return this.regexPrefix;
    }

    public String getRegexString() throws ResourceUnavailableException {
        if (this.regexString == null) {
            this.regexString = this.getRegexPrefix() + this.oracleSystemDefinition.getDecryptedPassword();
        }
        return this.regexString;
    }

    public String getStringWithOraclePasswordHidden(String string) throws ResourceUnavailableException {
        String string2 = string;
        if (string.contains(this.getRegexString())) {
            String string3 = this.getRegexPrefix() + "*****";
            string2 = string2.replace(this.getRegexString(), string3);
        }
        return string2;
    }

    public void processStringForOracleOutputChecks(String string, ExecutableJob executableJob) throws OracleCommandException {
        if (string.contains(SUBMITTED_REQUEST)) {
            logger.debug((Object)("Oracle Concurrent Request Submitted output: " + string));
            String string2 = "";
            String[] stringArray = string.split(" ");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase("request")) continue;
                string2 = stringArray[i + 1];
                logger.debug((Object)("Oracle Concurrent Request ID: " + string2));
                int n = Integer.parseInt(string2);
                executableJob.addOracleRequest(n, this.commandSetCommand.getOracleExecutable().getOracleCommand());
                this.currentOracleRequestID = n;
                break;
            }
            return;
        }
        if (string.contains("Normal completion")) {
            logger.debug((Object)("Oracle Concurrent Request output: " + string));
            try {
                executableJob.updateOracleRequest(this.currentOracleRequestID, OracleStatusCode.C);
            }
            catch (Exception exception) {
                logger.error((Object)("Error updating status code for Request ID " + this.currentOracleRequestID), (Throwable)exception);
            }
            return;
        }
        if (string.contains("Request was cancelled")) {
            logger.error((Object)("Oracle Concurrent Request cancelled: " + string));
            try {
                executableJob.updateOracleRequest(this.currentOracleRequestID, OracleStatusCode.D);
            }
            catch (Exception exception) {
                logger.error((Object)("Error updating status code for Request ID " + this.currentOracleRequestID), (Throwable)exception);
            }
            throw new OracleCommandException(string);
        }
        if (string.contains("Terminated by user")) {
            logger.error((Object)("Oracle Concurrent Request terminated: " + string));
            try {
                executableJob.updateOracleRequest(this.currentOracleRequestID, OracleStatusCode.X);
            }
            catch (Exception exception) {
                logger.error((Object)("Error updating status code for Request ID " + this.currentOracleRequestID), (Throwable)exception);
            }
            throw new OracleCommandException(string);
        }
        if (string.contains("Concurrent Manager encountered an error while running")) {
            logger.error((Object)("Oracle Concurrent Request error: " + string));
            if (string.contains("concurrent request")) {
                int n = string.indexOf("concurrent request");
                String string3 = string.substring(n);
                String[] stringArray = string3.split(" ");
                String string4 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase("request")) continue;
                    string4 = stringArray[i + 1];
                    string4 = string4.substring(0, string4.indexOf("."));
                    logger.debug((Object)("Oracle Concurrent Request ID: " + string4));
                    int n2 = Integer.parseInt(string4);
                    try {
                        executableJob.updateOracleRequest(n2, OracleStatusCode.E);
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error updating status code for Request ID " + this.currentOracleRequestID), (Throwable)exception);
                    }
                    break;
                }
            }
            throw new OracleCommandException(string);
        }
        if (string.contains("ORACLE error")) {
            logger.error((Object)("Oracle Concurrent Request error: " + string));
            throw new OracleCommandException(string);
        }
    }
}

