/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.informatica;

import com.helpsystems.enterprise.core.busobj.informatica.ConsoleLogger;
import java.io.File;

public class InformaticaKeystoreInfo {
    private static final String defaultPath = ".";
    private static final String SERVER_DIRECTORY = "Automate Schedule Server";
    public static final String KEYSTORE_FILE_NAME = "skybot.keystore";
    public static final String KEYSTORE_PASSWORD = "SkyKeys";
    private static String agentDataPath = null;
    private static String serverDataPath = null;

    public static void configureKeystore(KeystoreType keystoreType) {
        switch (keystoreType) {
            case AGENT: {
                if (agentDataPath != null) break;
                agentDataPath = InformaticaKeystoreInfo.getKeystorePath(keystoreType);
                String string = agentDataPath + "/" + KEYSTORE_FILE_NAME;
                InformaticaKeystoreInfo.setKeystore(string, agentDataPath);
                break;
            }
            case SERVER: {
                if (serverDataPath != null) break;
                serverDataPath = InformaticaKeystoreInfo.getKeystorePath(keystoreType);
                String string = serverDataPath + "/" + KEYSTORE_FILE_NAME;
                InformaticaKeystoreInfo.setKeystore(string, serverDataPath);
            }
        }
    }

    private static void setKeystore(String string, String string2) {
        File file = new File(string);
        if (file.exists() && file.isFile()) {
            ConsoleLogger.println("Keystore Path '" + string + " was found with resolved path: " + file.getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStore", string);
            System.setProperty("javax.net.ssl.trustStorePassword", KEYSTORE_PASSWORD);
        } else {
            ConsoleLogger.println("Using data directory: " + string2);
            ConsoleLogger.println("Keystore Path '" + string + " was not found with resolved path: " + file.getAbsolutePath());
        }
    }

    private static String getKeystorePath(KeystoreType keystoreType) {
        String string = System.getenv("ALLUSERSPROFILE");
        if (string == null || string.length() == 0) {
            ConsoleLogger.printlnDebug("Environment variable 'ALLUSERSPROFILE' is null or blank.");
            return defaultPath;
        }
        File file = new File(string);
        if (!file.exists()) {
            ConsoleLogger.printlnDebug("Base path does not exist: " + file.getAbsolutePath());
            return defaultPath;
        }
        if (!file.isDirectory()) {
            ConsoleLogger.printlnDebug("Base path is not a directory: " + file.getAbsolutePath());
            return defaultPath;
        }
        String string2 = string + File.separator + "Application Data";
        File file2 = new File(string2);
        if (!file2.exists() || !file2.isDirectory()) {
            string2 = string;
            file2 = new File(string2);
            ConsoleLogger.println("Using application directory: " + file2.getAbsolutePath());
        } else {
            ConsoleLogger.println("Using application data directory: " + file2.getAbsolutePath());
        }
        if (!file2.exists()) {
            file2.mkdir();
        }
        String string3 = file2.getAbsolutePath();
        switch (keystoreType) {
            case AGENT: {
                string3 = string3 + File.separator + "Help Systems" + File.separator + "Automate Schedule Agent";
                break;
            }
            case SERVER: {
                string3 = string3 + File.separator + "Help Systems" + File.separator + SERVER_DIRECTORY;
                break;
            }
            default: {
                ConsoleLogger.println("Undefined type: " + keystoreType.toString());
                return defaultPath;
            }
        }
        File file3 = new File(string3);
        if (file3.exists() && !file3.isDirectory()) {
            ConsoleLogger.println("Common application path is not a directory: " + file3.getAbsolutePath());
            return defaultPath;
        }
        if (!file3.exists() && !file3.mkdirs()) {
            ConsoleLogger.printlnDebug("Unable to create common application path: " + file3.getAbsolutePath());
            return defaultPath;
        }
        return string3;
    }

    public static enum KeystoreType {
        SERVER,
        AGENT;

    }
}

