/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.module.filetransfer;

import com.helpsystems.enterprise.core.busobj.DeleteFileException;
import com.helpsystems.enterprise.core.busobj.FileTransferException;
import com.helpsystems.enterprise.core.busobj.FileTransferReturnCode;
import com.helpsystems.enterprise.core.util.RemoteFile;
import com.helpsystems.enterprise.module.exec.FTPWorker;
import com.helpsystems.enterprise.module.exec.Utils;
import com.helpsystems.enterprise.module.filetransfer.IPeerFileTransferClient;
import com.helpsystems.enterprise.peer.FileTransterUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.log4j.Logger;

public class PeerFtpClient
implements IPeerFileTransferClient {
    protected FTPWorker ftpWorker = new FTPWorker();
    private static final Logger logger = Logger.getLogger(FTPWorker.class);
    private static final boolean verbose = false;
    private FTPClient ftpClient;

    public PeerFtpClient(FTPClient fTPClient) {
        this.ftpClient = fTPClient;
    }

    public FTPClient getFTPClient() {
        return this.ftpClient;
    }

    @Override
    public void get(String string, String string2, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4, boolean bl5) throws FileNotFoundException, IOException, FileTransferException, DeleteFileException {
        try {
            String string3 = Utils.concatToStrings("Downloading - Source:", "\"" + string + "\"", " Target: ", "\"" + string2 + "\"");
            System.out.println(string3);
            this.ftpWorker.get(this.ftpClient, string, string2, bl, bl2, n, bl3, bl4, true, bl5);
            String string4 = Utils.concatToStrings("Download complete.");
            System.out.println(string4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string5 = Utils.concatToStrings("Download of ", "\"" + string + "\"", " failed. Exception:", fileNotFoundException.getMessage());
            System.out.println(string5);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            String string6 = Utils.concatToStrings("Download of ", "\"" + string + "\"", " failed. Exception:", iOException.getMessage());
            System.out.println(string6);
            throw iOException;
        }
        catch (FileTransferException fileTransferException) {
            String string7 = Utils.concatToStrings("Download of ", "\"" + string + "\"", " failed. Exception:", fileTransferException.getMessage());
            logger.trace((Object)string7, (Throwable)fileTransferException);
            System.out.println(string7);
            throw fileTransferException;
        }
        catch (DeleteFileException deleteFileException) {
            String string8 = Utils.concatToStrings(deleteFileException.getMessage());
            System.out.println(string8);
            throw deleteFileException;
        }
        catch (RuntimeException runtimeException) {
            String string9 = Utils.concatToStrings("Download of ", "\"" + string + "\"", " failed. Exception:", runtimeException.getMessage());
            System.out.println(string9);
            throw runtimeException;
        }
    }

    @Override
    public void put(String string, String string2, boolean bl, int n, boolean bl2, boolean bl3) throws IOException, FileTransferException {
        try {
            String string3 = Utils.concatToStrings("Uploading - Source: ", "\"" + string2 + "\"", "Target file: ", "\"" + string + "\"");
            System.out.println(string3);
            this.ftpWorker.put(this.ftpClient, string, string2, bl, n, bl2, bl3, true);
            String string4 = Utils.concatToStrings("Done");
            System.out.println(string4);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string5 = Utils.concatToStrings("Upload of ", "\"" + string2 + "\"", " failed. Exception:", fileNotFoundException.getMessage());
            System.out.println(string5);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            String string6 = Utils.concatToStrings("Upload of ", "\"" + string2 + "\"", " failed. Exception:", iOException.getMessage());
            System.out.println(string6);
            throw iOException;
        }
        catch (FileTransferException fileTransferException) {
            String string7 = Utils.concatToStrings("Upload of ", "\"" + string2 + "\"", " failed. Exception:", fileTransferException.getMessage());
            logger.trace((Object)string7, (Throwable)fileTransferException);
            System.out.println(string7);
            throw fileTransferException;
        }
        catch (RuntimeException runtimeException) {
            String string8 = Utils.concatToStrings("Upload of ", "\"" + string2 + "\"", " failed. Exception:", runtimeException.getMessage());
            System.out.println(string8);
            throw runtimeException;
        }
    }

    @Override
    public List<RemoteFile> getList(String string, boolean bl) throws IOException {
        try {
            String string2 = "Retrieving list of files.";
            System.out.println(string2);
            List<RemoteFile> list = this.ftpWorker.getList(this.ftpClient, string, bl);
            String string3 = "List retrieved successfully.";
            System.out.println(string3);
            return list;
        }
        catch (IOException iOException) {
            String string4 = Utils.concatToStrings("Unable to retrieve list of files. Exception:", iOException.getMessage());
            System.out.println(string4);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            String string5 = Utils.concatToStrings("Unable to retrieve list of files. Exception:", runtimeException.getMessage());
            System.out.println(string5);
            throw runtimeException;
        }
    }

    @Override
    public void makeDir(String string) throws IOException {
        String string2 = Utils.concatToStrings("Creating folder: ", string);
        System.out.println(string2);
        int n = -1;
        try {
            n = this.ftpWorker.makeDir(this.ftpClient, string);
        }
        catch (IOException iOException) {
            String string3 = Utils.concatToStrings("Failed to create folder. Exception: ", iOException.getMessage());
            System.out.println(string3);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            String string4 = Utils.concatToStrings("Failed to create folder. Exception: ", runtimeException.getMessage());
            System.out.println(string4);
            throw runtimeException;
        }
        if (n != 0 && n != 1) {
            String string5 = Utils.concatToStrings("Failed to create folder. Exception: Unable to create folder ", string);
            System.out.println(string5);
            throw new IOException("Unable to create folder " + string);
        }
        String string6 = Utils.concatToStrings("Folder " + string + " created successfully.");
        System.out.println(string6);
    }

    @Override
    public void validateIfFolder(String string) throws FileTransferException, IOException {
        if (!"".equals(string) && !"/".equals(string)) {
            String string2 = FileTransterUtils.getRemoteParentFolderPath((String)string);
            List<FTPFile> list = null;
            try {
                list = this.ftpWorker.getFileList(this.ftpClient, string2, true, true);
            }
            catch (IOException iOException) {
                throw new FileTransferException("Host folder does not exist: " + string, FileTransferReturnCode.outputRemoteFolderDoesNotExist);
            }
            if (list == null || list.isEmpty()) {
                throw new FileTransferException("Host folder does not exist: " + string, FileTransferReturnCode.outputRemoteFolderDoesNotExist);
            }
            FTPFile fTPFile = this.getFileFromListByPath(list, string);
            if (fTPFile == null) {
                throw new FileTransferException("Host folder does not exist: " + string, FileTransferReturnCode.outputRemoteFolderDoesNotExist);
            }
            if (!fTPFile.isDirectory()) {
                throw new FileTransferException("Host path exists, but is not a directory", FileTransferReturnCode.outputRemoteFolderIsFile);
            }
        }
    }

    private FTPFile getFileFromListByPath(List<FTPFile> list, String string) {
        FTPFile fTPFile = null;
        for (FTPFile fTPFile2 : list) {
            if (!string.endsWith(fTPFile2.getName())) continue;
            fTPFile = fTPFile2;
            break;
        }
        return fTPFile;
    }

    @Override
    public boolean sendSiteCommand(String string) throws IOException {
        String[] stringArray = null;
        System.out.println("Doing Site Command: " + string);
        boolean bl = this.ftpClient.sendSiteCommand(string);
        if (!bl) {
            System.out.println("Failed to issue Site Command: " + string);
        } else {
            stringArray = this.ftpClient.getReplyStrings();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (string2 == null || string2.indexOf("200") != -1) continue;
                    System.out.println(string2);
                }
            }
        }
        return bl;
    }
}

